/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.java.BigDecimalMapping;
import org.datanucleus.store.rdbms.mapping.java.BigIntegerMapping;
import org.datanucleus.store.rdbms.mapping.java.BooleanMapping;
import org.datanucleus.store.rdbms.mapping.java.DoubleMapping;
import org.datanucleus.store.rdbms.mapping.java.FloatMapping;
import org.datanucleus.store.rdbms.mapping.java.IntegerMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.LongMapping;
import org.datanucleus.store.rdbms.mapping.java.OptionalMapping;
import org.datanucleus.store.rdbms.mapping.java.ShortMapping;
import org.datanucleus.store.rdbms.mapping.java.StringMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.CaseBooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.CaseExpression;
import org.datanucleus.store.rdbms.sql.expression.CaseNumericExpression;
import org.datanucleus.store.rdbms.sql.expression.CaseStringExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;

public class OptionalOrElseMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (args == null || args.size() != 1) {
            throw new NucleusException("Optional.orElse should be passed 1 argument");
        }
        SQLExpression elseExpr = args.get(0);
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        OptionalMapping opMapping = (OptionalMapping)expr.getJavaTypeMapping();
        JavaTypeMapping javaMapping = opMapping.getWrappedMapping();
        SQLExpression getExpr = exprFactory.newExpression(stmt, expr.getSQLTable(), javaMapping);
        BooleanExpression isNotNullExpr = exprFactory.newExpression(stmt, expr.getSQLTable(), javaMapping).ne(new NullLiteral(stmt, javaMapping, null, null));
        if (javaMapping instanceof StringMapping) {
            return new CaseStringExpression(new SQLExpression[]{isNotNullExpr}, new SQLExpression[]{getExpr}, elseExpr);
        }
        if (javaMapping instanceof IntegerMapping || javaMapping instanceof LongMapping || javaMapping instanceof ShortMapping || javaMapping instanceof FloatMapping || javaMapping instanceof DoubleMapping || javaMapping instanceof BigIntegerMapping || javaMapping instanceof BigDecimalMapping) {
            return new CaseNumericExpression(new SQLExpression[]{isNotNullExpr}, new SQLExpression[]{getExpr}, elseExpr);
        }
        if (javaMapping instanceof BooleanMapping) {
            return new CaseBooleanExpression(new SQLExpression[]{isNotNullExpr}, new SQLExpression[]{getExpr}, elseExpr);
        }
        return new CaseExpression(new SQLExpression[]{isNotNullExpr}, new SQLExpression[]{getExpr}, elseExpr);
    }
}

