/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.List;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;

public class BinaryExpression
extends SQLExpression {
    public BinaryExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
    }

    public BinaryExpression(SQLStatement stmt, JavaTypeMapping mapping, String functionName, List<SQLExpression> args, List types) {
        super(stmt, mapping, functionName, args, types);
    }

    @Override
    public BooleanExpression eq(SQLExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof BinaryExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(SQLExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.ne(this);
        }
        if (expr instanceof BinaryExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        return super.ne(expr);
    }

    @Override
    public BooleanExpression lt(SQLExpression expr) {
        if (expr instanceof BinaryExpression) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(SQLExpression expr) {
        if (expr instanceof BinaryExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        return super.le(expr);
    }

    @Override
    public BooleanExpression gt(SQLExpression expr) {
        if (expr instanceof BinaryExpression) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(SQLExpression expr) {
        if (expr instanceof BinaryExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        return super.ge(expr);
    }

    @Override
    public BooleanExpression in(SQLExpression expr, boolean not) {
        return new BooleanExpression(this, not ? Expression.OP_NOTIN : Expression.OP_IN, expr);
    }
}

