/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfLogger {
    public static final String ACQUIRE_READ_WRITE_LOCKS = "acquireReadWriteLocks";
    public static final String COMPILE = "compile";
    public static final String COMPILE_STEP = "Compile Step";
    public static final String WAIT_COMPILE = "waitCompile";
    public static final String PARSE = "parse";
    public static final String ANALYZE = "semanticAnalyze";
    public static final String OPTIMIZER = "optimizer";
    public static final String GENERATE_RESOLVED_PARSETREE = "Generate Resolved ParseTree";
    public static final String LOGICALPLAN_AND_HIVE_OPERATOR_TREE = "Logical Plan and hive Operator Tree";
    public static final String DEDUCE_RESULTSET_SCHEMA = "Deduce ResultsetSchema";
    public static final String PARSE_CONTEXT_GENERATION = "Parse Context generation";
    public static final String SAVE_AND_VALIDATE_VIEW = "Save and Validate View Creation";
    public static final String LOGICAL_OPTIMIZATION = "Logical Optimization";
    public static final String PHYSICAL_OPTIMIZATION = "Physical Optimization";
    public static final String POST_PROCESSING = "Post Processing";
    public static final String GENERATE_LOGICAL_PLAN = "Generate Logical Plan";
    public static final String GENERATE_OPERATOR_TREE = "Generate Operator Tree";
    public static final String VIEW_REWRITING = "Calcite: View-based rewriting";
    public static final String PLAN_GENERATION = "Calcite: Plan generation";
    public static final String MV_REWRITE_FIELD_TRIMMER = "MV Rewrite and Field Trimmer";
    public static final String REMOVING_SUBQUERY = "Removing SubQuery";
    public static final String DECORRELATION = "Decorrelation";
    public static final String VALIDATE_QUERY_MATERIALIZATION = "Validate Query Materialization";
    public static final String PREJOIN_ORDERING = "Calcite: Prejoin ordering transformation";
    public static final String MV_REWRITING = "MV Rewriting";
    public static final String JOIN_REORDERING = "Calcite: Join Reordering";
    public static final String POSTJOIN_ORDERING = "Calcite: Postjoin ordering transformation";
    public static final String HIVE_SORT_PREDICATES = "Hive Sort Predicates";
    public static final String MATERIALIZED_VIEWS_REGISTRY_REFRESH = "MaterializedViewsRegistryRefresh";
    public static final String DO_AUTHORIZATION = "doAuthorization";
    public static final String DRIVER_EXECUTE = "Driver.execute";
    public static final String INPUT_SUMMARY = "getInputSummary";
    public static final String INPUT_PATHS = "getInputPaths";
    public static final String GET_SPLITS = "getSplits";
    public static final String RUN_TASKS = "runTasks";
    public static final String SERIALIZE_PLAN = "serializePlan";
    public static final String DESERIALIZE_PLAN = "deserializePlan";
    public static final String CLONE_PLAN = "clonePlan";
    public static final String RELEASE_LOCKS = "releaseLocks";
    public static final String PRUNE_LISTING = "prune-listing";
    public static final String PARTITION_RETRIEVING = "partition-retrieving";
    public static final String PRE_HOOK = "PreHook.";
    public static final String POST_HOOK = "PostHook.";
    public static final String FAILURE_HOOK = "FailureHook.";
    public static final String TEZ_COMPILER = "TezCompiler";
    public static final String TEZ_SUBMIT_TO_RUNNING = "TezSubmitToRunningDag";
    public static final String TEZ_BUILD_DAG = "TezBuildDag";
    public static final String TEZ_SUBMIT_DAG = "TezSubmitDag";
    public static final String TEZ_RUN_DAG = "TezRunDag";
    public static final String TEZ_CREATE_VERTEX = "TezCreateVertex.";
    public static final String TEZ_RUN_VERTEX = "TezRunVertex.";
    public static final String TEZ_INITIALIZE_PROCESSOR = "TezInitializeProcessor";
    public static final String TEZ_RUN_PROCESSOR = "TezRunProcessor";
    public static final String TEZ_INIT_OPERATORS = "TezInitializeOperators";
    public static final String LOAD_HASHTABLE = "LoadHashtable";
    public static final String TEZ_GET_SESSION = "TezGetSession";
    public static final String SAVE_TO_RESULTS_CACHE = "saveToResultsCache";
    public static final String SEARCH_TRANSFORMER = "transformSearch";
    public static final String FILE_MOVES = "FileMoves";
    public static final String LOAD_TABLE = "LoadTable";
    public static final String LOAD_PARTITION = "LoadPartition";
    public static final String LOAD_DYNAMIC_PARTITIONS = "LoadDynamicPartitions";
    public static final String STATS_TASK = "StatsTask";
    public static final String HIVE_GET_TABLE = "getTablesByType";
    public static final String HIVE_GET_CATALOG = "getCatalog";
    public static final String HIVE_GET_DATABASE = "getDatabase";
    public static final String HIVE_GET_DATABASE_2 = "getDatabase2";
    public static final String HIVE_GET_PARTITIONS = "getPartitions";
    public static final String HIVE_GET_PARTITIONS_2 = "getPartitions2";
    public static final String HIVE_GET_PARTITIONS_BY_EXPR = "getPartitionsByExpr";
    public static final String HIVE_GET_TABLE_COLUMN_STATS = "getTableColumnStatistics";
    public static final String HIVE_GET_AGGR_COL_STATS = "getAggrColStatsFor";
    public static final String HIVE_GET_NOT_NULL_CONSTRAINT = "getNotNullConstraints";
    public static final String HIVE_GET_TABLE_CONSTRAINTS = "getTableConstraints";
    protected final Map<String, Long> startTimes = new ConcurrentHashMap<String, Long>();
    protected final Map<String, Long> endTimes = new ConcurrentHashMap<String, Long>();
    private static final Logger LOG = LoggerFactory.getLogger((String)PerfLogger.class.getName());
    protected static final ThreadLocal<PerfLogger> perfLogger = new ThreadLocal();
    private final transient Map<String, MetricsScope> openScopes = new HashMap<String, MetricsScope>();

    private PerfLogger() {
    }

    public static PerfLogger getPerfLogger(HiveConf conf, boolean resetPerfLogger) {
        PerfLogger result = perfLogger.get();
        if (resetPerfLogger || result == null) {
            if (conf == null) {
                result = new PerfLogger();
            } else {
                try {
                    result = (PerfLogger)ReflectionUtils.newInstance((Class)conf.getClassByName(conf.getVar(HiveConf.ConfVars.HIVE_PERF_LOGGER)), (Configuration)conf);
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Performance Logger Class not found:" + e.getMessage());
                    result = new PerfLogger();
                }
            }
            perfLogger.set(result);
        }
        return result;
    }

    public void perfLogBegin(String callerName, String method) {
        long startTime = System.currentTimeMillis();
        this.startTimes.put(method, startTime);
        LOG.debug("<PERFLOG method={} from={}>", (Object)method, (Object)callerName);
        this.beginMetrics(method);
    }

    public long perfLogEnd(String callerName, String method) {
        return this.perfLogEnd(callerName, method, null);
    }

    public long perfLogEnd(String callerName, String method, String additionalInfo) {
        long startTime = this.startTimes.getOrDefault(method, -1L);
        long endTime = System.currentTimeMillis();
        long duration = startTime < 0L ? -1L : endTime - startTime;
        this.endTimes.put(method, endTime);
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("</PERFLOG method=").append(method);
            if (startTime >= 0L) {
                sb.append(" start=").append(startTime);
            }
            sb.append(" end=").append(endTime);
            if (duration >= 0L) {
                sb.append(" duration=").append(duration);
            }
            sb.append(" from=").append(callerName);
            if (additionalInfo != null) {
                sb.append(" ").append(additionalInfo);
            }
            sb.append(">");
            LOG.debug(sb.toString());
        }
        this.endMetrics(method);
        return duration;
    }

    public long getStartTime(String method) {
        return this.startTimes.getOrDefault(method, 0L);
    }

    public long getEndTime(String method) {
        return this.endTimes.getOrDefault(method, 0L);
    }

    public boolean startTimeHasMethod(String method) {
        return this.startTimes.containsKey(method);
    }

    public boolean endTimeHasMethod(String method) {
        return this.endTimes.containsKey(method);
    }

    public long getDuration(String method) {
        Long startTime = this.startTimes.get(method);
        Long endTime = this.endTimes.get(method);
        if (startTime != null && endTime != null) {
            return endTime - startTime;
        }
        return 0L;
    }

    public Map<String, Long> getStartTimes() {
        return ImmutableMap.copyOf(this.startTimes);
    }

    public Map<String, Long> getEndTimes() {
        return ImmutableMap.copyOf(this.endTimes);
    }

    public long getPreparePlanDuration() {
        long dagSubmitStartTime = this.getStartTime(TEZ_SUBMIT_DAG);
        long compileEndTime = this.getEndTime(COMPILE);
        long getSessionDuration = this.getDuration(TEZ_GET_SESSION);
        if (dagSubmitStartTime == 0L) {
            return 0L;
        }
        return dagSubmitStartTime - compileEndTime - getSessionDuration;
    }

    public long getRunDagDuration() {
        long submitToRunningDuration = this.getDuration(TEZ_SUBMIT_TO_RUNNING);
        return submitToRunningDuration == 0L ? this.getDuration(TEZ_RUN_DAG) : this.getEndTime(TEZ_RUN_DAG) - this.getEndTime(TEZ_SUBMIT_TO_RUNNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginMetrics(String method) {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            MetricsScope scope = metrics.createScope("api_" + method);
            Map<String, MetricsScope> map = this.openScopes;
            synchronized (map) {
                this.openScopes.put(method, scope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endMetrics(String method) {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            MetricsScope scope;
            Map<String, MetricsScope> map = this.openScopes;
            synchronized (map) {
                scope = this.openScopes.remove(method);
            }
            if (scope != null) {
                metrics.endScope(scope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupPerfLogMetrics() {
        Metrics metrics = MetricsFactory.getInstance();
        Map<String, MetricsScope> map = this.openScopes;
        synchronized (map) {
            if (metrics != null) {
                for (MetricsScope openScope : this.openScopes.values()) {
                    metrics.endScope(openScope);
                }
            }
            this.openScopes.clear();
        }
    }
}

