/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.CommandHandler;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.NullCompleter;

public abstract class AbstractCommandHandler
implements CommandHandler {
    private final BeeLine beeLine;
    private final String name;
    private final String[] names;
    private final String helpText;
    private Completer[] parameterCompleters = new Completer[0];
    protected transient Throwable lastException;

    public AbstractCommandHandler(BeeLine beeLine, String[] names, String helpText, Completer[] completers) {
        this.beeLine = beeLine;
        this.name = names[0];
        this.names = names;
        this.helpText = helpText;
        if (completers == null || completers.length == 0) {
            this.parameterCompleters = new Completer[]{new NullCompleter()};
        } else {
            LinkedList<Completer> c = new LinkedList<Completer>(Arrays.asList(completers));
            c.add((Completer)new NullCompleter());
            this.parameterCompleters = c.toArray(new Completer[0]);
        }
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getNames() {
        return this.names;
    }

    @Override
    public String matches(String line) {
        if (line == null || line.length() == 0) {
            return null;
        }
        String[] parts = this.beeLine.split(line);
        if (parts == null || parts.length == 0) {
            return null;
        }
        for (String name2 : this.names) {
            if (!name2.startsWith(parts[0])) continue;
            return name2;
        }
        return null;
    }

    @Override
    public Completer[] getParameterCompleters() {
        return this.parameterCompleters;
    }

    @Override
    public Throwable getLastException() {
        return this.lastException;
    }
}

