/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class AssignFreshIds
extends TypeUtil.CustomOrderSchemaVisitor<Type> {
    private final Schema visitingSchema;
    private final Schema baseSchema;
    private final TypeUtil.NextID nextId;

    AssignFreshIds(TypeUtil.NextID nextId) {
        this.visitingSchema = null;
        this.baseSchema = null;
        this.nextId = nextId;
    }

    AssignFreshIds(Schema visitingSchema, Schema baseSchema, TypeUtil.NextID nextId) {
        this.visitingSchema = visitingSchema;
        this.baseSchema = baseSchema;
        this.nextId = nextId;
    }

    private int idFor(String fullName) {
        Types.NestedField field;
        if (this.baseSchema != null && fullName != null && (field = this.baseSchema.findField(fullName)) != null) {
            return field.fieldId();
        }
        return this.nextId.get();
    }

    private String name(int id) {
        if (this.visitingSchema != null) {
            return this.visitingSchema.findColumnName(id);
        }
        return null;
    }

    @Override
    public Type schema(Schema schema, Supplier<Type> future) {
        return future.get();
    }

    @Override
    public Type struct(Types.StructType struct, Iterable<Type> futures) {
        List<Types.NestedField> fields = struct.fields();
        int length = struct.fields().size();
        ArrayList<Integer> newIds = Lists.newArrayListWithExpectedSize(length);
        for (int i = 0; i < length; ++i) {
            newIds.add(this.idFor(this.name(fields.get(i).fieldId())));
        }
        ArrayList<Types.NestedField> newFields = Lists.newArrayListWithExpectedSize(length);
        Iterator<Type> types = futures.iterator();
        for (int i = 0; i < length; ++i) {
            Types.NestedField field = fields.get(i);
            Type type = types.next();
            newFields.add(Types.NestedField.from(field).withId((Integer)newIds.get(i)).ofType(type).build());
        }
        return Types.StructType.of(newFields);
    }

    @Override
    public Type field(Types.NestedField field, Supplier<Type> future) {
        return future.get();
    }

    @Override
    public Type list(Types.ListType list, Supplier<Type> future) {
        int newId = this.idFor(this.name(list.elementId()));
        if (list.isElementOptional()) {
            return Types.ListType.ofOptional(newId, future.get());
        }
        return Types.ListType.ofRequired(newId, future.get());
    }

    @Override
    public Type map(Types.MapType map, Supplier<Type> keyFuture, Supplier<Type> valueFuture) {
        int newKeyId = this.idFor(this.name(map.keyId()));
        int newValueId = this.idFor(this.name(map.valueId()));
        if (map.isValueOptional()) {
            return Types.MapType.ofOptional(newKeyId, newValueId, keyFuture.get(), valueFuture.get());
        }
        return Types.MapType.ofRequired(newKeyId, newValueId, keyFuture.get(), valueFuture.get());
    }

    @Override
    public Type variant(Types.VariantType variant) {
        return variant;
    }

    @Override
    public Type primitive(Type.PrimitiveType primitive) {
        return primitive;
    }
}

