/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LlapServiceCommandLine {
    private static final Logger LOG = LoggerFactory.getLogger((String)LlapServiceCommandLine.class.getName());
    private static final Option DIRECTORY;
    private static final Option NAME;
    private static final Option EXECUTORS;
    private static final Option IO_THREADS;
    private static final Option CACHE;
    private static final Option SIZE;
    private static final Option XMX;
    private static final Option AUXJARS;
    private static final Option AUXHBASE;
    private static final Option HBASEJARS;
    private static final Option HIVECONF;
    private static final Option JAVAHOME;
    private static final Option QUEUE;
    private static final Set<String> VALID_LOGGERS;
    private static final Option LOGGER;
    private static final Option START;
    private static final Option OUTPUT;
    private static final Option AUXHIVE;
    private static final Option HELP;
    private static final String OPTION_INSTANCES = "instances";
    private static final String OPTION_ARGS = "args";
    private static final String OPTION_LOGLEVEL = "loglevel";
    private static final String OPTION_SERVICE_KEYTAB_DIR = "service-keytab-dir";
    private static final String OPTION_SERVICE_KEYTAB = "service-keytab";
    private static final String OPTION_SERVICE_PRINCIPAL = "service-principal";
    private static final String OPTION_SERVICE_PLACEMENT = "service-placement";
    private static final String OPTION_SERVICE_DEFAULT_KEYTAB = "service-default-keytab";
    private static final String OPTION_HEALTH_PERCENT = "health-percent";
    private static final String OPTION_HEALTH_TIME_WINDOW_SECS = "health-time-window-secs";
    private static final String OPTION_HEALTH_INIT_DELAY_SECS = "health-init-delay-secs";
    private static final String OPTION_SERVICE_AM_CONTAINER_MB = "service-am-container-mb";
    private static final String OPTION_SERVICE_APPCONFIG_GLOBAL = "service-appconfig-global";
    private static final Options OPTIONS;
    private String[] args;
    private String directory;
    private String name;
    private int executors;
    private int ioThreads;
    private long cache;
    private long size;
    private long xmx;
    private String jars;
    private String hbaseJars;
    private boolean isHbase;
    private Properties conf = new Properties();
    private String javaPath = null;
    private String llapQueueName;
    private String logger = null;
    private boolean isStarting;
    private String output;
    private boolean isHiveAux;
    private boolean isHelp;

    static LlapServiceCommandLine parseArguments(String[] args) {
        LlapServiceCommandLine cl = null;
        try {
            cl = new LlapServiceCommandLine(args);
        }
        catch (Exception e) {
            LOG.error("Parsing the command line arguments failed", (Throwable)e);
            LlapServiceCommandLine.printUsage();
            ExitUtil.terminate((int)1);
        }
        if (cl.isHelp) {
            LlapServiceCommandLine.printUsage();
            ExitUtil.terminate((int)0);
        }
        return cl;
    }

    LlapServiceCommandLine(String[] args) throws ParseException {
        LOG.info("LLAP invoked with arguments = {}", (Object)Arrays.toString(args));
        this.args = args;
        this.parseCommandLine(args);
    }

    private void parseCommandLine(String[] args) throws ParseException {
        CommandLine cl = new GnuParser().parse(OPTIONS, args);
        if (cl.hasOption(HELP.getOpt())) {
            this.isHelp = true;
            return;
        }
        if (!cl.hasOption(OPTION_INSTANCES)) {
            LlapServiceCommandLine.printUsage();
            throw new ParseException("instance must be set");
        }
        int instances = Integer.parseInt(cl.getOptionValue(OPTION_INSTANCES));
        if (instances <= 0) {
            throw new ParseException("Invalid configuration: " + instances + " (should be greater than 0)");
        }
        this.directory = cl.getOptionValue(DIRECTORY.getOpt());
        this.name = cl.getOptionValue(NAME.getOpt());
        this.executors = Integer.parseInt(cl.getOptionValue(EXECUTORS.getOpt(), "-1"));
        this.ioThreads = Integer.parseInt(cl.getOptionValue(IO_THREADS.getOpt(), Integer.toString(this.executors)));
        this.cache = StringUtils.TraditionalBinaryPrefix.string2long((String)cl.getOptionValue(CACHE.getOpt(), "-1"));
        this.size = StringUtils.TraditionalBinaryPrefix.string2long((String)cl.getOptionValue(SIZE.getOpt(), "-1"));
        this.xmx = StringUtils.TraditionalBinaryPrefix.string2long((String)cl.getOptionValue(XMX.getOpt(), "-1"));
        this.jars = cl.getOptionValue(AUXJARS.getOpt());
        this.hbaseJars = cl.getOptionValue(HBASEJARS.getOpt());
        this.isHbase = Boolean.parseBoolean(cl.getOptionValue(AUXHBASE.getOpt(), "true"));
        if (cl.hasOption(HIVECONF.getLongOpt())) {
            this.conf = cl.getOptionProperties(HIVECONF.getLongOpt());
        }
        if (cl.hasOption(JAVAHOME.getLongOpt())) {
            this.javaPath = cl.getOptionValue(JAVAHOME.getLongOpt());
        }
        this.llapQueueName = cl.getOptionValue(QUEUE.getOpt(), HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME.getDefaultValue());
        if (cl.hasOption(LOGGER.getLongOpt())) {
            this.logger = cl.getOptionValue(LOGGER.getLongOpt());
            Preconditions.checkArgument((boolean)VALID_LOGGERS.contains(this.logger.toLowerCase()));
        }
        this.isStarting = cl.hasOption(START.getOpt());
        this.output = cl.getOptionValue(OUTPUT.getLongOpt());
        this.isHiveAux = Boolean.parseBoolean(cl.getOptionValue(AUXHIVE.getOpt(), "true"));
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        try {
            int width = hf.getWidth();
            int jlineWidth = TerminalBuilder.terminal().getWidth();
            width = Math.min(160, Math.max(jlineWidth, width));
            hf.setWidth(width);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hf.printHelp("llap", OPTIONS);
    }

    String[] getArgs() {
        return this.args;
    }

    String getDirectory() {
        return this.directory;
    }

    String getName() {
        return this.name;
    }

    int getExecutors() {
        return this.executors;
    }

    int getIoThreads() {
        return this.ioThreads;
    }

    long getCache() {
        return this.cache;
    }

    long getSize() {
        return this.size;
    }

    long getXmx() {
        return this.xmx;
    }

    String getAuxJars() {
        return this.jars;
    }

    String getHBaseJars() {
        return this.hbaseJars;
    }

    boolean getIsHBase() {
        return this.isHbase;
    }

    boolean getIsHiveAux() {
        return this.isHiveAux;
    }

    Properties getConfig() {
        return this.conf;
    }

    String getJavaPath() {
        return this.javaPath;
    }

    String getLlapQueueName() {
        return this.llapQueueName;
    }

    String getLogger() {
        return this.logger;
    }

    boolean isStarting() {
        return this.isStarting;
    }

    String getOutput() {
        return this.output;
    }

    static {
        OptionBuilder.withLongOpt((String)"directory");
        OptionBuilder.withDescription((String)"Temp directory for jars etc.");
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.hasArg();
        DIRECTORY = OptionBuilder.create((char)'d');
        OptionBuilder.withLongOpt((String)"name");
        OptionBuilder.withDescription((String)"Cluster name for YARN registry");
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        NAME = OptionBuilder.create((char)'n');
        OptionBuilder.withLongOpt((String)"executors");
        OptionBuilder.withDescription((String)"executor per instance");
        OptionBuilder.withArgName((String)"executors");
        OptionBuilder.hasArg();
        EXECUTORS = OptionBuilder.create((char)'e');
        OptionBuilder.withLongOpt((String)"iothreads");
        OptionBuilder.withDescription((String)"iothreads per instance");
        OptionBuilder.withArgName((String)"iothreads");
        OptionBuilder.hasArg();
        IO_THREADS = OptionBuilder.create((char)'t');
        OptionBuilder.withLongOpt((String)"cache");
        OptionBuilder.withDescription((String)"cache size per instance");
        OptionBuilder.withArgName((String)"cache");
        OptionBuilder.hasArg();
        CACHE = OptionBuilder.create((char)'c');
        OptionBuilder.withLongOpt((String)"size");
        OptionBuilder.withDescription((String)"cache size per instance");
        OptionBuilder.withArgName((String)"size");
        OptionBuilder.hasArg();
        SIZE = OptionBuilder.create((char)'s');
        OptionBuilder.withLongOpt((String)"xmx");
        OptionBuilder.withDescription((String)"working memory size");
        OptionBuilder.withArgName((String)"xmx");
        OptionBuilder.hasArg();
        XMX = OptionBuilder.create((char)'w');
        OptionBuilder.withLongOpt((String)"auxjars");
        OptionBuilder.withDescription((String)"additional jars to package (by default, JSON SerDe jar is packaged if available)");
        OptionBuilder.withArgName((String)"auxjars");
        OptionBuilder.hasArg();
        AUXJARS = OptionBuilder.create((char)'j');
        OptionBuilder.withLongOpt((String)"auxhbase");
        OptionBuilder.withDescription((String)"whether to package the HBase jars (true by default)");
        OptionBuilder.withArgName((String)"auxhbase");
        OptionBuilder.hasArg();
        AUXHBASE = OptionBuilder.create((char)'h');
        OptionBuilder.withLongOpt((String)"hbasejars");
        OptionBuilder.withDescription((String)"HBase mapredcp jars to package");
        OptionBuilder.withArgName((String)"hbasejars");
        OptionBuilder.hasArg();
        HBASEJARS = OptionBuilder.create((char)'k');
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Use value for given property. Overridden by explicit parameters");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator();
        HIVECONF = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"javaHome");
        OptionBuilder.withDescription((String)"Path to the JRE/JDK. This should be installed at the same location on all cluster nodes ($JAVA_HOME, java.home by default)");
        OptionBuilder.withArgName((String)"javaHome");
        OptionBuilder.hasArg();
        JAVAHOME = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"queue");
        OptionBuilder.withDescription((String)"The queue within which LLAP will be started");
        OptionBuilder.withArgName((String)"queue");
        OptionBuilder.hasArg();
        QUEUE = OptionBuilder.create((char)'q');
        VALID_LOGGERS = ImmutableSet.of((Object)"RFA".toLowerCase(), (Object)"query-routing".toLowerCase(), (Object)"console".toLowerCase());
        OptionBuilder.withLongOpt((String)"logger");
        OptionBuilder.withDescription((String)("logger for llap instance ([" + String.valueOf(VALID_LOGGERS) + "]"));
        OptionBuilder.withArgName((String)"logger");
        OptionBuilder.hasArg();
        LOGGER = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"startImmediately");
        OptionBuilder.withDescription((String)"immediately start the cluster");
        OptionBuilder.withArgName((String)"startImmediately");
        OptionBuilder.hasArg((boolean)false);
        START = OptionBuilder.create((char)'z');
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.withDescription((String)"Output directory for the generated scripts");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OUTPUT = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"auxhive");
        OptionBuilder.withDescription((String)"whether to package the Hive aux jars (true by default)");
        OptionBuilder.withArgName((String)"auxhive");
        OptionBuilder.hasArg();
        AUXHIVE = OptionBuilder.create((String)"auxhive");
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Print help information");
        OptionBuilder.withArgName((String)"help");
        OptionBuilder.hasArg((boolean)false);
        HELP = OptionBuilder.create((char)'H');
        OPTIONS = new Options();
        OPTIONS.addOption(DIRECTORY);
        OPTIONS.addOption(NAME);
        OPTIONS.addOption(EXECUTORS);
        OPTIONS.addOption(IO_THREADS);
        OPTIONS.addOption(CACHE);
        OPTIONS.addOption(SIZE);
        OPTIONS.addOption(XMX);
        OPTIONS.addOption(AUXJARS);
        OPTIONS.addOption(AUXHBASE);
        OPTIONS.addOption(HBASEJARS);
        OPTIONS.addOption(HIVECONF);
        OPTIONS.addOption(JAVAHOME);
        OPTIONS.addOption(QUEUE);
        OPTIONS.addOption(LOGGER);
        OPTIONS.addOption(START);
        OPTIONS.addOption(OUTPUT);
        OPTIONS.addOption(AUXHIVE);
        OPTIONS.addOption(HELP);
        OptionBuilder.withLongOpt((String)OPTION_INSTANCES);
        OptionBuilder.withDescription((String)"Specify the number of instances to run this on");
        OptionBuilder.withArgName((String)OPTION_INSTANCES);
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)OPTION_ARGS);
        OptionBuilder.withDescription((String)"java arguments to the llap instance");
        OptionBuilder.withArgName((String)OPTION_ARGS);
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.withLongOpt((String)OPTION_LOGLEVEL);
        OptionBuilder.withDescription((String)"log levels for the llap instance");
        OptionBuilder.withArgName((String)OPTION_LOGLEVEL);
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create((char)'l'));
        OptionBuilder.withLongOpt((String)OPTION_SERVICE_KEYTAB_DIR);
        OptionBuilder.withDescription((String)"Service AM keytab directory on HDFS (where the headless user keytab is stored by Service keytab installation, e.g. .yarn/keytabs/llap)");
        OptionBuilder.withArgName((String)OPTION_SERVICE_KEYTAB_DIR);
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)OPTION_SERVICE_KEYTAB);
        OptionBuilder.withDescription((String)"Service AM keytab file name inside service-keytab-dir");
        OptionBuilder.withArgName((String)OPTION_SERVICE_KEYTAB);
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)OPTION_SERVICE_PRINCIPAL);
        OptionBuilder.withDescription((String)"Service AM principal; should be the user running the cluster, e.g. hive@EXAMPLE.COM");
        OptionBuilder.withArgName((String)OPTION_SERVICE_PRINCIPAL);
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)OPTION_SERVICE_PLACEMENT);
        OptionBuilder.withDescription((String)"Service placement policy; see YARN documentation at https://issues.apache.org/jira/browse/YARN-1042. This is unnecessary if LLAP is going to take more than half of the YARN capacity of a node.");
        OptionBuilder.withArgName((String)OPTION_SERVICE_PLACEMENT);
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)OPTION_SERVICE_DEFAULT_KEYTAB);
        OptionBuilder.withDescription((String)"try to set default settings for Service AM keytab; mostly for dev testing");
        OptionBuilder.withArgName((String)OPTION_SERVICE_DEFAULT_KEYTAB);
        OptionBuilder.hasArg((boolean)false);
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)OPTION_HEALTH_PERCENT);
        OptionBuilder.withDescription((String)"Percentage of running containers after which LLAP application is considered healthy (Default: 80)");
        OptionBuilder.withArgName((String)OPTION_HEALTH_PERCENT);
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)OPTION_HEALTH_TIME_WINDOW_SECS);
        OptionBuilder.withDescription((String)"Time window in seconds (after initial delay) for which LLAP application is allowed to be in unhealthy state before being killed (Default: 300)");
        OptionBuilder.withArgName((String)OPTION_HEALTH_TIME_WINDOW_SECS);
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)OPTION_HEALTH_INIT_DELAY_SECS);
        OptionBuilder.withDescription((String)"Delay in seconds after which health percentage is monitored (Default: 400)");
        OptionBuilder.withArgName((String)OPTION_HEALTH_INIT_DELAY_SECS);
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)OPTION_SERVICE_AM_CONTAINER_MB);
        OptionBuilder.withDescription((String)"The size of the service AppMaster container in MB");
        OptionBuilder.withArgName((String)"b");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)OPTION_SERVICE_APPCONFIG_GLOBAL);
        OptionBuilder.withDescription((String)"Property (key=value) to be set in the global section of the Service appConfig");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator();
        OPTIONS.addOption(OptionBuilder.create());
    }
}

