/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionsMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TException;

public class JSONAlterPartitionsMessage
extends AlterPartitionsMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String table;
    @JsonProperty
    String tableType;
    @JsonProperty
    String tableObjJson;
    @JsonProperty
    String isTruncateOp;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    Long writeId;
    @JsonProperty
    List<Map<String, String>> partitions;
    @JsonProperty
    List<String> partitionListJson;

    public JSONAlterPartitionsMessage() {
    }

    public JSONAlterPartitionsMessage(String server, String servicePrincipal, Table tableObj, List<Partition> partitionsAfter, boolean isTruncateOp, Long writeId, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = tableObj.getDbName();
        this.table = tableObj.getTableName();
        this.tableType = tableObj.getTableType();
        this.isTruncateOp = Boolean.toString(isTruncateOp);
        this.timestamp = timestamp;
        this.writeId = writeId;
        this.partitions = new ArrayList<Map<String, String>>();
        this.partitionListJson = new ArrayList<String>();
        try {
            this.tableObjJson = MessageBuilder.createTableObjJson(tableObj);
            for (Partition partitionObj : partitionsAfter) {
                this.partitions.add(MessageBuilder.getPartitionKeyValues(tableObj, partitionObj));
                this.partitionListJson.add(MessageBuilder.createPartitionObjJson(partitionObj));
            }
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
        this.checkValid();
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getTableType() {
        return this.tableType != null ? this.tableType : "";
    }

    @Override
    public Table getTableObj() throws Exception {
        return (Table)MessageBuilder.getTObj(this.tableObjJson, Table.class);
    }

    @Override
    public boolean getIsTruncateOp() {
        return Boolean.parseBoolean(this.isTruncateOp);
    }

    @Override
    public Long getWriteId() {
        return this.writeId == null ? 0L : this.writeId;
    }

    @Override
    public List<Map<String, String>> getPartitions() {
        return this.partitions;
    }

    @Override
    public Iterable<Partition> getPartitionObjs() throws Exception {
        return Iterables.transform(MessageBuilder.getTObjs(this.partitionListJson, Partition.class), (Function)new Function<Object, Partition>(this){

            @Nullable
            public Partition apply(@Nullable Object input) {
                return (Partition)input;
            }
        });
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
    }
}

