/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging;

import org.apache.hadoop.hive.metastore.messaging.AbortTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.AcidWriteMessage;
import org.apache.hadoop.hive.metastore.messaging.AddCheckConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddDefaultConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddForeignKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddNotNullConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPrimaryKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddUniqueConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AllocWriteIdMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionsMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.CommitCompactionMessage;
import org.apache.hadoop.hive.metastore.messaging.CommitTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.DeletePartitionColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.DeleteTableColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.DropConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.DropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.DropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.metastore.messaging.OpenTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.UpdatePartitionColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.UpdateTableColumnStatMessage;

public abstract class MessageDeserializer {
    public EventMessage getEventMessage(String eventTypeString, String messageBody) {
        switch (EventMessage.EventType.valueOf(eventTypeString)) {
            case CREATE_DATABASE: {
                return this.getCreateDatabaseMessage(messageBody);
            }
            case ALTER_DATABASE: {
                return this.getAlterDatabaseMessage(messageBody);
            }
            case DROP_DATABASE: {
                return this.getDropDatabaseMessage(messageBody);
            }
            case CREATE_TABLE: {
                return this.getCreateTableMessage(messageBody);
            }
            case ALTER_TABLE: {
                return this.getAlterTableMessage(messageBody);
            }
            case DROP_TABLE: {
                return this.getDropTableMessage(messageBody);
            }
            case ADD_PARTITION: {
                return this.getAddPartitionMessage(messageBody);
            }
            case ALTER_PARTITION: {
                return this.getAlterPartitionMessage(messageBody);
            }
            case DROP_PARTITION: {
                return this.getDropPartitionMessage(messageBody);
            }
            case CREATE_FUNCTION: {
                return this.getCreateFunctionMessage(messageBody);
            }
            case DROP_FUNCTION: {
                return this.getDropFunctionMessage(messageBody);
            }
            case INSERT: {
                return this.getInsertMessage(messageBody);
            }
            case ADD_PRIMARYKEY: {
                return this.getAddPrimaryKeyMessage(messageBody);
            }
            case ADD_FOREIGNKEY: {
                return this.getAddForeignKeyMessage(messageBody);
            }
            case ADD_UNIQUECONSTRAINT: {
                return this.getAddUniqueConstraintMessage(messageBody);
            }
            case ADD_NOTNULLCONSTRAINT: {
                return this.getAddNotNullConstraintMessage(messageBody);
            }
            case ADD_DEFAULTCONSTRAINT: {
                return this.getAddDefaultConstraintMessage(messageBody);
            }
            case ADD_CHECKCONSTRAINT: {
                return this.getAddCheckConstraintMessage(messageBody);
            }
            case DROP_CONSTRAINT: {
                return this.getDropConstraintMessage(messageBody);
            }
            case OPEN_TXN: {
                return this.getOpenTxnMessage(messageBody);
            }
            case COMMIT_TXN: {
                return this.getCommitTxnMessage(messageBody);
            }
            case ABORT_TXN: {
                return this.getAbortTxnMessage(messageBody);
            }
            case ALLOC_WRITE_ID: {
                return this.getAllocWriteIdMessage(messageBody);
            }
            case ACID_WRITE: {
                return this.getAcidWriteMessage(messageBody);
            }
            case UPDATE_TABLE_COLUMN_STAT: {
                return this.getUpdateTableColumnStatMessage(messageBody);
            }
            case DELETE_TABLE_COLUMN_STAT: {
                return this.getDeleteTableColumnStatMessage(messageBody);
            }
            case UPDATE_PARTITION_COLUMN_STAT: {
                return this.getUpdatePartitionColumnStatMessage(messageBody);
            }
            case DELETE_PARTITION_COLUMN_STAT: {
                return this.getDeletePartitionColumnStatMessage(messageBody);
            }
            case COMMIT_COMPACTION: {
                return this.getCommitCompactionMessage(messageBody);
            }
        }
        throw new IllegalArgumentException("Unsupported event-type: " + eventTypeString);
    }

    public abstract CreateDatabaseMessage getCreateDatabaseMessage(String var1);

    public abstract AlterDatabaseMessage getAlterDatabaseMessage(String var1);

    public abstract DropDatabaseMessage getDropDatabaseMessage(String var1);

    public abstract CreateTableMessage getCreateTableMessage(String var1);

    public abstract AlterTableMessage getAlterTableMessage(String var1);

    public abstract DropTableMessage getDropTableMessage(String var1);

    public abstract AddPartitionMessage getAddPartitionMessage(String var1);

    public abstract AlterPartitionMessage getAlterPartitionMessage(String var1);

    public abstract AlterPartitionsMessage getAlterPartitionsMessage(String var1);

    public abstract DropPartitionMessage getDropPartitionMessage(String var1);

    public abstract CreateFunctionMessage getCreateFunctionMessage(String var1);

    public abstract DropFunctionMessage getDropFunctionMessage(String var1);

    public abstract InsertMessage getInsertMessage(String var1);

    public abstract AddPrimaryKeyMessage getAddPrimaryKeyMessage(String var1);

    public abstract AddForeignKeyMessage getAddForeignKeyMessage(String var1);

    public abstract AddUniqueConstraintMessage getAddUniqueConstraintMessage(String var1);

    public abstract AddNotNullConstraintMessage getAddNotNullConstraintMessage(String var1);

    public abstract AddDefaultConstraintMessage getAddDefaultConstraintMessage(String var1);

    public abstract AddCheckConstraintMessage getAddCheckConstraintMessage(String var1);

    public abstract DropConstraintMessage getDropConstraintMessage(String var1);

    public abstract OpenTxnMessage getOpenTxnMessage(String var1);

    public abstract CommitTxnMessage getCommitTxnMessage(String var1);

    public abstract AbortTxnMessage getAbortTxnMessage(String var1);

    public abstract AllocWriteIdMessage getAllocWriteIdMessage(String var1);

    public abstract AcidWriteMessage getAcidWriteMessage(String var1);

    public abstract UpdateTableColumnStatMessage getUpdateTableColumnStatMessage(String var1);

    public abstract DeleteTableColumnStatMessage getDeleteTableColumnStatMessage(String var1);

    public abstract UpdatePartitionColumnStatMessage getUpdatePartitionColumnStatMessage(String var1);

    public abstract DeletePartitionColumnStatMessage getDeletePartitionColumnStatMessage(String var1);

    public abstract CommitCompactionMessage getCommitCompactionMessage(String var1);

    public String deSerializeGenericString(String messageBody) {
        return messageBody;
    }

    protected MessageDeserializer() {
    }
}

