/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;

public class MaterializationsRebuildLockHandler {
    private static final MaterializationsRebuildLockHandler SINGLETON = new MaterializationsRebuildLockHandler();
    private final ConcurrentMap<String, ResourceLock> locks = new ConcurrentHashMap<String, ResourceLock>();

    private MaterializationsRebuildLockHandler() {
    }

    public static MaterializationsRebuildLockHandler get() {
        return SINGLETON;
    }

    public LockResponse lockResource(String dbName, String tableName, long txnId) {
        ResourceLock prevResourceLock = this.locks.putIfAbsent(Warehouse.getQualifiedName((String)dbName, (String)tableName), new ResourceLock(this, txnId, System.nanoTime(), State.ACQUIRED));
        if (prevResourceLock != null) {
            return new LockResponse(txnId, LockState.NOT_ACQUIRED);
        }
        return new LockResponse(txnId, LockState.ACQUIRED);
    }

    public boolean readyToCommitResource(String dbName, String tableName, long txnId) {
        ResourceLock prevResourceLock = (ResourceLock)this.locks.get(Warehouse.getQualifiedName((String)dbName, (String)tableName));
        if (prevResourceLock == null || prevResourceLock.txnId != txnId) {
            return false;
        }
        return prevResourceLock.state.compareAndSet(State.ACQUIRED, State.COMMIT_READY);
    }

    public boolean refreshLockResource(String dbName, String tableName, long txnId) {
        ResourceLock prevResourceLock = (ResourceLock)this.locks.get(Warehouse.getQualifiedName((String)dbName, (String)tableName));
        if (prevResourceLock == null || prevResourceLock.txnId != txnId || prevResourceLock.state.get() != State.ACQUIRED) {
            return false;
        }
        prevResourceLock.lastHeartBeatTime.set(System.currentTimeMillis());
        return true;
    }

    public boolean unlockResource(String dbName, String tableName, long txnId) {
        String fullyQualifiedName = Warehouse.getQualifiedName((String)dbName, (String)tableName);
        ResourceLock prevResourceLock = (ResourceLock)this.locks.get(fullyQualifiedName);
        if (prevResourceLock == null || prevResourceLock.txnId != txnId) {
            return false;
        }
        return this.locks.remove(fullyQualifiedName, prevResourceLock);
    }

    public long cleanupResourceLocks(long timeout) {
        long removed = 0L;
        long currentTime = System.currentTimeMillis();
        Iterator it = this.locks.entrySet().iterator();
        while (it.hasNext()) {
            ResourceLock resourceLock = (ResourceLock)it.next().getValue();
            if (currentTime - resourceLock.lastHeartBeatTime.get() <= timeout || !resourceLock.state.compareAndSet(State.ACQUIRED, State.EXPIRED)) continue;
            it.remove();
            ++removed;
        }
        return removed;
    }

    private class ResourceLock {
        final long txnId;
        final AtomicLong lastHeartBeatTime;
        final AtomicStateEnum state;

        ResourceLock(MaterializationsRebuildLockHandler materializationsRebuildLockHandler, long txnId, long lastHeartBeatTime, State state) {
            this.txnId = txnId;
            this.lastHeartBeatTime = new AtomicLong(lastHeartBeatTime);
            this.state = new AtomicStateEnum(materializationsRebuildLockHandler, state);
        }
    }

    private static enum State {
        ACQUIRED,
        COMMIT_READY,
        EXPIRED;

    }

    private class AtomicStateEnum {
        private final AtomicReference<State> ref;

        public AtomicStateEnum(MaterializationsRebuildLockHandler materializationsRebuildLockHandler, State initialValue) {
            this.ref = new AtomicReference<State>(initialValue);
        }

        public void set(State newValue) {
            this.ref.set(newValue);
        }

        public State get() {
            return this.ref.get();
        }

        public State getAndSet(State newValue) {
            return this.ref.getAndSet(newValue);
        }

        public boolean compareAndSet(State expect, State update) {
            return this.ref.compareAndSet(expect, update);
        }
    }
}

