/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;

public final class HMSHandlerContext {
    private static final ThreadLocal<HMSHandlerContext> context = ThreadLocal.withInitial(() -> new HMSHandlerContext());
    private RawStore rawStore;
    private TxnStore txnStore;
    private HMSHandler hmsHandler;
    private Configuration configuration;
    private Map<String, String> modifiedConfig = new HashMap<String, String>();
    private String ipAddress;
    private Map<String, Timer.Context> timerContexts = new HashMap<String, Timer.Context>();

    private HMSHandlerContext() {
    }

    public static Optional<RawStore> getRawStore() {
        return Optional.ofNullable(HMSHandlerContext.context.get().rawStore);
    }

    public static Optional<HMSHandler> getHMSHandler() {
        return Optional.ofNullable(HMSHandlerContext.context.get().hmsHandler);
    }

    public static Optional<String> getIpAddress() {
        return Optional.ofNullable(HMSHandlerContext.context.get().ipAddress);
    }

    public static Optional<Configuration> getConfiguration() {
        return Optional.ofNullable(HMSHandlerContext.context.get().configuration);
    }

    public static TxnStore getTxnStore(Configuration conf) {
        if (HMSHandlerContext.context.get().txnStore == null) {
            HMSHandlerContext.setTxnStore(TxnUtils.getTxnStore(conf));
        }
        return HMSHandlerContext.context.get().txnStore;
    }

    public static Map<String, String> getModifiedConfig() {
        return HMSHandlerContext.context.get().modifiedConfig;
    }

    public static Map<String, Timer.Context> getTimerContexts() {
        return HMSHandlerContext.context.get().timerContexts;
    }

    public static void setRawStore(RawStore rawStore) {
        HMSHandlerContext.context.get().rawStore = rawStore;
    }

    public static void setTxnStore(TxnStore txnStore) {
        HMSHandlerContext.context.get().txnStore = txnStore;
    }

    public static void setHMSHandler(HMSHandler hmsHandler) {
        HMSHandlerContext.context.get().hmsHandler = hmsHandler;
    }

    public static void setConfiguration(Configuration conf) {
        HMSHandlerContext.context.get().configuration = conf;
    }

    public static void setIpAddress(String ipAddress) {
        HMSHandlerContext.context.get().ipAddress = ipAddress;
    }

    public static void clear() {
        context.remove();
    }
}

