/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class TimeBoundary
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private String startTime;
    private String endTime;
    private String timeZone;

    public TimeBoundary() {
        this(null, null, null);
    }

    public TimeBoundary(String startTime) {
        this(startTime, null, null);
    }

    public TimeBoundary(String startTime, String endTime) {
        this(startTime, endTime, null);
    }

    public TimeBoundary(String startTime, String endTime, String timeZone) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.timeZone = timeZone;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeBoundary that = (TimeBoundary)o;
        return Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime) && Objects.equals(this.timeZone, that.timeZone);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime, this.timeZone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TimeBoundary{");
        sb.append("startTime='").append(this.startTime).append("; endTime='").append(this.endTime).append("; timeZone='").append(this.timeZone).append('}');
        return sb.toString();
    }
}

