/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.common;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveClientCache;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hive.hcatalog.common.ErrorType;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.Pair;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchemaUtils;
import org.apache.hive.hcatalog.mapreduce.FosterStorageHandler;
import org.apache.hive.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hive.hcatalog.mapreduce.InputJobInfo;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hive.hcatalog.mapreduce.PartInfo;
import org.apache.hive.hcatalog.mapreduce.StorerInfo;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HCatUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HCatUtil.class);
    private static final HashMap<String, String> hiveConfCodeDefaults = Maps.newHashMapWithExpectedSize((int)HiveConf.ConfVars.values().length);
    private static volatile HiveClientCache hiveClientCache;

    public static boolean checkJobContextIfRunningFromBackend(JobContext j) {
        return !j.getConfiguration().get("pig.job.converted.fetch", "").isEmpty() || !j.getConfiguration().get("mapred.task.id", "").isEmpty() || "true".equals(j.getConfiguration().get("pig.illustrating"));
    }

    public static String serialize(Serializable obj) throws IOException {
        if (obj == null) {
            return "";
        }
        try {
            ByteArrayOutputStream serialObj = new ByteArrayOutputStream();
            ObjectOutputStream objStream = new ObjectOutputStream(serialObj);
            objStream.writeObject(obj);
            objStream.close();
            return HCatUtil.encodeBytes(serialObj.toByteArray());
        }
        catch (Exception e) {
            throw new IOException("Serialization error: " + e.getMessage(), e);
        }
    }

    public static Object deserialize(String str) throws IOException {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try {
            ByteArrayInputStream serialObj = new ByteArrayInputStream(HCatUtil.decodeBytes(str));
            ObjectInputStream objStream = new ObjectInputStream(serialObj);
            return objStream.readObject();
        }
        catch (Exception e) {
            throw new IOException("Deserialization error: " + e.getMessage(), e);
        }
    }

    public static String encodeBytes(byte[] bytes) {
        return new String(Base64.encodeBase64((byte[])bytes, (boolean)false, (boolean)false));
    }

    public static byte[] decodeBytes(String str) {
        return Base64.decodeBase64((byte[])str.getBytes());
    }

    public static List<HCatFieldSchema> getHCatFieldSchemaList(List<FieldSchema> fields) throws HCatException {
        if (fields == null) {
            return null;
        }
        ArrayList<HCatFieldSchema> result = new ArrayList<HCatFieldSchema>();
        for (FieldSchema f : fields) {
            result.add(HCatSchemaUtils.getHCatFieldSchema(f));
        }
        return result;
    }

    public static HCatSchema extractSchema(Table table) throws HCatException {
        return new HCatSchema(HCatUtil.getHCatFieldSchemaList(table.getCols()));
    }

    public static HCatSchema extractSchema(Partition partition) throws HCatException {
        return new HCatSchema(HCatUtil.getHCatFieldSchemaList(partition.getCols()));
    }

    public static List<FieldSchema> getFieldSchemaList(List<HCatFieldSchema> hcatFields) {
        if (hcatFields == null) {
            return null;
        }
        ArrayList<FieldSchema> result = new ArrayList<FieldSchema>();
        for (HCatFieldSchema f : hcatFields) {
            result.add(HCatSchemaUtils.getFieldSchema(f));
        }
        return result;
    }

    public static Table getTable(IMetaStoreClient client, String dbName, String tableName) throws TException {
        return new Table(client.getTable(dbName, tableName));
    }

    public static HCatSchema getTableSchemaWithPtnCols(Table table) throws IOException {
        HCatSchema tableSchema = new HCatSchema(HCatUtil.getHCatFieldSchemaList(table.getCols()));
        if (!table.getPartitionKeys().isEmpty()) {
            for (FieldSchema fs : table.getPartitionKeys()) {
                tableSchema.append(HCatSchemaUtils.getHCatFieldSchema(fs));
            }
        }
        return tableSchema;
    }

    public static HCatSchema getPartitionColumns(Table table) throws IOException {
        HCatSchema cols = new HCatSchema(new LinkedList<HCatFieldSchema>());
        if (!table.getPartitionKeys().isEmpty()) {
            for (FieldSchema fs : table.getPartitionKeys()) {
                cols.append(HCatSchemaUtils.getHCatFieldSchema(fs));
            }
        }
        return cols;
    }

    public static List<FieldSchema> validatePartitionSchema(Table table, HCatSchema partitionSchema) throws IOException {
        HashMap<String, FieldSchema> partitionKeyMap = new HashMap<String, FieldSchema>();
        for (FieldSchema field : table.getPartitionKeys()) {
            partitionKeyMap.put(field.getName().toLowerCase(), field);
        }
        List tableCols = table.getCols();
        ArrayList<FieldSchema> newFields = new ArrayList<FieldSchema>();
        for (int i = 0; i < partitionSchema.getFields().size(); ++i) {
            TypeInfo tableType;
            FieldSchema tableField;
            FieldSchema field = HCatSchemaUtils.getFieldSchema(partitionSchema.getFields().get(i));
            if (i < tableCols.size()) {
                tableField = (FieldSchema)tableCols.get(i);
                if (!tableField.getName().equalsIgnoreCase(field.getName())) {
                    throw new HCatException(ErrorType.ERROR_SCHEMA_COLUMN_MISMATCH, "Expected column <" + tableField.getName() + "> at position " + (i + 1) + ", found column <" + field.getName() + ">");
                }
            } else {
                tableField = (FieldSchema)partitionKeyMap.get(field.getName().toLowerCase());
                if (tableField != null) {
                    throw new HCatException(ErrorType.ERROR_SCHEMA_PARTITION_KEY, "Key <" + field.getName() + ">");
                }
            }
            if (tableField == null) {
                newFields.add(field);
                continue;
            }
            TypeInfo partitionType = TypeInfoUtils.getTypeInfoFromTypeString((String)field.getType());
            if (partitionType.equals((Object)(tableType = TypeInfoUtils.getTypeInfoFromTypeString((String)tableField.getType())))) continue;
            String msg = "Column <" + field.getName() + ">, expected <" + tableType.getTypeName() + ">, got <" + partitionType.getTypeName() + ">";
            LOG.warn(msg);
            throw new HCatException(ErrorType.ERROR_SCHEMA_TYPE_MISMATCH, msg);
        }
        return newFields;
    }

    public static boolean validateMorePermissive(FsAction first, FsAction second) {
        if (first == FsAction.ALL || second == FsAction.NONE || first == second) {
            return true;
        }
        return switch (first) {
            case FsAction.READ_EXECUTE -> {
                if (second == FsAction.READ || second == FsAction.EXECUTE) {
                    yield true;
                }
                yield false;
            }
            case FsAction.READ_WRITE -> {
                if (second == FsAction.READ || second == FsAction.WRITE) {
                    yield true;
                }
                yield false;
            }
            case FsAction.WRITE_EXECUTE -> {
                if (second == FsAction.WRITE || second == FsAction.EXECUTE) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean validateExecuteBitPresentIfReadOrWrite(FsAction perms) {
        return perms != FsAction.READ && perms != FsAction.WRITE && perms != FsAction.READ_WRITE;
    }

    public static Token<DelegationTokenIdentifier> getJobTrackerDelegationToken(Configuration conf, String userName) throws Exception {
        try (JobClient jcl = new JobClient(new JobConf(conf, HCatOutputFormat.class));){
            Token token = jcl.getDelegationToken(new Text(userName));
            return token;
        }
    }

    public static Token<? extends AbstractDelegationTokenIdentifier> extractThriftToken(String tokenStrForm, String tokenSignature) throws IOException {
        Token t = new Token();
        t.decodeFromUrlString(tokenStrForm);
        t.setService(new Text(tokenSignature));
        return t;
    }

    public static HiveStorageHandler getStorageHandler(Configuration conf, StorerInfo storerInfo) throws IOException {
        return HCatUtil.getStorageHandler(conf, storerInfo.getStorageHandlerClass(), storerInfo.getSerdeClass(), storerInfo.getIfClass(), storerInfo.getOfClass());
    }

    public static HiveStorageHandler getStorageHandler(Configuration conf, PartInfo partitionInfo) throws IOException {
        return HCatUtil.getStorageHandler(conf, partitionInfo.getStorageHandlerClassName(), partitionInfo.getSerdeClassName(), partitionInfo.getInputFormatClassName(), partitionInfo.getOutputFormatClassName());
    }

    public static HiveStorageHandler getStorageHandler(Configuration conf, String storageHandler, String serDe, String inputFormat, String outputFormat) throws IOException {
        if (storageHandler == null || storageHandler.equals(FosterStorageHandler.class.getName())) {
            try {
                FosterStorageHandler fosterStorageHandler = new FosterStorageHandler(inputFormat, outputFormat, serDe);
                fosterStorageHandler.setConf(conf);
                return fosterStorageHandler;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Failed to load foster storage handler", e);
            }
        }
        try {
            Class<?> handlerClass = Class.forName(storageHandler, true, Utilities.getSessionSpecifiedClassLoader());
            return (HiveStorageHandler)ReflectionUtils.newInstance(handlerClass, (Configuration)conf);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error in loading storage handler." + e.getMessage(), e);
        }
    }

    public static Pair<String, String> getDbAndTableName(String tableName) throws IOException {
        String[] dbTableNametokens = tableName.split("\\.");
        if (dbTableNametokens.length == 1) {
            return new Pair<String, String>("default", tableName);
        }
        if (dbTableNametokens.length == 2) {
            return new Pair<String, String>(dbTableNametokens[0], dbTableNametokens[1]);
        }
        throw new IOException("tableName expected in the form <databasename>.<table name> or <table name>. Got " + tableName);
    }

    public static Map<String, String> getInputJobProperties(HiveStorageHandler storageHandler, InputJobInfo inputJobInfo) {
        Properties props = inputJobInfo.getTableInfo().getStorerInfo().getProperties();
        props.put("serialization.lib", storageHandler.getSerDeClass().getName());
        TableDesc tableDesc = new TableDesc(storageHandler.getInputFormatClass(), storageHandler.getOutputFormatClass(), props);
        if (tableDesc.getJobProperties() == null) {
            tableDesc.setJobProperties(new HashMap());
        }
        Properties mytableProperties = tableDesc.getProperties();
        mytableProperties.setProperty("name", inputJobInfo.getDatabaseName() + "." + inputJobInfo.getTableName());
        HashMap<String, String> jobProperties = new HashMap<String, String>();
        try {
            Map properties = tableDesc.getJobProperties();
            LinkedList<InputJobInfo> inputJobInfos = (LinkedList<InputJobInfo>)HCatUtil.deserialize((String)properties.get("mapreduce.lib.hcat.job.info"));
            if (inputJobInfos == null) {
                inputJobInfos = new LinkedList<InputJobInfo>();
            }
            inputJobInfos.add(inputJobInfo);
            properties.put("mapreduce.lib.hcat.job.info", HCatUtil.serialize(inputJobInfos));
            storageHandler.configureInputJobProperties(tableDesc, jobProperties);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to configure StorageHandler", e);
        }
        return jobProperties;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static void configureOutputStorageHandler(HiveStorageHandler storageHandler, Configuration conf, OutputJobInfo outputJobInfo) {
        Properties props = outputJobInfo.getTableInfo().getStorerInfo().getProperties();
        props.put("serialization.lib", storageHandler.getSerDeClass().getName());
        TableDesc tableDesc = new TableDesc(storageHandler.getInputFormatClass(), IgnoreKeyTextOutputFormat.class, props);
        if (tableDesc.getJobProperties() == null) {
            tableDesc.setJobProperties(new HashMap());
        }
        for (Map.Entry el : conf) {
            tableDesc.getJobProperties().put((String)el.getKey(), (String)el.getValue());
        }
        Properties mytableProperties = tableDesc.getProperties();
        mytableProperties.setProperty("name", outputJobInfo.getDatabaseName() + "." + outputJobInfo.getTableName());
        HashMap<String, String> jobProperties = new HashMap<String, String>();
        try {
            String jobString;
            tableDesc.getJobProperties().put("mapreduce.lib.hcatoutput.info", HCatUtil.serialize(outputJobInfo));
            storageHandler.configureOutputJobProperties(tableDesc, jobProperties);
            Map tableJobProperties = tableDesc.getJobProperties();
            if (tableJobProperties != null && tableJobProperties.containsKey("mapreduce.lib.hcatoutput.info") && (jobString = (String)tableJobProperties.get("mapreduce.lib.hcatoutput.info")) != null && !jobProperties.containsKey("mapreduce.lib.hcatoutput.info")) {
                jobProperties.put("mapreduce.lib.hcatoutput.info", (String)tableJobProperties.get("mapreduce.lib.hcatoutput.info"));
            }
            for (Map.Entry el : jobProperties.entrySet()) {
                conf.set((String)el.getKey(), (String)el.getValue());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to configure StorageHandler", e);
        }
    }

    public static void copyConf(Configuration src, Configuration dest) {
        dest.clear();
        for (Map.Entry el : src) {
            dest.set((String)el.getKey(), (String)el.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IMetaStoreClient getHiveMetastoreClient(HiveConf hiveConf) throws MetaException, IOException {
        if (hiveConf.getBoolean("hcatalog.hive.client.cache.disabled", false)) {
            return HiveClientCache.getNonCachedHiveMetastoreClient((HiveConf)hiveConf);
        }
        if (hiveClientCache != null) return hiveClientCache.get(hiveConf);
        Class<IMetaStoreClient> clazz = IMetaStoreClient.class;
        synchronized (IMetaStoreClient.class) {
            if (hiveClientCache != null) return hiveClientCache.get(hiveConf);
            hiveClientCache = new HiveClientCache(hiveConf.getInt("hcatalog.hive.client.cache.expiry.time", 120), hiveConf.getInt("hcatalog.hive.client.cache.initial.capacity", 50), hiveConf.getInt("hcatalog.hive.client.cache.max.capacity", 50), hiveConf.getBoolean("hcatalog.hive.client.cache.stats.enabled", false));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return hiveClientCache.get(hiveConf);
        }
    }

    @Deprecated
    public static HiveMetaStoreClient getHiveClient(HiveConf hiveConf) throws MetaException {
        LOG.warn("HCatUtil.getHiveClient is unsafe and can be a resource leak depending on HMSC implementation and caching mechanism. Use HCatUtil.getHiveMetastoreClient instead.");
        return new HiveMetaStoreClient((Configuration)hiveConf);
    }

    public static void closeHiveClientQuietly(IMetaStoreClient client) {
        try {
            if (client != null) {
                client.close();
            }
        }
        catch (Exception e) {
            LOG.debug("Error closing metastore client. Ignored the error.", (Throwable)e);
        }
    }

    private static Configuration getHiveSiteContentsFromClasspath() {
        Configuration configuration = new Configuration(false);
        configuration.addResource("hive-site.xml");
        return configuration;
    }

    private static Properties getHiveSiteOverrides(Configuration jobConf) {
        return HCatUtil.getHiveSiteOverrides(HCatUtil.getHiveSiteContentsFromClasspath(), jobConf);
    }

    private static Properties getHiveSiteOverrides(Configuration hiveSite, Configuration jobConf) {
        Properties difference = new Properties();
        for (Map.Entry keyValue : hiveSite) {
            String key = (String)keyValue.getKey();
            String hiveSiteValue = (String)keyValue.getValue();
            String jobConfValue = jobConf.getRaw(key);
            if (jobConfValue == null) {
                difference.put(key, hiveSiteValue);
                continue;
            }
            if (!hiveConfCodeDefaults.containsKey(key) || jobConfValue.equals(hiveConfCodeDefaults.get(key))) continue;
            difference.put(key, jobConfValue);
        }
        LOG.info("Configuration differences=" + String.valueOf(difference));
        return difference;
    }

    public static HiveConf getHiveConf(Configuration conf) throws IOException {
        HiveConf hiveConf = new HiveConf(conf, HCatUtil.class);
        if (StringUtils.isBlank((CharSequence)conf.get("mapreduce.lib.hcatoutput.hive.conf"))) {
            LOG.info("mapreduce.lib.hcatoutput.hive.conf not set. Generating configuration differences.");
            Properties differences = HCatUtil.getHiveSiteOverrides(conf);
            conf.set("mapreduce.lib.hcatoutput.hive.conf", HCatUtil.serialize(differences));
        } else {
            LOG.info("mapreduce.lib.hcatoutput.hive.conf is set. Applying configuration differences.");
            Properties properties = (Properties)HCatUtil.deserialize(conf.get("mapreduce.lib.hcatoutput.hive.conf"));
            HCatUtil.storePropertiesToHiveConf(properties, hiveConf);
        }
        if (conf.get("mapreduce.lib.hcatoutput.token.sig") != null) {
            hiveConf.setVar(HiveConf.ConfVars.METASTORE_TOKEN_SIGNATURE, conf.get("mapreduce.lib.hcatoutput.token.sig"));
        }
        return hiveConf;
    }

    public static void storePropertiesToHiveConf(Properties properties, HiveConf hiveConf) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            Object selector0$temp = value;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class, Boolean.class, Long.class, Float.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    String s = (String)selector0$temp;
                    hiveConf.set((String)key, s);
                    break;
                }
                case 1: {
                    Integer i = (Integer)selector0$temp;
                    hiveConf.setInt((String)key, i.intValue());
                    break;
                }
                case 2: {
                    Boolean b = (Boolean)selector0$temp;
                    hiveConf.setBoolean((String)key, b.booleanValue());
                    break;
                }
                case 3: {
                    Long l = (Long)selector0$temp;
                    hiveConf.setLong((String)key, l.longValue());
                    break;
                }
                case 4: {
                    Float v = (Float)selector0$temp;
                    hiveConf.setFloat((String)key, v.floatValue());
                    break;
                }
                default: {
                    LOG.warn("Unsupported type: key=" + String.valueOf(key) + " value=" + String.valueOf(value));
                }
            }
        }));
    }

    public static JobConf getJobConfFromContext(JobContext jobContext) {
        JobConf jobConf = new JobConf(jobContext.getConfiguration());
        return jobConf;
    }

    public static Map<String, String> getHCatKeyHiveConf(JobConf conf) {
        try {
            Properties properties;
            if (!StringUtils.isBlank((CharSequence)conf.get("mapreduce.lib.hcatoutput.hive.conf"))) {
                properties = (Properties)HCatUtil.deserialize(conf.get("mapreduce.lib.hcatoutput.hive.conf"));
                LOG.info("mapreduce.lib.hcatoutput.hive.conf is set. Using differences=" + String.valueOf(properties));
            } else {
                LOG.info("mapreduce.lib.hcatoutput.hive.conf not set. Generating configuration differences.");
                properties = HCatUtil.getHiveSiteOverrides((Configuration)conf);
            }
            return Maps.fromProperties((Properties)properties);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deserialize hive conf", e);
        }
    }

    public static void copyJobPropertiesToJobConf(Map<String, String> jobProperties, JobConf jobConf) {
        for (Map.Entry<String, String> entry : jobProperties.entrySet()) {
            jobConf.set(entry.getKey(), entry.getValue());
        }
    }

    public static boolean isHadoop23() {
        String version = VersionInfo.getVersion();
        return version.matches("\\b0\\.23\\..+\\b") || version.matches("\\b2\\..*") || version.matches("\\b3\\..*");
    }

    public static String makePathASafeFileName(String filePath) {
        return new File(filePath).getPath().replaceAll("\\\\", "/");
    }

    public static void assertNotNull(Object t, String msg, Logger logger) {
        if (t == null) {
            if (logger != null) {
                logger.warn(msg);
            }
            throw new IllegalArgumentException(msg);
        }
    }

    public static void putInputJobInfoToConf(InputJobInfo inputJobInfo, Configuration conf) throws IOException {
        LinkedList<InputJobInfo> inputJobInfos = (LinkedList<InputJobInfo>)HCatUtil.deserialize(conf.get("mapreduce.lib.hcat.job.info"));
        if (inputJobInfos == null) {
            inputJobInfos = new LinkedList<InputJobInfo>();
        }
        inputJobInfos.add(inputJobInfo);
        conf.set("mapreduce.lib.hcat.job.info", HCatUtil.serialize(inputJobInfos));
    }

    public static LinkedList<InputJobInfo> getInputJobInfosFromConf(Configuration conf) throws IOException {
        LinkedList inputJobInfos = (LinkedList)HCatUtil.deserialize(conf.get("mapreduce.lib.hcat.job.info"));
        return inputJobInfos;
    }

    public static InputJobInfo getLastInputJobInfosFromConf(Configuration conf) throws IOException {
        LinkedList<InputJobInfo> inputJobInfos = HCatUtil.getInputJobInfosFromConf(conf);
        if (inputJobInfos == null || inputJobInfos.isEmpty()) {
            return null;
        }
        return HCatUtil.getInputJobInfosFromConf(conf).getLast();
    }

    static {
        for (HiveConf.ConfVars var : HiveConf.ConfVars.values()) {
            hiveConfCodeDefaults.put(var.toString(), var.getDefaultValue());
        }
    }
}

