/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixException;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigResource.class);

    public ConfigResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    String getValue(String key) {
        return (String)this.getRequest().getAttributes().get(key);
    }

    static StringRepresentation getConfigScopes() throws Exception {
        StringRepresentation representation = null;
        ZNRecord record = new ZNRecord("Config");
        List<String> scopeList = Arrays.asList(HelixConfigScope.ConfigScopeProperty.CLUSTER.toString(), HelixConfigScope.ConfigScopeProperty.RESOURCE.toString(), HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString(), HelixConfigScope.ConfigScopeProperty.PARTITION.toString());
        record.setListField("scopes", scopeList);
        representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(record), MediaType.APPLICATION_JSON);
        return representation;
    }

    StringRepresentation getConfigKeys(HelixConfigScope.ConfigScopeProperty scopeProperty, String ... keys) throws Exception {
        StringRepresentation representation = null;
        ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
        ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkClient);
        HelixAdmin admin = setupTool.getClusterManagementTool();
        ZNRecord record = new ZNRecord(scopeProperty + " Config");
        HelixConfigScope scope = new HelixConfigScopeBuilder(scopeProperty, keys).build();
        List configKeys = admin.getConfigKeys(scope);
        record.setListField(scopeProperty.toString(), configKeys);
        representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(record), MediaType.APPLICATION_JSON);
        return representation;
    }

    StringRepresentation getConfigs(HelixConfigScope.ConfigScopeProperty scopeProperty, String ... keys) throws Exception {
        StringRepresentation representation = null;
        ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
        ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkClient);
        HelixAdmin admin = setupTool.getClusterManagementTool();
        ZNRecord record = new ZNRecord(scopeProperty + " Config");
        HelixConfigScope scope = new HelixConfigScopeBuilder(scopeProperty, keys).build();
        List configKeys = admin.getConfigKeys(scope);
        Map configs = admin.getConfig(scope, configKeys);
        record.setSimpleFields(configs);
        representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(record), MediaType.APPLICATION_JSON);
        return representation;
    }

    public Representation get() {
        StringRepresentation representation = null;
        String clusterName = this.getValue("clusterName");
        String scopeStr = this.getValue("scope");
        try {
            if (scopeStr == null) {
                return ConfigResource.getConfigScopes();
            }
            scopeStr = scopeStr.toUpperCase();
            HelixConfigScope.ConfigScopeProperty scopeProperty = HelixConfigScope.ConfigScopeProperty.valueOf((String)scopeStr);
            switch (scopeProperty) {
                case CLUSTER: 
                case PARTICIPANT: 
                case RESOURCE: {
                    String scopeKey1 = this.getValue("scopeKey1");
                    if (scopeKey1 == null) {
                        representation = this.getConfigKeys(scopeProperty, clusterName);
                        break;
                    }
                    representation = this.getConfigs(scopeProperty, clusterName, scopeKey1);
                    break;
                }
                case PARTITION: {
                    String scopeKey1 = this.getValue("scopeKey1");
                    String scopeKey2 = this.getValue("scopeKey2");
                    if (scopeKey1 == null) {
                        throw new HelixException("Missing resourceName");
                    }
                    if (scopeKey2 == null) {
                        representation = this.getConfigKeys(scopeProperty, clusterName, scopeKey1);
                        break;
                    }
                    representation = this.getConfigs(scopeProperty, clusterName, scopeKey1, scopeKey2);
                    break;
                }
            }
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            representation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("", (Throwable)e);
        }
        return representation;
    }

    void setConfigs(Representation entity, HelixConfigScope.ConfigScopeProperty type, String scopeArgs) throws Exception {
        JsonParameters jsonParameters = new JsonParameters(entity);
        String command = jsonParameters.getCommand();
        ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
        ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkClient);
        if (command.equalsIgnoreCase("setConfig")) {
            jsonParameters.verifyCommand("setConfig");
            String propertiesStr = jsonParameters.getParameter("configs");
            setupTool.setConfig(type, scopeArgs, propertiesStr);
        } else if (command.equalsIgnoreCase("removeConfig")) {
            jsonParameters.verifyCommand("removeConfig");
            String propertiesStr = jsonParameters.getParameter("configs");
            setupTool.removeConfig(type, scopeArgs, propertiesStr);
        } else {
            throw new HelixException("Unsupported command: " + command + ". Should be one of [setConfig, removeConfig]");
        }
        this.getResponse().setEntity(this.get());
        this.getResponse().setStatus(Status.SUCCESS_OK);
    }

    public Representation post(Representation entity) {
        String clusterName = this.getValue("clusterName");
        String scopeStr = this.getValue("scope").toUpperCase();
        try {
            HelixConfigScope.ConfigScopeProperty scopeProperty = HelixConfigScope.ConfigScopeProperty.valueOf((String)scopeStr);
            switch (scopeProperty) {
                case CLUSTER: {
                    String scopeArgs = clusterName;
                    this.setConfigs(entity, scopeProperty, scopeArgs);
                    break;
                }
                case PARTICIPANT: 
                case RESOURCE: {
                    String scopeKey1 = this.getValue("scopeKey1");
                    if (scopeKey1 == null) {
                        throw new HelixException("Missing resourceName|participantName");
                    }
                    String scopeArgs = clusterName + "," + scopeKey1;
                    this.setConfigs(entity, scopeProperty, scopeArgs);
                    break;
                }
                case PARTITION: {
                    String scopeKey1 = this.getValue("scopeKey1");
                    String scopeKey2 = this.getValue("scopeKey2");
                    if (scopeKey1 == null || scopeKey2 == null) {
                        throw new HelixException("Missing resourceName|partitionName");
                    }
                    String scopeArgs = clusterName + "," + scopeKey1 + "," + scopeKey2;
                    this.setConfigs(entity, scopeProperty, scopeArgs);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error in posting " + entity, (Throwable)e);
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        return null;
    }
}

