/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.changedetector.trimmer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixProperty;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public abstract class HelixPropertyTrimmer<T extends HelixProperty> {
    protected abstract Map<FieldType, Set<String>> getNonTrimmableFields(T var1);

    protected Map<FieldType, Set<String>> getNonTrimmableKeys(T property) {
        HashMap<FieldType, Set<String>> nonTrimmableKeys = new HashMap<FieldType, Set<String>>();
        nonTrimmableKeys.put(FieldType.MAP_FIELD, ((HelixProperty)property).getRecord().getMapFields().keySet());
        nonTrimmableKeys.put(FieldType.LIST_FIELD, ((HelixProperty)property).getRecord().getListFields().keySet());
        return nonTrimmableKeys;
    }

    public abstract T trimProperty(T var1);

    protected ZNRecord doTrim(T originalProperty) {
        ZNRecord originalZNRecord = ((HelixProperty)originalProperty).getRecord();
        ZNRecord trimmedZNRecord = new ZNRecord(((HelixProperty)originalProperty).getId());
        this.copyNonTrimmableInfo(originalZNRecord, trimmedZNRecord, this.getNonTrimmableFields(originalProperty), false);
        this.copyNonTrimmableInfo(originalZNRecord, trimmedZNRecord, this.getNonTrimmableKeys(originalProperty), true);
        return trimmedZNRecord;
    }

    private void copyNonTrimmableInfo(ZNRecord originalZNRecord, ZNRecord trimmedZNRecord, Map<FieldType, Set<String>> nonTrimmableFields, boolean trimValue) {
        for (Map.Entry<FieldType, Set<String>> fieldEntry : nonTrimmableFields.entrySet()) {
            FieldType fieldType = fieldEntry.getKey();
            Set<String> fieldKeySet = fieldEntry.getValue();
            if (null == fieldKeySet || fieldKeySet.isEmpty()) continue;
            switch (fieldType) {
                case SIMPLE_FIELD: {
                    fieldKeySet.stream().forEach(fieldKey -> {
                        if (originalZNRecord.getSimpleFields().containsKey(fieldKey)) {
                            trimmedZNRecord.getSimpleFields().putIfAbsent((String)fieldKey, trimValue ? null : originalZNRecord.getSimpleField((String)fieldKey));
                        }
                    });
                    break;
                }
                case LIST_FIELD: {
                    fieldKeySet.stream().forEach(fieldKey -> {
                        if (originalZNRecord.getListFields().containsKey(fieldKey)) {
                            trimmedZNRecord.getListFields().putIfAbsent((String)fieldKey, trimValue ? Collections.EMPTY_LIST : originalZNRecord.getListField((String)fieldKey));
                        }
                    });
                    break;
                }
                case MAP_FIELD: {
                    fieldKeySet.stream().forEach(fieldKey -> {
                        if (originalZNRecord.getMapFields().containsKey(fieldKey)) {
                            trimmedZNRecord.getMapFields().putIfAbsent((String)fieldKey, trimValue ? Collections.EMPTY_MAP : originalZNRecord.getMapField((String)fieldKey));
                        }
                    });
                    break;
                }
            }
        }
    }

    static enum FieldType {
        SIMPLE_FIELD,
        LIST_FIELD,
        MAP_FIELD;

    }
}

