/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class ZKNodeTracker
extends ZKListener {
    protected static final Logger LOG = LoggerFactory.getLogger(ZKNodeTracker.class);
    protected final String node;
    private byte[] data;
    protected final Abortable abortable;
    private boolean stopped = false;

    public ZKNodeTracker(ZKWatcher watcher, String node, Abortable abortable) {
        super(watcher);
        this.node = node;
        this.abortable = abortable;
        this.data = null;
    }

    public synchronized void start() {
        this.watcher.registerListener(this);
        try {
            if (ZKUtil.watchAndCheckExists(this.watcher, this.node)) {
                byte[] data = ZKUtil.getDataAndWatch(this.watcher, this.node);
                if (data != null) {
                    this.data = data;
                } else {
                    LOG.debug("Try starting again because there is no data from {}", (Object)this.node);
                    this.start();
                }
            }
        }
        catch (KeeperException e) {
            this.abortable.abort("Unexpected exception during initialization, aborting", (Throwable)e);
        }
        this.postStart();
    }

    protected void postStart() {
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    public synchronized byte[] blockUntilAvailable() throws InterruptedException {
        return this.blockUntilAvailable(0L, false);
    }

    public synchronized byte[] blockUntilAvailable(long timeout, boolean refresh) throws InterruptedException {
        boolean nodeExistsChecked;
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        boolean notimeout = timeout == 0L;
        long startTime = EnvironmentEdgeManager.currentTime();
        long remaining = timeout;
        if (refresh) {
            try {
                this.data = ZKUtil.getDataAndWatch(this.watcher, this.node);
            }
            catch (KeeperException e) {
                LOG.warn("Unexpected exception handling blockUntilAvailable", (Throwable)e);
                this.abortable.abort("Unexpected exception handling blockUntilAvailable", (Throwable)e);
            }
        }
        boolean bl = nodeExistsChecked = !refresh || this.data != null;
        while (!this.stopped && (notimeout || remaining > 0L) && this.data == null) {
            if (!nodeExistsChecked) {
                try {
                    nodeExistsChecked = ZKUtil.checkExists(this.watcher, this.node) != -1;
                }
                catch (KeeperException e) {
                    LOG.warn("Got exception while trying to check existence in  ZooKeeper of the node: " + this.node + ", retrying if timeout not reached", (Throwable)e);
                }
                if (nodeExistsChecked) {
                    LOG.debug("Node {} now exists, resetting a watcher", (Object)this.node);
                    try {
                        this.data = ZKUtil.getDataAndWatch(this.watcher, this.node);
                    }
                    catch (KeeperException e) {
                        LOG.warn("Unexpected exception handling blockUntilAvailable", (Throwable)e);
                        this.abortable.abort("Unexpected exception handling blockUntilAvailable", (Throwable)e);
                    }
                }
            }
            this.wait(100L);
            remaining = timeout - (EnvironmentEdgeManager.currentTime() - startTime);
        }
        return this.data;
    }

    public synchronized byte[] getData(boolean refresh) {
        if (refresh) {
            try {
                this.data = ZKUtil.getDataAndWatch(this.watcher, this.node);
            }
            catch (KeeperException e) {
                this.abortable.abort("Unexpected exception handling getData", (Throwable)e);
            }
        }
        return this.data;
    }

    public String getNode() {
        return this.node;
    }

    @Override
    public synchronized void nodeCreated(String path) {
        if (!path.equals(this.node)) {
            return;
        }
        try {
            byte[] data = ZKUtil.getDataAndWatch(this.watcher, this.node);
            if (data != null) {
                this.data = data;
                this.notifyAll();
            } else {
                this.nodeDeleted(path);
            }
        }
        catch (KeeperException e) {
            this.abortable.abort("Unexpected exception handling nodeCreated event", (Throwable)e);
        }
    }

    @Override
    public synchronized void nodeDeleted(String path) {
        if (path.equals(this.node)) {
            try {
                if (ZKUtil.watchAndCheckExists(this.watcher, this.node)) {
                    this.nodeCreated(path);
                } else {
                    this.data = null;
                }
            }
            catch (KeeperException e) {
                this.abortable.abort("Unexpected exception handling nodeDeleted event", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void nodeDataChanged(String path) {
        if (path.equals(this.node)) {
            this.nodeCreated(path);
        }
    }

    public boolean checkIfBaseNodeAvailable() {
        try {
            if (ZKUtil.checkExists(this.watcher, this.watcher.getZNodePaths().baseZNode) == -1) {
                return false;
            }
        }
        catch (KeeperException e) {
            this.abortable.abort("Exception while checking if basenode (" + this.watcher.getZNodePaths().baseZNode + ") exists in ZooKeeper.", (Throwable)e);
        }
        return true;
    }

    public String toString() {
        return "ZKNodeTracker{node='" + this.node + ", stopped=" + this.stopped + '}';
    }
}

