/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.CreateStoreFileWriterParams;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, SmallTests.class})
public class TestCacheOnWriteInSchema {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCacheOnWriteInSchema.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCacheOnWriteInSchema.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    private static final String DIR = TEST_UTIL.getDataTestDir("TestCacheOnWriteInSchema").toString();
    private static byte[] table;
    private static byte[] family;
    private static final int NUM_KV = 25000;
    private static final Random rand;
    private static final int NUM_VALID_KEY_TYPES;
    private final CacheOnWriteType cowType;
    private Configuration conf;
    private final String testDescription;
    private HRegion region;
    private HStore store;
    private FileSystem fs;

    public TestCacheOnWriteInSchema(CacheOnWriteType cowType) {
        this.cowType = cowType;
        this.testDescription = "[cacheOnWrite=" + (Object)((Object)cowType) + "]";
        System.out.println(this.testDescription);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> cowTypes = new ArrayList<Object[]>();
        for (CacheOnWriteType cowType : CacheOnWriteType.values()) {
            cowTypes.add(new Object[]{cowType});
        }
        return cowTypes;
    }

    @Before
    public void setUp() throws IOException {
        table = Bytes.toBytes((String)this.name.getMethodName().replaceAll("[\\[\\]]", "_"));
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setInt("hfile.format.version", 3);
        this.conf.setBoolean("hbase.rs.cacheblocksonwrite", false);
        this.conf.setBoolean("hfile.block.index.cacheonwrite", false);
        this.conf.setBoolean("hfile.block.bloom.cacheonwrite", false);
        this.fs = HFileSystem.get((Configuration)this.conf);
        ColumnFamilyDescriptor hcd = this.cowType.modifyFamilySchema(ColumnFamilyDescriptorBuilder.newBuilder((byte[])family).setBloomFilterType(BloomType.ROWCOL)).build();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])table)).setColumnFamily(hcd).build();
        String id = TestCacheOnWriteInSchema.class.getName();
        Path logdir = new Path(CommonFSUtils.getRootDir((Configuration)this.conf), AbstractFSWALProvider.getWALDirectoryName((String)id));
        this.fs.delete(logdir, true);
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        this.region = HBaseTestingUtility.createRegionAndWAL(info, logdir, this.conf, htd, BlockCacheFactory.createBlockCache((Configuration)this.conf));
        this.store = this.region.getStore(hcd.getName());
    }

    @After
    public void tearDown() throws IOException {
        IOException ex = null;
        try {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
        }
        catch (IOException e) {
            LOG.warn("Caught Exception", (Throwable)e);
            ex = e;
        }
        try {
            this.fs.delete(new Path(DIR), true);
        }
        catch (IOException e) {
            LOG.error("Could not delete " + DIR, (Throwable)e);
            ex = e;
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Test
    public void testCacheOnWriteInSchema() throws IOException {
        StoreFileWriter writer = this.store.getStoreEngine().createWriter(CreateStoreFileWriterParams.create().maxKeyCount(Integer.MAX_VALUE).compression(HFile.DEFAULT_COMPRESSION_ALGORITHM).isCompaction(false).includeMVCCReadpoint(true).includesTag(false).shouldDropBehind(false));
        this.writeStoreFile(writer);
        writer.close();
        this.readStoreFile(writer.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStoreFile(Path path) throws IOException {
        CacheConfig cacheConf = this.store.getCacheConfig();
        BlockCache cache = (BlockCache)cacheConf.getBlockCache().get();
        HStoreFile sf = new HStoreFile(this.fs, path, this.conf, cacheConf, BloomType.ROWCOL, true);
        sf.initReader();
        try (HFile.Reader reader = sf.getReader().getHFileReader();){
            HFileBlock block;
            HFileScanner scanner = reader.getScanner(this.conf, false, false);
            Assert.assertTrue((String)this.testDescription, (boolean)scanner.seekTo());
            for (long offset = 0L; offset < reader.getTrailer().getLoadOnOpenDataOffset(); offset += (long)block.getOnDiskSizeWithHeader()) {
                block = reader.readBlock(offset, -1L, false, true, false, true, null, DataBlockEncoding.NONE);
                BlockCacheKey blockCacheKey = new BlockCacheKey(reader.getName(), offset);
                boolean isCached = cache.getBlock(blockCacheKey, true, false, true) != null;
                boolean shouldBeCached = this.cowType.shouldBeCached(block.getBlockType());
                BlockType blockType = block.getBlockType();
                if (shouldBeCached != isCached && (this.cowType.blockType1.equals((Object)blockType) || this.cowType.blockType2.equals((Object)blockType))) {
                    throw new AssertionError((Object)("shouldBeCached: " + shouldBeCached + "\nisCached: " + isCached + "\nTest description: " + this.testDescription + "\nblock: " + block + "\nblockCacheKey: " + blockCacheKey));
                }
            }
        }
    }

    private static KeyValue.Type generateKeyType(Random rand) {
        if (rand.nextBoolean()) {
            return KeyValue.Type.Put;
        }
        KeyValue.Type keyType = KeyValue.Type.values()[1 + rand.nextInt(NUM_VALID_KEY_TYPES)];
        if (keyType == KeyValue.Type.Minimum || keyType == KeyValue.Type.Maximum) {
            throw new RuntimeException("Generated an invalid key type: " + keyType + ". Probably the layout of KeyValue.Type has changed.");
        }
        return keyType;
    }

    private void writeStoreFile(StoreFileWriter writer) throws IOException {
        int rowLen = 32;
        for (int i = 0; i < 25000; ++i) {
            byte[] k = RandomKeyValueUtil.randomOrderedKey(rand, i);
            byte[] v = RandomKeyValueUtil.randomValue(rand);
            int cfLen = rand.nextInt(k.length - 32 + 1);
            KeyValue kv = new KeyValue(k, 0, 32, k, 32, cfLen, k, 32 + cfLen, k.length - 32 - cfLen, rand.nextLong(), TestCacheOnWriteInSchema.generateKeyType(rand), v, 0, v.length);
            writer.append((Cell)kv);
        }
    }

    static {
        family = Bytes.toBytes((String)"family");
        rand = new Random(12983177L);
        NUM_VALID_KEY_TYPES = KeyValue.Type.values().length - 2;
    }

    private static enum CacheOnWriteType {
        DATA_BLOCKS(BlockType.DATA, BlockType.ENCODED_DATA),
        BLOOM_BLOCKS(BlockType.BLOOM_CHUNK),
        INDEX_BLOCKS(BlockType.LEAF_INDEX, BlockType.INTERMEDIATE_INDEX);

        private final BlockType blockType1;
        private final BlockType blockType2;

        private CacheOnWriteType(BlockType blockType) {
            this(blockType, blockType);
        }

        private CacheOnWriteType(BlockType blockType1, BlockType blockType2) {
            this.blockType1 = blockType1;
            this.blockType2 = blockType2;
        }

        public boolean shouldBeCached(BlockType blockType) {
            return blockType == this.blockType1 || blockType == this.blockType2;
        }

        public ColumnFamilyDescriptorBuilder modifyFamilySchema(ColumnFamilyDescriptorBuilder builder) {
            switch (this) {
                case DATA_BLOCKS: {
                    builder.setCacheDataOnWrite(true);
                    break;
                }
                case BLOOM_BLOCKS: {
                    builder.setCacheBloomsOnWrite(true);
                    break;
                }
                case INDEX_BLOCKS: {
                    builder.setCacheIndexesOnWrite(true);
                }
            }
            return builder;
        }
    }
}

