/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMultimap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RSMobFileCleanerChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(RSMobFileCleanerChore.class);
    private final HRegionServer rs;

    public RSMobFileCleanerChore(HRegionServer rs) {
        super(rs.getServerName() + "-MobFileCleanerChore", rs, rs.getConfiguration().getInt("hbase.master.mob.cleaner.period", 86400), Math.round((double)rs.getConfiguration().getInt("hbase.master.mob.cleaner.period", 86400) * (ThreadLocalRandom.current().nextDouble() + 0.5)), TimeUnit.SECONDS);
        this.rs = rs;
    }

    public RSMobFileCleanerChore() {
        this.rs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void chore() {
        long minAgeToArchive = this.rs.getConfiguration().getLong("hbase.mob.min.age.archive", 3600000L);
        long maxCreationTimeToArchive = EnvironmentEdgeManager.currentTime() - minAgeToArchive;
        TableDescriptors htds = this.rs.getTableDescriptors();
        try {
            FileSystem fs = FileSystem.get((Configuration)this.rs.getConfiguration());
            Map<String, TableDescriptor> map = null;
            try {
                map = htds.getAll();
            }
            catch (IOException e) {
                LOG.error("MobFileCleanerChore failed", (Throwable)e);
                return;
            }
            HashMap<String, Map> referencedMOBs = new HashMap<String, Map>();
            for (TableDescriptor htd : map.values()) {
                LOG.info("Cleaning obsolete MOB files from table={}", (Object)htd.getTableName());
                List<ColumnFamilyDescriptor> list = MobUtils.getMobColumnFamilies(htd);
                if (list.isEmpty()) continue;
                List<HRegion> regions = this.rs.getRegions(htd.getTableName());
                for (HRegion region : regions) {
                    for (ColumnFamilyDescriptor hcd : list) {
                        HStore store = region.getStore(hcd.getName());
                        Collection<HStoreFile> sfs = store.getStorefiles();
                        HashSet regionMobs = new HashSet();
                        Path currentPath = null;
                        try {
                            for (HStoreFile sf : sfs) {
                                currentPath = sf.getPath();
                                byte[] mobRefData = null;
                                byte[] bulkloadMarkerData = null;
                                if (sf.getReader() == null) {
                                    HStoreFile hStoreFile = sf;
                                    synchronized (hStoreFile) {
                                        boolean needCreateReader = sf.getReader() == null;
                                        sf.initReader();
                                        mobRefData = sf.getMetadataValue(HStoreFile.MOB_FILE_REFS);
                                        bulkloadMarkerData = sf.getMetadataValue(HStoreFile.BULKLOAD_TASK_KEY);
                                        if (needCreateReader) {
                                            sf.closeStoreFile(true);
                                        }
                                    }
                                } else {
                                    mobRefData = sf.getMetadataValue(HStoreFile.MOB_FILE_REFS);
                                    bulkloadMarkerData = sf.getMetadataValue(HStoreFile.BULKLOAD_TASK_KEY);
                                }
                                if (mobRefData == null) {
                                    if (bulkloadMarkerData == null) {
                                        LOG.warn("Found old store file with no MOB_FILE_REFS: {} - can not proceed until all old files will be MOB-compacted.", (Object)currentPath);
                                        return;
                                    }
                                    LOG.debug("Skipping file without MOB references (bulkloaded file):{}", (Object)currentPath);
                                    continue;
                                }
                                try {
                                    ImmutableMultimap mobs = MobUtils.deserializeMobFileRefs(mobRefData).build();
                                    LOG.debug("Found {} mob references for store={}", (Object)mobs.size(), (Object)sf);
                                    LOG.trace("Specific mob references found for store={} : {}", (Object)sf, (Object)mobs);
                                    regionMobs.addAll(mobs.values());
                                }
                                catch (RuntimeException exception) {
                                    throw new IOException("failure getting mob references for hfile " + sf, exception);
                                }
                            }
                            regionMobs.addAll(store.getStoreFilesBeingWritten().stream().map(path -> path.getName()).collect(Collectors.toList()));
                            referencedMOBs.computeIfAbsent(hcd.getNameAsString(), cf -> new HashMap()).computeIfAbsent(region.getRegionInfo().getEncodedName(), name -> new ArrayList()).addAll(regionMobs);
                        }
                        catch (FileNotFoundException e) {
                            LOG.warn("Missing file:{} Starting MOB cleaning cycle from the beginning due to error", currentPath, (Object)e);
                            regionMobs.clear();
                        }
                        catch (IOException e) {
                            LOG.error("Failed to clean the obsolete mob files for table={}", (Object)htd.getTableName().getNameAsString(), (Object)e);
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found: {} active mob refs for table={}", (Object)referencedMOBs.values().stream().map(inner -> inner.values()).flatMap(lists -> lists.stream()).mapToInt(lists -> lists.size()).sum(), (Object)htd.getTableName().getNameAsString());
                }
                if (LOG.isTraceEnabled()) {
                    referencedMOBs.values().stream().forEach(innerMap -> innerMap.values().stream().forEach(mobFileList -> mobFileList.stream().forEach(arg_0 -> ((Logger)LOG).trace(arg_0))));
                }
                HashSet regionsCovered = new HashSet();
                referencedMOBs.values().stream().forEach(regionMap -> regionsCovered.addAll(regionMap.keySet()));
                for (ColumnFamilyDescriptor hcd : list) {
                    ArrayList<Path> toArchive = new ArrayList<Path>();
                    String family = hcd.getNameAsString();
                    Path dir = MobUtils.getMobFamilyPath(this.rs.getConfiguration(), htd.getTableName(), family);
                    RemoteIterator rit = fs.listLocatedStatus(dir);
                    while (rit.hasNext()) {
                        LocatedFileStatus lfs = (LocatedFileStatus)rit.next();
                        Path p = lfs.getPath();
                        String[] mobParts = p.getName().split("_");
                        String regionName = mobParts[mobParts.length - 1];
                        if (!regionsCovered.contains(regionName)) {
                            LOG.trace("MOB file does not belong to current rs: {}", (Object)p);
                            continue;
                        }
                        Map cfMobs = (Map)referencedMOBs.get(hcd.getNameAsString());
                        if (cfMobs != null && cfMobs.get(regionName) != null && ((List)cfMobs.get(regionName)).contains(p.getName())) {
                            LOG.trace("Keeping active MOB file: {}", (Object)p);
                            continue;
                        }
                        long creationTime = fs.getFileStatus(p).getModificationTime();
                        if (creationTime < maxCreationTimeToArchive) {
                            LOG.trace("Archiving MOB file {} creation time={}", (Object)p, (Object)fs.getFileStatus(p).getModificationTime());
                            toArchive.add(p);
                            continue;
                        }
                        LOG.trace("Skipping fresh file: {}. Creation time={}", (Object)p, (Object)fs.getFileStatus(p).getModificationTime());
                    }
                    LOG.info(" MOB Cleaner found {} files to archive for table={} family={}", new Object[]{toArchive.size(), htd.getTableName().getNameAsString(), family});
                    this.archiveMobFiles(this.rs.getConfiguration(), htd.getTableName(), family.getBytes(), toArchive);
                    LOG.info(" MOB Cleaner archived {} files, table={} family={}", new Object[]{toArchive.size(), htd.getTableName().getNameAsString(), family});
                }
                LOG.info("Cleaning obsolete MOB files finished for table={}", (Object)htd.getTableName());
            }
        }
        catch (IOException e) {
            LOG.error("MOB Cleaner failed when trying to access the file system", (Throwable)e);
        }
    }

    public void archiveMobFiles(Configuration conf, TableName tableName, byte[] family, List<Path> storeFiles) throws IOException {
        if (storeFiles.size() == 0) {
            LOG.debug("Skipping archiving old MOB files - no files found for table={} cf={}", (Object)tableName, (Object)Bytes.toString(family));
            return;
        }
        Path mobTableDir = CommonFSUtils.getTableDir(MobUtils.getMobHome(conf), tableName);
        FileSystem fs = storeFiles.get(0).getFileSystem(conf);
        for (Path p : storeFiles) {
            LOG.debug("MOB Cleaner is archiving: {}", (Object)p);
            HFileArchiver.archiveStoreFile(conf, fs, MobUtils.getMobRegionInfo(tableName), mobTableDir, family, p);
        }
    }
}

