/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestMultipleTimestamps {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultipleTimestamps.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMultipleTimestamps.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testReseeksWithOneColumnMiltipleTimestamp() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] FAMILY = Bytes.toBytes((String)"event_log");
        byte[][] FAMILIES = new byte[][]{FAMILY};
        Table ht = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES, Integer.MAX_VALUE);
        Integer[] putRows = new Integer[]{1, 3, 5, 7};
        Integer[] putColumns = new Integer[]{1, 3, 5};
        Long[] putTimestamps = new Long[]{1L, 2L, 3L, 4L, 5L};
        Integer[] scanRows = new Integer[]{3, 5};
        Integer[] scanColumns = new Integer[]{3};
        Long[] scanTimestamps = new Long[]{3L, 4L};
        int scanMaxVersions = 2;
        this.put(ht, FAMILY, putRows, putColumns, putTimestamps);
        TEST_UTIL.flush(tableName);
        ResultScanner scanner = this.scan(ht, FAMILY, scanRows, scanColumns, scanTimestamps, scanMaxVersions);
        Cell[] kvs = scanner.next().rawCells();
        Assert.assertEquals((long)2L, (long)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 3, 3, 4L);
        this.checkOneCell(kvs[1], FAMILY, 3, 3, 3L);
        kvs = scanner.next().rawCells();
        Assert.assertEquals((long)2L, (long)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 5, 3, 4L);
        this.checkOneCell(kvs[1], FAMILY, 5, 3, 3L);
        ht.close();
    }

    @Test
    public void testReseeksWithMultipleColumnOneTimestamp() throws IOException {
        LOG.info(this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] FAMILY = Bytes.toBytes((String)"event_log");
        byte[][] FAMILIES = new byte[][]{FAMILY};
        Table ht = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES, Integer.MAX_VALUE);
        Integer[] putRows = new Integer[]{1, 3, 5, 7};
        Integer[] putColumns = new Integer[]{1, 3, 5};
        Long[] putTimestamps = new Long[]{1L, 2L, 3L, 4L, 5L};
        Integer[] scanRows = new Integer[]{3, 5};
        Integer[] scanColumns = new Integer[]{3, 4};
        Long[] scanTimestamps = new Long[]{3L};
        int scanMaxVersions = 2;
        this.put(ht, FAMILY, putRows, putColumns, putTimestamps);
        TEST_UTIL.flush(tableName);
        ResultScanner scanner = this.scan(ht, FAMILY, scanRows, scanColumns, scanTimestamps, scanMaxVersions);
        Cell[] kvs = scanner.next().rawCells();
        Assert.assertEquals((long)1L, (long)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 3, 3, 3L);
        kvs = scanner.next().rawCells();
        Assert.assertEquals((long)1L, (long)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 5, 3, 3L);
        ht.close();
    }

    @Test
    public void testReseeksWithMultipleColumnMultipleTimestamp() throws IOException {
        Result r;
        LOG.info(this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] FAMILY = Bytes.toBytes((String)"event_log");
        byte[][] FAMILIES = new byte[][]{FAMILY};
        Table ht = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES, Integer.MAX_VALUE);
        Integer[] putRows = new Integer[]{1, 3, 5, 7};
        Integer[] putColumns = new Integer[]{1, 3, 5};
        Long[] putTimestamps = new Long[]{1L, 2L, 3L, 4L, 5L};
        Integer[] scanRows = new Integer[]{5, 7};
        Integer[] scanColumns = new Integer[]{3, 4, 5};
        Long[] scanTimestamps = new Long[]{2L, 3L};
        int scanMaxVersions = 2;
        this.put(ht, FAMILY, putRows, putColumns, putTimestamps);
        TEST_UTIL.flush(tableName);
        Scan scan = new Scan();
        scan.setMaxVersions(10);
        ResultScanner scanner = ht.getScanner(scan);
        while ((r = scanner.next()) != null) {
            LOG.info("r=" + r);
        }
        scanner = this.scan(ht, FAMILY, scanRows, scanColumns, scanTimestamps, scanMaxVersions);
        Cell[] kvs = scanner.next().rawCells();
        Assert.assertEquals((long)4L, (long)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 5, 3, 3L);
        this.checkOneCell(kvs[1], FAMILY, 5, 3, 2L);
        this.checkOneCell(kvs[2], FAMILY, 5, 5, 3L);
        this.checkOneCell(kvs[3], FAMILY, 5, 5, 2L);
        kvs = scanner.next().rawCells();
        Assert.assertEquals((long)4L, (long)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 7, 3, 3L);
        this.checkOneCell(kvs[1], FAMILY, 7, 3, 2L);
        this.checkOneCell(kvs[2], FAMILY, 7, 5, 3L);
        this.checkOneCell(kvs[3], FAMILY, 7, 5, 2L);
        ht.close();
    }

    @Test
    public void testReseeksWithMultipleFiles() throws IOException {
        LOG.info(this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] FAMILY = Bytes.toBytes((String)"event_log");
        byte[][] FAMILIES = new byte[][]{FAMILY};
        Table ht = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES, Integer.MAX_VALUE);
        Integer[] putRows1 = new Integer[]{1, 2, 3};
        Integer[] putColumns1 = new Integer[]{2, 5, 6};
        Long[] putTimestamps1 = new Long[]{1L, 2L, 5L};
        Integer[] putRows2 = new Integer[]{6, 7};
        Integer[] putColumns2 = new Integer[]{3, 6};
        Long[] putTimestamps2 = new Long[]{4L, 5L};
        Integer[] putRows3 = new Integer[]{2, 3, 5};
        Integer[] putColumns3 = new Integer[]{1, 2, 3};
        Long[] putTimestamps3 = new Long[]{4L, 8L};
        Integer[] scanRows = new Integer[]{3, 5, 7};
        Integer[] scanColumns = new Integer[]{3, 4, 5};
        Long[] scanTimestamps = new Long[]{2L, 4L};
        int scanMaxVersions = 5;
        this.put(ht, FAMILY, putRows1, putColumns1, putTimestamps1);
        TEST_UTIL.flush(tableName);
        this.put(ht, FAMILY, putRows2, putColumns2, putTimestamps2);
        TEST_UTIL.flush(tableName);
        this.put(ht, FAMILY, putRows3, putColumns3, putTimestamps3);
        ResultScanner scanner = this.scan(ht, FAMILY, scanRows, scanColumns, scanTimestamps, scanMaxVersions);
        Cell[] kvs = scanner.next().rawCells();
        Assert.assertEquals((long)2L, (long)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 3, 3, 4L);
        this.checkOneCell(kvs[1], FAMILY, 3, 5, 2L);
        kvs = scanner.next().rawCells();
        Assert.assertEquals((long)1L, (long)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 5, 3, 4L);
        kvs = scanner.next().rawCells();
        Assert.assertEquals((long)1L, (long)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 6, 3, 4L);
        kvs = scanner.next().rawCells();
        Assert.assertEquals((long)1L, (long)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 7, 3, 4L);
        ht.close();
    }

    @Test
    public void testWithVersionDeletes() throws Exception {
        this.testWithVersionDeletes(false);
        this.testWithVersionDeletes(true);
    }

    public void testWithVersionDeletes(boolean flushTables) throws IOException {
        LOG.info(this.name.getMethodName() + "_" + (flushTables ? "flush" : "noflush"));
        TableName tableName = TableName.valueOf((String)(this.name.getMethodName() + "_" + (flushTables ? "flush" : "noflush")));
        byte[] FAMILY = Bytes.toBytes((String)"event_log");
        byte[][] FAMILIES = new byte[][]{FAMILY};
        Table ht = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES, Integer.MAX_VALUE);
        this.putNVersions(ht, FAMILY, 0, 0, 1L, 5L);
        if (flushTables) {
            TEST_UTIL.flush(tableName);
        }
        this.deleteOneVersion(ht, FAMILY, 0, 0, 4L);
        Cell[] kvs = this.getNVersions(ht, FAMILY, 0, 0, Arrays.asList(2L, 3L, 4L, 5L));
        Assert.assertEquals((long)3L, (long)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 0, 0, 5L);
        this.checkOneCell(kvs[1], FAMILY, 0, 0, 3L);
        this.checkOneCell(kvs[2], FAMILY, 0, 0, 2L);
        ht.close();
    }

    @Test
    public void testWithMultipleVersionDeletes() throws IOException {
        LOG.info(this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] FAMILY = Bytes.toBytes((String)"event_log");
        byte[][] FAMILIES = new byte[][]{FAMILY};
        Table ht = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES, Integer.MAX_VALUE);
        this.putNVersions(ht, FAMILY, 0, 0, 1L, 5L);
        TEST_UTIL.flush(tableName);
        this.deleteAllVersionsBefore(ht, FAMILY, 0, 0, 4L);
        Cell[] kvs = this.getNVersions(ht, FAMILY, 0, 0, Arrays.asList(2L, 3L));
        Assert.assertEquals((long)0L, (long)kvs.length);
        ht.close();
    }

    @Test
    public void testWithColumnDeletes() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] FAMILY = Bytes.toBytes((String)"event_log");
        byte[][] FAMILIES = new byte[][]{FAMILY};
        Table ht = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES, Integer.MAX_VALUE);
        this.putNVersions(ht, FAMILY, 0, 0, 1L, 5L);
        TEST_UTIL.flush(tableName);
        this.deleteColumn(ht, FAMILY, 0, 0);
        Cell[] kvs = this.getNVersions(ht, FAMILY, 0, 0, Arrays.asList(2L, 3L));
        Assert.assertEquals((long)0L, (long)kvs.length);
        ht.close();
    }

    @Test
    public void testWithFamilyDeletes() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] FAMILY = Bytes.toBytes((String)"event_log");
        byte[][] FAMILIES = new byte[][]{FAMILY};
        Table ht = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES, Integer.MAX_VALUE);
        this.putNVersions(ht, FAMILY, 0, 0, 1L, 5L);
        TEST_UTIL.flush(tableName);
        this.deleteFamily(ht, FAMILY, 0);
        Cell[] kvs = this.getNVersions(ht, FAMILY, 0, 0, Arrays.asList(2L, 3L));
        Assert.assertEquals((long)0L, (long)kvs.length);
        ht.close();
    }

    private void checkOneCell(Cell kv, byte[] cf, int rowIdx, int colIdx, long ts) {
        String ctx = "rowIdx=" + rowIdx + "; colIdx=" + colIdx + "; ts=" + ts;
        Assert.assertEquals((String)("Row mismatch which checking: " + ctx), (Object)("row:" + rowIdx), (Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)kv)));
        Assert.assertEquals((String)("ColumnFamily mismatch while checking: " + ctx), (Object)Bytes.toString((byte[])cf), (Object)Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kv)));
        Assert.assertEquals((String)("Column qualifier mismatch while checking: " + ctx), (Object)("column:" + colIdx), (Object)Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)));
        Assert.assertEquals((String)("Timestamp mismatch while checking: " + ctx), (long)ts, (long)kv.getTimestamp());
        Assert.assertEquals((String)("Value mismatch while checking: " + ctx), (Object)("value-version-" + ts), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)));
    }

    private Cell[] getNVersions(Table ht, byte[] cf, int rowIdx, int colIdx, List<Long> versions) throws IOException {
        byte[] row = Bytes.toBytes((String)("row:" + rowIdx));
        byte[] column = Bytes.toBytes((String)("column:" + colIdx));
        Get get = new Get(row);
        get.addColumn(cf, column);
        get.setMaxVersions();
        get.setTimeRange(Collections.min(versions).longValue(), Collections.max(versions) + 1L);
        Result result = ht.get(get);
        return result.rawCells();
    }

    private ResultScanner scan(Table ht, byte[] cf, Integer[] rowIndexes, Integer[] columnIndexes, Long[] versions, int maxVersions) throws IOException {
        byte[] startRow = Bytes.toBytes((String)("row:" + Collections.min(Arrays.asList(rowIndexes))));
        byte[] endRow = Bytes.toBytes((String)("row:" + Collections.max(Arrays.asList(rowIndexes)) + 1));
        Scan scan = new Scan(startRow, endRow);
        for (Integer colIdx : columnIndexes) {
            byte[] column = Bytes.toBytes((String)("column:" + colIdx));
            scan.addColumn(cf, column);
        }
        scan.setMaxVersions(maxVersions);
        scan.setTimeRange(Collections.min(Arrays.asList(versions)).longValue(), Collections.max(Arrays.asList(versions)) + 1L);
        ResultScanner scanner = ht.getScanner(scan);
        return scanner;
    }

    private void put(Table ht, byte[] cf, Integer[] rowIndexes, Integer[] columnIndexes, Long[] versions) throws IOException {
        Integer[] integerArray = rowIndexes;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int rowIdx = integerArray[i];
            byte[] row = Bytes.toBytes((String)("row:" + rowIdx));
            Put put = new Put(row);
            put.setDurability(Durability.SKIP_WAL);
            Integer[] integerArray2 = columnIndexes;
            int n2 = integerArray2.length;
            for (int j = 0; j < n2; ++j) {
                int colIdx = integerArray2[j];
                byte[] column = Bytes.toBytes((String)("column:" + colIdx));
                Long[] longArray = versions;
                int n3 = longArray.length;
                for (int k = 0; k < n3; ++k) {
                    long version = longArray[k];
                    put.addColumn(cf, column, version, Bytes.toBytes((String)("value-version-" + version)));
                }
            }
            ht.put(put);
        }
    }

    private void putNVersions(Table ht, byte[] cf, int rowIdx, int colIdx, long versionStart, long versionEnd) throws IOException {
        byte[] row = Bytes.toBytes((String)("row:" + rowIdx));
        byte[] column = Bytes.toBytes((String)("column:" + colIdx));
        Put put = new Put(row);
        put.setDurability(Durability.SKIP_WAL);
        for (long idx = versionStart; idx <= versionEnd; ++idx) {
            put.addColumn(cf, column, idx, Bytes.toBytes((String)("value-version-" + idx)));
        }
        ht.put(put);
    }

    private void deleteOneVersion(Table ht, byte[] cf, int rowIdx, int colIdx, long version) throws IOException {
        byte[] row = Bytes.toBytes((String)("row:" + rowIdx));
        byte[] column = Bytes.toBytes((String)("column:" + colIdx));
        Delete del = new Delete(row);
        del.addColumn(cf, column, version);
        ht.delete(del);
    }

    private void deleteAllVersionsBefore(Table ht, byte[] cf, int rowIdx, int colIdx, long version) throws IOException {
        byte[] row = Bytes.toBytes((String)("row:" + rowIdx));
        byte[] column = Bytes.toBytes((String)("column:" + colIdx));
        Delete del = new Delete(row);
        del.addColumns(cf, column, version);
        ht.delete(del);
    }

    private void deleteColumn(Table ht, byte[] cf, int rowIdx, int colIdx) throws IOException {
        byte[] row = Bytes.toBytes((String)("row:" + rowIdx));
        byte[] column = Bytes.toBytes((String)("column:" + colIdx));
        Delete del = new Delete(row);
        del.addColumns(cf, column);
        ht.delete(del);
    }

    private void deleteFamily(Table ht, byte[] cf, int rowIdx) throws IOException {
        byte[] row = Bytes.toBytes((String)("row:" + rowIdx));
        Delete del = new Delete(row);
        del.addFamily(cf);
        ht.delete(del);
    }
}

