/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestCellBuilder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCellBuilder.class);
    private static final byte OLD_DATA = 87;
    private static final byte NEW_DATA = 100;

    @Test
    public void testCellBuilderWithDeepCopy() {
        byte[] row = new byte[]{87};
        byte[] family = new byte[]{87};
        byte[] qualifier = new byte[]{87};
        byte[] value = new byte[]{87};
        Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(row).setFamily(family).setQualifier(qualifier).setType(Cell.Type.Put).setValue(value).build();
        row[0] = 100;
        family[0] = 100;
        qualifier[0] = 100;
        value[0] = 100;
        Assert.assertEquals((long)87L, (long)cell.getRowArray()[cell.getRowOffset()]);
        Assert.assertEquals((long)87L, (long)cell.getFamilyArray()[cell.getFamilyOffset()]);
        Assert.assertEquals((long)87L, (long)cell.getQualifierArray()[cell.getQualifierOffset()]);
        Assert.assertEquals((long)87L, (long)cell.getValueArray()[cell.getValueOffset()]);
    }

    @Test
    public void testCellBuilderWithShallowCopy() {
        byte[] row = new byte[]{87};
        byte[] family = new byte[]{87};
        byte[] qualifier = new byte[]{87};
        byte[] value = new byte[]{87};
        Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(row).setFamily(family).setQualifier(qualifier).setType(Cell.Type.Put).setValue(value).build();
        row[0] = 100;
        family[0] = 100;
        qualifier[0] = 100;
        value[0] = 100;
        Assert.assertEquals((long)100L, (long)cell.getRowArray()[cell.getRowOffset()]);
        Assert.assertEquals((long)100L, (long)cell.getFamilyArray()[cell.getFamilyOffset()]);
        Assert.assertEquals((long)100L, (long)cell.getQualifierArray()[cell.getQualifierOffset()]);
        Assert.assertEquals((long)100L, (long)cell.getValueArray()[cell.getValueOffset()]);
    }

    @Test
    public void testExtendedCellBuilderWithShallowCopy() {
        byte[] row = new byte[]{87};
        byte[] family = new byte[]{87};
        byte[] qualifier = new byte[]{87};
        byte[] value = new byte[]{87};
        byte[] tags = new byte[]{87};
        long seqId = 999L;
        ExtendedCell cell = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(row).setFamily(family).setQualifier(qualifier).setType(KeyValue.Type.Put.getCode()).setValue(value).setTags(tags).setSequenceId(seqId).build();
        row[0] = 100;
        family[0] = 100;
        qualifier[0] = 100;
        value[0] = 100;
        tags[0] = 100;
        Assert.assertEquals((long)100L, (long)cell.getRowArray()[cell.getRowOffset()]);
        Assert.assertEquals((long)100L, (long)cell.getFamilyArray()[cell.getFamilyOffset()]);
        Assert.assertEquals((long)100L, (long)cell.getQualifierArray()[cell.getQualifierOffset()]);
        Assert.assertEquals((long)100L, (long)cell.getValueArray()[cell.getValueOffset()]);
        Assert.assertEquals((long)100L, (long)cell.getTagsArray()[cell.getTagsOffset()]);
        Assert.assertEquals((long)seqId, (long)cell.getSequenceId());
    }

    @Test
    public void testExtendedCellBuilderWithDeepCopy() {
        byte[] row = new byte[]{87};
        byte[] family = new byte[]{87};
        byte[] qualifier = new byte[]{87};
        byte[] value = new byte[]{87};
        byte[] tags = new byte[]{87};
        long seqId = 999L;
        ExtendedCell cell = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(row).setFamily(family).setQualifier(qualifier).setType(KeyValue.Type.Put.getCode()).setValue(value).setTags(tags).setSequenceId(seqId).build();
        row[0] = 100;
        family[0] = 100;
        qualifier[0] = 100;
        value[0] = 100;
        tags[0] = 100;
        Assert.assertEquals((long)87L, (long)cell.getRowArray()[cell.getRowOffset()]);
        Assert.assertEquals((long)87L, (long)cell.getFamilyArray()[cell.getFamilyOffset()]);
        Assert.assertEquals((long)87L, (long)cell.getQualifierArray()[cell.getQualifierOffset()]);
        Assert.assertEquals((long)87L, (long)cell.getValueArray()[cell.getValueOffset()]);
        Assert.assertEquals((long)87L, (long)cell.getTagsArray()[cell.getTagsOffset()]);
        Assert.assertEquals((long)seqId, (long)cell.getSequenceId());
    }
}

