/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
interface ClusterManager
extends Configurable {
    public void start(ServiceType var1, String var2, int var3) throws IOException;

    public void stop(ServiceType var1, String var2, int var3) throws IOException;

    public void restart(ServiceType var1, String var2, int var3) throws IOException;

    public void kill(ServiceType var1, String var2, int var3) throws IOException;

    public void suspend(ServiceType var1, String var2, int var3) throws IOException;

    public void resume(ServiceType var1, String var2, int var3) throws IOException;

    public boolean isRunning(ServiceType var1, String var2, int var3) throws IOException;

    public boolean isSuspended(ServiceType var1, String var2, int var3) throws IOException;

    public boolean isResumed(ServiceType var1, String var2, int var3) throws IOException;

    public static enum ServiceType {
        HADOOP_NAMENODE("namenode"),
        HADOOP_DATANODE("datanode"),
        HADOOP_JOURNALNODE("journalnode"),
        HADOOP_JOBTRACKER("jobtracker"),
        HADOOP_TASKTRACKER("tasktracker"),
        ZOOKEEPER_SERVER("QuorumPeerMain"),
        HBASE_MASTER("master"),
        HBASE_REGIONSERVER("regionserver");

        private final String name;

        private ServiceType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

