/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

public final class Version {
    private static final int VERY_LARGE_NUMBER = 100000;
    private static final int MAJOR = 0;
    private static final int MINOR = 1;
    private static final int PATCH = 2;

    private Version() {
    }

    static boolean check(String version, String ... thresholdVersions) {
        if (thresholdVersions == null) {
            return true;
        }
        boolean supported = false;
        String[] versionComponents = Version.getVersionComponents(version);
        boolean excessiveMajor = false;
        boolean excessiveMinor = false;
        for (String thresholdVersion : thresholdVersions) {
            int thresholdMinor;
            int thresholdMajor;
            String[] thresholdVersionComponents = Version.getVersionComponents(thresholdVersion);
            int serverMajor = Integer.parseInt(versionComponents[0]);
            if (serverMajor > (thresholdMajor = Integer.parseInt(thresholdVersionComponents[0]))) {
                excessiveMajor = true;
                continue;
            }
            excessiveMajor = false;
            if (serverMajor < thresholdMajor) continue;
            int serverMinor = Integer.parseInt(versionComponents[1]);
            if (serverMinor > (thresholdMinor = Integer.parseInt(thresholdVersionComponents[1]))) {
                excessiveMinor = true;
                continue;
            }
            excessiveMinor = false;
            if (serverMinor < thresholdMinor) continue;
            if (Integer.parseInt(versionComponents[2]) < Integer.parseInt(thresholdVersionComponents[2])) break;
            supported = true;
            break;
        }
        return supported || excessiveMajor || excessiveMinor;
    }

    private static String[] getVersionComponents(String version) {
        assert (version != null);
        String[] strComps = version.split("[\\.-]");
        assert (strComps.length > 0);
        String[] comps = new String[strComps.length];
        for (int i = 0; i < strComps.length; ++i) {
            comps[i] = strComps[i].matches("\\d+") ? strComps[i] : (strComps[i] == null || strComps[i].isEmpty() ? String.valueOf(100000) : ("SNAPSHOT".equals(strComps[i]) ? "-1" : ("beta".equals(strComps[i]) ? "-2" : ("alpha".equals(strComps[i]) ? "-3" : "-4"))));
        }
        return comps;
    }
}

