/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface ProtobufMessageHandler {
    public static final int BUFFER_SIZE = 8192;

    default public void writeProtobufOutput(OutputStream os) throws IOException {
        CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)os, (int)8192);
        this.messageFromObject().writeTo(cos);
        cos.flush();
    }

    default public byte[] createProtobufOutput() {
        return this.messageFromObject().toByteArray();
    }

    public Message messageFromObject();

    default public ProtobufMessageHandler getObjectFromMessage(byte[] message) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((byte[])message);
        codedInput.setSizeLimit(message.length);
        return this.getObjectFromMessage(codedInput);
    }

    default public ProtobufMessageHandler getObjectFromMessage(InputStream is) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((InputStream)is);
        codedInput.setSizeLimit(Integer.MAX_VALUE);
        return this.getObjectFromMessage(codedInput);
    }

    public ProtobufMessageHandler getObjectFromMessage(CodedInputStream var1) throws IOException;
}

