/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import org.apache.hadoop.hbase.TableName;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class RestoreRequest {
    private String backupRootDir;
    private String restoreRootDir;
    private String backupId;
    private boolean check = false;
    private TableName[] fromTables;
    private TableName[] toTables;
    private boolean overwrite = false;
    private boolean keepOriginalSplits = false;

    private RestoreRequest() {
    }

    public String getBackupRootDir() {
        return this.backupRootDir;
    }

    private RestoreRequest setBackupRootDir(String backupRootDir) {
        this.backupRootDir = backupRootDir;
        return this;
    }

    public String getRestoreRootDir() {
        return this.restoreRootDir;
    }

    private RestoreRequest setRestoreRootDir(String restoreRootDir) {
        this.restoreRootDir = restoreRootDir;
        return this;
    }

    public String getBackupId() {
        return this.backupId;
    }

    private RestoreRequest setBackupId(String backupId) {
        this.backupId = backupId;
        return this;
    }

    public boolean isCheck() {
        return this.check;
    }

    private RestoreRequest setCheck(boolean check) {
        this.check = check;
        return this;
    }

    public TableName[] getFromTables() {
        return this.fromTables;
    }

    private RestoreRequest setFromTables(TableName[] fromTables) {
        this.fromTables = fromTables;
        return this;
    }

    public TableName[] getToTables() {
        return this.toTables;
    }

    private RestoreRequest setToTables(TableName[] toTables) {
        this.toTables = toTables;
        return this;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    private RestoreRequest setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public boolean isKeepOriginalSplits() {
        return this.keepOriginalSplits;
    }

    private RestoreRequest setKeepOriginalSplits(boolean keepOriginalSplits) {
        this.keepOriginalSplits = keepOriginalSplits;
        return this;
    }

    public static class Builder {
        RestoreRequest request = new RestoreRequest();

        public Builder withBackupRootDir(String backupRootDir) {
            this.request.setBackupRootDir(backupRootDir);
            return this;
        }

        public Builder withRestoreRootDir(String restoreRootDir) {
            this.request.setRestoreRootDir(restoreRootDir);
            return this;
        }

        public Builder withBackupId(String backupId) {
            this.request.setBackupId(backupId);
            return this;
        }

        public Builder withCheck(boolean check) {
            this.request.setCheck(check);
            return this;
        }

        public Builder withFromTables(TableName[] fromTables) {
            this.request.setFromTables(fromTables);
            return this;
        }

        public Builder withToTables(TableName[] toTables) {
            this.request.setToTables(toTables);
            return this;
        }

        public Builder withOvewrite(boolean overwrite) {
            this.request.setOverwrite(overwrite);
            return this;
        }

        public Builder withKeepOriginalSplits(boolean keepOriginalSplits) {
            this.request.setKeepOriginalSplits(keepOriginalSplits);
            return this;
        }

        public RestoreRequest build() {
            return this.request;
        }
    }
}

