/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.backup.BackupRequest;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.impl.FullTableBackupClient;
import org.apache.hadoop.hbase.backup.impl.IncrementalTableBackupClient;
import org.apache.hadoop.hbase.backup.impl.TableBackupClient;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class BackupClientFactory {
    private BackupClientFactory() {
    }

    public static TableBackupClient create(Connection conn, String backupId, BackupRequest request) throws IOException {
        Configuration conf = conn.getConfiguration();
        try {
            String clsName = conf.get("backup.client.impl.class");
            if (clsName != null) {
                Class<TableBackupClient> clientImpl = Class.forName(clsName).asSubclass(TableBackupClient.class);
                TableBackupClient client = clientImpl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                client.init(conn, backupId, request);
                return client;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        BackupType type = request.getBackupType();
        if (type == BackupType.FULL) {
            return new FullTableBackupClient(conn, backupId, request);
        }
        return new IncrementalTableBackupClient(conn, backupId, request);
    }
}

