/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.security.HBasePolicyProvider;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.security.authorize.Service;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SecurityTests.class, SmallTests.class})
public class TestSecurityInfoAndHBasePolicyProviderMatch {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSecurityInfoAndHBasePolicyProviderMatch.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private void assertServiceMatches(RpcServerInterface rpcServer) {
        HBasePolicyProvider provider = new HBasePolicyProvider();
        Set serviceClasses = Stream.of(provider.getServices()).map(Service::getProtocol).collect(Collectors.toSet());
        for (RpcServer.BlockingServiceAndInterface bsai : ((RpcServer)rpcServer).getServices()) {
            Assert.assertNotNull((String)("no security info for " + bsai.getBlockingService().getDescriptorForType().getName()), (Object)SecurityInfo.getInfo((String)bsai.getBlockingService().getDescriptorForType().getName()));
            MatcherAssert.assertThat(serviceClasses, (Matcher)Matchers.hasItem((Object)bsai.getServiceInterface()));
        }
    }

    @Test
    public void testMatches() {
        this.assertServiceMatches(UTIL.getMiniHBaseCluster().getMaster().getRpcServer());
        this.assertServiceMatches(UTIL.getMiniHBaseCluster().getRegionServer(0).getRpcServer());
    }
}

