/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotProcedureWithLockTimeout {
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotProcedureWithLockTimeout.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotProcedureWithLockTimeout.class);
    private static HBaseTestingUtility TEST_UTIL;
    private HMaster master;
    private TableName TABLE_NAME;
    private byte[] CF;
    private String SNAPSHOT_NAME;

    @Before
    public void setup() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        Configuration config = TEST_UTIL.getConfiguration();
        config.setInt("hbase.snapshot.remote.verify.threshold", 1);
        config.setLong("hbase.snapshot.master.lock.acquire.timeout", 1L);
        TEST_UTIL.startMiniCluster(3);
        this.master = TEST_UTIL.getHBaseCluster().getMaster();
        this.TABLE_NAME = TableName.valueOf((byte[])Bytes.toBytes((String)"TestSnapshotProcedureWithLockTimeout"));
        this.CF = Bytes.toBytes((String)"cf");
        this.SNAPSHOT_NAME = "SnapshotProcLockTimeout";
        byte[][] splitKeys = new RegionSplitter.HexStringSplit().split(10);
        Table table = TEST_UTIL.createTable(this.TABLE_NAME, this.CF, splitKeys);
        TEST_UTIL.loadTable(table, this.CF, false);
    }

    @After
    public void teardown() throws Exception {
        if (this.master != null) {
            ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)this.master.getMasterProcedureExecutor(), (boolean)false);
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testTakeZkCoordinatedSnapshot() {
        for (int i = 0; i < 10; ++i) {
            try {
                this.testTakeZkCoordinatedSnapshot(i);
                break;
            }
            catch (Exception e) {
                LOG.error("Error because of faster lock acquisition. retrying....", (Throwable)e);
                Assert.assertNotEquals((String)"Retries exhausted", (long)9L, (long)i);
                continue;
            }
        }
    }

    private void testTakeZkCoordinatedSnapshot(int i) throws Exception {
        SnapshotDescription snapshotOnSameTable = new SnapshotDescription(this.SNAPSHOT_NAME + i, this.TABLE_NAME, SnapshotType.SKIPFLUSH);
        final SnapshotProtos.SnapshotDescription snapshotOnSameTableProto = ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)snapshotOnSameTable);
        Thread second = new Thread("zk-snapshot"){

            @Override
            public void run() {
                try {
                    TestSnapshotProcedureWithLockTimeout.this.master.getSnapshotManager().takeSnapshot(snapshotOnSameTableProto);
                }
                catch (IOException e) {
                    LOG.error("zk snapshot failed", (Throwable)e);
                    Assert.fail((String)"zk snapshot failed");
                }
            }
        };
        second.start();
        Thread.sleep(5000L);
        boolean snapshotCreated = false;
        try {
            SnapshotTestingUtils.confirmSnapshotValid(TEST_UTIL, snapshotOnSameTableProto, this.TABLE_NAME, this.CF);
            snapshotCreated = true;
        }
        catch (AssertionError e) {
            LOG.error("Assertion error..", (Throwable)((Object)e));
            if (((Throwable)((Object)e)).getMessage() != null && ((Throwable)((Object)e)).getMessage().contains("target snapshot directory") && ((Throwable)((Object)e)).getMessage().contains("doesn't exist.")) {
                LOG.debug("Expected behaviour - snapshot could not be created");
            }
            throw new IOException((Throwable)((Object)e));
        }
        if (snapshotCreated) {
            throw new IOException("Snapshot created successfully");
        }
        TEST_UTIL.waitFor(4000L, 400L, () -> this.master.getMasterProcedureExecutor().getProcedures().stream().filter(masterProcedureEnvProcedure -> masterProcedureEnvProcedure.getState() == ProcedureProtos.ProcedureState.SUCCESS).count() == (long)this.master.getMasterProcedureExecutor().getProcedures().size());
    }
}

