/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RecoverySnapshotUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, SmallTests.class})
public class TestRecoverySnapshotUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRecoverySnapshotUtils.class);

    @Test
    public void testRecoverySnapshotTtlNoDescriptor() {
        long siteLevelTtl = 7200L;
        Configuration conf = new Configuration();
        conf.setLong("hbase.snapshot.before.destructive.action.ttl", siteLevelTtl);
        MasterProcedureEnv env = (MasterProcedureEnv)Mockito.mock(MasterProcedureEnv.class);
        Mockito.when((Object)env.getMasterConfiguration()).thenReturn((Object)conf);
        long actualTtl = RecoverySnapshotUtils.getRecoverySnapshotTtl((MasterProcedureEnv)env, null);
        Assert.assertEquals((String)"Should return site-level TTL when no table descriptor provided", (long)siteLevelTtl, (long)actualTtl);
    }

    @Test
    public void testRecoverySnapshotTtlWithDescriptor() {
        long siteLevelTtl = 7200L;
        Configuration conf = new Configuration();
        conf.setLong("hbase.snapshot.before.destructive.action.ttl", siteLevelTtl);
        MasterProcedureEnv env = (MasterProcedureEnv)Mockito.mock(MasterProcedureEnv.class);
        Mockito.when((Object)env.getMasterConfiguration()).thenReturn((Object)conf);
        long tableLevelTtl = 3600L;
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"test")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"cf")).setValue("RECOVERY_SNAPSHOT_TTL", String.valueOf(tableLevelTtl)).build();
        long actualTtl = RecoverySnapshotUtils.getRecoverySnapshotTtl((MasterProcedureEnv)env, (TableDescriptor)tableDescriptor);
        Assert.assertEquals((String)"Should return table-level TTL when table descriptor provides override", (long)tableLevelTtl, (long)actualTtl);
    }

    @Test
    public void testRecoverySnapshotTtlUsesDefault() {
        Configuration conf = new Configuration();
        MasterProcedureEnv env = (MasterProcedureEnv)Mockito.mock(MasterProcedureEnv.class);
        Mockito.when((Object)env.getMasterConfiguration()).thenReturn((Object)conf);
        long actualTtl = RecoverySnapshotUtils.getRecoverySnapshotTtl((MasterProcedureEnv)env, null);
        Assert.assertEquals((String)"Should return default TTL when no site configuration provided", (long)86400L, (long)actualTtl);
    }
}

