/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.security.sasl.SaslException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.FailedServerException;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcConnection;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.io.netty.handler.codec.DecoderException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SecurityTests.class, MediumTests.class})
public class TestMultipleServerPrincipalsIPC {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultipleServerPrincipalsIPC.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final File KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
    private static MiniKdc KDC;
    private static String HOST;
    private static String SERVER_PRINCIPAL;
    private static String SERVER_PRINCIPAL2;
    private static String CLIENT_PRINCIPAL;
    @Parameterized.Parameter(value=0)
    public Class<? extends RpcServer> rpcServerImpl;
    @Parameterized.Parameter(value=1)
    public Class<? extends RpcClient> rpcClientImpl;
    private Configuration clientConf;
    private Configuration serverConf;
    private UserGroupInformation clientUGI;
    private UserGroupInformation serverUGI;
    private RpcServer rpcServer;
    private RpcClient rpcClient;

    @Parameterized.Parameters(name="{index}: rpcServerImpl={0}, rpcClientImpl={1}")
    public static List<Object[]> params() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        List<Class> rpcServerImpls = Arrays.asList(NettyRpcServer.class, SimpleRpcServer.class);
        List<Class> rpcClientImpls = Arrays.asList(NettyRpcClient.class, BlockingRpcClient.class);
        for (Class rpcServerImpl : rpcServerImpls) {
            for (Class rpcClientImpl : rpcClientImpls) {
                params.add(new Object[]{rpcServerImpl, rpcClientImpl});
            }
        }
        return params;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        SERVER_PRINCIPAL = "server/" + HOST;
        SERVER_PRINCIPAL2 = "server2/" + HOST;
        CLIENT_PRINCIPAL = "client";
        KDC.createPrincipal(KEYTAB_FILE, new String[]{CLIENT_PRINCIPAL, SERVER_PRINCIPAL, SERVER_PRINCIPAL2});
        SERVER_PRINCIPAL = SERVER_PRINCIPAL + "@" + KDC.getRealm();
        SERVER_PRINCIPAL2 = SERVER_PRINCIPAL2 + "@" + KDC.getRealm();
        TestMultipleServerPrincipalsIPC.setSecuredConfiguration(TEST_UTIL.getConfiguration());
        TEST_UTIL.getConfiguration().setInt("hbase.security.relogin.maxbackoff", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.security.relogin.maxretries", 0);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.failed.servers.expiry", 10);
    }

    @AfterClass
    public static void tearDownAfterClass() {
        if (KDC != null) {
            KDC.stop();
        }
    }

    private static void setSecuredConfiguration(Configuration conf) {
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hbase.security.authentication", "kerberos");
        conf.setBoolean("hbase.security.authorization", true);
    }

    private void loginAndStartRpcServer(String principal, int port) throws Exception {
        UserGroupInformation.setConfiguration((Configuration)this.serverConf);
        this.serverUGI = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)KEYTAB_FILE.getCanonicalPath());
        this.rpcServer = (RpcServer)this.serverUGI.doAs(() -> RpcServerFactory.createRpcServer(null, (String)this.getClass().getSimpleName(), (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), (InetSocketAddress)new InetSocketAddress(HOST, port), (Configuration)this.serverConf, (RpcScheduler)new FifoRpcScheduler(this.serverConf, 1)));
        this.rpcServer.start();
    }

    @Before
    public void setUp() throws Exception {
        this.clientConf = new Configuration(TEST_UTIL.getConfiguration());
        this.clientConf.setClass("hbase.rpc.client.impl", this.rpcClientImpl, RpcClient.class);
        String serverPrincipalConfigName = "hbase.test.multiple.principal.first";
        String serverPrincipalConfigName2 = "hbase.test.multiple.principal.second";
        this.clientConf.set(serverPrincipalConfigName, SERVER_PRINCIPAL);
        this.clientConf.set(serverPrincipalConfigName2, SERVER_PRINCIPAL2);
        this.serverConf = new Configuration(TEST_UTIL.getConfiguration());
        this.serverConf.setClass("hbase.rpc.server.impl", this.rpcServerImpl, RpcServer.class);
        SecurityInfo securityInfo = new SecurityInfo(AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN, new String[]{serverPrincipalConfigName2, serverPrincipalConfigName});
        SecurityInfo.addInfo((String)TestRpcServiceProtos.TestProtobufRpcProto.getDescriptor().getName(), (SecurityInfo)securityInfo);
        UserGroupInformation.setConfiguration((Configuration)this.clientConf);
        this.clientUGI = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)CLIENT_PRINCIPAL, (String)KEYTAB_FILE.getCanonicalPath());
        this.loginAndStartRpcServer(SERVER_PRINCIPAL, 0);
        this.rpcClient = (RpcClient)this.clientUGI.doAs(() -> RpcClientFactory.createClient((Configuration)this.clientConf, (String)HConstants.DEFAULT_CLUSTER_ID.toString()));
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.rpcClient, (boolean)true);
        this.rpcServer.stop();
    }

    private String echo(String msg) throws Exception {
        return (String)this.clientUGI.doAs(() -> {
            BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(ServerName.valueOf((String)HOST, (int)this.rpcServer.getListenerAddress().getPort(), (long)-1L), User.getCurrent(), 10000);
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestRpcServiceProtos.TestProtobufRpcProto.newBlockingStub((BlockingRpcChannel)channel);
            return stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage(msg).build()).getMessage();
        });
    }

    @Test
    public void testEcho() throws Exception {
        String msg = "Hello World";
        Assert.assertEquals((Object)msg, (Object)this.echo(msg));
    }

    @Test
    public void testMaliciousServer() throws Exception {
        SecurityInfo securityInfo = SecurityInfo.getInfo((String)TestRpcServiceProtos.TestProtobufRpcProto.getDescriptor().getName());
        for (int i = 0; i < securityInfo.getServerPrincipals().size(); ++i) {
            this.clientConf.set((String)securityInfo.getServerPrincipals().get(i), "valid_server_" + i + "/" + HOST + "@" + KDC.getRealm());
        }
        UndeclaredThrowableException error = (UndeclaredThrowableException)Assert.assertThrows(UndeclaredThrowableException.class, () -> this.echo("whatever"));
        MatcherAssert.assertThat((Object)error.getCause(), (Matcher)Matchers.instanceOf(ServiceException.class));
        MatcherAssert.assertThat((Object)error.getCause().getCause(), (Matcher)Matchers.instanceOf(SaslException.class));
    }

    @Test
    public void testRememberLastSucceededServerPrincipal() throws Exception {
        RemoteException rme;
        Assert.assertEquals((Object)"a", (Object)this.echo("a"));
        RpcConnection conn = (RpcConnection)Iterables.getOnlyElement((Iterable)((AbstractRpcClient)this.rpcClient).getConnections().values());
        conn.shutdown();
        int port = this.rpcServer.getListenerAddress().getPort();
        this.rpcServer.stop();
        this.serverUGI.logoutUserFromKeytab();
        this.loginAndStartRpcServer(SERVER_PRINCIPAL2, port);
        UndeclaredThrowableException error = (UndeclaredThrowableException)Assert.assertThrows(UndeclaredThrowableException.class, () -> this.echo("a"));
        MatcherAssert.assertThat((Object)error.getCause(), (Matcher)Matchers.instanceOf(ServiceException.class));
        MatcherAssert.assertThat((Object)error.getCause().getCause(), (Matcher)Matchers.instanceOf(IOException.class));
        MatcherAssert.assertThat((Object)error.getCause().getCause().getCause(), (Matcher)Matchers.instanceOf(IOException.class));
        Throwable cause = error.getCause().getCause().getCause().getCause();
        MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.either((Matcher)Matchers.instanceOf(DecoderException.class)).or(Matchers.instanceOf(RemoteException.class)));
        if (!(cause instanceof RemoteException)) {
            MatcherAssert.assertThat((Object)cause.getCause(), (Matcher)Matchers.instanceOf(RemoteException.class));
            rme = (RemoteException)cause.getCause();
        } else {
            rme = (RemoteException)cause;
        }
        Assert.assertEquals((Object)SaslException.class.getName(), (Object)rme.getClassName());
        TEST_UTIL.waitFor(10000L, () -> {
            try {
                this.echo("a");
            }
            catch (UndeclaredThrowableException e) {
                Throwable t = e.getCause().getCause();
                MatcherAssert.assertThat((Object)t, (Matcher)Matchers.instanceOf(IOException.class));
                if (!(t instanceof FailedServerException)) {
                    MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Can not send request because relogin is in progress."));
                }
                return false;
            }
            return true;
        });
    }

    static {
        HOST = "localhost";
    }
}

