/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RpcConnectionRegistry;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestBootstrapNodeUpdate {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBootstrapNodeUpdate.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static RpcConnectionRegistry REGISTRY;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setLong("hbase.server.bootstrap.request_master_interval.secs", 5L);
        conf.setLong("hbase.server.bootstrap.request_master_min_interval.secs", 1L);
        conf.setLong("hbase.server.bootstrap.request_regionserver_interval.secs", 1L);
        conf.setInt("hbase.client.bootstrap.node.limit", 2);
        conf.setLong("hbase.client.bootstrap.initial_refresh_delay_secs", 5L);
        conf.setLong("hbase.client.bootstrap.refresh_interval_secs", 1L);
        conf.setLong("hbase.client.bootstrap.min_secs_between_refreshes", 1L);
        UTIL.startMiniCluster(3);
        REGISTRY = new RpcConnectionRegistry(conf, UserProvider.instantiate((Configuration)conf).getCurrent());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Closeables.close((Closeable)REGISTRY, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testUpdate() throws Exception {
        ServerName activeMasterServerName = (ServerName)REGISTRY.getActiveMaster().get();
        ServerName masterInConf = ServerName.valueOf((String)activeMasterServerName.getHostname(), (int)activeMasterServerName.getPort(), (long)-1L);
        MatcherAssert.assertThat((Object)REGISTRY.getParsedServers(), (Matcher)Matchers.hasItem((Object)masterInConf));
        UTIL.waitFor(15000L, () -> !REGISTRY.getParsedServers().contains(masterInConf) && !REGISTRY.getParsedServers().contains(activeMasterServerName));
        Set parsedServers = REGISTRY.getParsedServers();
        Assert.assertEquals((long)2L, (long)parsedServers.size());
        ServerName serverToKill = (ServerName)parsedServers.iterator().next();
        UTIL.getMiniHBaseCluster().killRegionServer(serverToKill);
        UTIL.waitFor(30000L, () -> !REGISTRY.getParsedServers().contains(serverToKill));
        Assert.assertEquals((long)2L, (long)parsedServers.size());
        Assert.assertNotNull(REGISTRY.getClusterId().get());
    }
}

