/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.RecoverLeaseFSUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MiscTests.class, MediumTests.class})
public class TestRecoverLeaseFSUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRecoverLeaseFSUtils.class);
    private static final HBaseCommonTestingUtility HTU = new HBaseCommonTestingUtility();
    private static Path FILE;

    @Test
    public void testRecoverLease() throws IOException {
        long startTime = EnvironmentEdgeManager.currentTime();
        HTU.getConfiguration().setInt("hbase.lease.recovery.dfs.timeout", 1000);
        CancelableProgressable reporter = (CancelableProgressable)Mockito.mock(CancelableProgressable.class);
        Mockito.when((Object)reporter.progress()).thenReturn((Object)true);
        DistributedFileSystem dfs = (DistributedFileSystem)Mockito.mock(DistributedFileSystem.class);
        Mockito.when((Object)dfs.recoverLease(FILE)).thenReturn((Object)false).thenReturn((Object)false).thenReturn((Object)false).thenReturn((Object)false).thenReturn((Object)true);
        RecoverLeaseFSUtils.recoverFileLease((FileSystem)dfs, (Path)FILE, (Configuration)HTU.getConfiguration(), (CancelableProgressable)reporter);
        ((DistributedFileSystem)Mockito.verify((Object)dfs, (VerificationMode)Mockito.times((int)5))).recoverLease(FILE);
        Assert.assertTrue((EnvironmentEdgeManager.currentTime() - startTime > (long)(3 * HTU.getConfiguration().getInt("hbase.lease.recovery.dfs.timeout", 61000)) ? 1 : 0) != 0);
    }

    @Test
    public void testLeaseRecoverable() throws IOException {
        try {
            RecoverLeaseFSUtils.initializeRecoverLeaseMethod((String)FakeLeaseRecoverable.class.getName());
            RecoverableFileSystem mockFS = (RecoverableFileSystem)Mockito.mock(RecoverableFileSystem.class);
            Mockito.when((Object)mockFS.recoverLease(FILE)).thenReturn((Object)true);
            RecoverLeaseFSUtils.recoverFileLease((FileSystem)mockFS, (Path)FILE, (Configuration)HTU.getConfiguration());
            ((RecoverableFileSystem)Mockito.verify((Object)mockFS, (VerificationMode)Mockito.times((int)1))).recoverLease(FILE);
            Assert.assertTrue((boolean)RecoverLeaseFSUtils.isLeaseRecoverable((FileSystem)((FileSystem)Mockito.mock(RecoverableFileSystem.class))));
        }
        finally {
            RecoverLeaseFSUtils.initializeRecoverLeaseMethod((String)"org.apache.hadoop.fs.LeaseRecoverable");
        }
    }

    @Test
    public void testIsFileClosed() throws IOException {
        HTU.getConfiguration().setInt("hbase.lease.recovery.dfs.timeout", 100000);
        CancelableProgressable reporter = (CancelableProgressable)Mockito.mock(CancelableProgressable.class);
        Mockito.when((Object)reporter.progress()).thenReturn((Object)true);
        IsFileClosedDistributedFileSystem dfs = (IsFileClosedDistributedFileSystem)((Object)Mockito.mock(IsFileClosedDistributedFileSystem.class));
        Mockito.when((Object)dfs.recoverLease(FILE)).thenReturn((Object)false).thenReturn((Object)false).thenReturn((Object)true);
        Mockito.when((Object)dfs.isFileClosed(FILE)).thenReturn((Object)true);
        RecoverLeaseFSUtils.recoverFileLease((FileSystem)dfs, (Path)FILE, (Configuration)HTU.getConfiguration(), (CancelableProgressable)reporter);
        ((IsFileClosedDistributedFileSystem)((Object)Mockito.verify((Object)((Object)dfs), (VerificationMode)Mockito.times((int)2)))).recoverLease(FILE);
        ((IsFileClosedDistributedFileSystem)((Object)Mockito.verify((Object)((Object)dfs), (VerificationMode)Mockito.times((int)1)))).isFileClosed(FILE);
    }

    @Test
    public void testIsLeaseRecoverable() {
        Assert.assertTrue((boolean)RecoverLeaseFSUtils.isLeaseRecoverable((FileSystem)new DistributedFileSystem()));
        Assert.assertFalse((boolean)RecoverLeaseFSUtils.isLeaseRecoverable((FileSystem)new LocalFileSystem()));
    }

    static {
        Configuration conf = HTU.getConfiguration();
        conf.setInt("hbase.lease.recovery.first.pause", 10);
        conf.setInt("hbase.lease.recovery.pause", 10);
        FILE = new Path(HTU.getDataTestDir(), "file.txt");
    }

    private static class IsFileClosedDistributedFileSystem
    extends DistributedFileSystem {
        private IsFileClosedDistributedFileSystem() {
        }

        public boolean isFileClosed(Path f) throws IOException {
            return false;
        }
    }

    private static abstract class RecoverableFileSystem
    extends FileSystem
    implements FakeLeaseRecoverable {
        private RecoverableFileSystem() {
        }

        @Override
        public boolean recoverLease(Path p) throws IOException {
            return true;
        }

        @Override
        public boolean isFileClosed(Path p) throws IOException {
            return true;
        }
    }

    private static interface FakeLeaseRecoverable {
        public boolean recoverLease(Path var1) throws IOException;

        public boolean isFileClosed(Path var1) throws IOException;
    }
}

