/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HAUtilClient;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TokenAspect<T extends FileSystem> {
    private DelegationTokenRenewer.RenewAction<?> action;
    private DelegationTokenRenewer dtRenewer = null;
    private final DTSelecorByKind dtSelector;
    private final T fs;
    private boolean hasInitedToken;
    private final Logger LOG;
    private final Text serviceName;

    TokenAspect(T fs, Text serviceName, Text kind) {
        this.LOG = LoggerFactory.getLogger(fs.getClass());
        this.fs = fs;
        this.dtSelector = new DTSelecorByKind(kind);
        this.serviceName = serviceName;
    }

    synchronized void ensureTokenInitialized() throws IOException {
        if (!this.hasInitedToken || this.action != null && !this.action.isValid()) {
            Token token = this.fs.getDelegationToken(null);
            if (token != null) {
                ((DelegationTokenRenewer.Renewable)this.fs).setDelegationToken(token);
                this.addRenewAction(this.fs);
                this.LOG.debug("Created new DT for {}", (Object)token.getService());
            }
            this.hasInitedToken = true;
        }
    }

    public synchronized void reset() {
        this.hasInitedToken = false;
    }

    synchronized void initDelegationToken(UserGroupInformation ugi) {
        Token<DelegationTokenIdentifier> token = this.selectDelegationToken(ugi);
        if (token != null) {
            this.LOG.debug("Found existing DT for {}", (Object)token.getService());
            ((DelegationTokenRenewer.Renewable)this.fs).setDelegationToken(token);
            this.hasInitedToken = true;
        }
    }

    synchronized void removeRenewAction() throws IOException {
        if (this.dtRenewer != null) {
            this.dtRenewer.removeRenewAction(this.fs);
        }
    }

    @VisibleForTesting
    Token<DelegationTokenIdentifier> selectDelegationToken(UserGroupInformation ugi) {
        return this.dtSelector.selectToken(this.serviceName, ugi.getTokens());
    }

    private synchronized void addRenewAction(T webhdfs) {
        if (this.dtRenewer == null) {
            this.dtRenewer = DelegationTokenRenewer.getInstance();
        }
        this.action = this.dtRenewer.addRenewAction(webhdfs);
    }

    static interface TokenManagementDelegator {
        public void cancelDelegationToken(Token<?> var1) throws IOException;

        public long renewDelegationToken(Token<?> var1) throws IOException;
    }

    private static class DTSelecorByKind
    extends AbstractDelegationTokenSelector<DelegationTokenIdentifier> {
        public DTSelecorByKind(Text kind) {
            super(kind);
        }
    }

    @InterfaceAudience.Private
    public static class TokenManager
    extends TokenRenewer {
        public void cancel(Token<?> token, Configuration conf) throws IOException {
            this.getInstance(token, conf).cancelDelegationToken(token);
        }

        public boolean handleKind(Text kind) {
            return kind.equals((Object)WebHdfsConstants.HFTP_TOKEN_KIND) || kind.equals((Object)WebHdfsConstants.HSFTP_TOKEN_KIND) || kind.equals((Object)WebHdfsConstants.WEBHDFS_TOKEN_KIND) || kind.equals((Object)WebHdfsConstants.SWEBHDFS_TOKEN_KIND);
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        public long renew(Token<?> token, Configuration conf) throws IOException {
            return this.getInstance(token, conf).renewDelegationToken(token);
        }

        private TokenManagementDelegator getInstance(Token<?> token, Configuration conf) throws IOException {
            URI uri;
            String scheme = TokenManager.getSchemeByKind(token.getKind());
            if (HAUtilClient.isTokenForLogicalUri(token)) {
                uri = HAUtilClient.getServiceUriFromToken(scheme, token);
            } else {
                InetSocketAddress address = SecurityUtil.getTokenServiceAddr(token);
                uri = URI.create(scheme + "://" + NetUtils.getHostPortString((InetSocketAddress)address));
            }
            return (TokenManagementDelegator)FileSystem.get((URI)uri, (Configuration)conf);
        }

        private static String getSchemeByKind(Text kind) {
            if (kind.equals((Object)WebHdfsConstants.HFTP_TOKEN_KIND)) {
                return "hftp";
            }
            if (kind.equals((Object)WebHdfsConstants.HSFTP_TOKEN_KIND)) {
                return "hsftp";
            }
            if (kind.equals((Object)WebHdfsConstants.WEBHDFS_TOKEN_KIND)) {
                return "webhdfs";
            }
            if (kind.equals((Object)WebHdfsConstants.SWEBHDFS_TOKEN_KIND)) {
                return "swebhdfs";
            }
            throw new IllegalArgumentException("Unsupported scheme");
        }
    }
}

