/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaByStorageTypeExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.apache.hadoop.security.AccessControlException;

public final class DirectoryWithQuotaFeature
implements INode.Feature {
    public static final long DEFAULT_NAMESPACE_QUOTA = Long.MAX_VALUE;
    public static final long DEFAULT_STORAGE_SPACE_QUOTA = -1L;
    private QuotaCounts quota;
    private QuotaCounts usage;

    private DirectoryWithQuotaFeature(Builder builder) {
        this.quota = builder.quota;
        this.usage = builder.usage;
    }

    QuotaCounts getQuota() {
        return new QuotaCounts.Builder().quotaCount(this.quota).build();
    }

    void setQuota(long nsQuota, long ssQuota, StorageType type) {
        if (type != null) {
            this.quota.setTypeSpace(type, ssQuota);
        } else {
            this.setQuota(nsQuota, ssQuota);
        }
    }

    void setQuota(long nsQuota, long ssQuota) {
        this.quota.setNameSpace(nsQuota);
        this.quota.setStorageSpace(ssQuota);
    }

    void setQuota(long quota, StorageType type) {
        this.quota.setTypeSpace(type, quota);
    }

    void setQuota(EnumCounters<StorageType> tsQuotas) {
        this.quota.setTypeSpaces(tsQuotas);
    }

    QuotaCounts AddCurrentSpaceUsage(QuotaCounts counts) {
        counts.add(this.usage);
        return counts;
    }

    ContentSummaryComputationContext computeContentSummary(INodeDirectory dir, ContentSummaryComputationContext summary) throws AccessControlException {
        long original = summary.getCounts().getStoragespace();
        long oldYieldCount = summary.getYieldCount();
        dir.computeDirectoryContentSummary(summary, 0x7FFFFFFE);
        if (oldYieldCount == summary.getYieldCount()) {
            this.checkStoragespace(dir, summary.getCounts().getStoragespace() - original);
        }
        return summary;
    }

    private void checkStoragespace(INodeDirectory dir, long computed) {
        if (-1L != this.quota.getStorageSpace() && this.usage.getStorageSpace() != computed) {
            NameNode.LOG.error("BUG: Inconsistent storagespace for directory " + dir.getFullPathName() + ". Cached = " + this.usage.getStorageSpace() + " != Computed = " + computed);
        }
    }

    void addSpaceConsumed(INodeDirectory dir, QuotaCounts counts, boolean verify) throws QuotaExceededException {
        if (dir.isQuotaSet()) {
            if (verify) {
                this.verifyQuota(counts);
            }
            dir.addSpaceConsumed2Parent(counts, verify);
            this.addSpaceConsumed2Cache(counts);
        } else {
            dir.addSpaceConsumed2Parent(counts, verify);
        }
    }

    public void addSpaceConsumed2Cache(QuotaCounts delta) {
        this.usage.add(delta);
    }

    void setSpaceConsumed(long namespace, long storagespace, EnumCounters<StorageType> typespaces) {
        this.usage.setNameSpace(namespace);
        this.usage.setStorageSpace(storagespace);
        this.usage.setTypeSpaces(typespaces);
    }

    void setSpaceConsumed(QuotaCounts c) {
        this.usage.setNameSpace(c.getNameSpace());
        this.usage.setStorageSpace(c.getStorageSpace());
        this.usage.setTypeSpaces(c.getTypeSpaces());
    }

    public QuotaCounts getSpaceConsumed() {
        return new QuotaCounts.Builder().quotaCount(this.usage).build();
    }

    private void verifyNamespaceQuota(long delta) throws NSQuotaExceededException {
        if (Quota.isViolated(this.quota.getNameSpace(), this.usage.getNameSpace(), delta)) {
            throw new NSQuotaExceededException(this.quota.getNameSpace(), this.usage.getNameSpace() + delta);
        }
    }

    private void verifyStoragespaceQuota(long delta) throws DSQuotaExceededException {
        if (Quota.isViolated(this.quota.getStorageSpace(), this.usage.getStorageSpace(), delta)) {
            throw new DSQuotaExceededException(this.quota.getStorageSpace(), this.usage.getStorageSpace() + delta);
        }
    }

    private void verifyQuotaByStorageType(EnumCounters<StorageType> typeDelta) throws QuotaByStorageTypeExceededException {
        if (!this.isQuotaByStorageTypeSet()) {
            return;
        }
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            if (!this.isQuotaByStorageTypeSet(t) || !Quota.isViolated(this.quota.getTypeSpace(t), this.usage.getTypeSpace(t), typeDelta.get(t))) continue;
            throw new QuotaByStorageTypeExceededException(this.quota.getTypeSpace(t), this.usage.getTypeSpace(t) + typeDelta.get(t), t);
        }
    }

    void verifyQuota(QuotaCounts counts) throws QuotaExceededException {
        this.verifyNamespaceQuota(counts.getNameSpace());
        this.verifyStoragespaceQuota(counts.getStorageSpace());
        this.verifyQuotaByStorageType(counts.getTypeSpaces());
    }

    boolean isQuotaSet() {
        return this.quota.anyNsSsCountGreaterOrEqual(0L) || this.quota.anyTypeSpaceCountGreaterOrEqual(0L);
    }

    boolean isQuotaByStorageTypeSet() {
        return this.quota.anyTypeSpaceCountGreaterOrEqual(0L);
    }

    boolean isQuotaByStorageTypeSet(StorageType t) {
        return this.quota.getTypeSpace(t) >= 0L;
    }

    private String namespaceString() {
        return "namespace: " + (this.quota.getNameSpace() < 0L ? "-" : this.usage.getNameSpace() + "/" + this.quota.getNameSpace());
    }

    private String storagespaceString() {
        return "storagespace: " + (this.quota.getStorageSpace() < 0L ? "-" : this.usage.getStorageSpace() + "/" + this.quota.getStorageSpace());
    }

    private String typeSpaceString() {
        StringBuilder sb = new StringBuilder();
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            sb.append("StorageType: " + t + (this.quota.getTypeSpace(t) < 0L ? "-" : this.usage.getTypeSpace(t) + "/" + this.usage.getTypeSpace(t)));
        }
        return sb.toString();
    }

    public String toString() {
        return "Quota[" + this.namespaceString() + ", " + this.storagespaceString() + ", " + this.typeSpaceString() + "]";
    }

    public static class Builder {
        private QuotaCounts quota = new QuotaCounts.Builder().nameSpace(Long.MAX_VALUE).storageSpace(-1L).typeSpaces(-1L).build();
        private QuotaCounts usage = new QuotaCounts.Builder().nameSpace(1L).build();

        public Builder nameSpaceQuota(long nameSpaceQuota) {
            this.quota.setNameSpace(nameSpaceQuota);
            return this;
        }

        public Builder storageSpaceQuota(long spaceQuota) {
            this.quota.setStorageSpace(spaceQuota);
            return this;
        }

        public Builder typeQuotas(EnumCounters<StorageType> typeQuotas) {
            this.quota.setTypeSpaces(typeQuotas);
            return this;
        }

        public Builder typeQuota(StorageType type, long quota) {
            this.quota.setTypeSpace(type, quota);
            return this;
        }

        public DirectoryWithQuotaFeature build() {
            return new DirectoryWithQuotaFeature(this);
        }
    }
}

