/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.generated.master;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.el.ExpressionFactory;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.RegionMetricsBuilder;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.http.MetaBrowser;
import org.apache.hadoop.hbase.master.http.RegionReplicaInfo;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.InstanceManagerFactory;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.JspSourceImports;
import org.apache.jasper.runtime.PageContextImpl;
import org.apache.tomcat.InstanceManager;

public final class table_jsp
extends HttpJspBase
implements JspSourceDependent,
JspSourceImports {
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Map<String, Long> _jspx_dependants;
    private static final Set<String> _jspx_imports_packages;
    private static final Set<String> _jspx_imports_classes;
    private volatile ExpressionFactory _el_expressionfactory;
    private volatile InstanceManager _jsp_instancemanager;

    private static RegionMetrics getEmptyRegionMetrics(RegionInfo regionInfo) {
        return RegionMetricsBuilder.toRegionMetrics((ClusterStatusProtos.RegionLoad)ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME).setValue(ByteString.copyFrom((byte[])regionInfo.getRegionName())).build()).build());
    }

    private static String buildRegionLink(ServerName serverName, int rsInfoPort, RegionInfo regionInfo, RegionState.State regionState) {
        if (serverName == null || regionInfo == null) {
            return null;
        }
        if (regionState != RegionState.State.OPEN) {
            return serverName.getServerName();
        }
        String socketAddress = serverName.getHostname() + ":" + rsInfoPort;
        String URI2 = "//" + socketAddress + "/region.jsp?name=" + regionInfo.getEncodedName();
        return "<a href=\"" + URI2 + "\">" + serverName.getServerName() + "</a>";
    }

    private static String buildRegionDeployedServerTag(RegionInfo regionInfo, HMaster master, Map<RegionInfo, ServerName> regionsToServer) throws UnsupportedEncodingException {
        ServerName serverName = regionsToServer.get(regionInfo);
        if (serverName == null) {
            return "<td class=\"undeployed-region\">not deployed</td>";
        }
        String hostName = serverName.getHostname();
        String hostNameEncoded = URLEncoder.encode(hostName, StandardCharsets.UTF_8.toString());
        int serverInfoPort = master.getRegionServerInfoPort(serverName);
        String urlRegionServer = "//" + hostNameEncoded + ":" + serverInfoPort + "/rs-status";
        return "<td><a href=\"" + urlRegionServer + "\">" + StringEscapeUtils.escapeHtml4((String)hostName) + ":" + serverInfoPort + "</a></td>";
    }

    private static String moreRegionsToRender(int numRegionsRendered, int numRegions, String fqtn) throws UnsupportedEncodingException {
        if (numRegions > numRegionsRendered) {
            String allRegionsUrl = "?name=" + URLEncoder.encode(fqtn, StandardCharsets.UTF_8.toString()) + "&numRegions=all";
            return "This table has <b>" + numRegions + "</b> regions in total, in order to improve the page load time, only <b>" + numRegionsRendered + "</b> regions are displayed here, <a href=\"" + allRegionsUrl + "\">click here</a> to see all regions.</p>";
        }
        return "";
    }

    public Map<String, Long> getDependants() {
        return _jspx_dependants;
    }

    public Set<String> getPackageImports() {
        return _jspx_imports_packages;
    }

    public Set<String> getClassImports() {
        return _jspx_imports_classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionFactory _jsp_getExpressionFactory() {
        if (this._el_expressionfactory == null) {
            table_jsp table_jsp2 = this;
            synchronized (table_jsp2) {
                if (this._el_expressionfactory == null) {
                    this._el_expressionfactory = _jspxFactory.getJspApplicationContext(this.getServletConfig().getServletContext()).getExpressionFactory();
                }
            }
        }
        return this._el_expressionfactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceManager _jsp_getInstanceManager() {
        if (this._jsp_instancemanager == null) {
            table_jsp table_jsp2 = this;
            synchronized (table_jsp2) {
                if (this._jsp_instancemanager == null) {
                    this._jsp_instancemanager = InstanceManagerFactory.getInstanceManager((ServletConfig)this.getServletConfig());
                }
            }
        }
        return this._jsp_instancemanager;
    }

    public void _jspInit() {
    }

    public void _jspDestroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block139: {
            MetaBrowser metaBrowser;
            AsyncConnection connection;
            int numRegions;
            int numRegionsToRender;
            long totalStoreFileSizeMB;
            boolean quotasEnabled;
            Map<String, Integer> frags;
            int numMetaReplicas;
            boolean readOnly;
            boolean showFragmentation;
            Table table;
            String escaped_fqtn;
            String fqtn;
            HMaster master;
            PageContext _jspx_page_context;
            JspWriter _jspx_out;
            JspWriter out;
            block136: {
                AsyncAdmin admin;
                String right;
                String left;
                String key;
                String action;
                block135: {
                    Configuration conf;
                    PageContext pageContext;
                    block134: {
                        if (!DispatcherType.ERROR.equals((Object)request.getDispatcherType())) {
                            String _jspx_method = request.getMethod();
                            if ("OPTIONS".equals(_jspx_method)) {
                                response.setHeader("Allow", "GET, HEAD, POST, OPTIONS");
                                return;
                            }
                            if (!("GET".equals(_jspx_method) || "POST".equals(_jspx_method) || "HEAD".equals(_jspx_method))) {
                                response.setHeader("Allow", "GET, HEAD, POST, OPTIONS");
                                response.sendError(405, "JSPs only permit GET, POST or HEAD. Jasper also permits OPTIONS");
                                return;
                            }
                        }
                        HttpSession session = null;
                        out = null;
                        table_jsp page = this;
                        _jspx_out = null;
                        _jspx_page_context = null;
                        response.setContentType("text/html;charset=UTF-8");
                        _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
                        ServletContext application = pageContext.getServletContext();
                        ServletConfig config = pageContext.getServletConfig();
                        session = pageContext.getSession();
                        _jspx_out = out = pageContext.getOut();
                        out.write("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
                        out.write(10);
                        out.write(10);
                        String _jspx_temp0_url = "header.jsp";
                        String _jspx_temp0_requestEncoding = request.getCharacterEncoding();
                        JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)(_jspx_temp0_url + (_jspx_temp0_url.indexOf(63) > 0 ? (char)'&' : '?') + JspRuntimeLibrary.URLEncode((String)"pageTitle", (String)_jspx_temp0_requestEncoding) + "=" + JspRuntimeLibrary.URLEncode((String)((String)PageContextImpl.proprietaryEvaluate((String)"${pageTitle}", String.class, (PageContext)_jspx_page_context, null)), (String)_jspx_temp0_requestEncoding)), (JspWriter)out, (boolean)false);
                        out.write(10);
                        out.write(10);
                        String ZEROMB = "0 MB";
                        master = (HMaster)this.getServletContext().getAttribute("master");
                        conf = master.getConfiguration();
                        fqtn = request.getParameter("name");
                        if (fqtn != null && master.isInitialized()) break block134;
                        out.write("\n    <div class=\"container-fluid content\">\n      <div class=\"row inner_header\">\n        <div class=\"page-header\">\n          <h1>Table not ready</h1>\n        </div>\n      </div>\n      <p><hr><p>\n      ");
                        JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"redirect.jsp", (JspWriter)out, (boolean)false);
                        out.write("\n    </div>\n");
                        _jspxFactory.releasePageContext(_jspx_page_context);
                        return;
                    }
                    out.write("\n  \n");
                    try {
                        TableName tn = TableName.valueOf((String)fqtn);
                        TableName.isLegalNamespaceName((byte[])tn.getNamespace());
                        TableName.isLegalTableQualifierName((byte[])tn.getQualifier());
                    }
                    catch (IllegalArgumentException e) {
                        out.write("\n    <div class=\"container-fluid content\">\n      <div class=\"row inner_header\">\n        <div class=\"page-header\">\n          <h1>Table not legal</h1>\n        </div>\n      </div>\n      <p><hr><p>\n      ");
                        JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"redirect.jsp", (JspWriter)out, (boolean)false);
                        out.write("\n    </div>\n");
                        _jspxFactory.releasePageContext(_jspx_page_context);
                        return;
                    }
                    out.write(10);
                    out.write(10);
                    escaped_fqtn = StringEscapeUtils.escapeHtml4((String)fqtn);
                    table = master.getConnection().getTable(TableName.valueOf((String)fqtn));
                    showFragmentation = conf.getBoolean("hbase.master.ui.fragmentation.enabled", false);
                    readOnly = !InfoServer.canUserModifyUI((HttpServletRequest)request, (ServletContext)this.getServletContext(), (Configuration)conf);
                    numMetaReplicas = master.getTableDescriptors().get(TableName.META_TABLE_NAME).getRegionReplication();
                    frags = null;
                    if (showFragmentation) {
                        frags = FSUtils.getTableFragmentation(master);
                    }
                    quotasEnabled = conf.getBoolean("hbase.quota.enabled", false);
                    action = request.getParameter("action");
                    key = request.getParameter("key");
                    left = request.getParameter("left");
                    right = request.getParameter("right");
                    totalStoreFileSizeMB = 0L;
                    String numRegionsParam = request.getParameter("numRegions");
                    numRegionsToRender = 10000;
                    if (numRegionsParam != null) {
                        if (numRegionsParam.equals("all")) {
                            numRegionsToRender = -1;
                        } else {
                            try {
                                numRegionsToRender = Integer.parseInt(numRegionsParam);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    numRegions = 0;
                    String pageTitle = !readOnly && action != null ? "HBase Master: " + StringEscapeUtils.escapeHtml4((String)master.getServerName().toString()) : "Table: " + escaped_fqtn;
                    pageContext.setAttribute("pageTitle", (Object)pageTitle);
                    connection = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)master.getConfiguration()).get();
                    admin = connection.getAdminBuilder().setOperationTimeout(5L, TimeUnit.SECONDS).build();
                    metaBrowser = new MetaBrowser(connection, request);
                    out.write(10);
                    out.write(10);
                    if (((Boolean)admin.tableExists(TableName.valueOf((String)fqtn)).get()).booleanValue()) break block135;
                    out.write("\n    <div class=\"container-fluid content\">\n      <div class=\"row inner_header\">\n        <div class=\"page-header\">\n          <h1>Table not found</h1>\n        </div>\n      </div>\n      <p><hr><p>\n      ");
                    JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"redirect.jsp", (JspWriter)out, (boolean)false);
                    out.write("\n    </div>\n");
                    _jspxFactory.releasePageContext(_jspx_page_context);
                    return;
                }
                out.write(10);
                out.write(10);
                if (readOnly || action == null) break block136;
                out.write("\n    <div class=\"container-fluid content\">\n      <div class=\"row inner_header\">\n        <div class=\"page-header\">\n          <h1>Table action request accepted</h1>\n        </div>\n      </div>\n      <p><hr><p>\n");
                if (action.equals("split")) {
                    if (key != null && key.length() > 0) {
                        admin.split(TableName.valueOf((String)fqtn), Bytes.toBytes((String)key));
                    } else {
                        admin.split(TableName.valueOf((String)fqtn));
                    }
                    out.write("    Split request accepted. ");
                } else if (action.equals("major compact")) {
                    if (key != null && key.length() > 0) {
                        List regions = (List)admin.getRegions(TableName.valueOf((String)fqtn)).get();
                        byte[] row = Bytes.toBytes((String)key);
                        for (RegionInfo region : regions) {
                            if (!region.containsRow(row)) continue;
                            admin.majorCompactRegion(region.getRegionName());
                        }
                    } else {
                        admin.majorCompact(TableName.valueOf((String)fqtn));
                    }
                    out.write("    major Compact request accepted. ");
                } else if (action.equals("compact")) {
                    if (key != null && key.length() > 0) {
                        List regions = (List)admin.getRegions(TableName.valueOf((String)fqtn)).get();
                        byte[] row = Bytes.toBytes((String)key);
                        for (RegionInfo region : regions) {
                            if (!region.containsRow(row)) continue;
                            admin.compactRegion(region.getRegionName());
                        }
                    } else {
                        admin.compact(TableName.valueOf((String)fqtn));
                    }
                    out.write("    Compact request accepted. ");
                } else if (action.equals("merge")) {
                    if (left != null && left.length() > 0 && right != null && right.length() > 0) {
                        admin.mergeRegions(Bytes.toBytesBinary((String)left), Bytes.toBytesBinary((String)right), false);
                    }
                    out.write("    Merge request accepted. ");
                }
                out.write("\n    ");
                JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"redirect.jsp", (JspWriter)out, (boolean)false);
                out.write("\n    </div>\n");
                _jspxFactory.releasePageContext(_jspx_page_context);
                return;
            }
            try {
                out.write("\n\n<div class=\"container-fluid content\">\n<div class=\"row inner_header\">\n  <div class=\"page-header\">\n    <h1>Table <small>");
                out.print(escaped_fqtn);
                out.write("</small></h1>\n  </div>\n</div>\n\n<div class=\"row\">\n");
                if (fqtn.equals(TableName.META_TABLE_NAME.getNameAsString())) {
                    boolean metaScanHasMore;
                    String hostAndPort;
                    int i;
                    ServerName metaLocation;
                    RegionStateNode rsn;
                    RegionInfo meta;
                    int j;
                    out.write("\n  <section>\n    <h2>Table Regions</h2>\n    <div class=\"tabbable\">\n      <ul class=\"nav nav-pills\" role=\"tablist\">\n        <li class=\"nav-item\"><a class=\"nav-link active\" href=\"#metaTab_baseStats\" data-bs-toggle=\"tab\" role=\"tab\">Base Stats</a></li>\n        <li class=\"nav-item\"><a class=\"nav-link\" href=\"#metaTab_localityStats\" data-bs-toggle=\"tab\" role=\"tab\">Localities</a></li>\n        <li class=\"nav-item\"><a class=\"nav-link\" href=\"#metaTab_compactStats\" data-bs-toggle=\"tab\" role=\"tab\">Compactions</a></li>\n      </ul>\n\n      <div class=\"tab-content\">\n        <div class=\"tab-pane active\" id=\"metaTab_baseStats\" role=\"tabpanel\">\n          <table id=\"metaTableBaseStatsTable\" class=\"tablesorter table table-striped\">\n            <thead>\n              <tr>\n                <th>Name</th>\n                <th>Region Server</th>\n                <th class=\"cls_separator\">ReadRequests</th>\n                <th class=\"cls_separator\">WriteRequests</th>\n                <th class=\"cls_filesize\">Uncompressed StoreFileSize</th>\n                <th class=\"cls_filesize\">StorefileSize</th>\n");
                    out.write("                <th class=\"cls_separator\">Num.Storefiles</th>\n                <th class=\"cls_filesize\">MemSize</th>\n                <th class=\"cls_emptyMin\">Start Key</th>\n                <th class=\"cls_emptyMax\">End Key</th>\n                <th>ReplicaID</th>\n              </tr>\n            </thead>\n            <tbody>\n            ");
                    for (j = 0; j < numMetaReplicas; ++j) {
                        meta = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)j);
                        rsn = master.getAssignmentManager().getRegionStates().getRegionStateNode(meta);
                        metaLocation = rsn != null ? rsn.getRegionLocation() : null;
                        for (i = 0; i < 1; ++i) {
                            void var47_98;
                            hostAndPort = "";
                            String readReq = "N/A";
                            String writeReq = "N/A";
                            String fileSizeUncompressed = "0 MB";
                            String fileSize = "0 MB";
                            String string = "N/A";
                            String memSize = "0 MB";
                            if (metaLocation != null) {
                                Map map;
                                ServerMetrics sl = master.getServerManager().getLoad(metaLocation);
                                hostAndPort = URLEncoder.encode(metaLocation.getHostname(), StandardCharsets.UTF_8.toString()) + ":" + master.getRegionServerInfoPort(metaLocation);
                                if (sl != null && (map = sl.getRegionMetrics()).containsKey(meta.getRegionName())) {
                                    double rSizeUncompressed;
                                    RegionMetrics load = (RegionMetrics)map.get(meta.getRegionName());
                                    readReq = String.format("%,1d", load.getReadRequestCount());
                                    writeReq = String.format("%,1d", load.getWriteRequestCount());
                                    double rSize = load.getStoreFileSize().get(Size.Unit.BYTE);
                                    if (rSize > 0.0) {
                                        fileSize = StringUtils.byteDesc((long)((long)rSize));
                                    }
                                    if ((rSizeUncompressed = load.getUncompressedStoreFileSize().get(Size.Unit.BYTE)) > 0.0) {
                                        fileSizeUncompressed = StringUtils.byteDesc((long)((long)rSizeUncompressed));
                                    }
                                    String string2 = String.format("%,1d", load.getStoreFileCount());
                                    double mSize = load.getMemStoreSize().get(Size.Unit.BYTE);
                                    if (mSize > 0.0) {
                                        memSize = StringUtils.byteDesc((long)((long)mSize));
                                    }
                                }
                            }
                            out.write("\n              <tr>\n                <td>");
                            out.print(StringEscapeUtils.escapeXml((String)meta.getRegionNameAsString()));
                            out.write("</td>\n                <td><a href=\"http://");
                            out.print(hostAndPort);
                            out.write("/rs-status\">");
                            out.print(StringEscapeUtils.escapeHtml4((String)hostAndPort));
                            out.write("</a></td>\n                <td>");
                            out.print(readReq);
                            out.write("</td>\n                <td>");
                            out.print(writeReq);
                            out.write("</td>\n                <td>");
                            out.print(fileSizeUncompressed);
                            out.write("</td>\n                <td>");
                            out.print(fileSize);
                            out.write("</td>\n                <td>");
                            out.print((String)var47_98);
                            out.write("</td>\n                <td>");
                            out.print(memSize);
                            out.write("</td>\n                <td>");
                            out.print(StringEscapeUtils.escapeXml((String)Bytes.toString((byte[])meta.getStartKey())));
                            out.write("</td>\n                <td>");
                            out.print(StringEscapeUtils.escapeXml((String)Bytes.toString((byte[])meta.getEndKey())));
                            out.write("</td>\n                <td>");
                            out.print(meta.getReplicaId());
                            out.write("</td>\n              </tr>\n            ");
                        }
                        out.write("\n            ");
                    }
                    out.write("\n            </tbody>\n          </table>\n        </div>\n        <div class=\"tab-pane\" id=\"metaTab_localityStats\">\n           <table id=\"metaTableLocalityStatsTable\" class=\"tablesorter table table-striped\">\n             <thead>\n               <tr>\n                 <th>Name</th>\n                 <th>Region Server</th>\n                 <th class=\"cls_separator\">Locality</th>\n                 <th class=\"cls_separator\">LocalityForSsd</th>\n               </tr>\n             </thead>\n             <tbody>\n             ");
                    for (j = 0; j < numMetaReplicas; ++j) {
                        meta = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)j);
                        rsn = master.getAssignmentManager().getRegionStates().getRegionStateNode(meta);
                        metaLocation = rsn != null ? rsn.getRegionLocation() : null;
                        for (i = 0; i < 1; ++i) {
                            hostAndPort = "";
                            float locality = 0.0f;
                            float localityForSsd = 0.0f;
                            if (metaLocation != null) {
                                Object map;
                                ServerMetrics sl = master.getServerManager().getLoad(metaLocation);
                                hostAndPort = URLEncoder.encode(metaLocation.getHostname(), StandardCharsets.UTF_8.toString()) + ":" + master.getRegionServerInfoPort(metaLocation);
                                if (sl != null && (map = sl.getRegionMetrics()).containsKey(meta.getRegionName())) {
                                    RegionMetrics regionMetrics = (RegionMetrics)map.get(meta.getRegionName());
                                    locality = regionMetrics.getDataLocality();
                                    localityForSsd = regionMetrics.getDataLocalityForSsd();
                                }
                            }
                            out.write("\n               <tr>\n                 <td>");
                            out.print(StringEscapeUtils.escapeXml((String)meta.getRegionNameAsString()));
                            out.write("</td>\n                 <td><a href=\"http://");
                            out.print(hostAndPort);
                            out.write("/rs-status\">");
                            out.print(StringEscapeUtils.escapeHtml4((String)hostAndPort));
                            out.write("</a></td>\n                 <td>");
                            out.print(locality);
                            out.write("</td>\n                 <td>");
                            out.print(localityForSsd);
                            out.write("</td>\n               </tr>\n             ");
                        }
                        out.write("\n             ");
                    }
                    out.write("\n             </tbody>\n           </table>\n         </div>\n        <div class=\"tab-pane\" id=\"metaTab_compactStats\" role=\"tabpanel\">\n          <table id=\"metaTableCompactStatsTable\" class=\"tablesorter table table-striped\">\n            <thead>\n              <tr>\n                <th>Name</th>\n                <th>Region Server</th>\n                <th class=\"cls_separator\">Num. Compacting Cells</th>\n                <th class=\"cls_separator\">Num. Compacted Cells</th>\n                <th class=\"cls_separator\">Remaining Cells</th>\n                <th>Compaction Progress</th>\n              </tr>\n            </thead>\n            <tbody>\n            ");
                    for (j = 0; j < numMetaReplicas; ++j) {
                        meta = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)j);
                        rsn = master.getAssignmentManager().getRegionStates().getRegionStateNode(meta);
                        metaLocation = rsn != null ? rsn.getRegionLocation() : null;
                        for (i = 0; i < 1; ++i) {
                            void var47_106;
                            hostAndPort = "";
                            long compactingCells = 0L;
                            long compactedCells = 0L;
                            String string = "";
                            if (metaLocation != null) {
                                Map map;
                                ServerMetrics sl = master.getServerManager().getLoad(metaLocation);
                                hostAndPort = URLEncoder.encode(metaLocation.getHostname(), StandardCharsets.UTF_8.toString()) + ":" + master.getRegionServerInfoPort(metaLocation);
                                if (sl != null && (map = sl.getRegionMetrics()).containsKey(meta.getRegionName())) {
                                    RegionMetrics load = (RegionMetrics)map.get(meta.getRegionName());
                                    compactingCells = load.getCompactingCellCount();
                                    compactedCells = load.getCompactedCellCount();
                                    if (compactingCells > 0L) {
                                        String string3 = String.format("%.2f", Float.valueOf(100.0f * ((float)compactedCells / (float)compactingCells))) + "%";
                                    }
                                }
                            }
                            out.write("\n              <tr>\n                <td>");
                            out.print(StringEscapeUtils.escapeXml((String)meta.getRegionNameAsString()));
                            out.write("</td>\n                <td><a href=\"http://");
                            out.print(hostAndPort);
                            out.write("/rs-status\">");
                            out.print(StringEscapeUtils.escapeHtml4((String)hostAndPort));
                            out.write("</a></td>\n                <td>");
                            out.print(String.format("%,1d", compactingCells));
                            out.write("</td>\n                <td>");
                            out.print(String.format("%,1d", compactedCells));
                            out.write("</td>\n                <td>");
                            out.print(String.format("%,1d", compactingCells - compactedCells));
                            out.write("</td>\n                <td>");
                            out.print((String)var47_106);
                            out.write("</td>\n              </tr>\n            ");
                        }
                        out.write("\n            ");
                    }
                    out.write("\n            </tbody>\n          </table>\n        </div>\n      </div>\n    </div>\n  </section>\n</div>\n\n<div class=\"row\">\n    <h2 id=\"meta-entries\">Meta Entries</h2>\n");
                    if (!metaBrowser.getErrorMessages().isEmpty()) {
                        for (String errorMessage : metaBrowser.getErrorMessages()) {
                            out.write("\n    <div class=\"alert alert-warning\" role=\"alert\">\n      ");
                            out.print(errorMessage);
                            out.write("\n    </div>\n");
                        }
                    }
                    String regionInfoColumnName = "info:regioninfo";
                    String serverColumnName = "info:server";
                    String startCodeColumnName = "info:serverstartcode";
                    String serverNameColumnName = "info:sn";
                    String seqNumColumnName = "info:seqnumDuringOpen";
                    out.write("\n    <div style=\"overflow-x: auto\">\n      <table class=\"table table-striped nowrap\">\n        <tr>\n          <th title=\"Region name, stored in ");
                    out.print(regionInfoColumnName);
                    out.write(" column\">RegionName</th>\n          <th title=\"The startKey of this region\">Start Key</th>\n          <th title=\"The endKey of this region\">End Key</th>\n          <th title=\"Region replica id\">Replica ID</th>\n          <th title=\"State of the region while undergoing transitions\">RegionState</th>\n          <th title=\"Server hosting this region replica, stored in ");
                    out.print(serverColumnName);
                    out.write(" column\">Server</th>\n          <th title=\"The seqNum for the region at the time the server opened this region replica, stored in ");
                    out.print(seqNumColumnName);
                    out.write("\">Sequence Number</th>\n          <th title=\"The server to which the region is transiting, stored in ");
                    out.print(serverNameColumnName);
                    out.write(" column\">Target Server</th>\n          <th title=\"The parents regions if this region is undergoing a merge\">info:merge*</th>\n          <th title=\"The daughter regions if this region is split\">info:split*</th>\n        </tr>\n");
                    byte[] lastRow = null;
                    try (RegionState.State[] results = metaBrowser.getResults();){
                        for (RegionReplicaInfo regionReplicaInfo : results) {
                            lastRow = Optional.ofNullable(regionReplicaInfo).map(RegionReplicaInfo::getRow).orElse(null);
                            if (regionReplicaInfo == null) {
                                out.write("\n        <tr>\n          <td colspan=\"6\">Null result</td>\n        </tr>\n");
                                continue;
                            }
                            String regionNameDisplay = regionReplicaInfo.getRegionName() != null ? Bytes.toStringBinary((byte[])regionReplicaInfo.getRegionName()) : "";
                            String startKeyDisplay = regionReplicaInfo.getStartKey() != null ? Bytes.toStringBinary((byte[])regionReplicaInfo.getStartKey()) : "";
                            String endKeyDisplay = regionReplicaInfo.getEndKey() != null ? Bytes.toStringBinary((byte[])regionReplicaInfo.getEndKey()) : "";
                            String replicaIdDisplay = regionReplicaInfo.getReplicaId() != null ? regionReplicaInfo.getReplicaId().toString() : "";
                            String regionStateDisplay = regionReplicaInfo.getRegionState() != null ? regionReplicaInfo.getRegionState().toString() : "";
                            RegionInfo regionInfo = regionReplicaInfo.getRegionInfo();
                            ServerName serverName = regionReplicaInfo.getServerName();
                            RegionState.State regionState = regionReplicaInfo.getRegionState();
                            int rsPort = master.getRegionServerInfoPort(serverName);
                            long seqNum = regionReplicaInfo.getSeqNum();
                            String regionSpanFormat = "<span title=info:%s>%s</span>";
                            String targetServerName = regionReplicaInfo.getTargetServerName() != null ? regionReplicaInfo.getTargetServerName().toString() : "";
                            Map<String, RegionInfo> mergeRegions = regionReplicaInfo.getMergeRegionInfo();
                            String mergeRegionNames = mergeRegions == null ? "" : mergeRegions.entrySet().stream().map(entry -> String.format("<span title=info:%s>%s</span>", entry.getKey(), ((RegionInfo)entry.getValue()).getRegionNameAsString())).collect(Collectors.joining("<br/>"));
                            Map<String, RegionInfo> splitRegions = regionReplicaInfo.getSplitRegionInfo();
                            String splitName = splitRegions == null ? "" : splitRegions.entrySet().stream().map(entry -> String.format("<span title=info:%s>%s</span>", entry.getKey(), ((RegionInfo)entry.getValue()).getRegionNameAsString())).collect(Collectors.joining("<br/>"));
                            out.write("\n    <tr>\n      <td title=\"");
                            out.print(regionInfoColumnName);
                            out.write(34);
                            out.write(62);
                            out.print(regionNameDisplay);
                            out.write("</td>\n      <td title=\"startKey\">");
                            out.print(startKeyDisplay);
                            out.write("</td>\n      <td title=\"endKey\">");
                            out.print(endKeyDisplay);
                            out.write("</td>\n      <td title=\"replicaId\">");
                            out.print(replicaIdDisplay);
                            out.write("</td>\n      <td title=\"regionState\">");
                            out.print(regionStateDisplay);
                            out.write("</td>\n      <td title=\"");
                            out.print(serverColumnName + "," + startCodeColumnName);
                            out.write(34);
                            out.write(62);
                            out.print(table_jsp.buildRegionLink(serverName, rsPort, regionInfo, regionState));
                            out.write("</td>\n      <td title=\"");
                            out.print(seqNumColumnName);
                            out.write(34);
                            out.write(62);
                            out.print(seqNum);
                            out.write("</td>\n      <td title=\"");
                            out.print(serverNameColumnName);
                            out.write(34);
                            out.write(62);
                            out.print(targetServerName);
                            out.write("</td>\n      <td>");
                            out.print(mergeRegionNames);
                            out.write("</td>\n      <td>");
                            out.print(splitName);
                            out.write("</td>\n    </tr>\n  ");
                        }
                        metaScanHasMore = results.hasMoreResults();
                    }
                    out.write("\n  </table>\n</div>\n</div>\n<div class=\"row mb-5\">\n  <div class=\"col-md-4\">\n    <ul class=\"pagination\" style=\"margin: 20px 0\">\n      <li class=\"page-item\">\n        <a class=\"page-link\" href=\"");
                    out.print(metaBrowser.buildFirstPageUrl());
                    out.write("\" aria-label=\"First\" title=\"First\">\n          <span aria-hidden=\"true\">&#x21E4;</span>\n        </a>\n      </li>\n      <li");
                    out.print(metaScanHasMore ? " class=\"page-item\"" : " class=\"page-item disabled\"");
                    out.write(">\n        <a class=\"page-link\" ");
                    out.print(metaScanHasMore ? " href=\"" + metaBrowser.buildNextPageUrl(lastRow) + "\"" : "");
                    out.write(" aria-label=\"Next\" title=\"Next\">\n          <span aria-hidden=\"true\">&raquo;</span>\n        </a>\n      </li>\n    </ul>\n  </div>\n  <div class=\"col-md-8\">\n    <form action=\"/table.jsp\" method=\"get\" class=\"row g-1 justify-content-end align-items-center\" style=\"margin: 20px 0\">\n      <input type=\"hidden\" name=\"name\" value=\"");
                    out.print((Object)TableName.META_TABLE_NAME);
                    out.write("\" />\n      <div class=\"col-sm-auto\">\n        <label for=\"scan-limit\" class=\"form-label\">Scan Limit</label>\n      </div>\n      <div class=\"col-sm-auto\">\n        <input type=\"text\" id=\"scan-limit\" name=\"");
                    out.print("scan_limit");
                    out.write("\"\n          class=\"form-control\" placeholder=\"");
                    out.print(10);
                    out.write("\"\n          ");
                    out.print(metaBrowser.getScanLimit() != null ? "value=\"" + metaBrowser.getScanLimit() + "\"" : "");
                    out.write("\n          aria-describedby=\"scan-limit\" />\n      </div>\n      <div class=\"col-sm-auto\">\n        <label for=\"table-name-filter\" class=\"form-label\">Table</label>\n      </div>\n      <div class=\"col-sm-auto\">\n        <input type=\"text\" id=\"table-name-filter\" name=\"");
                    out.print("scan_table");
                    out.write("\"\n           class=\"form-control\"\n          ");
                    out.print(metaBrowser.getScanTable() != null ? "value=\"" + metaBrowser.getScanTable() + "\"" : "");
                    out.write("\n          aria-describedby=\"scan-filter-table\" />\n      </div>\n      <div class=\"col-sm-auto\">\n        <label for=\"region-state-filter\" class=\"form-label\">Region State</label>\n      </div>\n      <div class=\"col-sm-auto\">\n        <select class=\"form-control\" id=\"region-state-filter\"\n           name=\"");
                    out.print("scan_region_state");
                    out.write("\">\n          <option></option>\n");
                    for (RegionState.State state : RegionState.State.values()) {
                        boolean selected = metaBrowser.getScanRegionState() == state;
                        out.write("\n              <option");
                        out.print(selected ? " selected" : "");
                        out.write(62);
                        out.print((Object)state);
                        out.write("</option>\n");
                    }
                    out.write("\n        </select>\n      </div>\n      <div class=\"col-sm-auto\">\n        <button type=\"submit\" class=\"btn btn-primary\">\n          Filter Results\n        </button>\n      </div>\n    </form>\n  </div><!--/.col-md-8 -->\n</div><!--/.row .mb-5 -->\n");
                } else {
                    RegionStates states = master.getAssignmentManager().getRegionStates();
                    Map<RegionState.State, List<RegionInfo>> regionStates = states.getRegionByStateOfTable(table.getName());
                    HashMap<String, RegionState.State> stateMap = new HashMap<String, RegionState.State>();
                    for (RegionState.State regionState : regionStates.keySet()) {
                        for (RegionInfo regionInfo : regionStates.get(regionState)) {
                            stateMap.put(regionInfo.getEncodedName(), regionState);
                        }
                    }
                    RegionLocator r = master.getConnection().getRegionLocator(table.getName());
                    try {
                        out.write("\n<h2>Table Attributes</h2>\n<table class=\"table table-striped\">\n  <tr>\n      <th>Attribute Name</th>\n      <th>Value</th>\n      <th>Description</th>\n  </tr>\n  <tr>\n      <td>Enabled</td>\n      <td>");
                        out.print(master.getTableStateManager().isTableState(table.getName(), TableState.State.ENABLED));
                        out.write("</td>\n      <td>Is the table enabled</td>\n  </tr>\n  <tr>\n      <td>Compaction</td>\n      <td>\n");
                        if (master.getTableStateManager().isTableState(table.getName(), TableState.State.ENABLED)) {
                            CompactionState compactionState = master.getCompactionState(table.getName());
                            out.print((Object)(compactionState == null ? "UNKNOWN" : compactionState));
                        } else {
                            out.print((Object)CompactionState.NONE);
                        }
                        out.write("\n      </td>\n      <td>Is the table compacting</td>\n  </tr>\n");
                        if (showFragmentation) {
                            out.write("\n  <tr>\n      <td>Fragmentation</td>\n      <td>");
                            out.print(frags.get(fqtn) != null ? frags.get(fqtn) + "%" : "n/a");
                            out.write("</td>\n      <td>How fragmented is the table. After a major compaction it is 0%.</td>\n  </tr>\n");
                        }
                        out.write(10);
                        if (quotasEnabled) {
                            List throttles;
                            TableName tn = TableName.valueOf((String)fqtn);
                            SpaceQuotaSnapshot masterSnapshot = null;
                            Object quota = QuotaTableUtil.getTableQuota((Connection)master.getConnection(), (TableName)tn);
                            if (quota == null || !quota.hasSpace()) {
                                quota = QuotaTableUtil.getNamespaceQuota((Connection)master.getConnection(), (String)tn.getNamespaceAsString());
                                if (quota != null) {
                                    masterSnapshot = master.getQuotaObserverChore().getNamespaceQuotaSnapshots().get(tn.getNamespaceAsString());
                                }
                            } else {
                                masterSnapshot = master.getQuotaObserverChore().getTableQuotaSnapshots().get(tn);
                            }
                            if (quota != null && quota.hasSpace()) {
                                QuotaProtos.SpaceQuota spaceQuota = quota.getSpace();
                                out.write("\n  <tr>\n    <td>Space Quota</td>\n    <td>\n      <table>\n        <tr>\n          <th>Property</th>\n          <th>Value</th>\n        </tr>\n        <tr>\n          <td>Limit</td>\n          <td>");
                                out.print(StringUtils.byteDesc((long)spaceQuota.getSoftLimit()));
                                out.write("</td>\n        </tr>\n        <tr>\n          <td>Policy</td>\n          <td>");
                                out.print((Object)spaceQuota.getViolationPolicy());
                                out.write("</td>\n        </tr>\n");
                                if (masterSnapshot != null) {
                                    out.write("\n        <tr>\n          <td>Usage</td>\n          <td>");
                                    out.print(StringUtils.byteDesc((long)masterSnapshot.getUsage()));
                                    out.write("</td>\n        </tr>\n        <tr>\n          <td>State</td>\n          <td>");
                                    out.print(masterSnapshot.getQuotaStatus().isInViolation() ? "In Violation" : "In Observance");
                                    out.write("</td>\n        </tr>\n");
                                }
                                out.write("\n      </table>\n    </td>\n    <td>Information about a Space Quota on this table, if set.</td>\n  </tr>\n");
                            }
                            if (quota != null && quota.hasThrottle() && (throttles = QuotaSettingsFactory.fromTableThrottles((TableName)table.getName(), (QuotaProtos.Throttle)quota.getThrottle())).size() > 0) {
                                out.write("\n  <tr>\n    <td>Throttle Quota</td>\n    <td>\n      <table>\n        <tr>\n          <th>Limit</th>\n          <th>Type</th>\n          <th>TimeUnit</th>\n          <th>Scope</th>\n        </tr>\n");
                                for (ThrottleSettings throttle : throttles) {
                                    out.write("\n        <tr>\n          <td>");
                                    out.print(throttle.getSoftLimit());
                                    out.write("</td>\n          <td>");
                                    out.print((Object)throttle.getThrottleType());
                                    out.write("</td>\n          <td>");
                                    out.print((Object)throttle.getTimeUnit());
                                    out.write("</td>\n          <td>");
                                    out.print((Object)throttle.getQuotaScope());
                                    out.write("</td>\n        </tr>\n");
                                }
                                out.write("\n      </table>\n    </td>\n    <td>Information about a Throttle Quota on this table, if set.</td>\n  </tr>\n");
                            }
                        }
                        out.write("\n</table>\n<h2>Table Schema</h2>\n<table class=\"table table-striped\">\n");
                        QuotaProtos.Quotas families = table.getDescriptor().getColumnFamilies();
                        HashSet familyKeySet = new HashSet();
                        for (QuotaProtos.Quotas family : families) {
                            familyKeySet.addAll(family.getValues().keySet());
                        }
                        out.write("\n  <tr>\n      <th>Property \\ Column Family Name</th>\n  ");
                        for (QuotaProtos.Quotas family : families) {
                            out.write("\n  <th>\n    ");
                            out.print(StringEscapeUtils.escapeHtml4((String)family.getNameAsString()));
                            out.write("\n      </th>\n      ");
                        }
                        out.write("\n    </tr>\n    ");
                        for (Bytes familyKey : familyKeySet) {
                            out.write("\n      <tr>\n        <td>\n          ");
                            out.print(StringEscapeUtils.escapeHtml4((String)familyKey.toString()));
                            out.write("\n        </td>\n        ");
                            for (QuotaProtos.Quotas family : families) {
                                String familyValue = "-";
                                if (family.getValues().containsKey(familyKey)) {
                                    familyValue = ((Bytes)family.getValues().get(familyKey)).toString();
                                }
                                out.write("\n    <td>\n      ");
                                out.print(StringEscapeUtils.escapeHtml4((String)familyValue));
                                out.write("\n    </td>\n    ");
                            }
                            out.write("\n  </tr>\n  ");
                        }
                        out.write("\n</table>\n");
                        long totalReadReq = 0L;
                        long totalWriteReq = 0L;
                        long l = 0L;
                        long totalSize = 0L;
                        long totalStoreFileCount = 0L;
                        long totalMemSize = 0L;
                        long totalCompactingCells = 0L;
                        long totalCompactedCells = 0L;
                        long totalBlocksTotalWeight = 0L;
                        long totalBlocksLocalWeight = 0L;
                        long totalBlocksLocalWithSsdWeight = 0L;
                        String totalCompactionProgress = "";
                        String totalMemSizeStr = "0 MB";
                        String totalSizeUncompressedStr = "0 MB";
                        String totalSizeStr = "0 MB";
                        String totalLocality = "";
                        String totalLocalityForSsd = "";
                        Object urlRegionServer = null;
                        TreeMap<ServerName, Integer> regDistribution = new TreeMap<ServerName, Integer>();
                        TreeMap<ServerName, Integer> primaryRegDistribution = new TreeMap<ServerName, Integer>();
                        List regions = r.getAllRegionLocations();
                        LinkedHashMap<HRegionInfo, RegionMetrics> regionsToLoad = new LinkedHashMap<HRegionInfo, RegionMetrics>();
                        LinkedHashMap<RegionInfo, ServerName> regionsToServer = new LinkedHashMap<RegionInfo, ServerName>();
                        for (HRegionLocation hriEntry : regions) {
                            HRegionInfo regionInfo = hriEntry.getRegionInfo();
                            ServerName serverName = hriEntry.getServerName();
                            regionsToServer.put((RegionInfo)regionInfo, serverName);
                            if (serverName != null) {
                                ServerMetrics sl = master.getServerManager().getLoad(serverName);
                                if (sl != null) {
                                    RegionMetrics regionMetrics = (RegionMetrics)sl.getRegionMetrics().get(regionInfo.getRegionName());
                                    regionsToLoad.put(regionInfo, regionMetrics);
                                    if (regionMetrics != null) {
                                        totalReadReq += regionMetrics.getReadRequestCount();
                                        totalWriteReq += regionMetrics.getWriteRequestCount();
                                        l = (long)((double)l + regionMetrics.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE));
                                        totalSize = (long)((double)totalSize + regionMetrics.getStoreFileSize().get(Size.Unit.MEGABYTE));
                                        totalStoreFileCount += (long)regionMetrics.getStoreFileCount();
                                        totalMemSize = (long)((double)totalMemSize + regionMetrics.getMemStoreSize().get(Size.Unit.MEGABYTE));
                                        totalStoreFileSizeMB = (long)((double)totalStoreFileSizeMB + regionMetrics.getStoreFileSize().get(Size.Unit.MEGABYTE));
                                        totalCompactingCells += regionMetrics.getCompactingCellCount();
                                        totalCompactedCells += regionMetrics.getCompactedCellCount();
                                        totalBlocksTotalWeight += regionMetrics.getBlocksTotalWeight();
                                        totalBlocksLocalWeight += regionMetrics.getBlocksLocalWeight();
                                        totalBlocksLocalWithSsdWeight += regionMetrics.getBlocksLocalWithSsdWeight();
                                        continue;
                                    }
                                    RegionMetrics load0 = table_jsp.getEmptyRegionMetrics((RegionInfo)regionInfo);
                                    regionsToLoad.put(regionInfo, load0);
                                    continue;
                                }
                                RegionMetrics load0 = table_jsp.getEmptyRegionMetrics((RegionInfo)regionInfo);
                                regionsToLoad.put(regionInfo, load0);
                                continue;
                            }
                            RegionMetrics load0 = table_jsp.getEmptyRegionMetrics((RegionInfo)regionInfo);
                            regionsToLoad.put(regionInfo, load0);
                        }
                        if (totalSize > 0L) {
                            totalSizeStr = StringUtils.byteDesc((long)(totalSize * 1024L * 1024L));
                        }
                        if (l > 0L) {
                            totalSizeUncompressedStr = StringUtils.byteDesc((long)(l * 1024L * 1024L));
                        }
                        if (totalMemSize > 0L) {
                            totalMemSizeStr = StringUtils.byteDesc((long)(totalMemSize * 1024L * 1024L));
                        }
                        if (totalCompactingCells > 0L) {
                            totalCompactionProgress = String.format("%.2f", Float.valueOf(100.0f * ((float)totalCompactedCells / (float)totalCompactingCells))) + "%";
                        }
                        if (totalBlocksTotalWeight > 0L) {
                            DecimalFormat df = new DecimalFormat("0.0#");
                            df.setRoundingMode(RoundingMode.DOWN);
                            totalLocality = df.format((float)totalBlocksLocalWeight / (float)totalBlocksTotalWeight);
                            totalLocalityForSsd = df.format((float)totalBlocksLocalWithSsdWeight / (float)totalBlocksTotalWeight);
                        }
                        if (regions != null && regions.size() > 0) {
                            ServerName addr;
                            RegionInfo regionInfo;
                            out.write("\n<div class=\"row\">\n  <div class=\"col\">\n    <section>\n      <h2>Table Regions</h2>\n      <div class=\"tabbable\">\n        <ul class=\"nav nav-pills\" role=\"tablist\">\n          <li class=\"nav-item\"><a class=\"nav-link active\" href=\"#tab_baseStats\" data-bs-toggle=\"tab\" role=\"tab\">Base Stats</a></li>\n          <li class=\"nav-item\"><a class=\"nav-link\" href=\"#tab_localityStats\" data-bs-toggle=\"tab\" role=\"tab\">Localities</a></li>\n          <li class=\"nav-item\"><a class=\"nav-link\" href=\"#tab_compactStats\" data-bs-toggle=\"tab\" role=\"tab\">Compactions</a></li>\n        </ul>\n        <div class=\"tab-content\">\n          <div class=\"tab-pane active\" id=\"tab_baseStats\" role=\"tabpanel\">\n            <table id=\"tableBaseStatsTable\" class=\"tablesorter table table-striped\">\n              <thead>\n                <tr>\n                  <th>Name(");
                            out.print(String.format("%,1d", regions.size()));
                            out.write(")</th>\n                  <th>Region Server</th>\n                  <th class=\"cls_separator\">ReadRequests<br>(");
                            out.print(String.format("%,1d", totalReadReq));
                            out.write(")</th>\n                  <th class=\"cls_separator\">WriteRequests<br>(");
                            out.print(String.format("%,1d", totalWriteReq));
                            out.write(")</th>\n                  <th class=\"cls_filesize\">Uncompressed StoreFileSize<br>(");
                            out.print(totalSizeUncompressedStr);
                            out.write(")</th>\n                  <th class=\"cls_filesize\">StorefileSize<br>(");
                            out.print(totalSizeStr);
                            out.write(")</th>\n                  <th class=\"cls_separator\">Num.Storefiles<br>(");
                            out.print(String.format("%,1d", totalStoreFileCount));
                            out.write(")</th>\n                  <th class=\"cls_filesize\">MemSize<br>(");
                            out.print(totalMemSizeStr);
                            out.write(")</th>\n                  <th class=\"cls_emptyMin\">Start Key</th>\n                  <th class=\"cls_emptyMax\">End Key</th>\n                  <th>Region State</th>\n                  <th>ReplicaID</th>\n                </tr>\n              </thead>\n              <tbody>\n              ");
                            ArrayList entryList = new ArrayList(regionsToLoad.entrySet());
                            numRegions = regions.size();
                            int numRegionsRendered = 0;
                            if (numRegionsToRender < 0) {
                                numRegionsToRender = numRegions;
                            }
                            for (Map.Entry entry2 : entryList) {
                                ServerMetrics sl;
                                regionInfo = (RegionInfo)entry2.getKey();
                                addr = (ServerName)regionsToServer.get(regionInfo);
                                RegionMetrics load = (RegionMetrics)entry2.getValue();
                                String readReq = "N/A";
                                String writeReq = "N/A";
                                String regionSizeUncompressed = "0 MB";
                                String regionSize = "0 MB";
                                String fileCount = "N/A";
                                String memSize = "0 MB";
                                String state = "N/A";
                                if (load != null) {
                                    double rSize;
                                    readReq = String.format("%,1d", load.getReadRequestCount());
                                    writeReq = String.format("%,1d", load.getWriteRequestCount());
                                    double rSizeUncompressed = load.getUncompressedStoreFileSize().get(Size.Unit.BYTE);
                                    if (rSizeUncompressed > 0.0) {
                                        regionSizeUncompressed = StringUtils.byteDesc((long)((long)rSizeUncompressed));
                                    }
                                    if ((rSize = load.getStoreFileSize().get(Size.Unit.BYTE)) > 0.0) {
                                        regionSize = StringUtils.byteDesc((long)((long)rSize));
                                    }
                                    fileCount = String.format("%,1d", load.getStoreFileCount());
                                    double mSize = load.getMemStoreSize().get(Size.Unit.BYTE);
                                    if (mSize > 0.0) {
                                        memSize = StringUtils.byteDesc((long)((long)mSize));
                                    }
                                }
                                if (stateMap.containsKey(regionInfo.getEncodedName())) {
                                    state = ((RegionState.State)stateMap.get(regionInfo.getEncodedName())).toString();
                                }
                                if (addr != null && (sl = master.getServerManager().getLoad(addr)) != null) {
                                    Integer i = (Integer)regDistribution.get(addr);
                                    if (null == i) {
                                        i = 0;
                                    }
                                    regDistribution.put(addr, i + 1);
                                    if (RegionReplicaUtil.isDefaultReplica((int)regionInfo.getReplicaId())) {
                                        i = (Integer)primaryRegDistribution.get(addr);
                                        if (null == i) {
                                            i = 0;
                                        }
                                        primaryRegDistribution.put(addr, i + 1);
                                    }
                                }
                                if (numRegionsRendered < numRegionsToRender) {
                                    ++numRegionsRendered;
                                    out.write("\n              <tr>\n                <td>");
                                    out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary((byte[])regionInfo.getRegionName())));
                                    out.write("</td>\n                ");
                                    out.print(table_jsp.buildRegionDeployedServerTag(regionInfo, master, regionsToServer));
                                    out.write("\n                <td>");
                                    out.print(readReq);
                                    out.write("</td>\n                <td>");
                                    out.print(writeReq);
                                    out.write("</td>\n                <td>");
                                    out.print(regionSizeUncompressed);
                                    out.write("</td>\n                <td>");
                                    out.print(regionSize);
                                    out.write("</td>\n                <td>");
                                    out.print(fileCount);
                                    out.write("</td>\n                <td>");
                                    out.print(memSize);
                                    out.write("</td>\n                <td>");
                                    out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary((byte[])regionInfo.getStartKey())));
                                    out.write("</td>\n                <td>");
                                    out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary((byte[])regionInfo.getEndKey())));
                                    out.write("</td>\n                <td>");
                                    out.print(state);
                                    out.write("</td>\n                <td>");
                                    out.print(regionInfo.getReplicaId());
                                    out.write("</td>\n              </tr>\n              ");
                                }
                                out.write("\n              ");
                            }
                            out.write("\n              </tbody>\n            </table>\n            ");
                            out.print(table_jsp.moreRegionsToRender(numRegionsRendered, numRegions, fqtn));
                            out.write("\n          </div>\n          <div class=\"tab-pane\" id=\"tab_localityStats\" role=\"tabpanel\">\n            <table id=\"tableLocalityStatsTable\" class=\"tablesorter table table-striped\">\n              <thead>\n                <tr>\n                  <th>Name(");
                            out.print(String.format("%,1d", regions.size()));
                            out.write(")</th>\n                  <th>Region Server</th>\n                  <th class=\"cls_separator\">Locality<br>(");
                            out.print(totalLocality);
                            out.write(")</th>\n                  <th class=\"cls_separator\">LocalityForSsd<br>(");
                            out.print(totalLocalityForSsd);
                            out.write(")</th>\n                </tr>\n              </thead>\n              <tbody>\n              ");
                            numRegionsRendered = 0;
                            for (Map.Entry entry3 : entryList) {
                                regionInfo = (RegionInfo)entry3.getKey();
                                RegionMetrics load = (RegionMetrics)entry3.getValue();
                                float locality = 0.0f;
                                float localityForSsd = 0.0f;
                                if (load != null) {
                                    locality = load.getDataLocality();
                                    localityForSsd = load.getDataLocalityForSsd();
                                }
                                if (numRegionsRendered < numRegionsToRender) {
                                    ++numRegionsRendered;
                                    out.write("\n              <tr>\n                <td>");
                                    out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary((byte[])regionInfo.getRegionName())));
                                    out.write("</td>\n                ");
                                    out.print(table_jsp.buildRegionDeployedServerTag(regionInfo, master, regionsToServer));
                                    out.write("\n                <td>");
                                    out.print(locality);
                                    out.write("</td>\n                <td>");
                                    out.print(localityForSsd);
                                    out.write("</td>\n              </tr>\n              ");
                                }
                                out.write("\n              ");
                            }
                            out.write("\n              </tbody>\n            </table>\n            ");
                            out.print(table_jsp.moreRegionsToRender(numRegionsRendered, numRegions, fqtn));
                            out.write("\n          </div>\n          <div class=\"tab-pane\" id=\"tab_compactStats\" role=\"tabpanel\">\n            <table id=\"tableCompactStatsTable\" class=\"tablesorter table table-striped\">\n              <thead>\n                <tr>\n                  <th>Name(");
                            out.print(String.format("%,1d", regions.size()));
                            out.write(")</th>\n                  <th>Region Server</th>\n                  <th class=\"cls_separator\">Num. Compacting Cells<br>(");
                            out.print(String.format("%,1d", totalCompactingCells));
                            out.write(")</th>\n                  <th class=\"cls_separator\">Num. Compacted Cells<br>(");
                            out.print(String.format("%,1d", totalCompactedCells));
                            out.write(")</th>\n                  <th class=\"cls_separator\">Remaining Cells<br>(");
                            out.print(String.format("%,1d", totalCompactingCells - totalCompactedCells));
                            out.write(")</th>\n                  <th>Compaction Progress<br>(");
                            out.print(totalCompactionProgress);
                            out.write(")</th>\n                </tr>\n              </thead>\n              <tbody>\n              ");
                            numRegionsRendered = 0;
                            for (Map.Entry entry4 : entryList) {
                                regionInfo = (RegionInfo)entry4.getKey();
                                addr = (ServerName)regionsToServer.get(regionInfo);
                                RegionMetrics load = (RegionMetrics)entry4.getValue();
                                long compactingCells = 0L;
                                long compactedCells = 0L;
                                String compactionProgress = "";
                                if (load != null) {
                                    compactingCells = load.getCompactingCellCount();
                                    compactedCells = load.getCompactedCellCount();
                                    if (compactingCells > 0L) {
                                        compactionProgress = String.format("%.2f", Float.valueOf(100.0f * ((float)compactedCells / (float)compactingCells))) + "%";
                                    }
                                }
                                if (numRegionsRendered < numRegionsToRender) {
                                    ++numRegionsRendered;
                                    out.write("\n              <tr>\n                <td>");
                                    out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary((byte[])regionInfo.getRegionName())));
                                    out.write("</td>\n                ");
                                    out.print(table_jsp.buildRegionDeployedServerTag(regionInfo, master, regionsToServer));
                                    out.write("\n                <td>");
                                    out.print(String.format("%,1d", compactingCells));
                                    out.write("</td>\n                <td>");
                                    out.print(String.format("%,1d", compactedCells));
                                    out.write("</td>\n                <td>");
                                    out.print(String.format("%,1d", compactingCells - compactedCells));
                                    out.write("</td>\n                <td>");
                                    out.print(compactionProgress);
                                    out.write("</td>\n              </tr>\n              ");
                                }
                                out.write("\n              ");
                            }
                            out.write("\n              </tbody>\n            </table>\n            ");
                            out.print(table_jsp.moreRegionsToRender(numRegionsRendered, numRegions, fqtn));
                            out.write("\n          </div>\n        </div>\n      </div>\n    </section>\n  </div>\n</div>\n\n<section>\n<h2>Regions by Region Server</h2>\n<table id=\"regionServerTable\" class=\"tablesorter table table-striped\">\n  <thead>\n    <tr>\n      <th>Region Server</th>\n      <th class=\"cls_separator\">Region Count</th>\n      <th>Primary Region Count</th>\n    </tr>\n  </thead>\n\n  <tbody>\n  ");
                            for (Map.Entry entry5 : regDistribution.entrySet()) {
                                ServerName addr2 = (ServerName)entry5.getKey();
                                String url = "//" + URLEncoder.encode(addr2.getHostname(), StandardCharsets.UTF_8.toString()) + ":" + master.getRegionServerInfoPort(addr2) + "/rs-status";
                                out.write("\n      <tr>\n        <td><a href=\"");
                                out.print(url);
                                out.write(34);
                                out.write(62);
                                out.print(StringEscapeUtils.escapeHtml4((String)addr2.getHostname()) + ":" + master.getRegionServerInfoPort(addr2));
                                out.write("</a></td>\n        <td>");
                                out.print(entry5.getValue());
                                out.write("</td>\n        <td>");
                                out.print(primaryRegDistribution.get(addr2) == null ? 0 : (Integer)primaryRegDistribution.get(addr2));
                                out.write("</td>\n      </tr>\n  ");
                            }
                            out.write("\n  </tbody>\n</table>\n\n");
                        }
                    }
                    catch (Exception ex) {
                        out.write("\n  Unknown Issue with Regions\n  <div onclick=\"document.getElementById('closeStackTrace').style.display='block';document.getElementById('openStackTrace').style.display='none';\">\n    <a id=\"openStackTrace\" style=\"cursor:pointer;\"> Show StackTrace</a>\n  </div>\n  <div id=\"closeStackTrace\" style=\"display:none;clear:both;\">\n    <div onclick=\"document.getElementById('closeStackTrace').style.display='none';document.getElementById('openStackTrace').style.display='block';\">\n      <a style=\"cursor:pointer;\"> Close StackTrace</a>\n    </div>\n  ");
                        for (StackTraceElement element : ex.getStackTrace()) {
                            out.print(StringEscapeUtils.escapeHtml4((String)(element.toString() + "\n")));
                        }
                    }
                    finally {
                        connection.close();
                    }
                }
                out.write("\n</section>\n\n      <h2>Table Stats</h2>\n      <table class=\"table table-striped\">\n        <tr>\n          <th>Name</th>\n          <th>Value</th>\n          <th>Description</th>\n        </tr>\n        <tr>\n          <td>Size</td>\n          <td>\n            ");
                if (totalStoreFileSizeMB > 0L) {
                    out.write("\n            ");
                    out.print(StringUtils.TraditionalBinaryPrefix.long2String((long)(totalStoreFileSizeMB * 1024L * 1024L), (String)"B", (int)2));
                    out.write("</td>\n          ");
                } else {
                    out.write("\n          0 MB </td>\n          ");
                }
                out.write("\n          <td>Total size of store files</td>\n        </tr>\n      </table>\n\n");
                if (!readOnly) {
                    out.write("\n\n<h2>Actions</h2>\n\n<table class=\"table\">\n  <tr>\n    <form method=\"get\">\n      <input type=\"hidden\" name=\"action\" value=\"major compact\" />\n      <input type=\"hidden\" name=\"name\" value=\"");
                    out.print(escaped_fqtn);
                    out.write("\" />\n      <td class=\"centered\">\n        <input type=\"submit\" value=\"Major Compact\" class=\"btn btn-secondary\" />\n      </td>\n      <td style=\"text-align: center;\">\n        <input type=\"text\" class=\"form-control\" name=\"key\" size=\"40\" placeholder=\"Row Key (optional)\" />\n      </td>\n      <td>\n      This action will force a major compaction of all regions of the table, or,\n      if a key is supplied, only the region major containing the\n      given key.\n      </td>\n    </form>\n  </tr>\n  <tr>\n    <form method=\"get\">\n      <input type=\"hidden\" name=\"action\" value=\"compact\" />\n      <input type=\"hidden\" name=\"name\" value=\"");
                    out.print(escaped_fqtn);
                    out.write("\" />\n      <td class=\"centered\">\n        <input type=\"submit\" value=\"Compact\" class=\"btn btn-secondary\" />\n      </td>\n      <td style=\"text-align: center;\">\n        <input type=\"text\" class=\"form-control\" name=\"key\" size=\"40\" placeholder=\"Row Key (optional)\" />\n      </td>\n      <td>\n      This action will force a compaction of all regions of the table, or,\n      if a key is supplied, only the region containing the\n      given key.\n      </td>\n    </form>\n  </tr>\n  <tr>\n    <form method=\"get\">\n      <input type=\"hidden\" name=\"action\" value=\"split\" />\n      <input type=\"hidden\" name=\"name\" value=\"");
                    out.print(escaped_fqtn);
                    out.write("\" />\n      <td class=\"centered\">\n        <input type=\"submit\" value=\"Split\" class=\"btn btn-secondary\" />\n      </td>\n      <td style=\"text-align: center;\">\n        <input type=\"text\" class=\"form-control\" name=\"key\" size=\"40\" placeholder=\"Row Key (optional)\" />\n      </td>\n      <td>\n      This action will force a split of all eligible\n      regions of the table, or, if a key is supplied, only the region containing the\n      given key. An eligible region is one that does not contain any references to\n      other regions. Split requests for noneligible regions will be ignored.\n      </td>\n    </form>\n  </tr>\n  <tr>\n    <form method=\"get\">\n      <input type=\"hidden\" name=\"action\" value=\"merge\" />\n      <input type=\"hidden\" name=\"name\" value=\"");
                    out.print(escaped_fqtn);
                    out.write("\" />\n      <td class=\"centered\">\n        <input type=\"submit\" value=\"Merge\" class=\"btn btn-secondary\" />\n      </td>\n      <td style=\"text-align: center;\">\n        <input type=\"text\" class=\"form-control mb-2\" name=\"left\" size=\"40\" required=\"required\" placeholder=\"Region Key (required)\" />\n        <input type=\"text\" class=\"form-control\" name=\"right\" size=\"40\" required=\"required\" placeholder=\"Region Key (required)\" />\n      </td>\n      <td>\n      This action will merge two regions of the table, Merge requests for\n      noneligible regions will be ignored.\n      </td>\n    </form>\n  </tr>\n</table>\n\n");
                }
                out.write("\n</div><!--/.row -->\n</div> <!--/.container-fluid -->\n\n");
                JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"scripts.jsp", (JspWriter)out, (boolean)false);
                out.write("\n<script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n\n<script>\n$(document).ready(function()\n    {\n        $.tablesorter.addParser(\n        {\n            id: 'filesize',\n            is: function(s) {\n                return s.match(new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ));\n            },\n            format: function(s) {\n                var suf = s.match(new RegExp( /(B|KB|MB|GB|TB)$/ ))[1];\n                var num = parseFloat(s.match( new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ))[0]);\n                switch(suf) {\n                    case 'B':\n                        return num;\n                    case 'KB':\n                        return num * 1024;\n                    case 'MB':\n                        return num * 1024 * 1024;\n                    case 'GB':\n                        return num * 1024 * 1024 * 1024;\n                    case 'TB':\n                        return num * 1024 * 1024 * 1024 * 1024;\n                }\n            },\n            type: 'numeric'\n        });\n");
                out.write("        $.tablesorter.addParser(\n        {\n            id: \"separator\",\n            is: function (s) {\n                return /^[0-9]?[0-9,]*$/.test(s);\n            }, format: function (s) {\n                return $.tablesorter.formatFloat( s.replace(/,/g,'') );\n            }, type: \"numeric\"\n        });\n        $(\"#regionServerTable\").tablesorter({\n            headers: {\n                '.cls_separator': {sorter: 'separator'}\n            }\n        });\n        $(\"#tableBaseStatsTable\").tablesorter({\n            headers: {\n                '.cls_separator': {sorter: 'separator'},\n                '.cls_filesize': {sorter: 'filesize'},\n                '.cls_emptyMin': {empty: 'emptyMin'},\n                '.cls_emptyMax': {empty: 'emptyMax'}\n            }\n        });\n        $(\"#metaTableBaseStatsTable\").tablesorter({\n            headers: {\n                '.cls_separator': {sorter: 'separator'},\n                '.cls_filesize': {sorter: 'filesize'},\n                '.cls_emptyMin': {empty: 'emptyMin'},\n                '.cls_emptyMax': {empty: 'emptyMax'}\n");
                out.write("            }\n        });\n        $(\"#tableLocalityStatsTable\").tablesorter({\n            headers: {\n               '.cls_separator': {sorter: 'separator'}\n            }\n        });\n        $(\"#metaTableLocalityStatsTable\").tablesorter({\n            headers: {\n                '.cls_separator': {sorter: 'separator'}\n            }\n        });\n        $(\"#tableCompactStatsTable\").tablesorter({\n            headers: {\n                '.cls_separator': {sorter: 'separator'}\n            }\n        });\n        $(\"#metaTableCompactStatsTable\").tablesorter({\n            headers: {\n                '.cls_separator': {sorter: 'separator'}\n            }\n        });\n    }\n);\n</script>\n</body>\n</html>\n");
            }
            catch (Throwable t) {
                try {
                    if (t instanceof SkipPageException) break block139;
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        try {
                            if (response.isCommitted()) {
                                out.flush();
                            } else {
                                out.clearBuffer();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                        break block139;
                    }
                    throw new ServletException(t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
            _jspxFactory.releasePageContext(_jspx_page_context);
        }
    }

    static {
        _jspx_imports_packages = new LinkedHashSet<String>(4);
        _jspx_imports_packages.add("javax.servlet");
        _jspx_imports_packages.add("javax.servlet.http");
        _jspx_imports_packages.add("javax.servlet.jsp");
        _jspx_imports_classes = new LinkedHashSet<String>(79);
        _jspx_imports_classes.add("org.apache.hadoop.hbase.RegionMetricsBuilder");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos.SpaceQuota");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.master.RegionState");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.NotServingRegionException");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.master.http.MetaBrowser");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.HTableDescriptor");
        _jspx_imports_classes.add("java.util.Map");
        _jspx_imports_classes.add("org.apache.hadoop.conf.Configuration");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.quotas.ThrottleSettings");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.client.ColumnFamilyDescriptor");
        _jspx_imports_classes.add("org.apache.commons.lang3.StringEscapeUtils");
        _jspx_imports_classes.add("java.math.RoundingMode");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.client.AsyncAdmin");
        _jspx_imports_classes.add("static org.apache.commons.lang3.StringEscapeUtils.escapeXml");
        _jspx_imports_classes.add("java.util.Set");
        _jspx_imports_classes.add("java.util.stream.Collectors");
        _jspx_imports_classes.add("java.nio.charset.StandardCharsets");
        _jspx_imports_classes.add("java.util.List");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.master.http.RegionReplicaInfo");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.client.CompactionState");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.client.RegionLocator");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos");
        _jspx_imports_classes.add("java.util.Optional");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.client.RegionInfoBuilder");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.master.HMaster");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.util.FSUtils");
        _jspx_imports_classes.add("java.io.UnsupportedEncodingException");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.ServerMetrics");
        _jspx_imports_classes.add("java.util.HashMap");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.client.TableState");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.master.assignment.RegionStateNode");
        _jspx_imports_classes.add("java.util.ArrayList");
        _jspx_imports_classes.add("java.util.LinkedHashMap");
        _jspx_imports_classes.add("java.util.HashSet");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.client.AsyncConnection");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.HConstants");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.quotas.QuotaTableUtil");
        _jspx_imports_classes.add("org.apache.hadoop.util.StringUtils");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.http.InfoServer");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.ServerName");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.util.Bytes");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.TableName");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.master.assignment.RegionStates");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos.Quotas");
        _jspx_imports_classes.add("java.text.DecimalFormat");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.client.RegionReplicaUtil");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.client.ConnectionFactory");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.quotas.QuotaSettingsFactory");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.RegionMetrics");
        _jspx_imports_classes.add("java.util.concurrent.TimeUnit");
        _jspx_imports_classes.add("java.net.URLEncoder");
        _jspx_imports_classes.add("java.util.TreeMap");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.HRegionLocation");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.Size");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.client.Table");
        _jspx_imports_classes.add("org.apache.hbase.thirdparty.com.google.protobuf.ByteString");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.client.RegionInfo");
    }
}

