/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SaslUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SaslUtil.class);
    public static final String SASL_DEFAULT_REALM = "default";
    public static final int SWITCH_TO_SIMPLE_AUTH = -88;

    public static String[] splitKerberosName(String fullName) {
        return (String[])Splitter.onPattern((String)"[/@]").splitToStream((CharSequence)fullName).toArray(String[]::new);
    }

    public static String encodeIdentifier(byte[] identifier) {
        return Base64.getEncoder().encodeToString(identifier);
    }

    public static byte[] decodeIdentifier(String identifier) {
        return Base64.getDecoder().decode(Bytes.toBytes((String)identifier));
    }

    public static char[] encodePassword(byte[] password) {
        return Base64.getEncoder().encodeToString(password).toCharArray();
    }

    public static QualityOfProtection getQop(String stringQop) {
        for (QualityOfProtection qop : QualityOfProtection.values()) {
            if (!qop.matches(stringQop)) continue;
            return qop;
        }
        throw new IllegalArgumentException("Invalid qop: " + stringQop + ". It must be one of 'authentication', 'integrity', 'privacy'.");
    }

    public static Map<String, String> initSaslProperties(String rpcProtection) {
        String saslQop;
        if (rpcProtection.isEmpty()) {
            saslQop = QualityOfProtection.AUTHENTICATION.getSaslQop();
        } else {
            StringBuilder saslQopBuilder = new StringBuilder();
            for (String s : Splitter.on((char)',').split((CharSequence)rpcProtection)) {
                QualityOfProtection qop = SaslUtil.getQop(s);
                saslQopBuilder.append(",").append(qop.getSaslQop());
            }
            saslQop = saslQopBuilder.substring(1);
        }
        TreeMap<String, String> saslProps = new TreeMap<String, String>();
        saslProps.put("javax.security.sasl.qop", saslQop);
        saslProps.put("javax.security.sasl.server.authentication", "true");
        return saslProps;
    }

    static void safeDispose(SaslClient saslClient) {
        try {
            saslClient.dispose();
        }
        catch (SaslException e) {
            LOG.error("Error disposing of SASL client", (Throwable)e);
        }
    }

    static void safeDispose(SaslServer saslServer) {
        try {
            saslServer.dispose();
        }
        catch (SaslException e) {
            LOG.error("Error disposing of SASL server", (Throwable)e);
        }
    }

    public static void verifyNegotiatedQop(String requestedQopString, String negotiatedQop) throws IOException {
        if (requestedQopString == null || requestedQopString.isEmpty()) {
            return;
        }
        List<String> requestedQops = Arrays.asList(requestedQopString.toLowerCase().split(","));
        if (negotiatedQop == null) {
            negotiatedQop = QualityOfProtection.AUTHENTICATION.getSaslQop();
        }
        if (requestedQops.contains(negotiatedQop.toLowerCase())) {
            return;
        }
        throw new IOException("Could not negotiate requested SASL QOP. Requested:" + requestedQopString + " , negotiated:" + negotiatedQop);
    }

    public static enum QualityOfProtection {
        AUTHENTICATION("auth"),
        INTEGRITY("auth-int"),
        PRIVACY("auth-conf");

        private final String saslQop;

        private QualityOfProtection(String saslQop) {
            this.saslQop = saslQop;
        }

        public String getSaslQop() {
            return this.saslQop;
        }

        public boolean matches(String stringQop) {
            if (this.saslQop.equals(stringQop)) {
                LOG.warn("Use authentication/integrity/privacy as value for rpc protection configurations instead of auth/auth-int/auth-conf.");
                return true;
            }
            return this.name().equalsIgnoreCase(stringQop);
        }
    }
}

