/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.BulkLoadObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.EndpointObserver;
import org.apache.hadoop.hbase.coprocessor.HasMasterServices;
import org.apache.hadoop.hbase.coprocessor.HasRegionServerServices;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.quotas.GlobalQuotaSettings;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlUtil;
import org.apache.hadoop.hbase.security.access.AuthManager;
import org.apache.hadoop.hbase.security.access.AuthResult;
import org.apache.hadoop.hbase.security.access.GetUserPermissionsRequest;
import org.apache.hadoop.hbase.security.access.NamespacePermission;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Service;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.SimpleMutableByteRange;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.MapMaker;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CoreCoprocessor
@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class AccessController
implements MasterCoprocessor,
RegionCoprocessor,
RegionServerCoprocessor,
AccessControlProtos.AccessControlService.Interface,
MasterObserver,
RegionObserver,
RegionServerObserver,
EndpointObserver,
BulkLoadObserver {
    private static final Logger LOG = LoggerFactory.getLogger(AccessController.class);
    private static final Logger AUDITLOG = LoggerFactory.getLogger((String)("SecurityLogger." + AccessController.class.getName()));
    private static final String CHECK_COVERING_PERM = "check_covering_perm";
    private static final String TAG_CHECK_PASSED = "tag_check_passed";
    private static final byte[] TRUE = Bytes.toBytes(true);
    private AccessChecker accessChecker;
    private ZKPermissionWatcher zkPermissionWatcher;
    private boolean aclRegion = false;
    private RegionCoprocessorEnvironment regionEnv;
    private Map<InternalScanner, String> scannerOwners = new MapMaker().weakKeys().makeMap();
    private Map<TableName, List<UserPermission>> tableAcls;
    private UserProvider userProvider;
    private boolean authorizationEnabled;
    private boolean cellFeaturesEnabled;
    private boolean shouldCheckExecPermission;
    private boolean compatibleEarlyTermination;
    private volatile boolean initialized = false;
    private volatile boolean aclTabAvailable = false;

    public static boolean isCellAuthorizationSupported(Configuration conf) {
        return AccessChecker.isAuthorizationSupported(conf) && HFile.getFormatVersion(conf) >= 3;
    }

    public Region getRegion() {
        return this.regionEnv != null ? this.regionEnv.getRegion() : null;
    }

    public AuthManager getAuthManager() {
        return this.accessChecker.getAuthManager();
    }

    private void initialize(RegionCoprocessorEnvironment e) throws IOException {
        Region region = e.getRegion();
        Configuration conf = e.getConfiguration();
        Map<byte[], ListMultimap<String, UserPermission>> tables = PermissionStorage.loadAll(region);
        for (Map.Entry<byte[], ListMultimap<String, UserPermission>> t : tables.entrySet()) {
            byte[] entry = t.getKey();
            ListMultimap<String, UserPermission> perms = t.getValue();
            byte[] serialized = PermissionStorage.writePermissionsAsBytes(perms, conf);
            this.zkPermissionWatcher.writeToZookeeper(entry, serialized);
        }
        this.initialized = true;
    }

    private void updateACL(RegionCoprocessorEnvironment e, Map<byte[], List<Cell>> familyMap) {
        TreeSet<byte[]> entries = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        for (Map.Entry<byte[], List<Cell>> f : familyMap.entrySet()) {
            List<Cell> cells = f.getValue();
            for (Cell cell : cells) {
                if (!CellUtil.matchingFamily(cell, PermissionStorage.ACL_LIST_FAMILY)) continue;
                entries.add(CellUtil.cloneRow(cell));
            }
        }
        Configuration conf = this.regionEnv.getConfiguration();
        byte[] currentEntry = null;
        try {
            Table t = e.getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);
            Object object = null;
            try {
                Iterator iterator = entries.iterator();
                while (iterator.hasNext()) {
                    byte[] entry;
                    currentEntry = entry = (byte[])iterator.next();
                    ListMultimap<String, UserPermission> perms = PermissionStorage.getPermissions(conf, entry, t, null, null, null, false);
                    byte[] serialized = PermissionStorage.writePermissionsAsBytes(perms, conf);
                    this.zkPermissionWatcher.writeToZookeeper(entry, serialized);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (t != null) {
                    if (object != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        t.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            LOG.error("Failed updating permissions mirror for '" + (currentEntry == null ? "null" : Bytes.toString(currentEntry)) + "'", (Throwable)ex);
        }
    }

    private AuthResult permissionGranted(OpType opType, User user, RegionCoprocessorEnvironment e, Map<byte[], ? extends Collection<?>> families, Permission.Action ... actions) {
        AuthResult result = null;
        for (Permission.Action action : actions) {
            result = this.accessChecker.permissionGranted(opType.toString(), user, action, e.getRegion().getRegionInfo().getTable(), families);
            if (result.isAllowed()) continue;
            return result;
        }
        return result;
    }

    public void requireAccess(ObserverContext<?> ctx, String request, TableName tableName, Permission.Action ... permissions) throws IOException {
        this.accessChecker.requireAccess(this.getActiveUser(ctx), request, tableName, permissions);
    }

    public void requirePermission(ObserverContext<?> ctx, String request, Permission.Action perm) throws IOException {
        this.accessChecker.requirePermission(this.getActiveUser(ctx), request, null, perm);
    }

    public void requireGlobalPermission(ObserverContext<?> ctx, String request, Permission.Action perm, TableName tableName, Map<byte[], ? extends Collection<byte[]>> familyMap) throws IOException {
        this.accessChecker.requireGlobalPermission(this.getActiveUser(ctx), request, perm, tableName, familyMap, null);
    }

    public void requireGlobalPermission(ObserverContext<?> ctx, String request, Permission.Action perm, String namespace) throws IOException {
        this.accessChecker.requireGlobalPermission(this.getActiveUser(ctx), request, perm, namespace);
    }

    public void requireNamespacePermission(ObserverContext<?> ctx, String request, String namespace, Permission.Action ... permissions) throws IOException {
        this.accessChecker.requireNamespacePermission(this.getActiveUser(ctx), request, namespace, null, permissions);
    }

    public void requireNamespacePermission(ObserverContext<?> ctx, String request, String namespace, TableName tableName, Map<byte[], ? extends Collection<byte[]>> familyMap, Permission.Action ... permissions) throws IOException {
        this.accessChecker.requireNamespacePermission(this.getActiveUser(ctx), request, namespace, tableName, familyMap, permissions);
    }

    public void requirePermission(ObserverContext<?> ctx, String request, TableName tableName, byte[] family, byte[] qualifier, Permission.Action ... permissions) throws IOException {
        this.accessChecker.requirePermission(this.getActiveUser(ctx), request, tableName, family, qualifier, null, permissions);
    }

    public void requireTablePermission(ObserverContext<?> ctx, String request, TableName tableName, byte[] family, byte[] qualifier, Permission.Action ... permissions) throws IOException {
        this.accessChecker.requireTablePermission(this.getActiveUser(ctx), request, tableName, family, qualifier, permissions);
    }

    public void checkLockPermissions(ObserverContext<?> ctx, String namespace, TableName tableName, RegionInfo[] regionInfos, String reason) throws IOException {
        this.accessChecker.checkLockPermissions(this.getActiveUser(ctx), namespace, tableName, regionInfos, reason);
    }

    private boolean hasFamilyQualifierPermission(User user, Permission.Action perm, RegionCoprocessorEnvironment env, Map<byte[], ? extends Collection<byte[]>> familyMap) throws IOException {
        RegionInfo hri = env.getRegion().getRegionInfo();
        TableName tableName = hri.getTable();
        if (user == null) {
            return false;
        }
        if (familyMap != null && familyMap.size() > 0) {
            for (Map.Entry<byte[], ? extends Collection<byte[]>> family : familyMap.entrySet()) {
                if (family.getValue() != null && !family.getValue().isEmpty()) {
                    for (byte[] qualifier : family.getValue()) {
                        if (!this.getAuthManager().authorizeUserTable(user, tableName, family.getKey(), qualifier, perm)) continue;
                        return true;
                    }
                    continue;
                }
                if (!this.getAuthManager().authorizeUserFamily(user, tableName, family.getKey(), perm)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Empty family map passed for permission check");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCoveringPermission(User user, OpType request, RegionCoprocessorEnvironment e, byte[] row, Map<byte[], ? extends Collection<?>> familyMap, long opTs, Permission.Action ... actions) throws IOException {
        boolean considerCellTs;
        if (!this.cellFeaturesEnabled) {
            return false;
        }
        long cellGrants = 0L;
        long latestCellTs = 0L;
        Get get = new Get(row);
        boolean bl = considerCellTs = request == OpType.PUT || request == OpType.DELETE;
        if (considerCellTs) {
            get.setMaxVersions();
        } else {
            get.setMaxVersions(1);
        }
        boolean diffCellTsFromOpTs = false;
        for (Map.Entry<byte[], Collection<?>> entry : familyMap.entrySet()) {
            byte[] col = entry.getKey();
            if (entry.getValue() instanceof Set) {
                Set set = (Set)entry.getValue();
                if (set == null || set.isEmpty()) {
                    get.addFamily(col);
                    continue;
                }
                for (byte[] qual : set) {
                    get.addColumn(col, qual);
                }
                continue;
            }
            if (entry.getValue() instanceof List) {
                List list = (List)entry.getValue();
                if (list == null || list.isEmpty()) {
                    get.addFamily(col);
                    continue;
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Cell cell = (Cell)iterator.next();
                    if (cell.getQualifierLength() == 0 && (cell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode() || cell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode())) {
                        get.addFamily(col);
                    } else {
                        get.addColumn(col, CellUtil.cloneQualifier(cell));
                    }
                    if (!considerCellTs) continue;
                    long cellTs = cell.getTimestamp();
                    latestCellTs = Math.max(latestCellTs, cellTs);
                    diffCellTsFromOpTs = diffCellTsFromOpTs || opTs != cellTs;
                }
                continue;
            }
            if (entry.getValue() == null) {
                get.addFamily(col);
                continue;
            }
            throw new RuntimeException("Unhandled collection type " + entry.getValue().getClass().getName());
        }
        long latestTs = Math.max(opTs, latestCellTs);
        if (latestTs == 0L || latestTs == Long.MAX_VALUE) {
            latestTs = EnvironmentEdgeManager.currentTime();
        }
        get.setTimeRange(0L, latestTs + 1L);
        if (!diffCellTsFromOpTs && request == OpType.PUT) {
            get.setMaxVersions(1);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Scanning for cells with " + get);
        }
        HashMap<SimpleMutableByteRange, List> familyMap1 = new HashMap<SimpleMutableByteRange, List>();
        for (Map.Entry entry : familyMap.entrySet()) {
            if (!(entry.getValue() instanceof List)) continue;
            familyMap1.put(new SimpleMutableByteRange((byte[])entry.getKey()), (List)entry.getValue());
        }
        RegionScanner scanner = this.getRegion(e).getScanner(new Scan(get));
        ArrayList<Cell> arrayList = Lists.newArrayList();
        Cell prevCell = null;
        SimpleMutableByteRange curFam = new SimpleMutableByteRange();
        boolean curColAllVersions = request == OpType.DELETE;
        long curColCheckTs = opTs;
        boolean foundColumn = false;
        try {
            boolean more = false;
            ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(1).build();
            do {
                arrayList.clear();
                more = scanner.next(arrayList, scannerContext);
                for (Cell cell : arrayList) {
                    boolean colChange;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Found cell " + cell);
                    }
                    boolean bl2 = colChange = prevCell == null || !CellUtil.matchingColumn(prevCell, cell);
                    if (colChange) {
                        foundColumn = false;
                    }
                    prevCell = cell;
                    if (!curColAllVersions && foundColumn) continue;
                    if (colChange && considerCellTs) {
                        curFam.set(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
                        List cols = (List)familyMap1.get(curFam);
                        for (Cell col : cols) {
                            if ((col.getQualifierLength() != 0 || request != OpType.DELETE) && !CellUtil.matchingQualifier(cell, col)) continue;
                            byte type = col.getTypeByte();
                            if (considerCellTs) {
                                curColCheckTs = col.getTimestamp();
                            }
                            curColAllVersions = KeyValue.Type.DeleteColumn.getCode() == type || KeyValue.Type.DeleteFamily.getCode() == type;
                            break;
                        }
                    }
                    if (cell.getTimestamp() > curColCheckTs) continue;
                    foundColumn = true;
                    for (Permission.Action action : actions) {
                        if (this.getAuthManager().authorizeCell(user, this.getTableName(e), cell, action)) continue;
                        boolean bl3 = false;
                        return bl3;
                    }
                    ++cellGrants;
                }
            } while (more);
        }
        catch (AccessDeniedException ex) {
            throw ex;
        }
        catch (IOException ex) {
            LOG.error("Exception while getting cells to calculate covering permission", (Throwable)ex);
        }
        finally {
            scanner.close();
        }
        return cellGrants > 0L;
    }

    private static void addCellPermissions(byte[] perms, Map<byte[], List<Cell>> familyMap) {
        for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
            ArrayList<Cell> newCells = Lists.newArrayList();
            for (Cell cell : e.getValue()) {
                ArrayList<Tag> tags = new ArrayList<Tag>();
                tags.add(new ArrayBackedTag(1, perms));
                Iterator<Tag> tagIterator = PrivateCellUtil.tagsIterator(cell);
                while (tagIterator.hasNext()) {
                    tags.add(tagIterator.next());
                }
                newCells.add(PrivateCellUtil.createCell(cell, tags));
            }
            e.setValue(newCells);
        }
    }

    private void checkForReservedTagPresence(User user, Mutation m3) throws IOException {
        if (!this.authorizationEnabled) {
            m3.setAttribute(TAG_CHECK_PASSED, TRUE);
            return;
        }
        if (Superusers.isSuperUser(user)) {
            m3.setAttribute(TAG_CHECK_PASSED, TRUE);
            return;
        }
        if (m3.getAttribute(TAG_CHECK_PASSED) != null) {
            return;
        }
        CellScanner cellScanner = m3.cellScanner();
        while (cellScanner.advance()) {
            Iterator<Tag> tagsItr = PrivateCellUtil.tagsIterator(cellScanner.current());
            while (tagsItr.hasNext()) {
                if (tagsItr.next().getType() != 1) continue;
                throw new AccessDeniedException("Mutation contains cell with reserved type tag");
            }
        }
        m3.setAttribute(TAG_CHECK_PASSED, TRUE);
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        CompoundConfiguration conf = new CompoundConfiguration();
        conf.add(env.getConfiguration());
        this.authorizationEnabled = AccessChecker.isAuthorizationSupported(conf);
        if (!this.authorizationEnabled) {
            LOG.warn("AccessController has been loaded with authorization checks DISABLED!");
        }
        this.shouldCheckExecPermission = conf.getBoolean("hbase.security.exec.permission.checks", false);
        boolean bl = this.cellFeaturesEnabled = HFile.getFormatVersion(conf) >= 3;
        if (!this.cellFeaturesEnabled) {
            LOG.info("A minimum HFile version of 3 is required to persist cell ACLs. Consider setting hfile.format.version accordingly.");
        }
        if (env instanceof MasterCoprocessorEnvironment) {
            MasterCoprocessorEnvironment mEnv = (MasterCoprocessorEnvironment)env;
            if (mEnv instanceof HasMasterServices) {
                MasterServices masterServices = ((HasMasterServices)((Object)mEnv)).getMasterServices();
                this.zkPermissionWatcher = masterServices.getZKPermissionWatcher();
                this.accessChecker = masterServices.getAccessChecker();
            }
        } else if (env instanceof RegionServerCoprocessorEnvironment) {
            RegionServerCoprocessorEnvironment rsEnv = (RegionServerCoprocessorEnvironment)env;
            if (rsEnv instanceof HasRegionServerServices) {
                RegionServerServices rsServices = ((HasRegionServerServices)((Object)rsEnv)).getRegionServerServices();
                this.zkPermissionWatcher = rsServices.getZKPermissionWatcher();
                this.accessChecker = rsServices.getAccessChecker();
            }
        } else if (env instanceof RegionCoprocessorEnvironment) {
            this.regionEnv = (RegionCoprocessorEnvironment)env;
            conf.addBytesMap(this.regionEnv.getRegion().getTableDescriptor().getValues());
            this.compatibleEarlyTermination = conf.getBoolean("hbase.security.access.early_out", true);
            if (this.regionEnv instanceof HasRegionServerServices) {
                RegionServerServices rsServices = ((HasRegionServerServices)((Object)this.regionEnv)).getRegionServerServices();
                this.zkPermissionWatcher = rsServices.getZKPermissionWatcher();
                this.accessChecker = rsServices.getAccessChecker();
            }
        }
        if (this.zkPermissionWatcher == null) {
            throw new NullPointerException("ZKPermissionWatcher is null");
        }
        if (this.accessChecker == null) {
            throw new NullPointerException("AccessChecker is null");
        }
        this.userProvider = UserProvider.instantiate(env.getConfiguration());
        this.tableAcls = new MapMaker().weakValues().makeMap();
    }

    @Override
    public void stop(CoprocessorEnvironment env) {
    }

    @Override
    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    @Override
    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }

    @Override
    public Optional<EndpointObserver> getEndpointObserver() {
        return Optional.of(this);
    }

    @Override
    public Optional<BulkLoadObserver> getBulkLoadObserver() {
        return Optional.of(this);
    }

    @Override
    public Optional<RegionServerObserver> getRegionServerObserver() {
        return Optional.of(this);
    }

    @Override
    public Iterable<Service> getServices() {
        return Collections.singleton(AccessControlProtos.AccessControlService.newReflectiveService(this));
    }

    @Override
    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        Set<byte[]> families = desc.getColumnFamilyNames();
        TreeMap<byte[], Object> familyMap = new TreeMap<byte[], Object>(Bytes.BYTES_COMPARATOR);
        for (byte[] family : families) {
            familyMap.put(family, null);
        }
        this.requireNamespacePermission(c, "createTable", desc.getTableName().getNamespaceAsString(), desc.getTableName(), familyMap, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void postCompletedCreateTableAction(final ObserverContext<MasterCoprocessorEnvironment> c, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        if (PermissionStorage.isAclTable(desc)) {
            this.aclTabAvailable = true;
        } else if (!TableName.NAMESPACE_TABLE_NAME.equals(desc.getTableName())) {
            if (!this.aclTabAvailable) {
                LOG.warn("Not adding owner permission for table " + desc.getTableName() + ". " + PermissionStorage.ACL_TABLE_NAME + " is not yet created. " + this.getClass().getSimpleName() + " should be configured as the first Coprocessor");
            } else {
                String owner = desc.getOwnerString();
                if (owner == null) {
                    owner = this.getActiveUser(c).getShortName();
                }
                final UserPermission userPermission = new UserPermission(owner, Permission.newBuilder(desc.getTableName()).withActions(Permission.Action.values()).build());
                User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        try (Table table = ((MasterCoprocessorEnvironment)c.getEnvironment()).getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);){
                            PermissionStorage.addUserPermission(((MasterCoprocessorEnvironment)c.getEnvironment()).getConfiguration(), userPermission, table);
                        }
                        return null;
                    }
                });
            }
        }
    }

    @Override
    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission(c, "deleteTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void postDeleteTable(final ObserverContext<MasterCoprocessorEnvironment> c, final TableName tableName) throws IOException {
        final Configuration conf = c.getEnvironment().getConfiguration();
        User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Table table = ((MasterCoprocessorEnvironment)c.getEnvironment()).getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);){
                    PermissionStorage.removeTablePermissions(conf, tableName, table);
                }
                return null;
            }
        });
        this.zkPermissionWatcher.deleteTableACLNode(tableName);
    }

    @Override
    public void preTruncateTable(ObserverContext<MasterCoprocessorEnvironment> c, final TableName tableName) throws IOException {
        this.requirePermission(c, "truncateTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        final Configuration conf = c.getEnvironment().getConfiguration();
        User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                List<UserPermission> acls = PermissionStorage.getUserTablePermissions(conf, tableName, null, null, null, false);
                if (acls != null) {
                    AccessController.this.tableAcls.put(tableName, acls);
                }
                return null;
            }
        });
    }

    @Override
    public void postTruncateTable(final ObserverContext<MasterCoprocessorEnvironment> ctx, final TableName tableName) throws IOException {
        final Configuration conf = ctx.getEnvironment().getConfiguration();
        User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                List perms = (List)AccessController.this.tableAcls.get(tableName);
                if (perms != null) {
                    for (UserPermission perm : perms) {
                        Table table = ((MasterCoprocessorEnvironment)ctx.getEnvironment()).getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);
                        Throwable throwable = null;
                        try {
                            PermissionStorage.addUserPermission(conf, perm, table);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (table == null) continue;
                            if (throwable != null) {
                                try {
                                    table.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            table.close();
                        }
                    }
                }
                AccessController.this.tableAcls.remove(tableName);
                return null;
            }
        });
    }

    @Override
    public TableDescriptor preModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, TableDescriptor currentDesc, TableDescriptor newDesc) throws IOException {
        this.requirePermission(c, "modifyTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        return newDesc;
    }

    @Override
    public void postModifyTable(final ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, final TableDescriptor htd) throws IOException {
        final Configuration conf = c.getEnvironment().getConfiguration();
        final String owner = htd.getOwnerString() != null ? htd.getOwnerString() : this.getActiveUser(c).getShortName();
        User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                UserPermission userperm = new UserPermission(owner, Permission.newBuilder(htd.getTableName()).withActions(Permission.Action.values()).build());
                try (Table table = ((MasterCoprocessorEnvironment)c.getEnvironment()).getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);){
                    PermissionStorage.addUserPermission(conf, userperm, table);
                }
                return null;
            }
        });
    }

    @Override
    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission(c, "enableTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (Bytes.equals(tableName.getName(), PermissionStorage.ACL_GLOBAL_NAME)) {
            throw new AccessDeniedException("Not allowed to disable " + PermissionStorage.ACL_TABLE_NAME + " table with AccessController installed");
        }
        this.requirePermission(c, "disableTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> ctx, long procId) throws IOException {
        this.requirePermission(ctx, "abortProcedure", Permission.Action.ADMIN);
    }

    @Override
    public void postAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    @Override
    public void preGetProcedures(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        this.requirePermission(ctx, "getProcedure", Permission.Action.ADMIN);
    }

    @Override
    public void preGetLocks(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        User user = this.getActiveUser(ctx);
        this.accessChecker.requirePermission(user, "getLocks", null, Permission.Action.ADMIN);
    }

    @Override
    public void preMove(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        this.requirePermission(c, "move", region.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo) throws IOException {
        this.requirePermission(c, "assign", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo) throws IOException {
        this.requirePermission(c, "unassign", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo) throws IOException {
        this.requirePermission(c, "regionOffline", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preSetSplitOrMergeEnabled(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean newValue, MasterSwitchType switchType) throws IOException {
        this.requirePermission(ctx, "setSplitOrMergeEnabled", Permission.Action.ADMIN);
    }

    @Override
    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission(c, "balance", Permission.Action.ADMIN);
    }

    @Override
    public void preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean newValue) throws IOException {
        this.requirePermission(c, "balanceSwitch", Permission.Action.ADMIN);
    }

    @Override
    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission(c, "shutdown", Permission.Action.ADMIN);
    }

    @Override
    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission(c, "stopMaster", Permission.Action.ADMIN);
    }

    @Override
    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        try (Admin admin = ctx.getEnvironment().getConnection().getAdmin();){
            if (!admin.tableExists(PermissionStorage.ACL_TABLE_NAME)) {
                AccessController.createACLTable(admin);
            } else {
                this.aclTabAvailable = true;
            }
        }
    }

    private static void createACLTable(Admin admin) throws IOException {
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder(PermissionStorage.ACL_LIST_FAMILY).setMaxVersions(1).setInMemory(true).setBlockCacheEnabled(true).setBlocksize(8192).setBloomFilterType(BloomType.NONE).setScope(0).build();
        TableDescriptor td = TableDescriptorBuilder.newBuilder(PermissionStorage.ACL_TABLE_NAME).setColumnFamily(cfd).build();
        admin.createTable(td);
    }

    @Override
    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission(ctx, "snapshot " + snapshot.getName(), hTableDescriptor.getTableName(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
        User user = this.getActiveUser(ctx);
        if (SnapshotDescriptionUtils.isSnapshotOwner(snapshot, user)) {
            AuthResult result = AuthResult.allow("listSnapshot " + snapshot.getName(), "Snapshot owner check allowed", user, null, null, null);
            AccessChecker.logResult(result);
        } else {
            this.accessChecker.requirePermission(user, "listSnapshot " + snapshot.getName(), null, Permission.Action.ADMIN);
        }
    }

    @Override
    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        User user = this.getActiveUser(ctx);
        if (SnapshotDescriptionUtils.isSnapshotOwner(snapshot, user) && hTableDescriptor.getTableName().getNameAsString().equals(snapshot.getTable())) {
            AuthResult result = AuthResult.allow("cloneSnapshot " + snapshot.getName(), "Snapshot owner check allowed", user, null, hTableDescriptor.getTableName(), null);
            AccessChecker.logResult(result);
        } else {
            this.accessChecker.requirePermission(user, "cloneSnapshot " + snapshot.getName(), null, Permission.Action.ADMIN);
        }
    }

    @Override
    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        User user = this.getActiveUser(ctx);
        if (SnapshotDescriptionUtils.isSnapshotOwner(snapshot, user)) {
            this.accessChecker.requirePermission(user, "restoreSnapshot " + snapshot.getName(), hTableDescriptor.getTableName(), null, null, null, Permission.Action.ADMIN);
        } else {
            this.accessChecker.requirePermission(user, "restoreSnapshot " + snapshot.getName(), null, Permission.Action.ADMIN);
        }
    }

    @Override
    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
        User user = this.getActiveUser(ctx);
        if (SnapshotDescriptionUtils.isSnapshotOwner(snapshot, user)) {
            AuthResult result = AuthResult.allow("deleteSnapshot " + snapshot.getName(), "Snapshot owner check allowed", user, null, null, null);
            AccessChecker.logResult(result);
        } else {
            this.accessChecker.requirePermission(user, "deleteSnapshot " + snapshot.getName(), null, Permission.Action.ADMIN);
        }
    }

    @Override
    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission(ctx, "createNamespace", Permission.Action.ADMIN, ns.getName());
    }

    @Override
    public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        this.requireGlobalPermission(ctx, "deleteNamespace", Permission.Action.ADMIN, namespace);
    }

    @Override
    public void postDeleteNamespace(final ObserverContext<MasterCoprocessorEnvironment> ctx, final String namespace) throws IOException {
        final Configuration conf = ctx.getEnvironment().getConfiguration();
        User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Table table = ((MasterCoprocessorEnvironment)ctx.getEnvironment()).getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);){
                    PermissionStorage.removeNamespacePermissions(conf, namespace, table);
                }
                return null;
            }
        });
        this.zkPermissionWatcher.deleteNamespaceACLNode(namespace);
        LOG.info(namespace + " entry deleted in " + PermissionStorage.ACL_TABLE_NAME + " table.");
    }

    @Override
    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission(ctx, "modifyNamespace", Permission.Action.ADMIN, ns.getName());
    }

    @Override
    public void preGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        this.requireNamespacePermission(ctx, "getNamespaceDescriptor", namespace, Permission.Action.ADMIN);
    }

    @Override
    public void postListNamespaces(ObserverContext<MasterCoprocessorEnvironment> ctx, List<String> namespaces) throws IOException {
    }

    @Override
    public void postListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<NamespaceDescriptor> descriptors) throws IOException {
        Iterator<NamespaceDescriptor> itr = descriptors.iterator();
        User user = this.getActiveUser(ctx);
        while (itr.hasNext()) {
            NamespaceDescriptor desc = itr.next();
            try {
                this.accessChecker.requireNamespacePermission(user, "listNamespaces", desc.getName(), null, Permission.Action.ADMIN);
            }
            catch (AccessDeniedException e) {
                itr.remove();
            }
        }
    }

    @Override
    public void preTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        this.requirePermission(ctx, "flushTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preSplitRegion(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] splitRow) throws IOException {
        this.requirePermission(ctx, "split", tableName, null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preClearDeadServers(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        this.requirePermission(ctx, "clearDeadServers", Permission.Action.ADMIN);
    }

    @Override
    public void preDecommissionRegionServers(ObserverContext<MasterCoprocessorEnvironment> ctx, List<ServerName> servers, boolean offload) throws IOException {
        this.requirePermission(ctx, "decommissionRegionServers", Permission.Action.ADMIN);
    }

    @Override
    public void preListDecommissionedRegionServers(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        this.requirePermission(ctx, "listDecommissionedRegionServers", Permission.Action.READ);
    }

    @Override
    public void preRecommissionRegionServer(ObserverContext<MasterCoprocessorEnvironment> ctx, ServerName server, List<byte[]> encodedRegionNames) throws IOException {
        this.requirePermission(ctx, "recommissionRegionServers", Permission.Action.ADMIN);
    }

    @Override
    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> c) throws IOException {
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Region region = env.getRegion();
        if (region == null) {
            LOG.error("NULL region from RegionCoprocessorEnvironment in preOpen()");
        } else {
            RegionInfo regionInfo = region.getRegionInfo();
            if (regionInfo.getTable().isSystemTable()) {
                this.checkSystemOrSuperUser(this.getActiveUser(c));
            } else {
                this.requirePermission(c, "preOpen", Permission.Action.ADMIN);
            }
        }
    }

    @Override
    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Region region = env.getRegion();
        if (region == null) {
            LOG.error("NULL region from RegionCoprocessorEnvironment in postOpen()");
            return;
        }
        if (PermissionStorage.isAclRegion(region)) {
            this.aclRegion = true;
            try {
                this.initialize(env);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to initialize permissions cache", ex);
            }
        } else {
            this.initialized = true;
        }
    }

    @Override
    public void preFlush(ObserverContext<RegionCoprocessorEnvironment> c, FlushLifeCycleTracker tracker) throws IOException {
        this.requirePermission(c, "flush", this.getTableName(c.getEnvironment()), null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        this.requirePermission(c, "compact", this.getTableName(c.getEnvironment()), null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        return scanner;
    }

    private void internalPreRead(ObserverContext<RegionCoprocessorEnvironment> c, Query query, OpType opType) throws IOException {
        Filter filter = query.getFilter();
        if (filter != null && filter instanceof AccessControlFilter) {
            return;
        }
        User user = this.getActiveUser(c);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Map<byte[], NavigableSet<byte[]>> families = null;
        switch (opType) {
            case GET: 
            case EXISTS: {
                families = ((Get)query).getFamilyMap();
                break;
            }
            case SCAN: {
                families = ((Scan)query).getFamilyMap();
                break;
            }
            default: {
                throw new RuntimeException("Unhandled operation " + (Object)((Object)opType));
            }
        }
        AuthResult authResult = this.permissionGranted(opType, user, env, families, Permission.Action.READ);
        Region region = this.getRegion(env);
        TableName table = this.getTableName(region);
        HashMap<ByteRange, Integer> cfVsMaxVersions = Maps.newHashMap();
        for (ColumnFamilyDescriptor hcd : region.getTableDescriptor().getColumnFamilies()) {
            cfVsMaxVersions.put(new SimpleMutableByteRange(hcd.getName()), hcd.getMaxVersions());
        }
        if (!authResult.isAllowed()) {
            FilterBase ourFilter;
            if (!this.cellFeaturesEnabled || this.compatibleEarlyTermination) {
                if (this.hasFamilyQualifierPermission(user, Permission.Action.READ, env, families)) {
                    authResult.setAllowed(true);
                    authResult.setReason("Access allowed with filter");
                    if (this.authorizationEnabled) {
                        ourFilter = new AccessControlFilter(this.getAuthManager(), user, table, AccessControlFilter.Strategy.CHECK_TABLE_AND_CF_ONLY, cfVsMaxVersions);
                        if (filter != null) {
                            ourFilter = new FilterList(FilterList.Operator.MUST_PASS_ALL, Lists.newArrayList(ourFilter, filter));
                        }
                        switch (opType) {
                            case GET: 
                            case EXISTS: {
                                ((Get)query).setFilter(ourFilter);
                                break;
                            }
                            case SCAN: {
                                ((Scan)query).setFilter(ourFilter);
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unhandled operation " + (Object)((Object)opType));
                            }
                        }
                    }
                }
            } else {
                authResult.setAllowed(true);
                authResult.setReason("Access allowed with filter");
                if (this.authorizationEnabled) {
                    ourFilter = new AccessControlFilter(this.getAuthManager(), user, table, AccessControlFilter.Strategy.CHECK_CELL_DEFAULT, cfVsMaxVersions);
                    if (filter != null) {
                        ourFilter = new FilterList(FilterList.Operator.MUST_PASS_ALL, Lists.newArrayList(ourFilter, filter));
                    }
                    switch (opType) {
                        case GET: 
                        case EXISTS: {
                            ((Get)query).setFilter(ourFilter);
                            break;
                        }
                        case SCAN: {
                            ((Scan)query).setFilter(ourFilter);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unhandled operation " + (Object)((Object)opType));
                        }
                    }
                }
            }
        }
        AccessChecker.logResult(authResult);
        if (this.authorizationEnabled && !authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (table=" + table + ", action=READ)");
        }
    }

    @Override
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
        this.internalPreRead(c, get, OpType.GET);
    }

    @Override
    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        this.internalPreRead(c, get, OpType.EXISTS);
        return exists;
    }

    @Override
    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        byte[] bytes;
        User user = this.getActiveUser(c);
        this.checkForReservedTagPresence(user, put);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        NavigableMap<byte[], List<Cell>> families = put.getFamilyCellMap();
        AuthResult authResult = this.permissionGranted(OpType.PUT, user, env, families, Permission.Action.WRITE);
        AccessChecker.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                put.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        if ((bytes = put.getAttribute("acl")) != null) {
            if (this.cellFeaturesEnabled) {
                AccessController.addCellPermissions(bytes, put.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
    }

    @Override
    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), put.getFamilyCellMap());
        }
    }

    @Override
    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (delete.getAttribute("acl") != null) {
            throw new DoNotRetryIOException("ACL on delete has no effect: " + delete.toString());
        }
        RegionCoprocessorEnvironment env = c.getEnvironment();
        NavigableMap<byte[], List<Cell>> families = delete.getFamilyCellMap();
        User user = this.getActiveUser(c);
        AuthResult authResult = this.permissionGranted(OpType.DELETE, user, env, families, Permission.Action.WRITE);
        AccessChecker.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                delete.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
    }

    @Override
    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            User user = this.getActiveUser(c);
            for (int i = 0; i < miniBatchOp.size(); ++i) {
                long timestamp;
                OpType opType;
                Mutation m3 = miniBatchOp.getOperation(i);
                if (m3.getAttribute(CHECK_COVERING_PERM) == null) continue;
                if (m3 instanceof Put) {
                    this.checkForReservedTagPresence(user, m3);
                    opType = OpType.PUT;
                    timestamp = m3.getTimestamp();
                } else if (m3 instanceof Delete) {
                    opType = OpType.DELETE;
                    timestamp = m3.getTimestamp();
                } else if (m3 instanceof Increment) {
                    opType = OpType.INCREMENT;
                    timestamp = ((Increment)m3).getTimeRange().getMax();
                } else {
                    if (!(m3 instanceof Append)) continue;
                    opType = OpType.APPEND;
                    timestamp = ((Append)m3).getTimeRange().getMax();
                }
                AuthResult authResult = null;
                authResult = this.checkCoveringPermission(user, opType, c.getEnvironment(), m3.getRow(), m3.getFamilyCellMap(), timestamp, Permission.Action.WRITE) ? AuthResult.allow(opType.toString(), "Covering cell set", user, Permission.Action.WRITE, table, m3.getFamilyCellMap()) : AuthResult.deny(opType.toString(), "Covering cell set", user, Permission.Action.WRITE, table, m3.getFamilyCellMap());
                AccessChecker.logResult(authResult);
                if (!this.authorizationEnabled || authResult.isAllowed()) continue;
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
    }

    @Override
    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), delete.getFamilyCellMap());
        }
    }

    @Override
    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        byte[] bytes;
        User user = this.getActiveUser(c);
        this.checkForReservedTagPresence(user, put);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
        AuthResult authResult = this.permissionGranted(OpType.CHECK_AND_PUT, user, env, families, Permission.Action.READ, Permission.Action.WRITE);
        AccessChecker.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                put.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        if ((bytes = put.getAttribute("acl")) != null) {
            if (this.cellFeaturesEnabled) {
                AccessController.addCellPermissions(bytes, put.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
        return result;
    }

    @Override
    public boolean preCheckAndPutAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator opp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        if (put.getAttribute(CHECK_COVERING_PERM) != null) {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
            AuthResult authResult = null;
            User user = this.getActiveUser(c);
            authResult = this.checkCoveringPermission(user, OpType.CHECK_AND_PUT, c.getEnvironment(), row, families, Long.MAX_VALUE, Permission.Action.READ) ? AuthResult.allow(OpType.CHECK_AND_PUT.toString(), "Covering cell set", user, Permission.Action.READ, table, families) : AuthResult.deny(OpType.CHECK_AND_PUT.toString(), "Covering cell set", user, Permission.Action.READ, table, families);
            AccessChecker.logResult(authResult);
            if (this.authorizationEnabled && !authResult.isAllowed()) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        return result;
    }

    @Override
    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        if (delete.getAttribute("acl") != null) {
            throw new DoNotRetryIOException("ACL on checkAndDelete has no effect: " + delete.toString());
        }
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
        User user = this.getActiveUser(c);
        AuthResult authResult = this.permissionGranted(OpType.CHECK_AND_DELETE, user, env, families, Permission.Action.READ, Permission.Action.WRITE);
        AccessChecker.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                delete.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        return result;
    }

    @Override
    public boolean preCheckAndDeleteAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        if (delete.getAttribute(CHECK_COVERING_PERM) != null) {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
            AuthResult authResult = null;
            User user = this.getActiveUser(c);
            authResult = this.checkCoveringPermission(user, OpType.CHECK_AND_DELETE, c.getEnvironment(), row, families, Long.MAX_VALUE, Permission.Action.READ) ? AuthResult.allow(OpType.CHECK_AND_DELETE.toString(), "Covering cell set", user, Permission.Action.READ, table, families) : AuthResult.deny(OpType.CHECK_AND_DELETE.toString(), "Covering cell set", user, Permission.Action.READ, table, families);
            AccessChecker.logResult(authResult);
            if (this.authorizationEnabled && !authResult.isAllowed()) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        return result;
    }

    @Override
    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        byte[] bytes;
        User user = this.getActiveUser(c);
        this.checkForReservedTagPresence(user, append);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        NavigableMap<byte[], List<Cell>> families = append.getFamilyCellMap();
        AuthResult authResult = this.permissionGranted(OpType.APPEND, user, env, families, Permission.Action.WRITE);
        AccessChecker.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                append.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        if ((bytes = append.getAttribute("acl")) != null) {
            if (this.cellFeaturesEnabled) {
                AccessController.addCellPermissions(bytes, append.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
        return null;
    }

    @Override
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        byte[] bytes;
        User user = this.getActiveUser(c);
        this.checkForReservedTagPresence(user, increment);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        NavigableMap<byte[], List<Cell>> families = increment.getFamilyCellMap();
        AuthResult authResult = this.permissionGranted(OpType.INCREMENT, user, env, families, Permission.Action.WRITE);
        AccessChecker.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                increment.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        if ((bytes = increment.getAttribute("acl")) != null) {
            if (this.cellFeaturesEnabled) {
                AccessController.addCellPermissions(bytes, increment.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
        return null;
    }

    @Override
    public List<Pair<Cell, Cell>> postIncrementBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, Mutation mutation, List<Pair<Cell, Cell>> cellPairs) throws IOException {
        if (!this.cellFeaturesEnabled || mutation.getACL() == null) {
            return cellPairs;
        }
        return cellPairs.stream().map(pair -> new Pair(pair.getFirst(), this.createNewCellWithTags(mutation, (Cell)pair.getFirst(), (Cell)pair.getSecond()))).collect(Collectors.toList());
    }

    @Override
    public List<Pair<Cell, Cell>> postAppendBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, Mutation mutation, List<Pair<Cell, Cell>> cellPairs) throws IOException {
        if (!this.cellFeaturesEnabled || mutation.getACL() == null) {
            return cellPairs;
        }
        return cellPairs.stream().map(pair -> new Pair(pair.getFirst(), this.createNewCellWithTags(mutation, (Cell)pair.getFirst(), (Cell)pair.getSecond()))).collect(Collectors.toList());
    }

    private Cell createNewCellWithTags(Mutation mutation, Cell oldCell, Cell newCell) {
        ArrayList<Tag> tags = Lists.newArrayList();
        if (newCell != null) {
            Iterator<Tag> tagIterator = PrivateCellUtil.tagsIterator(newCell);
            while (tagIterator.hasNext()) {
                Tag tag = tagIterator.next();
                if (tag.getType() == 1) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Carrying forward tag from " + newCell + ": type " + tag.getType() + " length " + tag.getValueLength());
                }
                tags.add(tag);
            }
        }
        tags.add(new ArrayBackedTag(1, mutation.getACL()));
        return PrivateCellUtil.createCell(newCell, tags);
    }

    @Override
    public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) throws IOException {
        this.internalPreRead(c, scan, OpType.SCAN);
    }

    @Override
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s2) throws IOException {
        User user = this.getActiveUser(c);
        if (user != null && user.getShortName() != null) {
            this.scannerOwners.put(s2, user.getShortName());
        }
        return s2;
    }

    @Override
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s2, List<Result> result, int limit, boolean hasNext) throws IOException {
        this.requireScannerOwner(s2);
        return hasNext;
    }

    @Override
    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s2) throws IOException {
        this.requireScannerOwner(s2);
    }

    @Override
    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s2) throws IOException {
        this.scannerOwners.remove(s2);
    }

    @Override
    @Deprecated
    public boolean postScannerFilterRow(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s2, Cell curRowCell, boolean hasMore) throws IOException {
        return hasMore;
    }

    private void requireScannerOwner(InternalScanner s2) throws AccessDeniedException {
        if (!RpcServer.isInRpcCallContext()) {
            return;
        }
        String requestUserName = RpcServer.getRequestUserName().orElse(null);
        String owner = this.scannerOwners.get(s2);
        if (this.authorizationEnabled && owner != null && !owner.equals(requestUserName)) {
            throw new AccessDeniedException("User '" + requestUserName + "' is not the scanner owner!");
        }
    }

    @Override
    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        User user = this.getActiveUser(ctx);
        for (Pair<byte[], String> el : familyPaths) {
            this.accessChecker.requirePermission(user, "preBulkLoadHFile", ctx.getEnvironment().getRegion().getTableDescriptor().getTableName(), el.getFirst(), null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        }
    }

    @Override
    public void prePrepareBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        this.requireAccess(ctx, "prePrepareBulkLoad", ctx.getEnvironment().getRegion().getTableDescriptor().getTableName(), Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preCleanupBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        this.requireAccess(ctx, "preCleanupBulkLoad", ctx.getEnvironment().getRegion().getTableDescriptor().getTableName(), Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public Message preEndpointInvocation(ObserverContext<RegionCoprocessorEnvironment> ctx, Service service, String methodName, Message request) throws IOException {
        if (this.shouldCheckExecPermission && !(service instanceof AccessControlProtos.AccessControlService)) {
            this.requirePermission(ctx, "invoke(" + service.getDescriptorForType().getName() + "." + methodName + ")", this.getTableName(ctx.getEnvironment()), null, null, Permission.Action.EXEC);
        }
        return request;
    }

    @Override
    public void postEndpointInvocation(ObserverContext<RegionCoprocessorEnvironment> ctx, Service service, String methodName, Message request, Message.Builder responseBuilder) throws IOException {
    }

    @Override
    @Deprecated
    public void grant(RpcController controller, AccessControlProtos.GrantRequest request, RpcCallback<AccessControlProtos.GrantResponse> done) {
        UserPermission perm = AccessControlUtil.toUserPermission(request.getUserPermission());
        AccessControlProtos.GrantResponse response = null;
        try {
            if (this.aclRegion) {
                if (!this.initialized) {
                    throw new CoprocessorException("AccessController not yet initialized");
                }
                User caller = RpcServer.getRequestUser().orElse(null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received request from {} to grant access permission {}", (Object)caller.getName(), (Object)perm.toString());
                }
                this.preGrantOrRevoke(caller, "grant", perm);
                this.regionEnv.getConnection().getAdmin().grant(new UserPermission(perm.getUser(), perm.getPermission()), request.getMergeExistingPermissions());
                if (AUDITLOG.isTraceEnabled()) {
                    AUDITLOG.trace("Granted permission " + perm.toString());
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + PermissionStorage.ACL_TABLE_NAME + " table.");
            }
            response = AccessControlProtos.GrantResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            CoprocessorRpcUtils.setControllerException(controller, ioe);
        }
        done.run(response);
    }

    @Override
    @Deprecated
    public void revoke(RpcController controller, AccessControlProtos.RevokeRequest request, RpcCallback<AccessControlProtos.RevokeResponse> done) {
        UserPermission perm = AccessControlUtil.toUserPermission(request.getUserPermission());
        AccessControlProtos.RevokeResponse response = null;
        try {
            if (this.aclRegion) {
                if (!this.initialized) {
                    throw new CoprocessorException("AccessController not yet initialized");
                }
                User caller = RpcServer.getRequestUser().orElse(null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received request from {} to revoke access permission {}", (Object)caller.getShortName(), (Object)perm.toString());
                }
                this.preGrantOrRevoke(caller, "revoke", perm);
                this.regionEnv.getConnection().getAdmin().revoke(new UserPermission(perm.getUser(), perm.getPermission()));
                if (AUDITLOG.isTraceEnabled()) {
                    AUDITLOG.trace("Revoked permission " + perm.toString());
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + PermissionStorage.ACL_TABLE_NAME + " table.");
            }
            response = AccessControlProtos.RevokeResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            CoprocessorRpcUtils.setControllerException(controller, ioe);
        }
        done.run(response);
    }

    @Override
    @Deprecated
    public void getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request, RpcCallback<AccessControlProtos.GetUserPermissionsResponse> done) {
        AccessControlProtos.GetUserPermissionsResponse response = null;
        try {
            if (this.aclRegion) {
                if (!this.initialized) {
                    throw new CoprocessorException("AccessController not yet initialized");
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + PermissionStorage.ACL_TABLE_NAME + " table.");
            }
            User caller = RpcServer.getRequestUser().orElse(null);
            String userName = request.hasUserName() ? request.getUserName().toStringUtf8() : null;
            String namespace = request.hasNamespaceName() ? request.getNamespaceName().toStringUtf8() : null;
            TableName table = request.hasTableName() ? ProtobufUtil.toTableName(request.getTableName()) : null;
            byte[] cf = request.hasColumnFamily() ? request.getColumnFamily().toByteArray() : null;
            byte[] cq = request.hasColumnQualifier() ? request.getColumnQualifier().toByteArray() : null;
            this.preGetUserPermissions(caller, userName, namespace, table, cf, cq);
            GetUserPermissionsRequest getUserPermissionsRequest = null;
            getUserPermissionsRequest = request.getType() == AccessControlProtos.Permission.Type.Table ? GetUserPermissionsRequest.newBuilder(table).withFamily(cf).withQualifier(cq).withUserName(userName).build() : (request.getType() == AccessControlProtos.Permission.Type.Namespace ? GetUserPermissionsRequest.newBuilder(namespace).withUserName(userName).build() : GetUserPermissionsRequest.newBuilder().withUserName(userName).build());
            List<UserPermission> perms = this.regionEnv.getConnection().getAdmin().getUserPermissions(getUserPermissionsRequest);
            response = AccessControlUtil.buildGetUserPermissionsResponse(perms);
        }
        catch (IOException ioe) {
            CoprocessorRpcUtils.setControllerException(controller, ioe);
        }
        done.run(response);
    }

    @Override
    @Deprecated
    public void checkPermissions(RpcController controller, AccessControlProtos.CheckPermissionsRequest request, RpcCallback<AccessControlProtos.CheckPermissionsResponse> done) {
        AccessControlProtos.CheckPermissionsResponse response = null;
        try {
            User user = RpcServer.getRequestUser().orElse(null);
            TableName tableName = this.regionEnv.getRegion().getTableDescriptor().getTableName();
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            for (int i = 0; i < request.getPermissionCount(); ++i) {
                TablePermission tperm;
                Permission permission = AccessControlUtil.toPermission(request.getPermission(i));
                permissions.add(permission);
                if (!(permission instanceof TablePermission) || (tperm = (TablePermission)permission).getTableName().equals(tableName)) continue;
                throw new CoprocessorException(AccessController.class, String.format("This method can only execute at the table specified in TablePermission. Table of the region:%s , requested table:%s", tableName, tperm.getTableName()));
            }
            for (Permission permission : permissions) {
                boolean hasPermission = this.accessChecker.hasUserPermission(user, "checkPermissions", permission);
                if (hasPermission) continue;
                throw new AccessDeniedException("Insufficient permissions " + permission.toString());
            }
            response = AccessControlProtos.CheckPermissionsResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            CoprocessorRpcUtils.setControllerException(controller, ioe);
        }
        done.run(response);
    }

    private Region getRegion(RegionCoprocessorEnvironment e) {
        return e.getRegion();
    }

    private TableName getTableName(RegionCoprocessorEnvironment e) {
        Region region = e.getRegion();
        if (region != null) {
            return this.getTableName(region);
        }
        return null;
    }

    private TableName getTableName(Region region) {
        RegionInfo regionInfo = region.getRegionInfo();
        if (regionInfo != null) {
            return regionInfo.getTable();
        }
        return null;
    }

    @Override
    public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) throws IOException {
        this.requirePermission(c, "preClose", Permission.Action.ADMIN);
    }

    private void checkSystemOrSuperUser(User activeUser) throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        if (!Superusers.isSuperUser(activeUser)) {
            throw new AccessDeniedException("User '" + (activeUser != null ? activeUser.getShortName() : "null") + "' is not system or super user.");
        }
    }

    @Override
    public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        this.requirePermission(ctx, "preStopRegionServer", Permission.Action.ADMIN);
    }

    private Map<byte[], ? extends Collection<byte[]>> makeFamilyMap(byte[] family, byte[] qualifier) {
        if (family == null) {
            return null;
        }
        TreeMap<byte[], ImmutableSet<byte[]>> familyMap = new TreeMap<byte[], ImmutableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
        familyMap.put(family, qualifier != null ? ImmutableSet.of(qualifier) : null);
        return familyMap;
    }

    @Override
    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<TableDescriptor> descriptors, String regex) throws IOException {
        if (regex == null && tableNamesList != null && !tableNamesList.isEmpty()) {
            TableName[] sns = null;
            try (Admin admin = ctx.getEnvironment().getConnection().getAdmin();){
                sns = admin.listTableNames();
                if (sns == null) {
                    return;
                }
                for (TableName tableName : tableNamesList) {
                    if (!admin.tableExists(tableName)) continue;
                    this.requirePermission(ctx, "getTableDescriptors", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
                }
            }
        }
    }

    @Override
    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<TableDescriptor> descriptors, String regex) throws IOException {
        if (regex == null && tableNamesList != null && !tableNamesList.isEmpty()) {
            return;
        }
        Iterator<TableDescriptor> itr = descriptors.iterator();
        while (itr.hasNext()) {
            TableDescriptor htd = itr.next();
            try {
                this.requirePermission(ctx, "getTableDescriptors", htd.getTableName(), null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
            }
            catch (AccessDeniedException e) {
                itr.remove();
            }
        }
    }

    @Override
    public void postGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableDescriptor> descriptors, String regex) throws IOException {
        Iterator<TableDescriptor> itr = descriptors.iterator();
        while (itr.hasNext()) {
            TableDescriptor htd = itr.next();
            try {
                this.requireAccess(ctx, "getTableNames", htd.getTableName(), Permission.Action.values());
            }
            catch (AccessDeniedException e) {
                itr.remove();
            }
        }
    }

    @Override
    public void preMergeRegions(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo[] regionsToMerge) throws IOException {
        this.requirePermission(ctx, "mergeRegions", regionsToMerge[0].getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        this.requirePermission(ctx, "preRollLogWriterRequest", Permission.Action.ADMIN);
    }

    @Override
    public void postRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
    }

    @Override
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, GlobalQuotaSettings quotas) throws IOException {
        this.requirePermission(ctx, "setUserQuota", Permission.Action.ADMIN);
    }

    @Override
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        this.requirePermission(ctx, "setUserTableQuota", tableName, null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, GlobalQuotaSettings quotas) throws IOException {
        this.requirePermission(ctx, "setUserNamespaceQuota", Permission.Action.ADMIN);
    }

    @Override
    public void preSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        this.requirePermission(ctx, "setTableQuota", tableName, null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, GlobalQuotaSettings quotas) throws IOException {
        this.requirePermission(ctx, "setNamespaceQuota", Permission.Action.ADMIN);
    }

    @Override
    public void preSetRegionServerQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String regionServer, GlobalQuotaSettings quotas) throws IOException {
        this.requirePermission(ctx, "setRegionServerQuota", Permission.Action.ADMIN);
    }

    @Override
    public ReplicationEndpoint postCreateReplicationEndPoint(ObserverContext<RegionServerCoprocessorEnvironment> ctx, ReplicationEndpoint endpoint) {
        return endpoint;
    }

    @Override
    public void preReplicateLogEntries(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        this.requirePermission(ctx, "replicateLogEntries", Permission.Action.WRITE);
    }

    @Override
    public void preClearCompactionQueues(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        this.requirePermission(ctx, "preClearCompactionQueues", Permission.Action.ADMIN);
    }

    @Override
    public void preAddReplicationPeer(ObserverContext<MasterCoprocessorEnvironment> ctx, String peerId, ReplicationPeerConfig peerConfig) throws IOException {
        this.requirePermission(ctx, "addReplicationPeer", Permission.Action.ADMIN);
    }

    @Override
    public void preRemoveReplicationPeer(ObserverContext<MasterCoprocessorEnvironment> ctx, String peerId) throws IOException {
        this.requirePermission(ctx, "removeReplicationPeer", Permission.Action.ADMIN);
    }

    @Override
    public void preEnableReplicationPeer(ObserverContext<MasterCoprocessorEnvironment> ctx, String peerId) throws IOException {
        this.requirePermission(ctx, "enableReplicationPeer", Permission.Action.ADMIN);
    }

    @Override
    public void preDisableReplicationPeer(ObserverContext<MasterCoprocessorEnvironment> ctx, String peerId) throws IOException {
        this.requirePermission(ctx, "disableReplicationPeer", Permission.Action.ADMIN);
    }

    @Override
    public void preGetReplicationPeerConfig(ObserverContext<MasterCoprocessorEnvironment> ctx, String peerId) throws IOException {
        this.requirePermission(ctx, "getReplicationPeerConfig", Permission.Action.ADMIN);
    }

    @Override
    public void preUpdateReplicationPeerConfig(ObserverContext<MasterCoprocessorEnvironment> ctx, String peerId, ReplicationPeerConfig peerConfig) throws IOException {
        this.requirePermission(ctx, "updateReplicationPeerConfig", Permission.Action.ADMIN);
    }

    @Override
    public void preListReplicationPeers(ObserverContext<MasterCoprocessorEnvironment> ctx, String regex) throws IOException {
        this.requirePermission(ctx, "listReplicationPeers", Permission.Action.ADMIN);
    }

    @Override
    public void preRequestLock(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, TableName tableName, RegionInfo[] regionInfos, String description) throws IOException {
        String reason = String.format("Description=%s", description);
        this.checkLockPermissions(ctx, namespace, tableName, regionInfos, reason);
    }

    @Override
    public void preLockHeartbeat(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, String description) throws IOException {
        this.checkLockPermissions(ctx, null, tableName, null, description);
    }

    @Override
    public void preExecuteProcedures(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        this.checkSystemOrSuperUser(this.getActiveUser(ctx));
    }

    @Override
    public void preSwitchRpcThrottle(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean enable) throws IOException {
        this.requirePermission(ctx, "switchRpcThrottle", Permission.Action.ADMIN);
    }

    @Override
    public void preIsRpcThrottleEnabled(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        this.requirePermission(ctx, "isRpcThrottleEnabled", Permission.Action.ADMIN);
    }

    @Override
    public void preSwitchExceedThrottleQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean enable) throws IOException {
        this.requirePermission(ctx, "switchExceedThrottleQuota", Permission.Action.ADMIN);
    }

    private User getActiveUser(ObserverContext<?> ctx) throws IOException {
        Optional<User> optionalUser = ctx.getCaller();
        if (optionalUser.isPresent()) {
            return optionalUser.get();
        }
        return this.userProvider.getCurrent();
    }

    @Override
    @Deprecated
    public void hasPermission(RpcController controller, AccessControlProtos.HasPermissionRequest request, RpcCallback<AccessControlProtos.HasPermissionResponse> done) {
        TablePermission tPerm = AccessControlUtil.toTablePermission(request.getTablePermission());
        if (!request.hasUserName()) {
            throw new IllegalStateException("Input username cannot be empty");
        }
        String inputUserName = request.getUserName().toStringUtf8();
        AccessControlProtos.HasPermissionResponse response = null;
        try {
            User caller = RpcServer.getRequestUser().orElse(null);
            ArrayList<Permission> permissions = Lists.newArrayList(new Permission[]{tPerm});
            this.preHasUserPermissions(caller, inputUserName, permissions);
            boolean hasPermission = this.regionEnv.getConnection().getAdmin().hasUserPermissions(inputUserName, permissions).get(0);
            response = ResponseConverter.buildHasPermissionResponse(hasPermission);
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException(controller, ioe);
        }
        done.run(response);
    }

    @Override
    public void preGrant(ObserverContext<MasterCoprocessorEnvironment> ctx, UserPermission userPermission, boolean mergeExistingPermissions) throws IOException {
        this.preGrantOrRevoke(this.getActiveUser(ctx), "grant", userPermission);
    }

    @Override
    public void preRevoke(ObserverContext<MasterCoprocessorEnvironment> ctx, UserPermission userPermission) throws IOException {
        this.preGrantOrRevoke(this.getActiveUser(ctx), "revoke", userPermission);
    }

    private void preGrantOrRevoke(User caller, String request, UserPermission userPermission) throws IOException {
        switch (userPermission.getPermission().scope) {
            case GLOBAL: {
                this.accessChecker.requireGlobalPermission(caller, request, Permission.Action.ADMIN, "");
                break;
            }
            case NAMESPACE: {
                NamespacePermission namespacePerm = (NamespacePermission)userPermission.getPermission();
                this.accessChecker.requireNamespacePermission(caller, request, namespacePerm.getNamespace(), null, Permission.Action.ADMIN);
                break;
            }
            case TABLE: {
                TablePermission tablePerm = (TablePermission)userPermission.getPermission();
                this.accessChecker.requirePermission(caller, request, tablePerm.getTableName(), tablePerm.getFamily(), tablePerm.getQualifier(), null, Permission.Action.ADMIN);
                break;
            }
        }
        if (!Superusers.isSuperUser(caller)) {
            this.accessChecker.performOnSuperuser(request, caller, userPermission.getUser());
        }
    }

    @Override
    public void preGetUserPermissions(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, TableName tableName, byte[] family, byte[] qualifier) throws IOException {
        this.preGetUserPermissions(this.getActiveUser(ctx), userName, namespace, tableName, family, qualifier);
    }

    private void preGetUserPermissions(User caller, String userName, String namespace, TableName tableName, byte[] family, byte[] qualifier) throws IOException {
        if (tableName != null) {
            this.accessChecker.requirePermission(caller, "getUserPermissions", tableName, family, qualifier, userName, Permission.Action.ADMIN);
        } else if (namespace != null) {
            this.accessChecker.requireNamespacePermission(caller, "getUserPermissions", namespace, userName, Permission.Action.ADMIN);
        } else {
            this.accessChecker.requirePermission(caller, "getUserPermissions", userName, Permission.Action.ADMIN);
        }
    }

    @Override
    public void preHasUserPermissions(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, List<Permission> permissions) throws IOException {
        this.preHasUserPermissions(this.getActiveUser(ctx), userName, permissions);
    }

    private void preHasUserPermissions(User caller, String userName, List<Permission> permissions) throws IOException {
        String request = "hasUserPermissions";
        for (Permission permission : permissions) {
            AuthResult result;
            if (!caller.getShortName().equals(userName)) {
                if (permission instanceof TablePermission) {
                    TablePermission tPerm = (TablePermission)permission;
                    this.accessChecker.requirePermission(caller, request, tPerm.getTableName(), tPerm.getFamily(), tPerm.getQualifier(), userName, Permission.Action.ADMIN);
                    continue;
                }
                if (permission instanceof NamespacePermission) {
                    NamespacePermission nsPerm = (NamespacePermission)permission;
                    this.accessChecker.requireNamespacePermission(caller, request, nsPerm.getNamespace(), userName, Permission.Action.ADMIN);
                    continue;
                }
                this.accessChecker.requirePermission(caller, request, userName, Permission.Action.ADMIN);
                continue;
            }
            if (permission instanceof TablePermission) {
                TablePermission tPerm = (TablePermission)permission;
                result = AuthResult.allow(request, "Self user validation allowed", caller, null, tPerm.getTableName(), tPerm.getFamily(), tPerm.getQualifier());
            } else if (permission instanceof NamespacePermission) {
                NamespacePermission nsPerm = (NamespacePermission)permission;
                result = AuthResult.allow(request, "Self user validation allowed", caller, null, nsPerm.getNamespace());
            } else {
                result = AuthResult.allow(request, "Self user validation allowed", caller, null, null, null, null);
            }
            AccessChecker.logResult(result);
        }
    }

    private static enum OpType {
        GET("get"),
        EXISTS("exists"),
        SCAN("scan"),
        PUT("put"),
        DELETE("delete"),
        CHECK_AND_PUT("checkAndPut"),
        CHECK_AND_DELETE("checkAndDelete"),
        APPEND("append"),
        INCREMENT("increment");

        private String type;

        private OpType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

