/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsMasterWrapperImpl
implements MetricsMasterWrapper {
    private final HMaster master;

    public MetricsMasterWrapperImpl(HMaster master) {
        this.master = master;
    }

    @Override
    public double getAverageLoad() {
        return this.master.getAverageLoad();
    }

    @Override
    public long getSplitPlanCount() {
        if (this.master.getRegionNormalizerManager() == null) {
            return 0L;
        }
        return this.master.getRegionNormalizerManager().getSplitPlanCount();
    }

    @Override
    public long getMergePlanCount() {
        if (this.master.getRegionNormalizerManager() == null) {
            return 0L;
        }
        return this.master.getRegionNormalizerManager().getMergePlanCount();
    }

    @Override
    public long getMasterInitializationTime() {
        return this.master.getMasterFinishedInitializationTime();
    }

    @Override
    public String getClusterId() {
        return this.master.getClusterId();
    }

    @Override
    public String getZookeeperQuorum() {
        ZKWatcher zk = this.master.getZooKeeper();
        if (zk == null) {
            return "";
        }
        return zk.getQuorum();
    }

    @Override
    public String[] getCoprocessors() {
        return this.master.getMasterCoprocessors();
    }

    @Override
    public long getStartTime() {
        return this.master.getMasterStartTime();
    }

    @Override
    public long getActiveTime() {
        return this.master.getMasterActiveTime();
    }

    @Override
    public String getRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return "";
        }
        return StringUtils.join(serverManager.getOnlineServers().keySet(), ";");
    }

    @Override
    public int getNumRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return 0;
        }
        return serverManager.getOnlineServers().size();
    }

    @Override
    public String getDeadRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return "";
        }
        return StringUtils.join(serverManager.getDeadServers().copyServerNames(), ";");
    }

    @Override
    public int getNumDeadRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return 0;
        }
        return serverManager.getDeadServers().size();
    }

    @Override
    public boolean isRunning() {
        return !this.master.isStopped() && !this.master.isStopping();
    }

    @Override
    public String getDrainingRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return "";
        }
        return StringUtils.join(serverManager.getDrainingServersList(), ";");
    }

    @Override
    public int getNumDrainingRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return 0;
        }
        return serverManager.getDrainingServersList().size();
    }

    @Override
    public String getServerName() {
        ServerName serverName = this.master.getServerName();
        if (serverName == null) {
            return "";
        }
        return serverName.getServerName();
    }

    @Override
    public boolean getIsActiveMaster() {
        return this.master.isActiveMaster();
    }

    @Override
    public long getNumWALFiles() {
        return this.master.getNumWALFiles();
    }

    @Override
    public Map<String, Map.Entry<Long, Long>> getTableSpaceUtilization() {
        if (this.master == null) {
            return Collections.emptyMap();
        }
        QuotaObserverChore quotaChore = this.master.getQuotaObserverChore();
        if (quotaChore == null) {
            return Collections.emptyMap();
        }
        Map<TableName, SpaceQuotaSnapshot> tableSnapshots = quotaChore.getTableQuotaSnapshots();
        HashMap<String, Map.Entry<Long, Long>> convertedData = new HashMap<String, Map.Entry<Long, Long>>();
        for (Map.Entry<TableName, SpaceQuotaSnapshot> entry : tableSnapshots.entrySet()) {
            convertedData.put(entry.getKey().toString(), this.convertSnapshot(entry.getValue()));
        }
        return convertedData;
    }

    @Override
    public Map<String, Map.Entry<Long, Long>> getNamespaceSpaceUtilization() {
        QuotaObserverChore quotaChore = this.master.getQuotaObserverChore();
        if (quotaChore == null) {
            return Collections.emptyMap();
        }
        Map<String, SpaceQuotaSnapshot> namespaceSnapshots = quotaChore.getNamespaceQuotaSnapshots();
        HashMap<String, Map.Entry<Long, Long>> convertedData = new HashMap<String, Map.Entry<Long, Long>>();
        for (Map.Entry<String, SpaceQuotaSnapshot> entry : namespaceSnapshots.entrySet()) {
            convertedData.put(entry.getKey(), this.convertSnapshot(entry.getValue()));
        }
        return convertedData;
    }

    Map.Entry<Long, Long> convertSnapshot(SpaceQuotaSnapshot snapshot) {
        return new AbstractMap.SimpleImmutableEntry<Long, Long>(snapshot.getUsage(), snapshot.getLimit());
    }

    @Override
    public long getOldWALsDirSize() {
        if (this.master == null || !this.master.isInitialized()) {
            return 0L;
        }
        return this.master.getMasterWalManager().getOldWALsDirSize();
    }
}

