/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.joni;

import org.apache.hadoop.hbase.shaded.org.jcodings.ObjPtr;
import org.apache.hadoop.hbase.shaded.org.jcodings.Ptr;
import org.apache.hadoop.hbase.shaded.org.jcodings.constants.PosixBracket;
import org.apache.hadoop.hbase.shaded.org.jcodings.exception.InternalException;
import org.apache.hadoop.hbase.shaded.org.joni.ApplyCaseFold;
import org.apache.hadoop.hbase.shaded.org.joni.ApplyCaseFoldArg;
import org.apache.hadoop.hbase.shaded.org.joni.BitStatus;
import org.apache.hadoop.hbase.shaded.org.joni.CodeRangeBuffer;
import org.apache.hadoop.hbase.shaded.org.joni.Lexer;
import org.apache.hadoop.hbase.shaded.org.joni.Option;
import org.apache.hadoop.hbase.shaded.org.joni.Regex;
import org.apache.hadoop.hbase.shaded.org.joni.Syntax;
import org.apache.hadoop.hbase.shaded.org.joni.WarnCallback;
import org.apache.hadoop.hbase.shaded.org.joni.ast.AnchorNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.AnyCharNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.BackRefNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.CClassNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.CTypeNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.CallNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.EncloseNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.ListNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.Node;
import org.apache.hadoop.hbase.shaded.org.joni.ast.QuantifierNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.StateNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.StringNode;
import org.apache.hadoop.hbase.shaded.org.joni.constants.internal.TokenType;

class Parser
extends Lexer {
    protected int returnCode;
    private static final int POSIX_BRACKET_NAME_MIN_LEN = 4;
    private static final int POSIX_BRACKET_CHECK_LIMIT_LENGTH = 20;
    private static final byte[] BRACKET_END = ":]".getBytes();
    private static int NODE_COMMON_SIZE = 16;

    protected Parser(Regex regex, Syntax syntax, byte[] bytes, int p, int end, WarnCallback warnings) {
        super(regex, syntax, bytes, p, end, warnings);
    }

    private boolean parsePosixBracket(CClassNode cc, CClassNode ascCc) {
        boolean not;
        this.mark();
        if (this.peekIs(94)) {
            this.inc();
            not = true;
        } else {
            not = false;
        }
        if (this.enc.strLength(this.bytes, this.p, this.stop) >= 7) {
            boolean asciiRange = Option.isAsciiRange(this.env.option) && !Option.isPosixBracketAllRange(this.env.option);
            for (int i = 0; i < PosixBracket.PBSNamesLower.length; ++i) {
                byte[] name = PosixBracket.PBSNamesLower[i];
                if (this.enc.strNCmp(this.bytes, this.p, this.stop, name, 0, name.length) != 0) continue;
                this.p = this.enc.step(this.bytes, this.p, this.stop, name.length);
                if (this.enc.strNCmp(this.bytes, this.p, this.stop, BRACKET_END, 0, BRACKET_END.length) != 0) {
                    this.newSyntaxException("invalid POSIX bracket type");
                }
                int ctype = PosixBracket.PBSValues[i];
                cc.addCType(ctype, not, asciiRange, this.env, this);
                if (ascCc != null && ctype != 12 && ctype != 14 && !asciiRange) {
                    ascCc.addCType(ctype, not, asciiRange, this.env, this);
                }
                this.inc();
                this.inc();
                return false;
            }
        }
        this.c = 0;
        int i = 0;
        while (this.left() && (this.c = this.peek()) != 58 && this.c != 93) {
            this.inc();
            if (++i <= 20) continue;
        }
        if (this.c == 58 && this.left()) {
            this.inc();
            if (this.left()) {
                this.fetch();
                if (this.c == 93) {
                    this.newSyntaxException("invalid POSIX bracket type");
                }
            }
        }
        this.restore();
        return true;
    }

    private boolean codeExistCheck(int code, boolean ignoreEscaped) {
        this.mark();
        boolean inEsc = false;
        while (this.left()) {
            if (ignoreEscaped && inEsc) {
                inEsc = false;
                continue;
            }
            this.fetch();
            if (this.c == code) {
                this.restore();
                return true;
            }
            if (this.c != this.syntax.metaCharTable.esc) continue;
            inEsc = true;
        }
        this.restore();
        return false;
    }

    private CClassNode parseCharClass(ObjPtr<CClassNode> ascNode) {
        boolean neg;
        CClassNode prevCc = null;
        CClassNode ascCc = null;
        CClassNode ascPrevCc = null;
        CClassNode workCc = null;
        CClassNode ascWorkCc = null;
        CClassNode.CCStateArg arg = new CClassNode.CCStateArg();
        this.fetchTokenInCC();
        if (this.token.type == TokenType.CHAR && this.token.getC() == 94 && !this.token.escaped) {
            neg = true;
            this.fetchTokenInCC();
        } else {
            neg = false;
        }
        if (this.token.type == TokenType.CC_CLOSE && !this.syntax.op3OptionECMAScript()) {
            if (!this.codeExistCheck(93, true)) {
                this.newSyntaxException("empty char-class");
            }
            this.env.ccEscWarn("]");
            this.token.type = TokenType.CHAR;
        }
        CClassNode cc = new CClassNode();
        if (Option.isIgnoreCase(this.env.option)) {
            ascNode.p = new CClassNode();
            ascCc = ascNode.p;
        }
        boolean andStart = false;
        arg.state = CClassNode.CCSTATE.START;
        while (this.token.type != TokenType.CC_CLOSE) {
            boolean fetched = false;
            switch (this.token.type) {
                case CHAR: {
                    int len;
                    arg.inType = this.token.getCode() >= 256 || (len = this.enc.codeToMbcLength(this.token.getC())) > 1 ? CClassNode.CCVALTYPE.CODE_POINT : CClassNode.CCVALTYPE.SB;
                    arg.to = this.token.getC();
                    arg.toIsRaw = false;
                    this.parseCharClassValEntry2(cc, ascCc, arg);
                    break;
                }
                case RAW_BYTE: {
                    int len;
                    if (!this.enc.isSingleByte() && this.token.base != 0) {
                        int i;
                        byte[] buf = new byte[18];
                        int psave = this.p;
                        int base = this.token.base;
                        buf[0] = (byte)this.token.getC();
                        for (i = 1; i < this.enc.maxLength(); ++i) {
                            this.fetchTokenInCC();
                            if (this.token.type != TokenType.RAW_BYTE || this.token.base != base) {
                                fetched = true;
                                break;
                            }
                            buf[i] = (byte)this.token.getC();
                        }
                        if (i < this.enc.minLength()) {
                            this.newValueException("too short multibyte code string");
                        }
                        if (i < (len = this.enc.length(buf, 0, i))) {
                            this.newValueException("too short multibyte code string");
                        } else if (i > len) {
                            this.p = psave;
                            for (i = 1; i < len; ++i) {
                                this.fetchTokenInCC();
                            }
                            fetched = false;
                        }
                        if (i == 1) {
                            arg.to = buf[0] & 0xFF;
                            arg.inType = CClassNode.CCVALTYPE.SB;
                        } else {
                            arg.to = this.enc.mbcToCode(buf, 0, buf.length);
                            arg.inType = CClassNode.CCVALTYPE.CODE_POINT;
                        }
                    } else {
                        arg.to = this.token.getC();
                        arg.inType = CClassNode.CCVALTYPE.SB;
                    }
                    arg.toIsRaw = true;
                    this.parseCharClassValEntry2(cc, ascCc, arg);
                    break;
                }
                case CODE_POINT: {
                    arg.to = this.token.getCode();
                    arg.toIsRaw = true;
                    this.parseCharClassValEntry(cc, ascCc, arg);
                    break;
                }
                case POSIX_BRACKET_OPEN: {
                    if (this.parsePosixBracket(cc, ascCc)) {
                        this.env.ccEscWarn("[");
                        this.p = this.token.backP;
                        arg.to = this.token.getC();
                        arg.toIsRaw = false;
                        this.parseCharClassValEntry(cc, ascCc, arg);
                        break;
                    }
                    cc.nextStateClass(arg, ascCc, this.env);
                    break;
                }
                case CHAR_TYPE: {
                    cc.addCType(this.token.getPropCType(), this.token.getPropNot(), Option.isAsciiRange(this.env.option), this.env, this);
                    if (ascCc != null && this.token.getPropCType() != 12) {
                        ascCc.addCType(this.token.getPropCType(), this.token.getPropNot(), Option.isAsciiRange(this.env.option), this.env, this);
                    }
                    cc.nextStateClass(arg, ascCc, this.env);
                    break;
                }
                case CHAR_PROPERTY: {
                    int ctype = this.fetchCharPropertyToCType();
                    cc.addCType(ctype, this.token.getPropNot(), false, this.env, this);
                    if (ascCc != null && ctype != 14) {
                        ascCc.addCType(ctype, this.token.getPropNot(), false, this.env, this);
                    }
                    cc.nextStateClass(arg, ascCc, this.env);
                    break;
                }
                case CC_RANGE: {
                    if (arg.state == CClassNode.CCSTATE.VALUE) {
                        this.fetchTokenInCC();
                        fetched = true;
                        if (this.token.type == TokenType.CC_CLOSE) {
                            this.parseCharClassRangeEndVal(cc, ascCc, arg);
                            break;
                        }
                        if (this.token.type == TokenType.CC_AND) {
                            this.env.ccEscWarn("-");
                            this.parseCharClassRangeEndVal(cc, ascCc, arg);
                            break;
                        }
                        if (arg.type == CClassNode.CCVALTYPE.CLASS) {
                            this.newValueException("unmatched range specifier in char-class");
                        }
                        arg.state = CClassNode.CCSTATE.RANGE;
                        break;
                    }
                    if (arg.state == CClassNode.CCSTATE.START) {
                        arg.to = this.token.getC();
                        arg.toIsRaw = false;
                        this.fetchTokenInCC();
                        fetched = true;
                        if (this.token.type == TokenType.CC_RANGE || andStart) {
                            this.env.ccEscWarn("-");
                        }
                        this.parseCharClassValEntry(cc, ascCc, arg);
                        break;
                    }
                    if (arg.state == CClassNode.CCSTATE.RANGE) {
                        this.env.ccEscWarn("-");
                        this.parseCharClassSbChar(cc, ascCc, arg);
                        break;
                    }
                    this.fetchTokenInCC();
                    fetched = true;
                    if (this.token.type == TokenType.CC_CLOSE) {
                        this.parseCharClassRangeEndVal(cc, ascCc, arg);
                        break;
                    }
                    if (this.token.type == TokenType.CC_AND) {
                        this.env.ccEscWarn("-");
                        this.parseCharClassRangeEndVal(cc, ascCc, arg);
                        break;
                    }
                    if (this.syntax.allowDoubleRangeOpInCC()) {
                        this.env.ccEscWarn("-");
                        this.parseCharClassRangeEndVal(cc, ascCc, arg);
                        break;
                    }
                    this.newSyntaxException("unmatched range specifier in char-class");
                    break;
                }
                case CC_CC_OPEN: {
                    ObjPtr<CClassNode> ascPtr = new ObjPtr<CClassNode>();
                    CClassNode acc = this.parseCharClass(ascPtr);
                    cc.or(acc, this.env);
                    if (ascPtr.p == null) break;
                    ascCc.or((CClassNode)ascPtr.p, this.env);
                    break;
                }
                case CC_AND: {
                    if (arg.state == CClassNode.CCSTATE.VALUE) {
                        arg.to = 0;
                        arg.toIsRaw = false;
                        cc.nextStateValue(arg, ascCc, this.env);
                    }
                    andStart = true;
                    arg.state = CClassNode.CCSTATE.START;
                    if (prevCc != null) {
                        prevCc.and(cc, this.env);
                        if (ascCc != null) {
                            ascPrevCc.and(ascCc, this.env);
                        }
                    } else {
                        prevCc = cc;
                        if (workCc == null) {
                            workCc = new CClassNode();
                        }
                        cc = workCc;
                        if (ascCc != null) {
                            ascPrevCc = ascCc;
                            if (ascWorkCc == null) {
                                ascWorkCc = new CClassNode();
                            }
                            ascCc = ascWorkCc;
                        }
                    }
                    cc.clear();
                    if (ascCc == null) break;
                    ascCc.clear();
                    break;
                }
                case EOT: {
                    this.newSyntaxException("premature end of char-class");
                }
                default: {
                    this.newInternalException("internal parser error (bug)");
                }
            }
            if (fetched) continue;
            this.fetchTokenInCC();
        }
        if (arg.state == CClassNode.CCSTATE.VALUE) {
            arg.to = 0;
            arg.toIsRaw = false;
            cc.nextStateValue(arg, ascCc, this.env);
        }
        if (prevCc != null) {
            prevCc.and(cc, this.env);
            cc = prevCc;
            if (ascCc != null) {
                ascPrevCc.and(ascCc, this.env);
                ascCc = ascPrevCc;
            }
        }
        if (neg) {
            cc.setNot();
            if (ascCc != null) {
                ascCc.setNot();
            }
        } else {
            cc.clearNot();
            if (ascCc != null) {
                ascCc.clearNot();
            }
        }
        if (cc.isNot() && this.syntax.notNewlineInNegativeCC() && !cc.isEmpty()) {
            int NEW_LINE = 10;
            if (this.enc.isNewLine(10)) {
                if (this.enc.codeToMbcLength(10) == 1) {
                    cc.bs.set(this.env, 10);
                } else {
                    cc.addCodeRange(this.env, 10, 10);
                }
            }
        }
        return cc;
    }

    private void parseCharClassSbChar(CClassNode cc, CClassNode ascCc, CClassNode.CCStateArg arg) {
        arg.inType = CClassNode.CCVALTYPE.SB;
        arg.to = this.token.getC();
        arg.toIsRaw = false;
        this.parseCharClassValEntry2(cc, ascCc, arg);
    }

    private void parseCharClassRangeEndVal(CClassNode cc, CClassNode ascCc, CClassNode.CCStateArg arg) {
        arg.to = 45;
        arg.toIsRaw = false;
        this.parseCharClassValEntry(cc, ascCc, arg);
    }

    private void parseCharClassValEntry(CClassNode cc, CClassNode ascCc, CClassNode.CCStateArg arg) {
        int len = this.enc.codeToMbcLength(arg.to);
        arg.inType = len == 1 ? CClassNode.CCVALTYPE.SB : CClassNode.CCVALTYPE.CODE_POINT;
        this.parseCharClassValEntry2(cc, ascCc, arg);
    }

    private void parseCharClassValEntry2(CClassNode cc, CClassNode ascCc, CClassNode.CCStateArg arg) {
        cc.nextStateValue(arg, ascCc, this.env);
    }

    private Node parseEnclose(TokenType term) {
        EncloseNode en;
        Node node;
        block66: {
            int num;
            block65: {
                node = null;
                if (!this.left()) {
                    this.newSyntaxException("end pattern with unmatched parenthesis");
                }
                int option = this.env.option;
                if (!this.peekIs(63) || !this.syntax.op2QMarkGroupEffect()) break block65;
                this.inc();
                if (!this.left()) {
                    this.newSyntaxException("end pattern in group");
                }
                boolean listCapture = false;
                this.fetch();
                switch (this.c) {
                    case 58: {
                        this.fetchToken();
                        node = this.parseSubExp(term);
                        this.returnCode = 1;
                        return node;
                    }
                    case 61: {
                        node = new AnchorNode(1024);
                        break;
                    }
                    case 33: {
                        node = new AnchorNode(2048);
                        if (this.syntax.op3OptionECMAScript()) {
                            this.env.pushPrecReadNotNode(node);
                            break;
                        }
                        break block66;
                    }
                    case 62: {
                        node = new EncloseNode(4);
                        break;
                    }
                    case 126: {
                        if (this.syntax.op2QMarkTildeAbsent()) {
                            node = new EncloseNode(16);
                            break;
                        }
                        this.newSyntaxException("undefined group option");
                    }
                    case 39: {
                        if (this.syntax.op2QMarkLtNamedGroup()) {
                            listCapture = false;
                            node = this.parseEncloseNamedGroup2(listCapture);
                            break;
                        }
                        this.newSyntaxException("undefined group option");
                        break;
                    }
                    case 60: {
                        this.fetch();
                        if (this.c == 61) {
                            node = new AnchorNode(4096);
                            break;
                        }
                        if (this.c == 33) {
                            node = new AnchorNode(8192);
                            break;
                        }
                        if (this.syntax.op2QMarkLtNamedGroup()) {
                            this.unfetch();
                            this.c = 60;
                            listCapture = false;
                            node = this.parseEncloseNamedGroup2(listCapture);
                            break;
                        }
                        this.newSyntaxException("undefined group option");
                        break;
                    }
                    case 64: {
                        if (this.syntax.op2AtMarkCaptureHistory()) {
                            if (this.syntax.op2QMarkLtNamedGroup()) {
                                this.fetch();
                                if (this.c == 60 || this.c == 39) {
                                    listCapture = true;
                                    node = this.parseEncloseNamedGroup2(listCapture);
                                }
                                this.unfetch();
                            }
                            en = EncloseNode.newMemory(this.env.option, false);
                            int num2 = this.env.addMemEntry();
                            if (num2 >= 32) {
                                this.newValueException("group number is too big for capture history");
                            }
                            en.regNum = num2;
                            node = en;
                            break;
                        }
                        this.newSyntaxException("undefined group option");
                        break;
                    }
                    case 40: {
                        if (this.syntax.op2QMarkLParenCondition()) {
                            int num3 = -1;
                            int name = -1;
                            this.fetch();
                            if (this.enc.isDigit(this.c)) {
                                this.unfetch();
                                num3 = this.fetchName(40, true);
                                if (this.syntax.strictCheckBackref() && (num3 > this.env.numMem || this.env.memNodes == null || this.env.memNodes[num3] == null)) {
                                    this.newValueException("invalid backref number/name");
                                }
                            } else if (this.c == 60 || this.c == 39) {
                                name = this.p;
                                this.fetchNamedBackrefToken();
                                this.inc();
                                num3 = this.token.getBackrefNum() > 1 ? this.token.getBackrefRefs()[0] : this.token.getBackrefRef1();
                            }
                            EncloseNode en2 = new EncloseNode(8);
                            en2.regNum = num3;
                            if (name != -1) {
                                en2.setNameRef();
                            }
                            node = en2;
                            break;
                        }
                        this.newSyntaxException("undefined group option");
                        break;
                    }
                    case 94: {
                        if (this.left() && this.syntax.op2OptionPerl()) {
                            option = BitStatus.bsOnOff(option, 4096, true);
                            option = BitStatus.bsOnOff(option, 1, true);
                            option = BitStatus.bsOnOff(option, 8, false);
                            option = BitStatus.bsOnOff(option, 4, true);
                            option = BitStatus.bsOnOff(option, 2, true);
                            this.fetch();
                        } else {
                            this.newSyntaxException("undefined group option");
                        }
                    }
                    case 45: 
                    case 97: 
                    case 100: 
                    case 105: 
                    case 108: 
                    case 109: 
                    case 115: 
                    case 117: 
                    case 120: {
                        boolean neg = false;
                        while (true) {
                            switch (this.c) {
                                case 41: 
                                case 58: {
                                    break;
                                }
                                case 45: {
                                    neg = true;
                                    break;
                                }
                                case 120: {
                                    option = BitStatus.bsOnOff(option, 2, neg);
                                    break;
                                }
                                case 105: {
                                    option = BitStatus.bsOnOff(option, 1, neg);
                                    break;
                                }
                                case 115: {
                                    if (this.syntax.op2OptionPerl()) {
                                        option = BitStatus.bsOnOff(option, 4, neg);
                                        break;
                                    }
                                    this.newSyntaxException("undefined group option");
                                    break;
                                }
                                case 109: {
                                    if (this.syntax.op2OptionPerl()) {
                                        option = BitStatus.bsOnOff(option, 8, !neg);
                                        break;
                                    }
                                    if (this.syntax.op2OptionRuby()) {
                                        option = BitStatus.bsOnOff(option, 4, neg);
                                        break;
                                    }
                                    this.newSyntaxException("undefined group option");
                                    break;
                                }
                                case 97: {
                                    if ((this.syntax.op2OptionPerl() || this.syntax.op2OptionRuby()) && !neg) {
                                        option = BitStatus.bsOnOff(option, 4096, false);
                                        option = BitStatus.bsOnOff(option, 8192, true);
                                        option = BitStatus.bsOnOff(option, 16384, true);
                                        break;
                                    }
                                    this.newSyntaxException("undefined group option");
                                }
                                case 117: {
                                    if ((this.syntax.op2OptionPerl() || this.syntax.op2OptionRuby()) && !neg) {
                                        option = BitStatus.bsOnOff(option, 4096, true);
                                        option = BitStatus.bsOnOff(option, 8192, true);
                                        option = BitStatus.bsOnOff(option, 16384, true);
                                        break;
                                    }
                                    this.newSyntaxException("undefined group option");
                                }
                                case 100: {
                                    if (this.syntax.op2OptionPerl() && !neg) {
                                        option = BitStatus.bsOnOff(option, 4096, true);
                                        break;
                                    }
                                    if (this.syntax.op2OptionRuby() && !neg) {
                                        option = BitStatus.bsOnOff(option, 4096, false);
                                        option = BitStatus.bsOnOff(option, 8192, false);
                                        option = BitStatus.bsOnOff(option, 16384, false);
                                        break;
                                    }
                                    this.newSyntaxException("undefined group option");
                                    break;
                                }
                                case 108: {
                                    if (this.syntax.op2OptionPerl() && !neg) {
                                        option = BitStatus.bsOnOff(option, 4096, true);
                                        break;
                                    }
                                    this.newSyntaxException("undefined group option");
                                    break;
                                }
                                default: {
                                    this.newSyntaxException("undefined group option");
                                }
                            }
                            if (this.c == 41) {
                                EncloseNode en3 = EncloseNode.newOption(option);
                                node = en3;
                                this.returnCode = 2;
                                return node;
                            }
                            if (this.c == 58) {
                                int prev = this.env.option;
                                this.env.option = option;
                                this.fetchToken();
                                Node target = this.parseSubExp(term);
                                this.env.option = prev;
                                EncloseNode en4 = EncloseNode.newOption(option);
                                en4.setTarget(target);
                                node = en4;
                                this.returnCode = 0;
                                return node;
                            }
                            if (!this.left()) {
                                this.newSyntaxException("end pattern in group");
                            }
                            this.fetch();
                        }
                    }
                    default: {
                        this.newSyntaxException("undefined group option");
                        break;
                    }
                }
                break block66;
            }
            if (Option.isDontCaptureGroup(this.env.option)) {
                this.fetchToken();
                node = this.parseSubExp(term);
                this.returnCode = 1;
                return node;
            }
            EncloseNode en5 = EncloseNode.newMemory(this.env.option, false);
            en5.regNum = num = this.env.addMemEntry();
            node = en5;
        }
        this.fetchToken();
        Node target = this.parseSubExp(term);
        if (node.getType() == 7) {
            AnchorNode an = (AnchorNode)node;
            an.setTarget(target);
            if (this.syntax.op3OptionECMAScript() && an.type == 2048) {
                this.env.popPrecReadNotNode(an);
            }
        } else {
            en = (EncloseNode)node;
            en.setTarget(target);
            if (en.type == 1) {
                if (this.syntax.op3OptionECMAScript()) {
                    en.containingAnchor = this.env.currentPrecReadNotNode();
                }
                this.env.setMemNode(en.regNum, en);
            } else if (en.type == 8 && target.getType() != 9) {
                en.setTarget(ListNode.newAlt(target, ListNode.newAlt(StringNode.EMPTY, null)));
            }
        }
        this.returnCode = 0;
        return node;
    }

    private Node parseEncloseNamedGroup2(boolean listCapture) {
        int nm = this.p;
        int num = this.fetchName(this.c, false);
        int nameEnd = this.value;
        num = this.env.addMemEntry();
        if (listCapture && num >= 32) {
            this.newValueException("group number is too big for capture history");
        }
        this.regex.nameAdd(this.bytes, nm, nameEnd, num, this.syntax);
        EncloseNode en = EncloseNode.newMemory(this.env.option, true);
        en.regNum = num;
        EncloseNode node = en;
        if (listCapture) {
            this.env.captureHistory = BitStatus.bsOnAtSimple(this.env.captureHistory, num);
        }
        ++this.env.numNamed;
        return node;
    }

    private int findStrPosition(int[] s, int n, int from, int to, Ptr nextChar) {
        int p = from;
        int i = 0;
        while (p < to) {
            int x = this.enc.mbcToCode(this.bytes, p, to);
            int q = p + this.enc.length(this.bytes, p, to);
            if (x == s[0]) {
                for (i = 1; i < n && q < to && (x = this.enc.mbcToCode(this.bytes, q, to)) == s[i]; q += this.enc.length(this.bytes, q, to), ++i) {
                }
                if (i >= n) {
                    if (this.bytes[nextChar.p] != 0) {
                        nextChar.p = q;
                    }
                    return p;
                }
            }
            p = q;
        }
        return -1;
    }

    private Node parseExp(TokenType term) {
        if (this.token.type == term) {
            return StringNode.EMPTY;
        }
        Node node = null;
        boolean group = false;
        switch (this.token.type) {
            case EOT: 
            case ALT: {
                return StringNode.EMPTY;
            }
            case SUBEXP_OPEN: {
                node = this.parseEnclose(TokenType.SUBEXP_CLOSE);
                if (this.returnCode == 1) {
                    group = true;
                    break;
                }
                if (this.returnCode != 2) break;
                int prev = this.env.option;
                EncloseNode en = (EncloseNode)node;
                this.env.option = en.option;
                this.fetchToken();
                Node target = this.parseSubExp(term);
                this.env.option = prev;
                en.setTarget(target);
                return node;
            }
            case SUBEXP_CLOSE: {
                if (!this.syntax.allowUnmatchedCloseSubexp()) {
                    this.newSyntaxException("unmatched close parenthesis");
                }
                if (this.token.escaped) {
                    return this.parseExpTkRawByte(group);
                }
                return this.parseExpTkByte(group);
            }
            case LINEBREAK: {
                node = this.parseLineBreak();
                break;
            }
            case EXTENDED_GRAPHEME_CLUSTER: {
                node = this.parseExtendedGraphemeCluster();
                break;
            }
            case KEEP: {
                node = new AnchorNode(65536);
                break;
            }
            case STRING: {
                return this.parseExpTkByte(group);
            }
            case RAW_BYTE: {
                return this.parseExpTkRawByte(group);
            }
            case CODE_POINT: {
                return this.parseStringLoop(StringNode.fromCodePoint(this.token.getCode(), this.enc), group);
            }
            case QUOTE_OPEN: {
                node = this.parseQuoteOpen();
                break;
            }
            case CHAR_TYPE: {
                node = this.parseCharType(node);
                break;
            }
            case CHAR_PROPERTY: {
                node = this.parseCharProperty();
                break;
            }
            case CC_OPEN: {
                ObjPtr<CClassNode> ascPtr = new ObjPtr<CClassNode>();
                CClassNode cc = this.parseCharClass(ascPtr);
                int code = cc.isOneChar();
                if (code != -1) {
                    return this.parseStringLoop(StringNode.fromCodePoint(code, this.enc), group);
                }
                node = cc;
                if (!Option.isIgnoreCase(this.env.option)) break;
                node = this.cClassCaseFold(node, cc, (CClassNode)ascPtr.p);
                break;
            }
            case ANYCHAR: {
                node = new AnyCharNode();
                break;
            }
            case ANYCHAR_ANYTIME: {
                node = this.parseAnycharAnytime();
                break;
            }
            case BACKREF: {
                node = this.parseBackref();
                break;
            }
            case CALL: {
                node = this.parseCall();
                break;
            }
            case ANCHOR: {
                node = new AnchorNode(this.token.getAnchorSubtype(), this.token.getAnchorASCIIRange());
                break;
            }
            case OP_REPEAT: 
            case INTERVAL: {
                if (this.syntax.contextIndepRepeatOps()) {
                    if (this.syntax.contextInvalidRepeatOps()) {
                        this.newSyntaxException("target of repeat operator is not specified");
                        break;
                    }
                    node = StringNode.EMPTY;
                    break;
                }
                return this.parseExpTkByte(group);
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
        this.fetchToken();
        return this.parseExpRepeat(node, group);
    }

    private Node parseLineBreak() {
        byte[] buflb = new byte[14];
        int len1 = this.enc.codeToMbc(13, buflb, 0);
        int len2 = this.enc.codeToMbc(10, buflb, len1);
        StringNode left = new StringNode(buflb, 0, len1 + len2);
        left.setRaw();
        CClassNode right = new CClassNode();
        if (this.enc.minLength() > 1) {
            right.addCodeRange(this.env, 10, 13);
        } else {
            right.bs.setRange(this.env, 10, 13);
        }
        if (this.enc.isUnicode()) {
            right.addCodeRange(this.env, 133, 133);
            right.addCodeRange(this.env, 8232, 8233);
        }
        EncloseNode en = new EncloseNode(4);
        en.setTarget(ListNode.newAlt(left, ListNode.newAlt(right, null)));
        return en;
    }

    private void addPropertyToCC(CClassNode cc, byte[] propName, boolean not) {
        int ctype = this.enc.propertyNameToCType(propName, 0, propName.length);
        cc.addCType(ctype, not, false, this.env, this);
    }

    private void createPropertyNode(Node[] nodes, int np, byte[] propName) {
        CClassNode cc = new CClassNode();
        this.addPropertyToCC(cc, propName, false);
        nodes[np] = cc;
    }

    private void quantifierNode(Node[] nodes, int np, int lower, int upper) {
        QuantifierNode qnf = new QuantifierNode(lower, upper, false);
        qnf.setTarget(nodes[np]);
        nodes[np] = qnf;
    }

    private void quantifierPropertyNode(Node[] nodes, int np, byte[] propName, char repetitions) {
        int lower = 0;
        int upper = -1;
        this.createPropertyNode(nodes, np, propName);
        switch (repetitions) {
            case '?': {
                upper = 1;
                break;
            }
            case '+': {
                lower = 1;
                break;
            }
            case '*': {
                break;
            }
            case '2': {
                upper = 2;
                lower = 2;
                break;
            }
            default: {
                new InternalException("internal parser error (bug)");
            }
        }
        this.quantifierNode(nodes, np, lower, upper);
    }

    private void createNodeFromArray(boolean list, Node[] nodes, int np, int nodeArray) {
        int i = 0;
        ListNode tmp = null;
        while (nodes[nodeArray + i] != null) {
            ++i;
        }
        while (--i >= 0) {
            nodes[np] = list ? ListNode.newList(nodes[nodeArray + i], tmp) : ListNode.newAlt(nodes[nodeArray + i], tmp);
            nodes[nodeArray + i] = null;
            tmp = (ListNode)nodes[np];
        }
    }

    private ListNode createNodeFromArray(Node[] nodes, int nodeArray) {
        int i = 0;
        ListNode np = null;
        ListNode tmp = null;
        while (nodes[nodeArray + i] != null) {
            ++i;
        }
        while (--i >= 0) {
            np = ListNode.newAlt(nodes[nodeArray + i], tmp);
            nodes[nodeArray + i] = null;
            tmp = np;
        }
        return np;
    }

    private Node parseExtendedGraphemeCluster() {
        int anyTargetPosition;
        Node[] nodes = new Node[NODE_COMMON_SIZE];
        int alts = 0;
        StringNode strNode = new StringNode(14);
        strNode.setRaw();
        strNode.catCode(13, this.enc);
        strNode.catCode(10, this.enc);
        nodes[alts] = strNode;
        if (this.enc.isUnicode()) {
            CClassNode cc = new CClassNode();
            nodes[alts + 1] = cc;
            this.addPropertyToCC(cc, GraphemeNames.Grapheme_Cluster_Break_Control, false);
            if (this.enc.minLength() > 1) {
                cc.addCodeRange(this.env, 10, 10);
                cc.addCodeRange(this.env, 13, 13);
            } else {
                cc.bs.set(10);
                cc.bs.set(13);
            }
            int list = alts + 3;
            this.quantifierPropertyNode(nodes, list + 0, GraphemeNames.Grapheme_Cluster_Break_Prepend, '*');
            int coreAlts = list + 2;
            int HList = coreAlts + 1;
            this.quantifierPropertyNode(nodes, HList + 0, GraphemeNames.Grapheme_Cluster_Break_L, '*');
            int HAlt2 = HList + 2;
            this.quantifierPropertyNode(nodes, HAlt2 + 0, GraphemeNames.Grapheme_Cluster_Break_V, '+');
            int HList2 = HAlt2 + 2;
            this.createPropertyNode(nodes, HList2 + 0, GraphemeNames.Grapheme_Cluster_Break_LV);
            this.quantifierPropertyNode(nodes, HList2 + 1, GraphemeNames.Grapheme_Cluster_Break_V, '*');
            this.createNodeFromArray(true, nodes, HAlt2 + 1, HList2);
            this.createPropertyNode(nodes, HAlt2 + 2, GraphemeNames.Grapheme_Cluster_Break_LVT);
            this.createNodeFromArray(false, nodes, HList + 1, HAlt2);
            this.quantifierPropertyNode(nodes, HList + 2, GraphemeNames.Grapheme_Cluster_Break_T, '*');
            this.createNodeFromArray(true, nodes, coreAlts + 0, HList);
            this.quantifierPropertyNode(nodes, coreAlts + 1, GraphemeNames.Grapheme_Cluster_Break_L, '+');
            this.quantifierPropertyNode(nodes, coreAlts + 2, GraphemeNames.Grapheme_Cluster_Break_T, '+');
            this.quantifierPropertyNode(nodes, coreAlts + 3, GraphemeNames.Regional_Indicator, '2');
            int XPList = coreAlts + 5;
            this.createPropertyNode(nodes, XPList + 0, GraphemeNames.Extended_Pictographic);
            int ExList = XPList + 2;
            this.quantifierPropertyNode(nodes, ExList + 0, GraphemeNames.Grapheme_Cluster_Break_Extend, '*');
            strNode = new StringNode(7);
            strNode.setRaw();
            strNode.catCode(8205, this.enc);
            nodes[ExList + 1] = strNode;
            this.createPropertyNode(nodes, ExList + 2, GraphemeNames.Extended_Pictographic);
            this.createNodeFromArray(true, nodes, XPList + 1, ExList);
            this.quantifierNode(nodes, XPList + 1, 0, -1);
            this.createNodeFromArray(true, nodes, coreAlts + 4, XPList);
            cc = new CClassNode();
            nodes[coreAlts + 5] = cc;
            if (this.enc.minLength() > 1) {
                this.addPropertyToCC(cc, GraphemeNames.Grapheme_Cluster_Break_Control, false);
                cc.addCodeRange(this.env, 10, 10);
                cc.addCodeRange(this.env, 13, 13);
                cc.mbuf = CodeRangeBuffer.notCodeRangeBuff(this.env, cc.mbuf);
            } else {
                this.addPropertyToCC(cc, GraphemeNames.Grapheme_Cluster_Break_Control, true);
                cc.bs.clear(10);
                cc.bs.clear(13);
            }
            this.createNodeFromArray(false, nodes, list + 1, coreAlts);
            this.createPropertyNode(nodes, list + 2, GraphemeNames.Grapheme_Cluster_Break_Extend);
            cc = (CClassNode)nodes[list + 2];
            this.addPropertyToCC(cc, GraphemeNames.Grapheme_Cluster_Break_SpacingMark, false);
            cc.addCodeRange(this.env, 8205, 8205);
            this.quantifierNode(nodes, list + 2, 0, -1);
            this.createNodeFromArray(true, nodes, alts + 2, list);
            anyTargetPosition = 3;
        } else {
            anyTargetPosition = 1;
        }
        AnyCharNode any = new AnyCharNode();
        EncloseNode option = EncloseNode.newOption(BitStatus.bsOnOff(this.env.option, 4, false));
        option.setTarget(any);
        nodes[anyTargetPosition] = option;
        ListNode topAlt = this.createNodeFromArray(nodes, alts);
        EncloseNode enclose = new EncloseNode(4);
        enclose.setTarget(topAlt);
        if (this.enc.isUnicode()) {
            option = EncloseNode.newOption(BitStatus.bsOnOff(this.env.option, 1, true));
            option.setTarget(enclose);
            return option;
        }
        return enclose;
    }

    private Node parseExpTkByte(boolean group) {
        StringNode node = new StringNode(this.bytes, this.token.backP, this.p);
        return this.parseStringLoop(node, group);
    }

    private Node parseStringLoop(StringNode node, boolean group) {
        while (true) {
            this.fetchToken();
            if (this.token.type == TokenType.STRING) {
                if (this.token.backP == node.end) {
                    node.end = this.p;
                    continue;
                }
                node.catBytes(this.bytes, this.token.backP, this.p);
                continue;
            }
            if (this.token.type != TokenType.CODE_POINT) break;
            node.catCode(this.token.getCode(), this.enc);
        }
        return this.parseExpRepeat(node, group);
    }

    private Node parseExpTkRawByte(boolean group) {
        StringNode node = new StringNode();
        node.setRaw();
        node.catByte((byte)this.token.getC());
        int len = 1;
        while (true) {
            if (len >= this.enc.minLength() && len == this.enc.length(node.bytes, node.p, node.end)) {
                this.fetchToken();
                node.clearRaw();
                return this.parseExpRepeat(node, group);
            }
            this.fetchToken();
            if (this.token.type != TokenType.RAW_BYTE) {
                this.newValueException("too short multibyte code string");
            }
            node.catByte((byte)this.token.getC());
            ++len;
        }
    }

    private Node parseExpRepeat(Node target, boolean group) {
        while (this.token.type == TokenType.OP_REPEAT || this.token.type == TokenType.INTERVAL) {
            if (this.isInvalidQuantifier(target)) {
                this.newSyntaxException("target of repeat operator is invalid");
            }
            if (!group && this.syntax.op3OptionECMAScript() && target.getType() == 5) {
                this.newSyntaxException("nested repeat is not allowed");
            }
            QuantifierNode qtfr = new QuantifierNode(this.token.getRepeatLower(), this.token.getRepeatUpper(), this.token.type == TokenType.INTERVAL);
            qtfr.greedy = this.token.getRepeatGreedy();
            int ret = qtfr.setQuantifier(target, group, this.env, this.bytes, this.getBegin(), this.getEnd());
            StateNode qn = qtfr;
            if (this.token.getRepeatPossessive()) {
                EncloseNode en = new EncloseNode(4);
                en.setTarget(qn);
                qn = en;
            }
            if (ret == 0 || this.syntax.op3OptionECMAScript() && ret == 1) {
                target = qn;
            } else if (ret == 2) {
                target = ListNode.newList(target, null);
                ListNode tmp = ListNode.newList(qn, null);
                ((ListNode)target).setTail(tmp);
                this.fetchToken();
                return this.parseExpRepeatForCar(target, tmp, group);
            }
            this.fetchToken();
        }
        return target;
    }

    private Node parseExpRepeatForCar(Node top, ListNode target, boolean group) {
        while (this.token.type == TokenType.OP_REPEAT || this.token.type == TokenType.INTERVAL) {
            if (this.isInvalidQuantifier(target.value)) {
                this.newSyntaxException("target of repeat operator is invalid");
            }
            QuantifierNode qtfr = new QuantifierNode(this.token.getRepeatLower(), this.token.getRepeatUpper(), this.token.type == TokenType.INTERVAL);
            qtfr.greedy = this.token.getRepeatGreedy();
            int ret = qtfr.setQuantifier(target.value, group, this.env, this.bytes, this.getBegin(), this.getEnd());
            StateNode qn = qtfr;
            if (this.token.getRepeatPossessive()) {
                EncloseNode en = new EncloseNode(4);
                en.setTarget(qn);
                qn = en;
            }
            if (ret == 0) {
                target.setValue(qn);
            } else if (ret == 2) assert (false);
            this.fetchToken();
        }
        return top;
    }

    private boolean isInvalidQuantifier(Node node) {
        return false;
    }

    private Node parseQuoteOpen() {
        int[] endOp = new int[]{this.syntax.metaCharTable.esc, 69};
        int qstart = this.p;
        Ptr nextChar = new Ptr();
        int qend = this.findStrPosition(endOp, endOp.length, qstart, this.stop, nextChar);
        if (qend == -1) {
            nextChar.p = qend = this.stop;
        }
        StringNode node = new StringNode(this.bytes, qstart, qend);
        this.p = nextChar.p;
        return node;
    }

    private Node parseCharType(Node node) {
        switch (this.token.getPropCType()) {
            case 12: {
                node = new CTypeNode(this.token.getPropCType(), this.token.getPropNot(), Option.isAsciiRange(this.env.option));
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                CClassNode ccn = new CClassNode();
                ccn.addCType(this.token.getPropCType(), false, Option.isAsciiRange(this.env.option), this.env, this);
                if (this.token.getPropNot()) {
                    ccn.setNot();
                }
                node = ccn;
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
        return node;
    }

    private Node cClassCaseFold(Node node, CClassNode cc, CClassNode ascCc) {
        ApplyCaseFoldArg arg = new ApplyCaseFoldArg(this.env, cc, ascCc);
        this.enc.applyAllCaseFold(this.env.caseFoldFlag, ApplyCaseFold.INSTANCE, arg);
        if (arg.altRoot != null) {
            node = ListNode.newAlt(node, arg.altRoot);
        }
        return node;
    }

    private Node parseCharProperty() {
        CClassNode cc;
        int ctype = this.fetchCharPropertyToCType();
        Node node = cc = new CClassNode();
        cc.addCType(ctype, false, false, this.env, this);
        if (this.token.getPropNot()) {
            cc.setNot();
        }
        if (Option.isIgnoreCase(this.env.option) && ctype != 14) {
            node = this.cClassCaseFold(node, cc, cc);
        }
        return node;
    }

    private Node parseAnycharAnytime() {
        AnyCharNode node = new AnyCharNode();
        QuantifierNode qn = new QuantifierNode(0, -1, false);
        qn.setTarget(node);
        return qn;
    }

    private Node parseBackref() {
        Node node;
        if (this.syntax.op3OptionECMAScript() && this.token.getBackrefNum() == 1 && this.env.memNodes != null) {
            EncloseNode encloseNode = this.env.memNodes[this.token.getBackrefRef1()];
            boolean shouldIgnore = false;
            if (encloseNode != null && encloseNode.containingAnchor != null) {
                shouldIgnore = true;
                for (Node anchorNode : this.env.precReadNotNodes) {
                    if (anchorNode != encloseNode.containingAnchor) continue;
                    shouldIgnore = false;
                    break;
                }
            }
            node = shouldIgnore ? StringNode.EMPTY : this.newBackRef(new int[]{this.token.getBackrefRef1()});
        } else {
            int[] nArray;
            if (this.token.getBackrefNum() > 1) {
                nArray = this.token.getBackrefRefs();
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.token.getBackrefRef1();
            }
            node = this.newBackRef(nArray);
        }
        return node;
    }

    private BackRefNode newBackRef(int[] backRefs) {
        return new BackRefNode(this.token.getBackrefNum(), backRefs, this.token.getBackrefByName(), this.token.getBackrefExistLevel(), this.token.getBackrefLevel(), this.env);
    }

    private Node parseCall() {
        int gNum = this.token.getCallGNum();
        if (gNum < 0 || this.token.getCallRel()) {
            if (gNum > 0) {
                --gNum;
            }
            if ((gNum = this.backrefRelToAbs(gNum)) <= 0) {
                this.newValueException("invalid backref number/name");
            }
        }
        CallNode node = new CallNode(this.bytes, this.token.getCallNameP(), this.token.getCallNameEnd(), gNum);
        ++this.env.numCall;
        return node;
    }

    private Node parseBranch(TokenType term) {
        ListNode top;
        Node node = this.parseExp(term);
        if (this.token.type == TokenType.EOT || this.token.type == term || this.token.type == TokenType.ALT) {
            return node;
        }
        ListNode t = top = ListNode.newList(node, null);
        while (this.token.type != TokenType.EOT && this.token.type != term && this.token.type != TokenType.ALT) {
            node = this.parseExp(term);
            if (node.getType() == 8) {
                t.setTail((ListNode)node);
                while (((ListNode)node).tail != null) {
                    node = ((ListNode)node).tail;
                }
                t = (ListNode)node;
                continue;
            }
            t.setTail(ListNode.newList(node, null));
            t = t.tail;
        }
        return top;
    }

    private Node parseSubExp(TokenType term) {
        Node node = this.parseBranch(term);
        if (this.token.type == term) {
            return node;
        }
        if (this.token.type == TokenType.ALT) {
            ListNode top;
            ListNode t = top = ListNode.newAlt(node, null);
            while (this.token.type == TokenType.ALT) {
                this.fetchToken();
                node = this.parseBranch(term);
                t.setTail(ListNode.newAlt(node, null));
                t = t.tail;
            }
            if (this.token.type != term) {
                this.parseSubExpError(term);
            }
            return top;
        }
        this.parseSubExpError(term);
        return null;
    }

    private void parseSubExpError(TokenType term) {
        if (term == TokenType.SUBEXP_CLOSE) {
            this.newSyntaxException("end pattern with unmatched parenthesis");
        } else {
            this.newInternalException("internal parser error (bug)");
        }
    }

    protected final Node parseRegexp() {
        this.fetchToken();
        Node top = this.parseSubExp(TokenType.EOT);
        if (this.env.numCall > 0) {
            EncloseNode np = EncloseNode.newMemory(this.env.option, false);
            np.regNum = 0;
            np.setTarget(top);
            if (this.env.memNodes == null) {
                this.env.memNodes = new EncloseNode[8];
            }
            this.env.memNodes[0] = np;
            top = np;
        }
        return top;
    }

    private static class GraphemeNames {
        static final byte[] Grapheme_Cluster_Break_Extend = "Grapheme_Cluster_Break=Extend".getBytes();
        static final byte[] Grapheme_Cluster_Break_Control = "Grapheme_Cluster_Break=Control".getBytes();
        static final byte[] Grapheme_Cluster_Break_Prepend = "Grapheme_Cluster_Break=Prepend".getBytes();
        static final byte[] Grapheme_Cluster_Break_L = "Grapheme_Cluster_Break=L".getBytes();
        static final byte[] Grapheme_Cluster_Break_V = "Grapheme_Cluster_Break=V".getBytes();
        static final byte[] Grapheme_Cluster_Break_LV = "Grapheme_Cluster_Break=LV".getBytes();
        static final byte[] Grapheme_Cluster_Break_LVT = "Grapheme_Cluster_Break=LVT".getBytes();
        static final byte[] Grapheme_Cluster_Break_T = "Grapheme_Cluster_Break=T".getBytes();
        static final byte[] Regional_Indicator = "Regional_Indicator".getBytes();
        static final byte[] Extended_Pictographic = "Extended_Pictographic".getBytes();
        static final byte[] Grapheme_Cluster_Break_SpacingMark = "Grapheme_Cluster_Break=SpacingMark".getBytes();

        private GraphemeNames() {
        }
    }
}

