/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.AbstractLivelinessMonitor;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;

public class TaskAttemptFinishingMonitor
extends AbstractLivelinessMonitor<TaskAttemptId> {
    private EventHandler eventHandler;

    public TaskAttemptFinishingMonitor(EventHandler eventHandler) {
        super("TaskAttemptFinishingMonitor", (Clock)SystemClock.getInstance());
        this.eventHandler = eventHandler;
    }

    public void init(Configuration conf) {
        super.init(conf);
        int expireIntvl = conf.getInt("mapreduce.task.exit.timeout", 60000);
        int checkIntvl = conf.getInt("mapreduce.task.exit.timeout.check-interval-ms", 20000);
        this.setExpireInterval(expireIntvl);
        this.setMonitorInterval(checkIntvl);
    }

    protected void expire(TaskAttemptId id) {
        this.eventHandler.handle((Event)new TaskAttemptEvent(id, TaskAttemptEventType.TA_TIMED_OUT));
    }
}

