/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.hbase.thrift.generated.AlreadyExists;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.thrift.generated.Mutation;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.hadoop.hbase.util.ClientUtils;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DemoClient {
    protected static int port;
    protected static String host;
    private static boolean secure;
    private static String serverPrincipal;

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 4 || args.length > 2 && !DemoClient.isBoolean(args[2])) {
            System.out.println("Invalid arguments!");
            System.out.println("Usage: DemoClient host port [secure=false [server-principal=hbase] ]");
            System.exit(-1);
        }
        port = Integer.parseInt(args[1]);
        host = args[0];
        if (args.length > 2) {
            secure = Boolean.parseBoolean(args[2]);
        }
        if (args.length == 4) {
            serverPrincipal = args[3];
        }
        final DemoClient client = new DemoClient();
        Subject.doAs(DemoClient.getSubject(), new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                client.run();
                return null;
            }
        });
    }

    private static boolean isBoolean(String s) {
        return Boolean.TRUE.toString().equalsIgnoreCase(s) || Boolean.FALSE.toString().equalsIgnoreCase(s);
    }

    DemoClient() {
    }

    private byte[] bytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void run() throws Exception {
        List entry;
        TSocket transport = new TSocket(host, port);
        if (secure) {
            HashMap<String, String> saslProperties = new HashMap<String, String>();
            saslProperties.put("javax.security.sasl.qop", "auth-conf,auth-int,auth");
            transport = new TSaslClientTransport("GSSAPI", null, serverPrincipal, host, saslProperties, null, (TTransport)transport);
        }
        transport.open();
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport, true, true);
        Hbase.Client client = new Hbase.Client((TProtocol)protocol);
        ByteBuffer demoTable = ByteBuffer.wrap(this.bytes("demo_table"));
        ByteBuffer disabledTable = ByteBuffer.wrap(this.bytes("disabled_table"));
        System.out.println("scanning tables...");
        for (ByteBuffer name : client.getTableNames()) {
            System.out.println("  found: " + ClientUtils.utf8(name.array()));
            if (!name.equals(demoTable) && !name.equals(disabledTable)) continue;
            if (client.isTableEnabled(name)) {
                System.out.println("    disabling table: " + ClientUtils.utf8(name.array()));
                client.disableTable(name);
            }
            System.out.println("    deleting table: " + ClientUtils.utf8(name.array()));
            client.deleteTable(name);
        }
        ArrayList<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>(2);
        ColumnDescriptor col = new ColumnDescriptor();
        col.name = ByteBuffer.wrap(this.bytes("entry:"));
        col.timeToLive = Integer.MAX_VALUE;
        col.maxVersions = 10;
        columns.add(col);
        col = new ColumnDescriptor();
        col.name = ByteBuffer.wrap(this.bytes("unused:"));
        col.timeToLive = Integer.MAX_VALUE;
        columns.add(col);
        System.out.println("creating table: " + ClientUtils.utf8(demoTable.array()));
        try {
            client.createTable(demoTable, columns);
            client.createTable(disabledTable, columns);
        }
        catch (AlreadyExists ae) {
            System.out.println("WARN: " + ae.message);
        }
        System.out.println("column families in " + ClientUtils.utf8(demoTable.array()) + ": ");
        Map columnMap = client.getColumnDescriptors(demoTable);
        for (Object col2 : columnMap.values()) {
            System.out.println("  column: " + ClientUtils.utf8(((ColumnDescriptor)col2).name.array()) + ", maxVer: " + ((ColumnDescriptor)col2).maxVersions);
        }
        if (client.isTableEnabled(disabledTable)) {
            System.out.println("disabling table: " + ClientUtils.utf8(disabledTable.array()));
            client.disableTable(disabledTable);
        }
        System.out.println("list tables with enabled statuses : ");
        Map statusMap = client.getTableNamesWithIsTableEnabled();
        for (Map.Entry entry2 : statusMap.entrySet()) {
            System.out.println(" Table: " + ClientUtils.utf8(((ByteBuffer)entry2.getKey()).array()) + ", is enabled: " + entry2.getValue());
        }
        Map dummyAttributes = null;
        boolean bl = false;
        byte[] invalid = new byte[]{102, 111, 111, 45, -4, -95, -95, -95, -95};
        byte[] valid = new byte[]{102, 111, 111, 45, -25, -108, -97, -29, -125, -109, -29, -125, -68, -29, -125, -85};
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(1);
        mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:foo")), ByteBuffer.wrap(invalid), bl));
        client.mutateRow(demoTable, ByteBuffer.wrap(this.bytes("foo")), mutations, dummyAttributes);
        mutations = new ArrayList(1);
        mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:foo")), ByteBuffer.wrap(valid), bl));
        client.mutateRow(demoTable, ByteBuffer.wrap(valid), mutations, dummyAttributes);
        mutations = new ArrayList(1);
        mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:foo")), ByteBuffer.wrap(invalid), bl));
        client.mutateRow(demoTable, ByteBuffer.wrap(invalid), mutations, dummyAttributes);
        ArrayList<ByteBuffer> columnNames = new ArrayList<ByteBuffer>();
        columnNames.add(ByteBuffer.wrap(this.bytes("entry:")));
        System.out.println("Starting scanner...");
        int scanner = client.scannerOpen(demoTable, ByteBuffer.wrap(this.bytes("")), columnNames, dummyAttributes);
        while (!(entry = client.scannerGet(scanner)).isEmpty()) {
            this.printRow(entry);
        }
        for (int i = 100; i >= 0; --i) {
            List result;
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumIntegerDigits(5);
            nf.setGroupingUsed(false);
            byte[] row = this.bytes(nf.format(i));
            mutations = new ArrayList(1);
            mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("unused:")), ByteBuffer.wrap(this.bytes("DELETE_ME")), bl));
            client.mutateRow(demoTable, ByteBuffer.wrap(row), mutations, dummyAttributes);
            this.printRow(client.getRow(demoTable, ByteBuffer.wrap(row), dummyAttributes));
            client.deleteAllRow(demoTable, ByteBuffer.wrap(row), dummyAttributes);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            mutations = new ArrayList(2);
            mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:num")), ByteBuffer.wrap(this.bytes("0")), bl));
            mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:foo")), ByteBuffer.wrap(this.bytes("FOO")), bl));
            client.mutateRow(demoTable, ByteBuffer.wrap(row), mutations, dummyAttributes);
            this.printRow(client.getRow(demoTable, ByteBuffer.wrap(row), dummyAttributes));
            mutations = new ArrayList(2);
            Mutation m = new Mutation();
            m.column = ByteBuffer.wrap(this.bytes("entry:foo"));
            m.isDelete = true;
            mutations.add(m);
            m = new Mutation();
            m.column = ByteBuffer.wrap(this.bytes("entry:num"));
            m.value = ByteBuffer.wrap(this.bytes("-1"));
            mutations.add(m);
            client.mutateRow(demoTable, ByteBuffer.wrap(row), mutations, dummyAttributes);
            this.printRow(client.getRow(demoTable, ByteBuffer.wrap(row), dummyAttributes));
            mutations = new ArrayList();
            mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:num")), ByteBuffer.wrap(this.bytes(Integer.toString(i))), bl));
            mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:sqr")), ByteBuffer.wrap(this.bytes(Integer.toString(i * i))), bl));
            client.mutateRow(demoTable, ByteBuffer.wrap(row), mutations, dummyAttributes);
            this.printRow(client.getRow(demoTable, ByteBuffer.wrap(row), dummyAttributes));
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            mutations.clear();
            m = new Mutation();
            m.column = ByteBuffer.wrap(this.bytes("entry:num"));
            m.value = ByteBuffer.wrap(this.bytes("-999"));
            mutations.add(m);
            m = new Mutation();
            m.column = ByteBuffer.wrap(this.bytes("entry:sqr"));
            m.isDelete = true;
            client.mutateRowTs(demoTable, ByteBuffer.wrap(row), mutations, 1L, dummyAttributes);
            this.printRow(client.getRow(demoTable, ByteBuffer.wrap(row), dummyAttributes));
            List versions = client.getVer(demoTable, ByteBuffer.wrap(row), ByteBuffer.wrap(this.bytes("entry:num")), 10, dummyAttributes);
            this.printVersions(ByteBuffer.wrap(row), versions);
            if (versions.isEmpty()) {
                System.out.println("FATAL: wrong # of versions");
                System.exit(-1);
            }
            if (!(result = client.get(demoTable, ByteBuffer.wrap(row), ByteBuffer.wrap(this.bytes("entry:foo")), dummyAttributes)).isEmpty()) {
                System.out.println("FATAL: shouldn't get here");
                System.exit(-1);
            }
            System.out.println("");
        }
        columnNames.clear();
        for (ColumnDescriptor col2 : client.getColumnDescriptors(demoTable).values()) {
            System.out.println("column with name: " + new String(col2.name.array()));
            System.out.println(col2.toString());
            columnNames.add(col2.name);
        }
        System.out.println("Starting scanner...");
        scanner = client.scannerOpenWithStop(demoTable, ByteBuffer.wrap(this.bytes("00020")), ByteBuffer.wrap(this.bytes("00040")), columnNames, dummyAttributes);
        while (true) {
            if ((entry = client.scannerGet(scanner)).isEmpty()) break;
            this.printRow(entry);
        }
        System.out.println("Scanner finished");
        transport.close();
    }

    private void printVersions(ByteBuffer row, List<TCell> versions) {
        StringBuilder rowStr = new StringBuilder();
        for (TCell cell : versions) {
            rowStr.append(ClientUtils.utf8(cell.value.array()));
            rowStr.append("; ");
        }
        System.out.println("row: " + ClientUtils.utf8(row.array()) + ", values: " + rowStr);
    }

    private void printRow(TRowResult rowResult) {
        ClientUtils.printRow(rowResult);
    }

    private void printRow(List<TRowResult> rows) {
        for (TRowResult rowResult : rows) {
            this.printRow(rowResult);
        }
    }

    static Subject getSubject() throws Exception {
        if (!secure) {
            return new Subject();
        }
        LoginContext context = ClientUtils.getLoginContext();
        context.login();
        return context.getSubject();
    }

    static {
        secure = false;
        serverPrincipal = "hbase";
    }
}

