/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.StartContainerRequestPBImpl;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnSecurityTokenProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.impl.pb.MasterKeyPBImpl;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ResourceMappings;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;
import org.fusesource.leveldbjni.JniDBFactory;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMLeveldbStateStoreService
extends NMStateStoreService {
    public static final Logger LOG = LoggerFactory.getLogger(NMLeveldbStateStoreService.class);
    private static final String DB_NAME = "yarn-nm-state";
    private static final String DB_SCHEMA_VERSION_KEY = "nm-schema-version";
    private static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)2);
    private static final String DELETION_TASK_KEY_PREFIX = "DeletionService/deltask_";
    private static final String APPLICATIONS_KEY_PREFIX = "ContainerManager/applications/";
    @Deprecated
    private static final String FINISHED_APPS_KEY_PREFIX = "ContainerManager/finishedApps/";
    private static final String LOCALIZATION_KEY_PREFIX = "Localization/";
    private static final String LOCALIZATION_PUBLIC_KEY_PREFIX = "Localization/public/";
    private static final String LOCALIZATION_PRIVATE_KEY_PREFIX = "Localization/private/";
    private static final String LOCALIZATION_STARTED_SUFFIX = "started/";
    private static final String LOCALIZATION_COMPLETED_SUFFIX = "completed/";
    private static final String LOCALIZATION_FILECACHE_SUFFIX = "filecache/";
    private static final String LOCALIZATION_APPCACHE_SUFFIX = "appcache/";
    private static final String CONTAINERS_KEY_PREFIX = "ContainerManager/containers/";
    private static final String CONTAINER_REQUEST_KEY_SUFFIX = "/request";
    private static final String CONTAINER_VERSION_KEY_SUFFIX = "/version";
    private static final String CONTAINER_START_TIME_KEY_SUFFIX = "/starttime";
    private static final String CONTAINER_DIAGS_KEY_SUFFIX = "/diagnostics";
    private static final String CONTAINER_LAUNCHED_KEY_SUFFIX = "/launched";
    private static final String CONTAINER_QUEUED_KEY_SUFFIX = "/queued";
    private static final String CONTAINER_PAUSED_KEY_SUFFIX = "/paused";
    private static final String CONTAINER_UPDATE_TOKEN_SUFFIX = "/updateToken";
    private static final String CONTAINER_KILLED_KEY_SUFFIX = "/killed";
    private static final String CONTAINER_EXIT_CODE_KEY_SUFFIX = "/exitcode";
    private static final String CONTAINER_REMAIN_RETRIES_KEY_SUFFIX = "/remainingRetryAttempts";
    private static final String CONTAINER_WORK_DIR_KEY_SUFFIX = "/workdir";
    private static final String CONTAINER_LOG_DIR_KEY_SUFFIX = "/logdir";
    private static final String CURRENT_MASTER_KEY_SUFFIX = "CurrentMasterKey";
    private static final String PREV_MASTER_KEY_SUFFIX = "PreviousMasterKey";
    private static final String NEXT_MASTER_KEY_SUFFIX = "NextMasterKey";
    private static final String NM_TOKENS_KEY_PREFIX = "NMTokens/";
    private static final String NM_TOKENS_CURRENT_MASTER_KEY = "NMTokens/CurrentMasterKey";
    private static final String NM_TOKENS_PREV_MASTER_KEY = "NMTokens/PreviousMasterKey";
    private static final String CONTAINER_TOKENS_KEY_PREFIX = "ContainerTokens/";
    private static final String CONTAINER_TOKENS_CURRENT_MASTER_KEY = "ContainerTokens/CurrentMasterKey";
    private static final String CONTAINER_TOKENS_PREV_MASTER_KEY = "ContainerTokens/PreviousMasterKey";
    private static final String LOG_DELETER_KEY_PREFIX = "LogDeleters/";
    private static final String AMRMPROXY_KEY_PREFIX = "AMRMProxy/";
    private static final String CONTAINER_ASSIGNED_RESOURCES_KEY_SUFFIX = "/assignedResources_";
    private static final byte[] EMPTY_VALUE = new byte[0];
    private DB db;
    private boolean isNewlyCreated;
    private boolean isHealthy;
    private Timer compactionTimer;
    private ListMultimap<ContainerId, String> containerUnknownKeySuffixes = ArrayListMultimap.create();

    public NMLeveldbStateStoreService() {
        super(NMLeveldbStateStoreService.class.getName());
    }

    @Override
    protected void startStorage() throws IOException {
        this.isHealthy = true;
    }

    @Override
    protected void closeStorage() throws IOException {
        if (this.compactionTimer != null) {
            this.compactionTimer.cancel();
            this.compactionTimer = null;
        }
        if (this.db != null) {
            this.db.close();
        }
    }

    @Override
    public boolean isNewlyCreated() {
        return this.isNewlyCreated;
    }

    private void markStoreUnHealthy(DBException dbErr) {
        LOG.error("Statestore exception: ", (Throwable)dbErr);
        if (!this.isHealthy) {
            return;
        }
        this.isHealthy = false;
        NodeStatusUpdater nsu = this.getNodeStatusUpdater();
        if (nsu != null) {
            nsu.reportException((Exception)((Object)dbErr));
        }
    }

    @VisibleForTesting
    boolean isHealthy() {
        return this.isHealthy;
    }

    @Override
    public List<NMStateStoreService.RecoveredContainerState> loadContainersState() throws IOException {
        ArrayList<NMStateStoreService.RecoveredContainerState> containers = new ArrayList<NMStateStoreService.RecoveredContainerState>();
        ArrayList<ContainerId> containersToRemove = new ArrayList<ContainerId>();
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)CONTAINERS_KEY_PREFIX));
            while (iter.hasNext()) {
                Map.Entry entry = iter.peekNext();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(CONTAINERS_KEY_PREFIX)) {
                    break;
                }
                int idEndPos = key.indexOf(47, CONTAINERS_KEY_PREFIX.length());
                if (idEndPos < 0) {
                    throw new IOException("Unable to determine container in key: " + key);
                }
                ContainerId containerId = ContainerId.fromString((String)key.substring(CONTAINERS_KEY_PREFIX.length(), idEndPos));
                String keyPrefix = key.substring(0, idEndPos + 1);
                NMStateStoreService.RecoveredContainerState rcs = this.loadContainerState(containerId, iter, keyPrefix);
                if (rcs.startRequest != null) {
                    containers.add(rcs);
                    continue;
                }
                containersToRemove.add(containerId);
            }
        }
        for (ContainerId containerId : containersToRemove) {
            LOG.warn("Remove container " + containerId + " with incomplete records");
            try {
                this.removeContainer(containerId);
            }
            catch (IOException e) {
                LOG.error("Unable to remove container " + containerId + " in store", (Throwable)e);
            }
        }
        return containers;
    }

    private NMStateStoreService.RecoveredContainerState loadContainerState(ContainerId containerId, LeveldbIterator iter, String keyPrefix) throws IOException {
        Map.Entry entry;
        String key;
        NMStateStoreService.RecoveredContainerState rcs = new NMStateStoreService.RecoveredContainerState();
        rcs.status = NMStateStoreService.RecoveredContainerStatus.REQUESTED;
        while (iter.hasNext() && (key = JniDBFactory.asString((byte[])((byte[])(entry = iter.peekNext()).getKey()))).startsWith(keyPrefix)) {
            iter.next();
            String suffix = key.substring(keyPrefix.length() - 1);
            if (suffix.equals(CONTAINER_REQUEST_KEY_SUFFIX)) {
                rcs.startRequest = new StartContainerRequestPBImpl(YarnServiceProtos.StartContainerRequestProto.parseFrom((byte[])((byte[])entry.getValue())));
                ContainerTokenIdentifier containerTokenIdentifier = BuilderUtils.newContainerTokenIdentifier((Token)rcs.startRequest.getContainerToken());
                rcs.capability = new ResourcePBImpl(containerTokenIdentifier.getProto().getResource());
                continue;
            }
            if (suffix.equals(CONTAINER_VERSION_KEY_SUFFIX)) {
                rcs.version = Integer.parseInt(JniDBFactory.asString((byte[])((byte[])entry.getValue())));
                continue;
            }
            if (suffix.equals(CONTAINER_START_TIME_KEY_SUFFIX)) {
                rcs.setStartTime(Long.parseLong(JniDBFactory.asString((byte[])((byte[])entry.getValue()))));
                continue;
            }
            if (suffix.equals(CONTAINER_DIAGS_KEY_SUFFIX)) {
                rcs.diagnostics = JniDBFactory.asString((byte[])((byte[])entry.getValue()));
                continue;
            }
            if (suffix.equals(CONTAINER_QUEUED_KEY_SUFFIX)) {
                if (rcs.status != NMStateStoreService.RecoveredContainerStatus.REQUESTED) continue;
                rcs.status = NMStateStoreService.RecoveredContainerStatus.QUEUED;
                continue;
            }
            if (suffix.equals(CONTAINER_PAUSED_KEY_SUFFIX)) {
                if (rcs.status != NMStateStoreService.RecoveredContainerStatus.LAUNCHED && rcs.status != NMStateStoreService.RecoveredContainerStatus.QUEUED && rcs.status != NMStateStoreService.RecoveredContainerStatus.REQUESTED) continue;
                rcs.status = NMStateStoreService.RecoveredContainerStatus.PAUSED;
                continue;
            }
            if (suffix.equals(CONTAINER_LAUNCHED_KEY_SUFFIX)) {
                if (rcs.status != NMStateStoreService.RecoveredContainerStatus.REQUESTED && rcs.status != NMStateStoreService.RecoveredContainerStatus.QUEUED && rcs.status != NMStateStoreService.RecoveredContainerStatus.PAUSED) continue;
                rcs.status = NMStateStoreService.RecoveredContainerStatus.LAUNCHED;
                continue;
            }
            if (suffix.equals(CONTAINER_KILLED_KEY_SUFFIX)) {
                rcs.killed = true;
                continue;
            }
            if (suffix.equals(CONTAINER_EXIT_CODE_KEY_SUFFIX)) {
                rcs.status = NMStateStoreService.RecoveredContainerStatus.COMPLETED;
                rcs.exitCode = Integer.parseInt(JniDBFactory.asString((byte[])((byte[])entry.getValue())));
                continue;
            }
            if (suffix.equals(CONTAINER_UPDATE_TOKEN_SUFFIX)) {
                YarnSecurityTokenProtos.ContainerTokenIdentifierProto tokenIdentifierProto = YarnSecurityTokenProtos.ContainerTokenIdentifierProto.parseFrom((byte[])((byte[])entry.getValue()));
                Token currentToken = rcs.getStartRequest().getContainerToken();
                Token updatedToken = Token.newInstance((byte[])tokenIdentifierProto.toByteArray(), (String)ContainerTokenIdentifier.KIND.toString(), (byte[])currentToken.getPassword().array(), (String)currentToken.getService());
                rcs.startRequest.setContainerToken(updatedToken);
                rcs.capability = new ResourcePBImpl(tokenIdentifierProto.getResource());
                rcs.version = tokenIdentifierProto.getVersion();
                continue;
            }
            if (suffix.equals(CONTAINER_REMAIN_RETRIES_KEY_SUFFIX)) {
                rcs.setRemainingRetryAttempts(Integer.parseInt(JniDBFactory.asString((byte[])((byte[])entry.getValue()))));
                continue;
            }
            if (suffix.equals(CONTAINER_WORK_DIR_KEY_SUFFIX)) {
                rcs.setWorkDir(JniDBFactory.asString((byte[])((byte[])entry.getValue())));
                continue;
            }
            if (suffix.equals(CONTAINER_LOG_DIR_KEY_SUFFIX)) {
                rcs.setLogDir(JniDBFactory.asString((byte[])((byte[])entry.getValue())));
                continue;
            }
            if (suffix.startsWith(CONTAINER_ASSIGNED_RESOURCES_KEY_SUFFIX)) {
                String resourceType = suffix.substring(CONTAINER_ASSIGNED_RESOURCES_KEY_SUFFIX.length());
                ResourceMappings.AssignedResources assignedResources = ResourceMappings.AssignedResources.fromBytes((byte[])entry.getValue());
                rcs.getResourceMappings().addAssignedResources(resourceType, assignedResources);
                continue;
            }
            LOG.warn("the container " + containerId + " will be killed because of the unknown key " + key + " during recovery.");
            this.containerUnknownKeySuffixes.put((Object)containerId, (Object)suffix);
            rcs.setRecoveryType(NMStateStoreService.RecoveredContainerType.KILL);
        }
        return rcs;
    }

    @Override
    public void storeContainer(ContainerId containerId, int containerVersion, long startTime, StartContainerRequest startRequest) throws IOException {
        String idStr = containerId.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("storeContainer: containerId= " + idStr + ", startRequest= " + startRequest);
        }
        String keyVersion = this.getContainerVersionKey(idStr);
        String keyRequest = this.getContainerKey(idStr, CONTAINER_REQUEST_KEY_SUFFIX);
        YarnServiceProtos.StartContainerRequestProto startContainerRequest = ((StartContainerRequestPBImpl)startRequest).getProto();
        String keyStartTime = this.getContainerKey(idStr, CONTAINER_START_TIME_KEY_SUFFIX);
        String startTimeValue = Long.toString(startTime);
        try (WriteBatch batch = this.db.createWriteBatch();){
            batch.put(JniDBFactory.bytes((String)keyRequest), startContainerRequest.toByteArray());
            batch.put(JniDBFactory.bytes((String)keyStartTime), JniDBFactory.bytes((String)startTimeValue));
            if (containerVersion != 0) {
                batch.put(JniDBFactory.bytes((String)keyVersion), JniDBFactory.bytes((String)Integer.toString(containerVersion)));
            }
            this.db.write(batch);
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    String getContainerVersionKey(String containerId) {
        return this.getContainerKey(containerId, CONTAINER_VERSION_KEY_SUFFIX);
    }

    private String getContainerKey(String containerId, String suffix) {
        return CONTAINERS_KEY_PREFIX + containerId + suffix;
    }

    @Override
    public void storeContainerQueued(ContainerId containerId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("storeContainerQueued: containerId=" + containerId);
        }
        String key = CONTAINERS_KEY_PREFIX + containerId.toString() + CONTAINER_QUEUED_KEY_SUFFIX;
        try {
            this.db.put(JniDBFactory.bytes((String)key), EMPTY_VALUE);
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    private void removeContainerQueued(ContainerId containerId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("removeContainerQueued: containerId=" + containerId);
        }
        String key = CONTAINERS_KEY_PREFIX + containerId.toString() + CONTAINER_QUEUED_KEY_SUFFIX;
        try {
            this.db.delete(JniDBFactory.bytes((String)key));
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void storeContainerPaused(ContainerId containerId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("storeContainerPaused: containerId=" + containerId);
        }
        String key = CONTAINERS_KEY_PREFIX + containerId.toString() + CONTAINER_PAUSED_KEY_SUFFIX;
        try {
            this.db.put(JniDBFactory.bytes((String)key), EMPTY_VALUE);
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void removeContainerPaused(ContainerId containerId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("removeContainerPaused: containerId=" + containerId);
        }
        String key = CONTAINERS_KEY_PREFIX + containerId.toString() + CONTAINER_PAUSED_KEY_SUFFIX;
        try {
            this.db.delete(JniDBFactory.bytes((String)key));
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void storeContainerDiagnostics(ContainerId containerId, StringBuilder diagnostics) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("storeContainerDiagnostics: containerId=" + containerId + ", diagnostics=" + diagnostics);
        }
        String key = CONTAINERS_KEY_PREFIX + containerId.toString() + CONTAINER_DIAGS_KEY_SUFFIX;
        try {
            this.db.put(JniDBFactory.bytes((String)key), JniDBFactory.bytes((String)diagnostics.toString()));
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void storeContainerLaunched(ContainerId containerId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("storeContainerLaunched: containerId=" + containerId);
        }
        this.removeContainerQueued(containerId);
        String key = CONTAINERS_KEY_PREFIX + containerId.toString() + CONTAINER_LAUNCHED_KEY_SUFFIX;
        try {
            this.db.put(JniDBFactory.bytes((String)key), EMPTY_VALUE);
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeContainerUpdateToken(ContainerId containerId, ContainerTokenIdentifier containerTokenIdentifier) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("storeContainerUpdateToken: containerId=" + containerId);
        }
        String keyUpdateToken = CONTAINERS_KEY_PREFIX + containerId.toString() + CONTAINER_UPDATE_TOKEN_SUFFIX;
        String keyVersion = CONTAINERS_KEY_PREFIX + containerId.toString() + CONTAINER_VERSION_KEY_SUFFIX;
        try (WriteBatch batch = this.db.createWriteBatch();){
            batch.put(JniDBFactory.bytes((String)keyUpdateToken), containerTokenIdentifier.getProto().toByteArray());
            batch.put(JniDBFactory.bytes((String)keyVersion), JniDBFactory.bytes((String)Integer.toString(containerTokenIdentifier.getVersion())));
            this.db.write(batch);
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void storeContainerKilled(ContainerId containerId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("storeContainerKilled: containerId=" + containerId);
        }
        String key = CONTAINERS_KEY_PREFIX + containerId.toString() + CONTAINER_KILLED_KEY_SUFFIX;
        try {
            this.db.put(JniDBFactory.bytes((String)key), EMPTY_VALUE);
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void storeContainerCompleted(ContainerId containerId, int exitCode) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("storeContainerCompleted: containerId=" + containerId);
        }
        String key = CONTAINERS_KEY_PREFIX + containerId.toString() + CONTAINER_EXIT_CODE_KEY_SUFFIX;
        try {
            this.db.put(JniDBFactory.bytes((String)key), JniDBFactory.bytes((String)Integer.toString(exitCode)));
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void storeContainerRemainingRetryAttempts(ContainerId containerId, int remainingRetryAttempts) throws IOException {
        String key = CONTAINERS_KEY_PREFIX + containerId.toString() + CONTAINER_REMAIN_RETRIES_KEY_SUFFIX;
        try {
            this.db.put(JniDBFactory.bytes((String)key), JniDBFactory.bytes((String)Integer.toString(remainingRetryAttempts)));
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void storeContainerWorkDir(ContainerId containerId, String workDir) throws IOException {
        String key = CONTAINERS_KEY_PREFIX + containerId.toString() + CONTAINER_WORK_DIR_KEY_SUFFIX;
        try {
            this.db.put(JniDBFactory.bytes((String)key), JniDBFactory.bytes((String)workDir));
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void storeContainerLogDir(ContainerId containerId, String logDir) throws IOException {
        String key = CONTAINERS_KEY_PREFIX + containerId.toString() + CONTAINER_LOG_DIR_KEY_SUFFIX;
        try {
            this.db.put(JniDBFactory.bytes((String)key), JniDBFactory.bytes((String)logDir));
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContainer(ContainerId containerId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("removeContainer: containerId=" + containerId);
        }
        String keyPrefix = CONTAINERS_KEY_PREFIX + containerId.toString();
        try (WriteBatch batch = this.db.createWriteBatch();){
            batch.delete(JniDBFactory.bytes((String)(keyPrefix + CONTAINER_REQUEST_KEY_SUFFIX)));
            batch.delete(JniDBFactory.bytes((String)(keyPrefix + CONTAINER_DIAGS_KEY_SUFFIX)));
            batch.delete(JniDBFactory.bytes((String)(keyPrefix + CONTAINER_LAUNCHED_KEY_SUFFIX)));
            batch.delete(JniDBFactory.bytes((String)(keyPrefix + CONTAINER_QUEUED_KEY_SUFFIX)));
            batch.delete(JniDBFactory.bytes((String)(keyPrefix + CONTAINER_PAUSED_KEY_SUFFIX)));
            batch.delete(JniDBFactory.bytes((String)(keyPrefix + CONTAINER_KILLED_KEY_SUFFIX)));
            batch.delete(JniDBFactory.bytes((String)(keyPrefix + CONTAINER_EXIT_CODE_KEY_SUFFIX)));
            batch.delete(JniDBFactory.bytes((String)(keyPrefix + CONTAINER_UPDATE_TOKEN_SUFFIX)));
            List unknownKeysForContainer = this.containerUnknownKeySuffixes.removeAll((Object)containerId);
            for (String unknownKeySuffix : unknownKeysForContainer) {
                batch.delete(JniDBFactory.bytes((String)(keyPrefix + unknownKeySuffix)));
            }
            this.db.write(batch);
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public NMStateStoreService.RecoveredApplicationsState loadApplicationsState() throws IOException {
        NMStateStoreService.RecoveredApplicationsState state = new NMStateStoreService.RecoveredApplicationsState();
        state.applications = new ArrayList<YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto>();
        String keyPrefix = APPLICATIONS_KEY_PREFIX;
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)keyPrefix));
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(keyPrefix)) {
                    break;
                }
                state.applications.add(YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto.parseFrom((byte[])entry.getValue()));
            }
        }
        this.cleanupDeprecatedFinishedApps();
        return state;
    }

    @Override
    public void storeApplication(ApplicationId appId, YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto p) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("storeApplication: appId=" + appId + ", proto=" + p);
        }
        String key = APPLICATIONS_KEY_PREFIX + appId;
        try {
            this.db.put(JniDBFactory.bytes((String)key), p.toByteArray());
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplication(ApplicationId appId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("removeApplication: appId=" + appId);
        }
        try (WriteBatch batch = this.db.createWriteBatch();){
            String key = APPLICATIONS_KEY_PREFIX + appId;
            batch.delete(JniDBFactory.bytes((String)key));
            this.db.write(batch);
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public NMStateStoreService.RecoveredLocalizationState loadLocalizationState() throws IOException {
        NMStateStoreService.RecoveredLocalizationState state = new NMStateStoreService.RecoveredLocalizationState();
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)LOCALIZATION_PUBLIC_KEY_PREFIX));
            state.publicTrackerState = this.loadResourceTrackerState(iter, LOCALIZATION_PUBLIC_KEY_PREFIX);
            iter.seek(JniDBFactory.bytes((String)LOCALIZATION_PRIVATE_KEY_PREFIX));
            while (iter.hasNext()) {
                Map.Entry entry = iter.peekNext();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(LOCALIZATION_PRIVATE_KEY_PREFIX)) {
                    break;
                }
                int userEndPos = key.indexOf(47, LOCALIZATION_PRIVATE_KEY_PREFIX.length());
                if (userEndPos < 0) {
                    throw new IOException("Unable to determine user in resource key: " + key);
                }
                String user = key.substring(LOCALIZATION_PRIVATE_KEY_PREFIX.length(), userEndPos);
                state.userResources.put(user, this.loadUserLocalizedResources(iter, key.substring(0, userEndPos + 1)));
            }
        }
        return state;
    }

    private NMStateStoreService.LocalResourceTrackerState loadResourceTrackerState(LeveldbIterator iter, String keyPrefix) throws IOException {
        Map.Entry entry;
        String key;
        String completedPrefix = keyPrefix + LOCALIZATION_COMPLETED_SUFFIX;
        String startedPrefix = keyPrefix + LOCALIZATION_STARTED_SUFFIX;
        NMStateStoreService.LocalResourceTrackerState state = new NMStateStoreService.LocalResourceTrackerState();
        while (iter.hasNext() && (key = JniDBFactory.asString((byte[])((byte[])(entry = iter.peekNext()).getKey()))).startsWith(keyPrefix)) {
            if (key.startsWith(completedPrefix)) {
                state.localizedResources = this.loadCompletedResources(iter, completedPrefix);
                continue;
            }
            if (key.startsWith(startedPrefix)) {
                state.inProgressResources = this.loadStartedResources(iter, startedPrefix);
                continue;
            }
            throw new IOException("Unexpected key in resource tracker state: " + key);
        }
        return state;
    }

    private List<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto> loadCompletedResources(LeveldbIterator iter, String keyPrefix) throws IOException {
        Map.Entry entry;
        String key;
        ArrayList<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto> rsrcs = new ArrayList<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto>();
        while (iter.hasNext() && (key = JniDBFactory.asString((byte[])((byte[])(entry = iter.peekNext()).getKey()))).startsWith(keyPrefix)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading completed resource from " + key);
            }
            rsrcs.add(YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto.parseFrom((byte[])entry.getValue()));
            iter.next();
        }
        return rsrcs;
    }

    private Map<YarnProtos.LocalResourceProto, Path> loadStartedResources(LeveldbIterator iter, String keyPrefix) throws IOException {
        Map.Entry entry;
        String key;
        HashMap<YarnProtos.LocalResourceProto, Path> rsrcs = new HashMap<YarnProtos.LocalResourceProto, Path>();
        while (iter.hasNext() && (key = JniDBFactory.asString((byte[])((byte[])(entry = iter.peekNext()).getKey()))).startsWith(keyPrefix)) {
            Path localPath = new Path(key.substring(keyPrefix.length()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading in-progress resource at " + localPath);
            }
            rsrcs.put(YarnProtos.LocalResourceProto.parseFrom((byte[])((byte[])entry.getValue())), localPath);
            iter.next();
        }
        return rsrcs;
    }

    private NMStateStoreService.RecoveredUserResources loadUserLocalizedResources(LeveldbIterator iter, String keyPrefix) throws IOException {
        Map.Entry entry;
        String key;
        NMStateStoreService.RecoveredUserResources userResources = new NMStateStoreService.RecoveredUserResources();
        while (iter.hasNext() && (key = JniDBFactory.asString((byte[])((byte[])(entry = iter.peekNext()).getKey()))).startsWith(keyPrefix)) {
            if (key.startsWith(LOCALIZATION_FILECACHE_SUFFIX, keyPrefix.length())) {
                userResources.privateTrackerState = this.loadResourceTrackerState(iter, keyPrefix + LOCALIZATION_FILECACHE_SUFFIX);
                continue;
            }
            if (key.startsWith(LOCALIZATION_APPCACHE_SUFFIX, keyPrefix.length())) {
                int appIdStartPos = keyPrefix.length() + LOCALIZATION_APPCACHE_SUFFIX.length();
                int appIdEndPos = key.indexOf(47, appIdStartPos);
                if (appIdEndPos < 0) {
                    throw new IOException("Unable to determine appID in resource key: " + key);
                }
                ApplicationId appId = ApplicationId.fromString((String)key.substring(appIdStartPos, appIdEndPos));
                userResources.appTrackerStates.put(appId, this.loadResourceTrackerState(iter, key.substring(0, appIdEndPos + 1)));
                continue;
            }
            throw new IOException("Unexpected user resource key " + key);
        }
        return userResources;
    }

    @Override
    public void startResourceLocalization(String user, ApplicationId appId, YarnProtos.LocalResourceProto proto, Path localPath) throws IOException {
        String key = this.getResourceStartedKey(user, appId, localPath.toString());
        try {
            this.db.put(JniDBFactory.bytes((String)key), proto.toByteArray());
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishResourceLocalization(String user, ApplicationId appId, YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto proto) throws IOException {
        String localPath = proto.getLocalPath();
        String startedKey = this.getResourceStartedKey(user, appId, localPath);
        String completedKey = this.getResourceCompletedKey(user, appId, localPath);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing localized resource to " + completedKey);
        }
        try (WriteBatch batch = this.db.createWriteBatch();){
            batch.delete(JniDBFactory.bytes((String)startedKey));
            batch.put(JniDBFactory.bytes((String)completedKey), proto.toByteArray());
            this.db.write(batch);
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocalizedResource(String user, ApplicationId appId, Path localPath) throws IOException {
        String localPathStr = localPath.toString();
        String startedKey = this.getResourceStartedKey(user, appId, localPathStr);
        String completedKey = this.getResourceCompletedKey(user, appId, localPathStr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing local resource at " + localPathStr);
        }
        try (WriteBatch batch = this.db.createWriteBatch();){
            batch.delete(JniDBFactory.bytes((String)startedKey));
            batch.delete(JniDBFactory.bytes((String)completedKey));
            this.db.write(batch);
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    private String getResourceStartedKey(String user, ApplicationId appId, String localPath) {
        return this.getResourceTrackerKeyPrefix(user, appId) + LOCALIZATION_STARTED_SUFFIX + localPath;
    }

    private String getResourceCompletedKey(String user, ApplicationId appId, String localPath) {
        return this.getResourceTrackerKeyPrefix(user, appId) + LOCALIZATION_COMPLETED_SUFFIX + localPath;
    }

    private String getResourceTrackerKeyPrefix(String user, ApplicationId appId) {
        if (user == null) {
            return LOCALIZATION_PUBLIC_KEY_PREFIX;
        }
        if (appId == null) {
            return LOCALIZATION_PRIVATE_KEY_PREFIX + user + "/" + LOCALIZATION_FILECACHE_SUFFIX;
        }
        return LOCALIZATION_PRIVATE_KEY_PREFIX + user + "/" + LOCALIZATION_APPCACHE_SUFFIX + appId + "/";
    }

    @Override
    public NMStateStoreService.RecoveredDeletionServiceState loadDeletionServiceState() throws IOException {
        NMStateStoreService.RecoveredDeletionServiceState state = new NMStateStoreService.RecoveredDeletionServiceState();
        state.tasks = new ArrayList<YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto>();
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)DELETION_TASK_KEY_PREFIX));
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(DELETION_TASK_KEY_PREFIX)) {
                    break;
                }
                state.tasks.add(YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto.parseFrom((byte[])entry.getValue()));
            }
        }
        return state;
    }

    @Override
    public void storeDeletionTask(int taskId, YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto taskProto) throws IOException {
        String key = DELETION_TASK_KEY_PREFIX + taskId;
        try {
            this.db.put(JniDBFactory.bytes((String)key), taskProto.toByteArray());
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void removeDeletionTask(int taskId) throws IOException {
        String key = DELETION_TASK_KEY_PREFIX + taskId;
        try {
            this.db.delete(JniDBFactory.bytes((String)key));
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public NMStateStoreService.RecoveredNMTokensState loadNMTokensState() throws IOException {
        NMStateStoreService.RecoveredNMTokensState state = new NMStateStoreService.RecoveredNMTokensState();
        state.applicationMasterKeys = new HashMap<ApplicationAttemptId, MasterKey>();
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)NM_TOKENS_KEY_PREFIX));
            while (iter.hasNext()) {
                ApplicationAttemptId attempt;
                Map.Entry entry = iter.next();
                String fullKey = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!fullKey.startsWith(NM_TOKENS_KEY_PREFIX)) {
                    break;
                }
                String key = fullKey.substring(NM_TOKENS_KEY_PREFIX.length());
                if (key.equals(CURRENT_MASTER_KEY_SUFFIX)) {
                    state.currentMasterKey = this.parseMasterKey((byte[])entry.getValue());
                    continue;
                }
                if (key.equals(PREV_MASTER_KEY_SUFFIX)) {
                    state.previousMasterKey = this.parseMasterKey((byte[])entry.getValue());
                    continue;
                }
                if (!key.startsWith("appattempt")) continue;
                try {
                    attempt = ApplicationAttemptId.fromString((String)key);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Bad application master key state for " + fullKey, e);
                }
                state.applicationMasterKeys.put(attempt, this.parseMasterKey((byte[])entry.getValue()));
            }
        }
        return state;
    }

    @Override
    public void storeNMTokenCurrentMasterKey(MasterKey key) throws IOException {
        this.storeMasterKey(NM_TOKENS_CURRENT_MASTER_KEY, key);
    }

    @Override
    public void storeNMTokenPreviousMasterKey(MasterKey key) throws IOException {
        this.storeMasterKey(NM_TOKENS_PREV_MASTER_KEY, key);
    }

    @Override
    public void storeNMTokenApplicationMasterKey(ApplicationAttemptId attempt, MasterKey key) throws IOException {
        this.storeMasterKey(NM_TOKENS_KEY_PREFIX + attempt, key);
    }

    @Override
    public void removeNMTokenApplicationMasterKey(ApplicationAttemptId attempt) throws IOException {
        String key = NM_TOKENS_KEY_PREFIX + attempt;
        try {
            this.db.delete(JniDBFactory.bytes((String)key));
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    private MasterKey parseMasterKey(byte[] keyData) throws IOException {
        return new MasterKeyPBImpl(YarnServerCommonProtos.MasterKeyProto.parseFrom((byte[])keyData));
    }

    private void storeMasterKey(String dbKey, MasterKey key) throws IOException {
        MasterKeyPBImpl pb = (MasterKeyPBImpl)key;
        try {
            this.db.put(JniDBFactory.bytes((String)dbKey), pb.getProto().toByteArray());
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public NMStateStoreService.RecoveredContainerTokensState loadContainerTokensState() throws IOException {
        NMStateStoreService.RecoveredContainerTokensState state = new NMStateStoreService.RecoveredContainerTokensState();
        state.activeTokens = new HashMap<ContainerId, Long>();
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)CONTAINER_TOKENS_KEY_PREFIX));
            int containerTokensKeyPrefixLength = CONTAINER_TOKENS_KEY_PREFIX.length();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String fullKey = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!fullKey.startsWith(CONTAINER_TOKENS_KEY_PREFIX)) {
                    break;
                }
                String key = fullKey.substring(containerTokensKeyPrefixLength);
                if (key.equals(CURRENT_MASTER_KEY_SUFFIX)) {
                    state.currentMasterKey = this.parseMasterKey((byte[])entry.getValue());
                    continue;
                }
                if (key.equals(PREV_MASTER_KEY_SUFFIX)) {
                    state.previousMasterKey = this.parseMasterKey((byte[])entry.getValue());
                    continue;
                }
                if (!key.startsWith("container")) continue;
                NMLeveldbStateStoreService.loadContainerToken(state, fullKey, key, (byte[])entry.getValue());
            }
        }
        return state;
    }

    private static void loadContainerToken(NMStateStoreService.RecoveredContainerTokensState state, String key, String containerIdStr, byte[] value) throws IOException {
        Long expTime;
        ContainerId containerId;
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
            expTime = Long.parseLong(JniDBFactory.asString((byte[])value));
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Bad container token state for " + key, e);
        }
        state.activeTokens.put(containerId, expTime);
    }

    @Override
    public void storeContainerTokenCurrentMasterKey(MasterKey key) throws IOException {
        this.storeMasterKey(CONTAINER_TOKENS_CURRENT_MASTER_KEY, key);
    }

    @Override
    public void storeContainerTokenPreviousMasterKey(MasterKey key) throws IOException {
        this.storeMasterKey(CONTAINER_TOKENS_PREV_MASTER_KEY, key);
    }

    @Override
    public void storeContainerToken(ContainerId containerId, Long expTime) throws IOException {
        String key = CONTAINER_TOKENS_KEY_PREFIX + containerId;
        try {
            this.db.put(JniDBFactory.bytes((String)key), JniDBFactory.bytes((String)expTime.toString()));
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void removeContainerToken(ContainerId containerId) throws IOException {
        String key = CONTAINER_TOKENS_KEY_PREFIX + containerId;
        try {
            this.db.delete(JniDBFactory.bytes((String)key));
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public NMStateStoreService.RecoveredLogDeleterState loadLogDeleterState() throws IOException {
        NMStateStoreService.RecoveredLogDeleterState state = new NMStateStoreService.RecoveredLogDeleterState();
        state.logDeleterMap = new HashMap<ApplicationId, YarnServerNodemanagerRecoveryProtos.LogDeleterProto>();
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)LOG_DELETER_KEY_PREFIX));
            int logDeleterKeyPrefixLength = LOG_DELETER_KEY_PREFIX.length();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String fullKey = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!fullKey.startsWith(LOG_DELETER_KEY_PREFIX)) {
                    break;
                }
                String appIdStr = fullKey.substring(logDeleterKeyPrefixLength);
                ApplicationId appId = null;
                try {
                    appId = ApplicationId.fromString((String)appIdStr);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Skipping unknown log deleter key " + fullKey);
                    continue;
                }
                YarnServerNodemanagerRecoveryProtos.LogDeleterProto proto = YarnServerNodemanagerRecoveryProtos.LogDeleterProto.parseFrom((byte[])entry.getValue());
                state.logDeleterMap.put(appId, proto);
            }
        }
        return state;
    }

    @Override
    public void storeLogDeleter(ApplicationId appId, YarnServerNodemanagerRecoveryProtos.LogDeleterProto proto) throws IOException {
        String key = this.getLogDeleterKey(appId);
        try {
            this.db.put(JniDBFactory.bytes((String)key), proto.toByteArray());
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void removeLogDeleter(ApplicationId appId) throws IOException {
        String key = this.getLogDeleterKey(appId);
        try {
            this.db.delete(JniDBFactory.bytes((String)key));
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeAssignedResources(Container container, String resourceType, List<Serializable> assignedResources) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("storeAssignedResources: containerId=" + container.getContainerId() + ", assignedResources=" + StringUtils.join((CharSequence)",", assignedResources));
        }
        String keyResChng = CONTAINERS_KEY_PREFIX + container.getContainerId().toString() + CONTAINER_ASSIGNED_RESOURCES_KEY_SUFFIX + resourceType;
        try (WriteBatch batch = this.db.createWriteBatch();){
            ResourceMappings.AssignedResources res = new ResourceMappings.AssignedResources();
            res.updateAssignedResources(assignedResources);
            batch.put(JniDBFactory.bytes((String)keyResChng), res.toBytes());
            this.db.write(batch);
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
        this.updateContainerResourceMapping(container, resourceType, assignedResources);
    }

    private void cleanupDeprecatedFinishedApps() {
        try {
            this.cleanupKeysWithPrefix(FINISHED_APPS_KEY_PREFIX);
        }
        catch (Exception e) {
            LOG.warn("cleanup keys with prefix ContainerManager/finishedApps/ from leveldb failed", (Throwable)e);
        }
    }

    private void cleanupKeysWithPrefix(String prefix) throws IOException {
        WriteBatch batch = null;
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            try {
                byte[] key;
                String keyStr;
                batch = this.db.createWriteBatch();
                iter.seek(JniDBFactory.bytes((String)prefix));
                while (iter.hasNext() && (keyStr = JniDBFactory.asString((byte[])(key = (byte[])iter.next().getKey()))).startsWith(prefix)) {
                    batch.delete(key);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("cleanup " + keyStr + " from leveldb");
                }
                this.db.write(batch);
            }
            catch (DBException e) {
                throw new IOException(e);
            }
            finally {
                if (batch != null) {
                    batch.close();
                }
            }
        }
    }

    private String getLogDeleterKey(ApplicationId appId) {
        return LOG_DELETER_KEY_PREFIX + appId;
    }

    @Override
    public NMStateStoreService.RecoveredAMRMProxyState loadAMRMProxyState() throws IOException {
        NMStateStoreService.RecoveredAMRMProxyState result = new NMStateStoreService.RecoveredAMRMProxyState();
        HashSet<String> unknownKeys = new HashSet<String>();
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)AMRMPROXY_KEY_PREFIX));
            while (iter.hasNext()) {
                ApplicationAttemptId attemptId;
                int idEndPos;
                Map.Entry entry = iter.peekNext();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(AMRMPROXY_KEY_PREFIX)) {
                    break;
                }
                String suffix = key.substring(AMRMPROXY_KEY_PREFIX.length());
                if (suffix.equals(CURRENT_MASTER_KEY_SUFFIX)) {
                    iter.next();
                    result.setCurrentMasterKey(this.parseMasterKey((byte[])entry.getValue()));
                    LOG.info("Recovered for AMRMProxy: current master key id " + result.getCurrentMasterKey().getKeyId());
                    continue;
                }
                if (suffix.equals(NEXT_MASTER_KEY_SUFFIX)) {
                    iter.next();
                    result.setNextMasterKey(this.parseMasterKey((byte[])entry.getValue()));
                    LOG.info("Recovered for AMRMProxy: next master key id " + result.getNextMasterKey().getKeyId());
                    continue;
                }
                try {
                    idEndPos = key.indexOf(47, AMRMPROXY_KEY_PREFIX.length());
                    if (idEndPos < 0) {
                        throw new IOException("Unable to determine attemptId in key: " + key);
                    }
                    attemptId = ApplicationAttemptId.fromString((String)key.substring(AMRMPROXY_KEY_PREFIX.length(), idEndPos));
                }
                catch (Exception e) {
                    LOG.warn("Unknown key " + key + ", remove and move on", (Throwable)e);
                    unknownKeys.add(key);
                    continue;
                }
                Map<String, byte[]> appContext = this.loadAMRMProxyAppContextMap(iter, key.substring(0, idEndPos + 1));
                result.getAppContexts().put(attemptId, appContext);
                LOG.info("Recovered for AMRMProxy: " + attemptId + ", map size " + appContext.size());
            }
        }
        try {
            for (String key : unknownKeys) {
                this.db.delete(JniDBFactory.bytes((String)key));
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        return result;
    }

    private Map<String, byte[]> loadAMRMProxyAppContextMap(LeveldbIterator iter, String keyPrefix) throws IOException {
        Map.Entry entry;
        String key;
        HashMap<String, byte[]> appContextMap = new HashMap<String, byte[]>();
        while (iter.hasNext() && (key = JniDBFactory.asString((byte[])((byte[])(entry = iter.peekNext()).getKey()))).startsWith(keyPrefix)) {
            iter.next();
            String suffix = key.substring(keyPrefix.length());
            byte[] data = (byte[])entry.getValue();
            appContextMap.put(suffix, Arrays.copyOf(data, data.length));
        }
        return appContextMap;
    }

    @Override
    public void storeAMRMProxyCurrentMasterKey(MasterKey key) throws IOException {
        this.storeMasterKey("AMRMProxy/CurrentMasterKey", key);
    }

    @Override
    public void storeAMRMProxyNextMasterKey(MasterKey key) throws IOException {
        String dbkey = "AMRMProxy/NextMasterKey";
        if (key == null) {
            try {
                this.db.delete(JniDBFactory.bytes((String)dbkey));
            }
            catch (DBException e) {
                this.markStoreUnHealthy(e);
                throw new IOException(e);
            }
            return;
        }
        this.storeMasterKey(dbkey, key);
    }

    @Override
    public void storeAMRMProxyAppContextEntry(ApplicationAttemptId attempt, String key, byte[] data) throws IOException {
        String fullkey = AMRMPROXY_KEY_PREFIX + attempt + "/" + key;
        try {
            this.db.put(JniDBFactory.bytes((String)fullkey), data);
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void removeAMRMProxyAppContextEntry(ApplicationAttemptId attempt, String key) throws IOException {
        String fullkey = AMRMPROXY_KEY_PREFIX + attempt + "/" + key;
        try {
            this.db.delete(JniDBFactory.bytes((String)fullkey));
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    public void removeAMRMProxyAppContext(ApplicationAttemptId attempt) throws IOException {
        HashSet<String> candidates = new HashSet<String>();
        String keyPrefix = AMRMPROXY_KEY_PREFIX + attempt + "/";
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)keyPrefix));
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(keyPrefix)) {
                    break;
                }
                candidates.add(key);
            }
        }
        try {
            for (String key : candidates) {
                this.db.delete(JniDBFactory.bytes((String)key));
            }
        }
        catch (DBException e) {
            this.markStoreUnHealthy(e);
            throw new IOException(e);
        }
    }

    @Override
    protected void initStorage(Configuration conf) throws IOException {
        this.db = this.openDatabase(conf);
        this.checkVersion();
        this.startCompactionTimer(conf);
    }

    protected DB openDatabase(Configuration conf) throws IOException {
        Path storeRoot = this.createStorageDir(conf);
        Options options = new Options();
        options.createIfMissing(false);
        LOG.info("Using state database at " + storeRoot + " for recovery");
        File dbfile = new File(storeRoot.toString());
        try {
            this.db = JniDBFactory.factory.open(dbfile, options);
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                LOG.info("Creating state database at " + dbfile);
                this.isNewlyCreated = true;
                options.createIfMissing(true);
                try {
                    this.db = JniDBFactory.factory.open(dbfile, options);
                    this.storeVersion();
                }
                catch (DBException dbErr) {
                    throw new IOException(dbErr.getMessage(), dbErr);
                }
            }
            throw e;
        }
        return this.db;
    }

    private Path createStorageDir(Configuration conf) throws IOException {
        String storeUri = conf.get("yarn.nodemanager.recovery.dir");
        if (storeUri == null) {
            throw new IOException("No store location directory configured in yarn.nodemanager.recovery.dir");
        }
        Path root = new Path(storeUri, DB_NAME);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.mkdirs(root, new FsPermission(448));
        return root;
    }

    private void startCompactionTimer(Configuration conf) {
        long intervalMsec = conf.getLong("yarn.nodemanager.recovery.compaction-interval-secs", 3600L) * 1000L;
        if (intervalMsec > 0L) {
            this.compactionTimer = new Timer(((Object)((Object)this)).getClass().getSimpleName() + " compaction timer", true);
            this.compactionTimer.schedule((TimerTask)new CompactionTimerTask(), intervalMsec, intervalMsec);
        }
    }

    Version loadVersion() throws IOException {
        byte[] data = this.db.get(JniDBFactory.bytes((String)DB_SCHEMA_VERSION_KEY));
        if (data == null || data.length == 0) {
            return this.getCurrentVersion();
        }
        VersionPBImpl version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
        return version;
    }

    private void storeVersion() throws IOException {
        this.dbStoreVersion(CURRENT_VERSION_INFO);
    }

    @VisibleForTesting
    void storeVersion(Version state) throws IOException {
        this.dbStoreVersion(state);
    }

    private void dbStoreVersion(Version state) throws IOException {
        String key = DB_SCHEMA_VERSION_KEY;
        byte[] data = ((VersionPBImpl)state).getProto().toByteArray();
        try {
            this.db.put(JniDBFactory.bytes((String)key), data);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @VisibleForTesting
    DB getDB() {
        return this.db;
    }

    @VisibleForTesting
    void setDB(DB testDb) {
        this.db = testDb;
    }

    protected void checkVersion() throws IOException {
        Version loadedVersion = this.loadVersion();
        LOG.info("Loaded NM state version info " + loadedVersion);
        if (loadedVersion.equals((Object)this.getCurrentVersion())) {
            return;
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            throw new IOException("Incompatible version for NM state: expecting NM state version " + this.getCurrentVersion() + ", but loading version " + loadedVersion);
        }
        LOG.info("Storing NM state version info " + this.getCurrentVersion());
        this.storeVersion();
    }

    private class CompactionTimerTask
    extends TimerTask {
        private CompactionTimerTask() {
        }

        @Override
        public void run() {
            long start = Time.monotonicNow();
            LOG.info("Starting full compaction cycle");
            try {
                NMLeveldbStateStoreService.this.db.compactRange(null, null);
            }
            catch (DBException e) {
                LOG.error("Error compacting database", (Throwable)e);
            }
            long duration = Time.monotonicNow() - start;
            LOG.info("Full compaction cycle completed in " + duration + " msec");
        }
    }
}

