/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageOrBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class WALUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WALUtil.class);
    public static final String WAL_BLOCK_SIZE = "hbase.regionserver.hlog.blocksize";

    private WALUtil() {
    }

    public static WALKeyImpl writeCompactionMarker(WAL wal, NavigableMap<byte[], Integer> replicationScope, RegionInfo hri, WALProtos.CompactionDescriptor c, MultiVersionConcurrencyControl mvcc) throws IOException {
        WALKeyImpl walKey = WALUtil.writeMarker(wal, replicationScope, hri, WALEdit.createCompaction(hri, c), mvcc, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Appended compaction marker " + TextFormat.shortDebugString((MessageOrBuilder)c));
        }
        return walKey;
    }

    public static WALKeyImpl writeFlushMarker(WAL wal, NavigableMap<byte[], Integer> replicationScope, RegionInfo hri, WALProtos.FlushDescriptor f, boolean sync, MultiVersionConcurrencyControl mvcc) throws IOException {
        WALKeyImpl walKey = WALUtil.doFullMarkerAppendTransaction(wal, replicationScope, hri, WALEdit.createFlushWALEdit(hri, f), mvcc, null, sync);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Appended flush marker " + TextFormat.shortDebugString((MessageOrBuilder)f));
        }
        return walKey;
    }

    public static WALKeyImpl writeRegionEventMarker(WAL wal, NavigableMap<byte[], Integer> replicationScope, RegionInfo hri, WALProtos.RegionEventDescriptor r, MultiVersionConcurrencyControl mvcc) throws IOException {
        WALKeyImpl walKey = WALUtil.writeMarker(wal, replicationScope, hri, WALEdit.createRegionEventWALEdit(hri, r), mvcc, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Appended region event marker " + TextFormat.shortDebugString((MessageOrBuilder)r));
        }
        return walKey;
    }

    public static WALKeyImpl writeBulkLoadMarkerAndSync(WAL wal, NavigableMap<byte[], Integer> replicationScope, RegionInfo hri, WALProtos.BulkLoadDescriptor desc, MultiVersionConcurrencyControl mvcc) throws IOException {
        WALKeyImpl walKey = WALUtil.writeMarker(wal, replicationScope, hri, WALEdit.createBulkLoadEvent(hri, desc), mvcc, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Appended Bulk Load marker " + TextFormat.shortDebugString((MessageOrBuilder)desc));
        }
        return walKey;
    }

    private static WALKeyImpl writeMarker(WAL wal, NavigableMap<byte[], Integer> replicationScope, RegionInfo hri, WALEdit edit, MultiVersionConcurrencyControl mvcc, Map<String, byte[]> extendedAttributes) throws IOException {
        return WALUtil.doFullMarkerAppendTransaction(wal, replicationScope, hri, edit, mvcc, extendedAttributes, true);
    }

    private static WALKeyImpl doFullMarkerAppendTransaction(WAL wal, NavigableMap<byte[], Integer> replicationScope, RegionInfo hri, WALEdit edit, MultiVersionConcurrencyControl mvcc, Map<String, byte[]> extendedAttributes, boolean sync) throws IOException {
        WALKeyImpl walKey = new WALKeyImpl(hri.getEncodedNameAsBytes(), hri.getTable(), System.currentTimeMillis(), mvcc, replicationScope, extendedAttributes);
        long trx = -1L;
        try {
            trx = wal.appendMarker(hri, walKey, edit);
            if (sync) {
                wal.sync(trx);
            }
            mvcc.complete(walKey.getWriteEntry());
        }
        catch (IOException ioe) {
            if (walKey.getWriteEntry() != null) {
                mvcc.complete(walKey.getWriteEntry());
            }
            throw ioe;
        }
        return walKey;
    }

    public static long getWALBlockSize(Configuration conf, FileSystem fs, Path dir) throws IOException {
        return WALUtil.getWALBlockSize(conf, fs, dir, false);
    }

    public static long getWALBlockSize(Configuration conf, FileSystem fs, Path dir, boolean isRecoverEdits) throws IOException {
        long defaultBlockSize = CommonFSUtils.getDefaultBlockSize((FileSystem)fs, (Path)dir) * 2L;
        if (isRecoverEdits) {
            return conf.getLong("hbase.regionserver.recoverededits.blocksize", defaultBlockSize);
        }
        return conf.getLong(WAL_BLOCK_SIZE, defaultBlockSize);
    }

    public static void filterCells(WALEdit edit, Function<Cell, Cell> mapper) {
        int i;
        ArrayList<Cell> cells = edit.getCells();
        int size = cells.size();
        int newSize = 0;
        for (i = 0; i < size; ++i) {
            Cell cell = mapper.apply(cells.get(i));
            if (cell == null) continue;
            cells.set(newSize, cell);
            ++newSize;
        }
        for (i = size - 1; i >= newSize; --i) {
            cells.remove(i);
        }
        if (newSize < size / 2) {
            cells.trimToSize();
        }
    }
}

