/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.screen.AbstractScreenView;
import org.apache.hadoop.hbase.hbtop.screen.Screen;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.FilterDisplayModeScreenPresenter;
import org.apache.hadoop.hbase.hbtop.terminal.KeyPress;
import org.apache.hadoop.hbase.hbtop.terminal.Terminal;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FilterDisplayModeScreenView
extends AbstractScreenView {
    private final int row;
    private final FilterDisplayModeScreenPresenter filterDisplayModeScreenPresenter;

    public FilterDisplayModeScreenView(Screen screen, Terminal terminal, int row, List<RecordFilter> filters, ScreenView nextScreenView) {
        super(screen, terminal);
        this.row = row;
        this.filterDisplayModeScreenPresenter = new FilterDisplayModeScreenPresenter(this, filters, nextScreenView);
    }

    @Override
    public void init() {
        this.filterDisplayModeScreenPresenter.init();
    }

    @Override
    public ScreenView handleKeyPress(KeyPress keyPress) {
        if (keyPress.getType() == KeyPress.Type.Enter) {
            return this.filterDisplayModeScreenPresenter.returnToNextScreen();
        }
        return this;
    }

    public void showFilters(List<RecordFilter> filters) {
        String filtersString = "none";
        if (!filters.isEmpty()) {
            filtersString = String.join((CharSequence)" + ", filters.stream().map(f -> String.format("'%s'", f)).collect(Collectors.toList()));
        }
        this.getTerminalPrinter(this.row).startBold().print("<Enter> to resume, filters: " + filtersString).stopBold().endOfLine();
    }
}

