/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.replication.ChainWALEntryFilter;
import org.apache.hadoop.hbase.replication.NamespaceTableCfWALEntryFilter;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigBuilder;
import org.apache.hadoop.hbase.replication.ScopeWALEntryFilter;
import org.apache.hadoop.hbase.replication.SystemTableWALEntryFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestReplicationWALEntryFilters {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationWALEntryFilters.class);
    static byte[] a = new byte[]{97};
    static byte[] b = new byte[]{98};
    static byte[] c = new byte[]{99};
    static byte[] d = new byte[]{100};
    WALEntryFilter nullFilter = new WALEntryFilter(){

        public WAL.Entry filter(WAL.Entry entry) {
            return null;
        }
    };
    WALEntryFilter passFilter = new WALEntryFilter(){

        public WAL.Entry filter(WAL.Entry entry) {
            return entry;
        }
    };

    @Test
    public void testSystemTableWALEntryFilter() {
        SystemTableWALEntryFilter filter = new SystemTableWALEntryFilter();
        WALKeyImpl key1 = new WALKeyImpl(RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), TableName.META_TABLE_NAME, System.currentTimeMillis());
        WAL.Entry metaEntry = new WAL.Entry(key1, null);
        Assert.assertNull((Object)filter.filter(metaEntry));
        WALKeyImpl key2 = new WALKeyImpl(new byte[0], TableName.NAMESPACE_TABLE_NAME, System.currentTimeMillis());
        WAL.Entry nsEntry = new WAL.Entry(key2, null);
        Assert.assertNull((Object)filter.filter(nsEntry));
        WALKeyImpl key3 = new WALKeyImpl(new byte[0], TableName.valueOf((String)"foo"), System.currentTimeMillis());
        WAL.Entry userEntry = new WAL.Entry(key3, null);
        this.assertEquals(userEntry, filter.filter(userEntry));
        WALKeyImpl key4 = new WALKeyImpl(new byte[0], PermissionStorage.ACL_TABLE_NAME, System.currentTimeMillis());
        WAL.Entry aclEntry = new WAL.Entry(key4, null);
        this.assertEquals(aclEntry, filter.filter(aclEntry));
        WALKeyImpl key5 = new WALKeyImpl(new byte[0], VisibilityConstants.LABELS_TABLE_NAME, System.currentTimeMillis());
        WAL.Entry labelsEntry = new WAL.Entry(key5, null);
        this.assertEquals(labelsEntry, filter.filter(labelsEntry));
    }

    @Test
    public void testScopeWALEntryFilter() {
        ChainWALEntryFilter filter = new ChainWALEntryFilter(new WALEntryFilter[]{new ScopeWALEntryFilter()});
        WAL.Entry userEntry = this.createEntry(null, a, b);
        WAL.Entry userEntryA = this.createEntry(null, new byte[][]{a});
        WAL.Entry userEntryB = this.createEntry(null, new byte[][]{b});
        WAL.Entry userEntryEmpty = this.createEntry(null, new byte[0][]);
        Assert.assertTrue((boolean)filter.filter(userEntry).getEdit().isEmpty());
        TreeMap<Object, Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        userEntry = this.createEntry(scopes, a, b);
        Assert.assertTrue((boolean)filter.filter(userEntry).getEdit().isEmpty());
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(c, 1);
        userEntry = this.createEntry(scopes, a, b);
        this.assertEquals(userEntryEmpty, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(a, 0);
        userEntry = this.createEntry(scopes, a, b);
        this.assertEquals(userEntryEmpty, filter.filter(userEntry));
        scopes.put(b, 0);
        this.assertEquals(userEntryEmpty, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(a, 1);
        userEntry = this.createEntry(scopes, a, b);
        this.assertEquals(userEntryA, filter.filter(userEntry));
        scopes.put(b, 0);
        this.assertEquals(userEntryA, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(b, 1);
        userEntry = this.createEntry(scopes, a, b);
        this.assertEquals(userEntryB, filter.filter(userEntry));
        scopes.put(a, 0);
        this.assertEquals(userEntryB, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(b, 1);
        userEntry = this.createEntry(scopes, a, b);
        this.assertEquals(userEntryB, filter.filter(userEntry));
        scopes.put(a, 0);
        this.assertEquals(userEntryB, filter.filter(userEntry));
    }

    @Test
    public void testChainWALEntryFilter() {
        WAL.Entry userEntry = this.createEntry(null, a, b, c);
        ChainWALEntryFilter filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter});
        this.assertEquals(this.createEntry(null, a, b, c), filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, this.passFilter});
        this.assertEquals(this.createEntry(null, a, b, c), filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, this.passFilter, this.passFilter});
        this.assertEquals(this.createEntry(null, a, b, c), filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.nullFilter});
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.nullFilter, this.passFilter});
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, this.nullFilter});
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.nullFilter, this.passFilter, this.nullFilter});
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{this.nullFilter, this.nullFilter});
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, this.passFilter}), new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter}), new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter})}), new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter})});
        this.assertEquals(this.createEntry(null, a, b, c), filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter, new ChainWALEntryFilter(new WALEntryFilter[]{this.nullFilter})})}), new ChainWALEntryFilter(new WALEntryFilter[]{this.passFilter})});
        this.assertEquals(null, filter.filter(userEntry));
    }

    @Test
    public void testNamespaceTableCfWALEntryFilter() {
        ReplicationPeer peer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
        ReplicationPeerConfigBuilder peerConfigBuilder = ReplicationPeerConfig.newBuilder();
        peerConfigBuilder.setReplicateAllUserTables(false).setNamespaces(null).setTableCFsMap(null);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        WAL.Entry userEntry = this.createEntry(null, a, b, c);
        ChainWALEntryFilter filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(null, filter.filter(userEntry));
        userEntry = this.createEntry(null, a, b, c);
        HashMap<TableName, ArrayList> tableCfs = new HashMap<TableName, ArrayList>();
        peerConfigBuilder.setReplicateAllUserTables(false).setTableCFsMap(tableCfs);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(null, filter.filter(userEntry));
        userEntry = this.createEntry(null, a, b, c);
        tableCfs = new HashMap();
        tableCfs.put(TableName.valueOf((String)"bar"), null);
        peerConfigBuilder.setReplicateAllUserTables(false).setTableCFsMap(tableCfs);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(null, filter.filter(userEntry));
        userEntry = this.createEntry(null, a, b, c);
        tableCfs = new HashMap();
        tableCfs.put(TableName.valueOf((String)"foo"), Lists.newArrayList((Object[])new String[]{"a"}));
        peerConfigBuilder.setReplicateAllUserTables(false).setTableCFsMap(tableCfs);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(this.createEntry(null, new byte[][]{a}), filter.filter(userEntry));
        userEntry = this.createEntry(null, a, b, c, d);
        tableCfs = new HashMap();
        tableCfs.put(TableName.valueOf((String)"foo"), Lists.newArrayList((Object[])new String[]{"a", "c"}));
        peerConfigBuilder.setReplicateAllUserTables(false).setTableCFsMap(tableCfs);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(this.createEntry(null, a, c), filter.filter(userEntry));
        Mockito.when((Object)peer.getTableCFs()).thenReturn(null);
        HashSet<String> namespaces = new HashSet<String>();
        peerConfigBuilder.setReplicateAllUserTables(false).setNamespaces(namespaces).setTableCFsMap(null);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(null, filter.filter(userEntry));
        namespaces.add("default");
        peerConfigBuilder.setReplicateAllUserTables(false).setNamespaces(namespaces);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(this.createEntry(null, a, b, c), filter.filter(userEntry));
        namespaces = new HashSet();
        namespaces.add("ns1");
        peerConfigBuilder.setReplicateAllUserTables(false).setNamespaces(namespaces);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(null, filter.filter(userEntry));
        namespaces = new HashSet();
        tableCfs = new HashMap();
        namespaces.add("ns1");
        tableCfs.put(TableName.valueOf((String)"foo"), Lists.newArrayList((Object[])new String[]{"a", "c"}));
        peerConfigBuilder.setReplicateAllUserTables(false).setNamespaces(namespaces).setTableCFsMap(tableCfs);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(this.createEntry(null, a, c), filter.filter(userEntry));
        namespaces = new HashSet();
        tableCfs = new HashMap();
        namespaces.add("default");
        tableCfs.put(TableName.valueOf((String)"ns1:foo"), Lists.newArrayList((Object[])new String[]{"a", "c"}));
        peerConfigBuilder.setReplicateAllUserTables(false).setNamespaces(namespaces).setTableCFsMap(tableCfs);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(this.createEntry(null, a, b, c), filter.filter(userEntry));
        namespaces = new HashSet();
        tableCfs = new HashMap();
        namespaces.add("ns1");
        tableCfs.put(TableName.valueOf((String)"bar"), null);
        peerConfigBuilder.setReplicateAllUserTables(false).setNamespaces(namespaces).setTableCFsMap(tableCfs);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(null, filter.filter(userEntry));
    }

    @Test
    public void testNamespaceTableCfWALEntryFilter2() {
        ReplicationPeer peer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
        ReplicationPeerConfigBuilder peerConfigBuilder = ReplicationPeerConfig.newBuilder();
        peerConfigBuilder.setReplicateAllUserTables(true).setExcludeNamespaces(null).setExcludeTableCFsMap(null);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        WAL.Entry userEntry = this.createEntry(null, a, b, c);
        ChainWALEntryFilter filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(this.createEntry(null, a, b, c), filter.filter(userEntry));
        HashSet<String> namespaces = new HashSet<String>();
        peerConfigBuilder.setExcludeNamespaces(namespaces).setExcludeTableCFsMap(null);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(this.createEntry(null, a, b, c), filter.filter(userEntry));
        namespaces.add("default");
        peerConfigBuilder.setExcludeNamespaces(namespaces).setExcludeTableCFsMap(null);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(null, filter.filter(userEntry));
        namespaces = new HashSet();
        namespaces.add("ns1");
        peerConfigBuilder.setExcludeNamespaces(namespaces).setExcludeTableCFsMap(null);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(this.createEntry(null, a, b, c), filter.filter(userEntry));
        HashMap tableCfs = new HashMap();
        peerConfigBuilder.setExcludeNamespaces(null).setExcludeTableCFsMap(tableCfs);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(this.createEntry(null, a, b, c), filter.filter(userEntry));
        tableCfs = new HashMap();
        tableCfs.put(TableName.valueOf((String)"bar"), null);
        peerConfigBuilder.setExcludeNamespaces(null).setExcludeTableCFsMap(tableCfs);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(this.createEntry(null, a, b, c), filter.filter(userEntry));
        tableCfs = new HashMap();
        tableCfs.put(TableName.valueOf((String)"foo"), Lists.newArrayList((Object[])new String[]{"a"}));
        peerConfigBuilder.setExcludeNamespaces(null).setExcludeTableCFsMap(tableCfs);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(this.createEntry(null, b, c), filter.filter(userEntry));
        namespaces = new HashSet();
        tableCfs = new HashMap();
        namespaces.add("ns1");
        tableCfs.put(TableName.valueOf((String)"foo"), Lists.newArrayList((Object[])new String[]{"a", "c"}));
        peerConfigBuilder.setExcludeNamespaces(namespaces).setExcludeTableCFsMap(tableCfs);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(this.createEntry(null, new byte[][]{b}), filter.filter(userEntry));
        namespaces = new HashSet();
        tableCfs = new HashMap();
        namespaces.add("default");
        tableCfs.put(TableName.valueOf((String)"ns1:bar"), new ArrayList());
        peerConfigBuilder.setExcludeNamespaces(namespaces).setExcludeTableCFsMap(tableCfs);
        Mockito.when((Object)peer.getPeerConfig()).thenReturn((Object)peerConfigBuilder.build());
        userEntry = this.createEntry(null, a, b, c);
        filter = new ChainWALEntryFilter(new WALEntryFilter[]{new NamespaceTableCfWALEntryFilter(peer)});
        this.assertEquals(null, filter.filter(userEntry));
    }

    private WAL.Entry createEntry(TreeMap<byte[], Integer> scopes, byte[] ... kvs) {
        WALKeyImpl key1 = new WALKeyImpl(new byte[0], TableName.valueOf((String)"foo"), System.currentTimeMillis(), scopes);
        WALEdit edit1 = new WALEdit();
        for (byte[] kv : kvs) {
            edit1.add((Cell)new KeyValue(kv, kv, kv));
        }
        return new WAL.Entry(key1, edit1);
    }

    private void assertEquals(WAL.Entry e1, WAL.Entry e2) {
        Assert.assertEquals((Object)(e1 == null ? 1 : 0), (Object)(e2 == null ? 1 : 0));
        if (e1 == null) {
            return;
        }
        Assert.assertEquals((Object)(e1.getEdit() == null ? 1 : 0), (Object)(e2.getEdit() == null ? 1 : 0));
        if (e1.getEdit() == null) {
            return;
        }
        ArrayList cells1 = e1.getEdit().getCells();
        ArrayList cells2 = e2.getEdit().getCells();
        Assert.assertEquals((long)cells1.size(), (long)cells2.size());
        for (int i = 0; i < cells1.size(); ++i) {
            CellComparatorImpl.COMPARATOR.compare((Cell)cells1.get(i), (Cell)cells2.get(i));
        }
    }
}

