/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.AbstractTestRestartCluster;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRetainAssignmentOnRestart
extends AbstractTestRestartCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRetainAssignmentOnRestart.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRetainAssignmentOnRestart.class);
    private static int NUM_OF_RS = 3;

    @Override
    protected boolean splitWALCoordinatedByZk() {
        return true;
    }

    @Test
    public void testRetainAssignmentOnClusterRestart() throws Exception {
        this.setupCluster();
        HMaster master = this.UTIL.getMiniHBaseCluster().getMaster();
        MiniHBaseCluster cluster = this.UTIL.getHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> threads = cluster.getLiveRegionServerThreads();
        Assert.assertEquals((long)NUM_OF_RS, (long)threads.size());
        int[] rsPorts = new int[NUM_OF_RS];
        for (int i = 0; i < NUM_OF_RS; ++i) {
            rsPorts[i] = threads.get(i).getRegionServer().getServerName().getPort();
        }
        SnapshotOfRegionAssignmentFromMeta snapshot = new SnapshotOfRegionAssignmentFromMeta(master.getConnection());
        snapshot.initialize();
        Map regionToRegionServerMap = snapshot.getRegionToRegionServerMap();
        for (ServerName serverName : regionToRegionServerMap.values()) {
            int found = 0;
            for (int k = 0; k < NUM_OF_RS && found == 0; ++k) {
                found = serverName.getPort() == rsPorts[k] ? 1 : 0;
            }
            Assert.assertTrue(found != 0);
        }
        LOG.info("\n\nShutting down HBase cluster");
        cluster.stopMaster(0);
        cluster.shutdown();
        cluster.waitUntilShutDown();
        LOG.info("\n\nSleeping a bit");
        Thread.sleep(2000L);
        LOG.info("\n\nStarting cluster the second time with the same ports");
        cluster.getConf().setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        master = cluster.startMaster().getMaster();
        for (int i = 0; i < NUM_OF_RS; ++i) {
            cluster.getConf().setInt("hbase.regionserver.port", rsPorts[i]);
            cluster.startRegionServer();
        }
        this.ensureServersWithSamePort(master, rsPorts);
        for (TableName TABLE : TABLES) {
            this.UTIL.waitTableAvailable(TABLE);
        }
        this.UTIL.waitUntilNoRegionsInTransition(60000L);
        snapshot = new SnapshotOfRegionAssignmentFromMeta(master.getConnection());
        snapshot.initialize();
        Map newRegionToRegionServerMap = snapshot.getRegionToRegionServerMap();
        Assert.assertEquals((long)regionToRegionServerMap.size(), (long)newRegionToRegionServerMap.size());
        for (Map.Entry entry : newRegionToRegionServerMap.entrySet()) {
            ServerName oldServer = (ServerName)regionToRegionServerMap.get(entry.getKey());
            ServerName currentServer = (ServerName)entry.getValue();
            LOG.info("Key=" + entry.getKey() + " oldServer=" + oldServer + ", currentServer=" + currentServer);
            Assert.assertEquals((String)((RegionInfo)entry.getKey()).toString(), (Object)oldServer.getAddress(), (Object)currentServer.getAddress());
            Assert.assertNotEquals((long)oldServer.getStartcode(), (long)currentServer.getStartcode());
        }
    }

    @Test
    public void testRetainAssignmentOnSingleRSRestart() throws Exception {
        this.setupCluster();
        HMaster master = this.UTIL.getMiniHBaseCluster().getMaster();
        MiniHBaseCluster cluster = this.UTIL.getHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> threads = cluster.getLiveRegionServerThreads();
        Assert.assertEquals((long)NUM_OF_RS, (long)threads.size());
        int[] rsPorts = new int[NUM_OF_RS];
        for (int i = 0; i < NUM_OF_RS; ++i) {
            rsPorts[i] = threads.get(i).getRegionServer().getServerName().getPort();
        }
        SnapshotOfRegionAssignmentFromMeta snapshot = new SnapshotOfRegionAssignmentFromMeta(master.getConnection());
        snapshot.initialize();
        Map regionToRegionServerMap = snapshot.getRegionToRegionServerMap();
        for (TableName[] serverName : regionToRegionServerMap.values()) {
            boolean found = false;
            for (int k = 0; k < NUM_OF_RS && !found; ++k) {
                found = serverName.getPort() == rsPorts[k];
            }
            Assert.assertTrue((boolean)found);
        }
        ServerName deadRS = threads.get(0).getRegionServer().getServerName();
        LOG.info("\n\nStopping HMaster and {} server", (Object)deadRS);
        cluster.stopMaster(0);
        cluster.waitForMasterToStop(master.getServerName(), 5000L);
        cluster.stopRegionServer(deadRS);
        LOG.info("\n\nSleeping a bit");
        Thread.sleep(2000L);
        LOG.info("\n\nStarting HMaster and region server {} second time with the same port", (Object)deadRS);
        cluster.getConf().setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        master = cluster.startMaster().getMaster();
        cluster.getConf().setInt("hbase.regionserver.port", deadRS.getPort());
        cluster.startRegionServer();
        this.ensureServersWithSamePort(master, rsPorts);
        for (TableName TABLE : TABLES) {
            this.UTIL.waitTableAvailable(TABLE);
        }
        this.UTIL.waitUntilNoRegionsInTransition(60000L);
        snapshot = new SnapshotOfRegionAssignmentFromMeta(master.getConnection());
        snapshot.initialize();
        Map newRegionToRegionServerMap = snapshot.getRegionToRegionServerMap();
        Assert.assertEquals((long)regionToRegionServerMap.size(), (long)newRegionToRegionServerMap.size());
        for (Map.Entry entry : newRegionToRegionServerMap.entrySet()) {
            ServerName oldServer = (ServerName)regionToRegionServerMap.get(entry.getKey());
            ServerName currentServer = (ServerName)entry.getValue();
            LOG.info("Key=" + entry.getKey() + " oldServer=" + oldServer + ", currentServer=" + currentServer);
            Assert.assertEquals((String)((RegionInfo)entry.getKey()).toString(), (Object)oldServer.getAddress(), (Object)currentServer.getAddress());
            if (deadRS.getPort() == oldServer.getPort()) {
                Assert.assertNotEquals((long)oldServer.getStartcode(), (long)currentServer.getStartcode());
                continue;
            }
            Assert.assertEquals((long)oldServer.getStartcode(), (long)currentServer.getStartcode());
        }
    }

    private void setupCluster() throws Exception, IOException, InterruptedException {
        this.UTIL.getConfiguration().set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        this.UTIL.getConfiguration().setBoolean("hbase.master.scp.retain.assignment", true);
        this.UTIL.startMiniCluster(NUM_OF_RS);
        this.UTIL.getMiniHBaseCluster().getMaster().getMasterRpcServices().synchronousBalanceSwitch(false);
        LOG.info("\n\nCreating tables");
        for (TableName TABLE : TABLES) {
            this.UTIL.createTable(TABLE, FAMILY);
        }
        for (TableName TABLE : TABLES) {
            this.UTIL.waitTableEnabled(TABLE);
        }
        this.UTIL.getMiniHBaseCluster().getMaster();
        this.UTIL.waitUntilNoRegionsInTransition(60000L);
    }

    private void ensureServersWithSamePort(HMaster master, int[] rsPorts) {
        List localServers = master.getServerManager().getOnlineServersList();
        Assert.assertEquals((long)NUM_OF_RS, (long)localServers.size());
        for (int i = 0; i < NUM_OF_RS; ++i) {
            boolean found = false;
            for (ServerName serverName : localServers) {
                if (serverName.getPort() != rsPorts[i]) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
    }
}

