/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.monitor.probe;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.monitor.probe.DefaultProbe;
import org.apache.hadoop.yarn.service.monitor.probe.ProbeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProbe
extends DefaultProbe {
    protected static final Logger log = LoggerFactory.getLogger(HttpProbe.class);
    private static final String HOST_TOKEN = "${THIS_HOST}";
    private final String urlString;
    private final int timeout;
    private final int min;
    private final int max;

    public HttpProbe(String url, int timeout, int min, int max, Map<String, String> props) {
        super("Http probe of " + url + " [" + min + "-" + max + "]", props);
        this.urlString = url;
        this.timeout = timeout;
        this.min = min;
        this.max = max;
    }

    public static HttpProbe create(Map<String, String> props) throws IOException {
        String urlString = HttpProbe.getProperty(props, "url", null);
        new URL(urlString);
        int timeout = HttpProbe.getPropertyInt(props, "timeout", 1000);
        int minSuccess = HttpProbe.getPropertyInt(props, "min.success", 200);
        int maxSuccess = HttpProbe.getPropertyInt(props, "max.success", 299);
        return new HttpProbe(urlString, timeout, minSuccess, maxSuccess, props);
    }

    private static HttpURLConnection getConnection(URL url, int timeout) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(true);
        connection.setConnectTimeout(timeout);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProbeStatus ping(ComponentInstance instance) {
        ProbeStatus status = super.ping(instance);
        if (!status.isSuccess()) {
            return status;
        }
        String ip = (String)instance.getContainerStatus().getIPs().get(0);
        HttpURLConnection connection = null;
        String hostString = this.urlString.replace(HOST_TOKEN, ip);
        try {
            URL url = new URL(hostString);
            connection = HttpProbe.getConnection(url, this.timeout);
            int rc = connection.getResponseCode();
            if (rc < this.min || rc > this.max) {
                String error = "Probe " + url + " error code: " + rc;
                log.info(error);
                status.fail(this, new IOException(error));
            } else {
                status.succeed(this);
            }
        }
        catch (Throwable e) {
            String error = "Probe " + hostString + " failed for IP " + ip + ": " + e;
            log.info(error, e);
            status.fail(this, new IOException(error, e));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return status;
    }
}

