/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestReconstructStripedBlocksWithRackAwareness {
    public static final Logger LOG = LoggerFactory.getLogger(TestReconstructStripedBlocksWithRackAwareness.class);
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final int cellSize = this.ecPolicy.getCellSize();
    private final short dataBlocks = (short)this.ecPolicy.getNumDataUnits();
    private final short parityBlocks = (short)this.ecPolicy.getNumParityUnits();
    private final String[] hosts = TestReconstructStripedBlocksWithRackAwareness.getHosts(this.dataBlocks + this.parityBlocks + 1);
    private final String[] racks = TestReconstructStripedBlocksWithRackAwareness.getRacks(this.dataBlocks + this.parityBlocks + 1, this.dataBlocks);
    private MiniDFSCluster cluster;
    private static final HdfsConfiguration conf;
    private DistributedFileSystem fs;

    private static String[] getHosts(int numHosts) {
        String[] hosts = new String[numHosts];
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = "host" + (i + 1);
        }
        return hosts;
    }

    private static String[] getRacks(int numHosts, int numRacks) {
        String[] racks = new String[numHosts];
        int numHostEachRack = numHosts / numRacks;
        int residue = numHosts % numRacks;
        int j = 0;
        for (int i = 1; i <= numRacks; ++i) {
            int limit = i <= residue ? numHostEachRack + 1 : numHostEachRack;
            for (int k = 0; k < limit; ++k) {
                racks[j++] = "/r" + i;
            }
        }
        assert (j == numHosts);
        return racks;
    }

    @BeforeClass
    public static void setup() throws Exception {
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        conf.setInt("dfs.namenode.decommission.interval", 1);
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private MiniDFSCluster.DataNodeProperties stopDataNode(String hostname) throws IOException {
        MiniDFSCluster.DataNodeProperties dnProp = null;
        for (int i = 0; i < this.cluster.getDataNodes().size(); ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            if (!dn.getDatanodeId().getHostName().equals(hostname)) continue;
            dnProp = this.cluster.stopDataNode(i);
            this.cluster.setDataNodeDead(dn.getDatanodeId());
            LOG.info("stop datanode " + dn.getDatanodeId().getHostName());
        }
        return dnProp;
    }

    private DataNode getDataNode(String host) {
        for (DataNode dn : this.cluster.getDataNodes()) {
            if (!dn.getDatanodeId().getHostName().equals(host)) continue;
            return dn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReconstructForNotEnoughRacks() throws Exception {
        LOG.info("cluster hosts: {}, racks: {}", Arrays.asList(this.hosts), Arrays.asList(this.racks));
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).racks(this.racks).hosts(this.hosts).numDataNodes(this.hosts.length).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        this.fs.setErasureCodingPolicy(new Path("/"), StripedFileTestUtil.getDefaultECPolicy().getName());
        FSNamesystem fsn = this.cluster.getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        MiniDFSCluster.DataNodeProperties lastHost = this.stopDataNode(this.hosts[this.hosts.length - 1]);
        Path file = new Path("/foo");
        DFSTestUtil.createFile((FileSystem)this.fs, file, this.cellSize * this.dataBlocks * 2, (short)1, 0L);
        GenericTestUtils.waitFor(() -> bm.numOfUnderReplicatedBlocks() == 0, (long)100L, (long)30000L);
        LOG.info("Created file {}", (Object)file);
        INodeFile fileNode = fsn.getFSDirectory().getINode4Write(file.toString()).asFile();
        BlockInfoStriped blockInfo = (BlockInfoStriped)fileNode.getLastBlock();
        HashSet<String> rackSet = new HashSet<String>();
        Iterator it = blockInfo.getStorageInfos();
        while (it.hasNext()) {
            DatanodeStorageInfo storage = (DatanodeStorageInfo)it.next();
            rackSet.add(storage.getDatanodeDescriptor().getNetworkLocation());
        }
        Assert.assertEquals((String)("rackSet size is wrong: " + rackSet), (long)(this.dataBlocks - 1), (long)rackSet.size());
        this.cluster.restartDataNode(lastHost);
        this.cluster.waitActive();
        NetworkTopology topology = bm.getDatanodeManager().getNetworkTopology();
        LOG.info("topology is: {}", (Object)topology);
        Assert.assertEquals((long)this.hosts.length, (long)topology.getNumOfLeaves());
        Assert.assertEquals((long)this.dataBlocks, (long)topology.getNumOfRacks());
        for (DataNode dn : this.cluster.getDataNodes()) {
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
        }
        fsn.writeLock();
        try {
            bm.processMisReplicatedBlocks();
        }
        finally {
            fsn.writeUnlock();
        }
        boolean scheduled = false;
        for (int i = 0; i < 5; ++i) {
            it = blockInfo.getStorageInfos();
            while (it.hasNext()) {
                DatanodeStorageInfo storage = (DatanodeStorageInfo)it.next();
                if (storage == null) continue;
                DatanodeDescriptor dn = storage.getDatanodeDescriptor();
                Assert.assertEquals((String)("Block to be erasure coded is wrong for datanode:" + dn), (long)0L, (long)dn.getNumberOfBlocksToBeErasureCoded());
                if (dn.getNumberOfBlocksToBeReplicated() != 1) continue;
                scheduled = true;
            }
            if (scheduled) break;
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)scheduled);
    }

    @Test
    public void testChooseExcessReplicasToDelete() throws Exception {
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).racks(this.racks).hosts(this.hosts).numDataNodes(this.hosts.length).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        this.fs.setErasureCodingPolicy(new Path("/"), StripedFileTestUtil.getDefaultECPolicy().getName());
        MiniDFSCluster.DataNodeProperties lastHost = this.stopDataNode(this.hosts[this.hosts.length - 1]);
        Path file = new Path("/foo");
        DFSTestUtil.createFile((FileSystem)this.fs, file, this.cellSize * this.dataBlocks * 2, (short)1, 0L);
        MiniDFSCluster.DataNodeProperties host1 = this.stopDataNode("host1");
        this.cluster.restartDataNode(lastHost);
        this.cluster.waitActive();
        short blockNum = (short)(this.dataBlocks + this.parityBlocks);
        DFSTestUtil.waitForReplication(this.fs, file, blockNum, 15000);
        this.cluster.restartDataNode(host1);
        this.cluster.waitActive();
        for (DataNode dn : this.cluster.getDataNodes()) {
            if (!dn.getDatanodeId().getHostName().equals("host1")) continue;
            DataNodeTestUtils.triggerBlockReport(dn);
            break;
        }
        DFSTestUtil.waitForReplication(this.fs, file, blockNum, 15000);
        LocatedBlocks blks = this.fs.getClient().getLocatedBlocks(file.toString(), 0L);
        LocatedStripedBlock block = (LocatedStripedBlock)blks.getLastLocatedBlock();
        for (DatanodeInfoWithStorage dn : block.getLocations()) {
            Assert.assertFalse((boolean)dn.getHostName().equals("host1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReconstructionWithDecommission() throws Exception {
        String[] rackNames = TestReconstructStripedBlocksWithRackAwareness.getRacks(this.dataBlocks + this.parityBlocks + 2, this.dataBlocks);
        String[] hostNames = TestReconstructStripedBlocksWithRackAwareness.getHosts(this.dataBlocks + this.parityBlocks + 2);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).racks(rackNames).hosts(hostNames).numDataNodes(hostNames.length).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        this.fs.setErasureCodingPolicy(new Path("/"), StripedFileTestUtil.getDefaultECPolicy().getName());
        BlockManager bm = this.cluster.getNamesystem().getBlockManager();
        DatanodeManager dm = bm.getDatanodeManager();
        MiniDFSCluster.DataNodeProperties h9 = this.stopDataNode(hostNames[hostNames.length - 3]);
        MiniDFSCluster.DataNodeProperties h10 = this.stopDataNode(hostNames[hostNames.length - 2]);
        Path file = new Path("/foo");
        DFSTestUtil.createFile((FileSystem)this.fs, file, this.cellSize * this.dataBlocks * 2, (short)1, 0L);
        BlockInfo blockInfo = this.cluster.getNamesystem().getFSDirectory().getINode(file.toString()).asFile().getLastBlock();
        this.cluster.restartDataNode(h9);
        this.cluster.waitActive();
        MiniDFSCluster.DataNodeProperties h11 = this.stopDataNode(hostNames[hostNames.length - 1]);
        boolean recovered = bm.countNodes(blockInfo).liveReplicas() >= this.dataBlocks + this.parityBlocks;
        int i = 0;
        while (i < 10 & !recovered) {
            Thread.sleep(1000L);
            recovered = bm.countNodes(blockInfo).liveReplicas() >= this.dataBlocks + this.parityBlocks;
            ++i;
        }
        Assert.assertTrue((boolean)recovered);
        DataNode datanode9 = this.getDataNode(hostNames[hostNames.length - 3]);
        Assert.assertNotNull((Object)datanode9);
        DatanodeDescriptor dn9 = dm.getDatanode(datanode9.getDatanodeId());
        dn9.startDecommission();
        this.cluster.restartDataNode(h10);
        this.cluster.restartDataNode(h11);
        this.cluster.waitActive();
        DataNodeTestUtils.triggerBlockReport(this.getDataNode(hostNames[hostNames.length - 1]));
        boolean satisfied = bm.isPlacementPolicySatisfied(blockInfo);
        Assert.assertFalse((boolean)satisfied);
        DatanodeAdminManager decomManager = (DatanodeAdminManager)Whitebox.getInternalState((Object)dm, (String)"datanodeAdminManager");
        this.cluster.getNamesystem().writeLock();
        try {
            dn9.stopDecommission();
            decomManager.startDecommission(dn9);
        }
        finally {
            this.cluster.getNamesystem().writeUnlock();
        }
        boolean decommissioned = dn9.isDecommissioned();
        for (int i2 = 0; i2 < 10 && !decommissioned; ++i2) {
            Thread.sleep(1000L);
            decommissioned = dn9.isDecommissioned();
        }
        Assert.assertTrue((boolean)decommissioned);
        Assert.assertTrue((boolean)bm.isPlacementPolicySatisfied(blockInfo));
    }

    static {
        GenericTestUtils.setLogLevel((Logger)BlockPlacementPolicy.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)BlockManager.blockLog, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)BlockManager.LOG, (Level)Level.TRACE);
        conf = new HdfsConfiguration();
    }
}

