/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class SingleCounterBlock
extends HtmlBlock {
    protected TreeMap<String, Long> values = new TreeMap();
    protected Job job;
    protected Task task;
    private TaskType counterType;

    @Inject
    SingleCounterBlock(AppContext appCtx, View.ViewContext ctx) {
        super(ctx);
        this.populateMembers(appCtx);
    }

    protected void render(HtmlBlock.Block html) {
        if (this.job == null) {
            html.p().__(new Object[]{"Sorry, no counters for nonexistent", this.$("job.id", "job")}).__();
            return;
        }
        if (!this.$("task.id").isEmpty() && this.task == null) {
            html.p().__(new Object[]{"Sorry, no counters for nonexistent", this.$("task.id", "task")}).__();
            return;
        }
        String columnType = this.task == null ? "Task" : "Task Attempt";
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.div(".info-wrap.ui-widget-content.ui-corner-bottom").table("#singleCounter").thead().tr().th(".ui-state-default", columnType).th(".ui-state-default", "Value").__()).__()).tbody();
        for (Map.Entry<String, Long> entry : this.values.entrySet()) {
            Hamlet.TR row = tbody.tr();
            String id = entry.getKey();
            String val = entry.getValue().toString();
            if (this.task != null) {
                row.td(id);
                ((Hamlet.TD)row.td().br().$title(val).__()).__(new Object[]{val}).__();
            } else {
                row.td().a(this.url(new String[]{"singletaskcounter", entry.getKey(), this.$("counter.group"), this.$("counter.name")}), id).__();
                ((Hamlet.TD)row.td().br().$title(val).__()).a(this.url(new String[]{"singletaskcounter", entry.getKey(), this.$("counter.group"), this.$("counter.name")}), val).__();
            }
            row.__();
        }
        ((Hamlet.DIV)((Hamlet.TABLE)tbody.__()).__()).__();
    }

    private void populateMembers(AppContext ctx) {
        JobId jobID = null;
        TaskId taskID = null;
        String tid = this.$("task.id");
        this.counterType = this.$("title").contains("MAPS") ? TaskType.MAP : (this.$("title").contains("REDUCES") ? TaskType.REDUCE : null);
        if (!tid.isEmpty()) {
            taskID = MRApps.toTaskID((String)tid);
            jobID = taskID.getJobId();
        } else {
            String jid = this.$("job.id");
            if (!jid.isEmpty()) {
                jobID = MRApps.toJobID((String)jid);
            }
        }
        if (jobID == null) {
            return;
        }
        this.job = ctx.getJob(jobID);
        if (this.job == null) {
            return;
        }
        if (taskID != null) {
            this.task = this.job.getTask(taskID);
            if (this.task == null) {
                return;
            }
            for (Map.Entry entry : this.task.getAttempts().entrySet()) {
                Counter c;
                CounterGroup group;
                long value = 0L;
                Counters counters = ((TaskAttempt)entry.getValue()).getCounters();
                CounterGroup counterGroup = group = counters != null ? (CounterGroup)counters.getGroup(this.$("counter.group")) : null;
                if (group != null && (c = group.findCounter(this.$("counter.name"))) != null) {
                    value = c.getValue();
                }
                this.values.put(MRApps.toString((TaskAttemptId)((TaskAttemptId)entry.getKey())), value);
            }
            return;
        }
        Map<TaskId, Task> tasks = this.job.getTasks();
        for (Map.Entry<TaskId, Task> entry : tasks.entrySet()) {
            Counter c;
            CounterGroup group;
            long value = 0L;
            Counters counters = entry.getValue().getCounters();
            CounterGroup counterGroup = group = counters != null ? (CounterGroup)counters.getGroup(this.$("counter.group")) : null;
            if (group != null && (c = group.findCounter(this.$("counter.name"))) != null) {
                value = c.getValue();
            }
            if (this.counterType != null && this.counterType != entry.getValue().getType()) continue;
            this.values.put(MRApps.toString((TaskId)entry.getKey()), value);
        }
    }
}

