/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivilegedNfsGatewayStarter
implements Daemon {
    static final Logger LOG = LoggerFactory.getLogger(PrivilegedNfsGatewayStarter.class);
    private String[] args = null;
    private DatagramSocket registrationSocket = null;
    private Nfs3 nfs3Server = null;

    public void init(DaemonContext context) throws Exception {
        System.err.println("Initializing privileged NFS client socket...");
        NfsConfiguration conf = new NfsConfiguration();
        int clientPort = conf.getInt("nfs.registration.port", 40);
        if (clientPort < 1 || clientPort > 1023) {
            throw new RuntimeException("Must start privileged NFS server with 'nfs.registration.port' configured to a privileged port.");
        }
        try {
            InetSocketAddress socketAddress = new InetSocketAddress("localhost", clientPort);
            this.registrationSocket = new DatagramSocket(null);
            this.registrationSocket.setReuseAddress(true);
            this.registrationSocket.bind(socketAddress);
        }
        catch (SocketException e) {
            LOG.error("Init failed for port=" + clientPort, (Throwable)e);
            throw e;
        }
        this.args = context.getArguments();
    }

    public void start() throws Exception {
        this.nfs3Server = Nfs3.startService(this.args, this.registrationSocket);
    }

    public void stop() throws Exception {
        if (this.nfs3Server != null) {
            this.nfs3Server.stop();
        }
    }

    public void destroy() {
        if (this.registrationSocket != null && !this.registrationSocket.isClosed()) {
            this.registrationSocket.close();
        }
    }
}

