/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.records;

import java.io.IOException;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreSerializer;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipStats;
import org.junit.Assert;
import org.junit.Test;

public class TestMembershipState {
    private static final String ROUTER = "router";
    private static final String NAMESERVICE = "nameservice";
    private static final String NAMENODE = "namenode";
    private static final String CLUSTER_ID = "cluster";
    private static final String BLOCKPOOL_ID = "blockpool";
    private static final String RPC_ADDRESS = "rpcaddress";
    private static final String SERVICE_ADDRESS = "serviceaddress";
    private static final String LIFELINE_ADDRESS = "lifelineaddress";
    private static final String WEB_ADDRESS = "webaddress";
    private static final boolean SAFE_MODE = false;
    private static final String SCHEME = "http";
    private static final long DATE_CREATED = 100L;
    private static final long DATE_MODIFIED = 200L;
    private static final long NUM_BLOCKS = 300L;
    private static final long NUM_FILES = 400L;
    private static final int NUM_DEAD = 500;
    private static final int NUM_STALE = 550;
    private static final int NUM_ACTIVE = 600;
    private static final int NUM_DECOM = 700;
    private static final int NUM_DECOM_ACTIVE = 800;
    private static final int NUM_DECOM_DEAD = 900;
    private static final int NUM_MAIN_LIVE = 151;
    private static final int NUM_MAIN_DEAD = 303;
    private static final int NUM_ENTER_MAIN = 144;
    private static final long NUM_BLOCK_MISSING = 1000L;
    private static final int CORRUPT_FILES_COUNT = 123;
    private static final long SCHEDULED_REPLICATION_BLOCKS = 112L;
    private static final long MISSING_BLOCK_WITH_REPLICATION_ONE = 221L;
    private static final long HIGHEST_PRIORITY_LOW_REDUNDANCY_REPL_BLOCK = 212L;
    private static final long HIGHEST_PRIORITY_LOW_REDUNDANCY_EC_BLOCK = 122L;
    private static final long TOTAL_SPACE = 1100L;
    private static final long AVAILABLE_SPACE = 1200L;
    private static final FederationNamenodeServiceState STATE = FederationNamenodeServiceState.ACTIVE;

    private MembershipState createRecord() throws IOException {
        MembershipState record = MembershipState.newInstance((String)ROUTER, (String)NAMESERVICE, (String)NAMENODE, (String)CLUSTER_ID, (String)BLOCKPOOL_ID, (String)RPC_ADDRESS, (String)SERVICE_ADDRESS, (String)LIFELINE_ADDRESS, (String)SCHEME, (String)WEB_ADDRESS, (FederationNamenodeServiceState)STATE, (boolean)false);
        record.setDateCreated(100L);
        record.setDateModified(200L);
        MembershipStats stats = MembershipStats.newInstance();
        stats.setNumOfBlocks(300L);
        stats.setNumOfFiles(400L);
        stats.setNumOfActiveDatanodes(600);
        stats.setNumOfDeadDatanodes(500);
        stats.setNumOfStaleDatanodes(550);
        stats.setNumOfDecommissioningDatanodes(700);
        stats.setNumOfDecomActiveDatanodes(800);
        stats.setNumOfDecomDeadDatanodes(900);
        stats.setNumOfInMaintenanceLiveDataNodes(151);
        stats.setNumOfInMaintenanceDeadDataNodes(303);
        stats.setNumOfEnteringMaintenanceDataNodes(144);
        stats.setNumOfBlocksMissing(1000L);
        stats.setTotalSpace(1100L);
        stats.setAvailableSpace(1200L);
        stats.setCorruptFilesCount(123);
        stats.setScheduledReplicationBlocks(112L);
        stats.setNumberOfMissingBlocksWithReplicationFactorOne(221L);
        stats.setHighestPriorityLowRedundancyReplicatedBlocks(212L);
        stats.setHighestPriorityLowRedundancyECBlocks(122L);
        record.setStats(stats);
        return record;
    }

    private void validateRecord(MembershipState record) throws IOException {
        Assert.assertEquals((Object)ROUTER, (Object)record.getRouterId());
        Assert.assertEquals((Object)NAMESERVICE, (Object)record.getNameserviceId());
        Assert.assertEquals((Object)CLUSTER_ID, (Object)record.getClusterId());
        Assert.assertEquals((Object)BLOCKPOOL_ID, (Object)record.getBlockPoolId());
        Assert.assertEquals((Object)RPC_ADDRESS, (Object)record.getRpcAddress());
        Assert.assertEquals((Object)SCHEME, (Object)record.getWebScheme());
        Assert.assertEquals((Object)WEB_ADDRESS, (Object)record.getWebAddress());
        Assert.assertEquals((Object)STATE, (Object)record.getState());
        Assert.assertEquals((Object)false, (Object)record.getIsSafeMode());
        Assert.assertEquals((long)100L, (long)record.getDateCreated());
        Assert.assertEquals((long)200L, (long)record.getDateModified());
        MembershipStats stats = record.getStats();
        Assert.assertEquals((long)300L, (long)stats.getNumOfBlocks());
        Assert.assertEquals((long)400L, (long)stats.getNumOfFiles());
        Assert.assertEquals((long)600L, (long)stats.getNumOfActiveDatanodes());
        Assert.assertEquals((long)500L, (long)stats.getNumOfDeadDatanodes());
        Assert.assertEquals((long)550L, (long)stats.getNumOfStaleDatanodes());
        Assert.assertEquals((long)700L, (long)stats.getNumOfDecommissioningDatanodes());
        Assert.assertEquals((long)800L, (long)stats.getNumOfDecomActiveDatanodes());
        Assert.assertEquals((long)900L, (long)stats.getNumOfDecomDeadDatanodes());
        Assert.assertEquals((long)151L, (long)stats.getNumOfInMaintenanceLiveDataNodes());
        Assert.assertEquals((long)303L, (long)stats.getNumOfInMaintenanceDeadDataNodes());
        Assert.assertEquals((long)144L, (long)stats.getNumOfEnteringMaintenanceDataNodes());
        Assert.assertEquals((long)1100L, (long)stats.getTotalSpace());
        Assert.assertEquals((long)1200L, (long)stats.getAvailableSpace());
        Assert.assertEquals((long)123L, (long)stats.getCorruptFilesCount());
        Assert.assertEquals((long)112L, (long)stats.getScheduledReplicationBlocks());
        Assert.assertEquals((long)221L, (long)stats.getNumberOfMissingBlocksWithReplicationFactorOne());
        Assert.assertEquals((long)212L, (long)stats.getHighestPriorityLowRedundancyReplicatedBlocks());
        Assert.assertEquals((long)122L, (long)stats.getHighestPriorityLowRedundancyECBlocks());
    }

    @Test
    public void testGetterSetter() throws IOException {
        MembershipState record = this.createRecord();
        this.validateRecord(record);
    }

    @Test
    public void testSerialization() throws IOException {
        MembershipState record = this.createRecord();
        StateStoreSerializer serializer = StateStoreSerializer.getSerializer();
        String serializedString = serializer.serializeString((BaseRecord)record);
        MembershipState newRecord = (MembershipState)serializer.deserialize(serializedString, MembershipState.class);
        this.validateRecord(newRecord);
    }
}

