/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.StopWatch;
import org.junit.Assert;
import org.junit.Test;

public class TestChunkedArrayList {
    @Test
    public void testBasics() {
        int N_ELEMS = 100000;
        ChunkedArrayList l = new ChunkedArrayList();
        Assert.assertTrue((boolean)l.isEmpty());
        for (int i = 0; i < 100000; ++i) {
            l.add((Object)i);
        }
        Assert.assertFalse((boolean)l.isEmpty());
        Assert.assertEquals((long)100000L, (long)l.size());
        Assert.assertTrue((l.getNumChunks() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((long)8192L, (long)l.getMaxChunkSize());
    }

    @Test
    public void testIterator() {
        int i;
        ChunkedArrayList l = new ChunkedArrayList();
        for (i = 0; i < 30000; ++i) {
            l.add((Object)i);
        }
        i = 0;
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            int fromList = (Integer)iterator.next();
            Assert.assertEquals((long)i, (long)fromList);
            ++i;
        }
    }

    @Test
    public void testPerformance() {
        String obj = "hello world";
        int numElems = 1000000;
        int numTrials = 5;
        for (int trial = 0; trial < 5; ++trial) {
            int i;
            System.gc();
            ArrayList<String> arrayList = new ArrayList<String>();
            StopWatch sw = new StopWatch();
            sw.start();
            for (i = 0; i < 1000000; ++i) {
                arrayList.add(obj);
            }
            System.out.println("       ArrayList " + sw.now(TimeUnit.MILLISECONDS));
            System.gc();
            ChunkedArrayList chunkedList = new ChunkedArrayList();
            sw = new StopWatch();
            sw.start();
            for (i = 0; i < 1000000; ++i) {
                chunkedList.add((Object)obj);
            }
            System.out.println("ChunkedArrayList " + sw.now(TimeUnit.MILLISECONDS));
        }
    }

    @Test
    public void testRemovals() throws Exception {
        Integer val;
        int i;
        int NUM_ELEMS = 100000;
        ChunkedArrayList list = new ChunkedArrayList();
        for (int i2 = 0; i2 < 100000; ++i2) {
            list.add((Object)i2);
        }
        Iterator iter = list.iterator();
        for (i = 0; i < 100000; ++i) {
            Assert.assertTrue((boolean)iter.hasNext());
            val = (Integer)iter.next();
            Assert.assertEquals((Object)i, (Object)val);
        }
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((long)100000L, (long)list.size());
        iter = list.iterator();
        for (i = 0; i < 100000; ++i) {
            Assert.assertTrue((boolean)iter.hasNext());
            val = (Integer)iter.next();
            Assert.assertEquals((Object)i, (Object)val);
            if (i % 2 != 0) continue;
            iter.remove();
        }
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((long)50000L, (long)list.size());
        iter = list.iterator();
        for (i = 0; i < 50000; ++i) {
            Assert.assertTrue((boolean)iter.hasNext());
            val = (Integer)iter.next();
            Assert.assertEquals((Object)(1 + 2 * i), (Object)val);
            iter.remove();
        }
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertTrue((boolean)list.isEmpty());
        iter = list.iterator();
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testGet() throws Exception {
        int NUM_ELEMS = 100001;
        ChunkedArrayList list = new ChunkedArrayList();
        for (int i = 0; i < 100001; ++i) {
            list.add((Object)i);
        }
        Assert.assertEquals((Object)100, (Object)list.get(100));
        Assert.assertEquals((Object)1000, (Object)list.get(1000));
        Assert.assertEquals((Object)10000, (Object)list.get(10000));
        Assert.assertEquals((Object)100000, (Object)list.get(100000));
        Iterator iter = list.iterator();
        iter.next();
        iter.remove();
        Assert.assertEquals((Object)1, (Object)list.get(0));
        iter = list.iterator();
        for (int i = 0; i < 500; ++i) {
            iter.next();
        }
        iter.remove();
        Assert.assertEquals((Object)502, (Object)list.get(500));
        Assert.assertEquals((Object)602, (Object)list.get(600));
    }
}

